#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Common_Interface.h"
#include "Brake_Pressure_Voltage_Table.h"
#include "Analog_Signals.h"

static uint8_t                g_BrakePressureVoltageSegNum_Disp;
static uint8_t                g_BrakePressureVoltageValid;          // -0 无效 -1 有效
static DataBrakePressureVoltageCalcStruct g_DataBrakePressureVoltageTempCalc;

/*** 制动气压上升表格 ***/
static const uint16_t DataBrakePressureVoltageTable_Up [ DATA_BrakePressureVoltage_TEMP_TOTAL_SEG ] =
    /*显示段：|    0     |    1     |    2     |    3     |    4     |*/
    {1044, 1588, 2133, 2677, 3221};    // 上升时小于等于表值则熄灭相应段

/*** 制动气压下降表格 ***/
static const uint16_t DataBrakePressureVoltageTable_Dn [ DATA_BrakePressureVoltage_TEMP_TOTAL_SEG ] =
    /*显示段：|    0     |    1     |    2     |    3     |    4     |*/
    {1004, 1548, 2129, 2673, 3217};    // 下降时小于等于表值则熄灭相应段

void Data_BrakePressureVoltage_TempPara_KL30_Init(void)
{
    g_DataBrakePressureVoltageTempCalc.FastMode         = 0u;
    g_BrakePressureVoltageSegNum_Disp                   = 0u;
    g_BrakePressureVoltageValid                         = 1u;
    g_DataBrakePressureVoltageTempCalc.Last             = 0u;
    g_DataBrakePressureVoltageTempCalc.InvalidCnt       = 0u;
    g_DataBrakePressureVoltageTempCalc.DstSeg           = 0u;
    g_DataBrakePressureVoltageTempCalc.State            = DATA_BrakePressureVoltage_TEMP_STATE_DELAY;
    g_DataBrakePressureVoltageTempCalc.Wait             = DATA_BrakePressureVoltage_TEMP_WAIT_SEC * 10;
    g_DataBrakePressureVoltageTempCalc.Prescaler        = 0u;
    g_DataBrakePressureVoltageTempCalc.OutputEnable     = 0u;
    g_DataBrakePressureVoltageTempCalc.DispTimer        = 0u;
    g_DataBrakePressureVoltageTempCalc.EngineStartTimer = 0u;
    g_DataBrakePressureVoltageTempCalc.Backup           = 0u;
}

void Data_BrakePressureVoltage_TempPara_Wakeup_Init(void)
{
    g_BrakePressureVoltageSegNum_Disp                   = 0u;
    g_BrakePressureVoltageValid                         = 1u;
    g_DataBrakePressureVoltageTempCalc.Last             = 0u;
    g_DataBrakePressureVoltageTempCalc.InvalidCnt       = 0u;
    g_DataBrakePressureVoltageTempCalc.DstSeg           = 0u;
    g_DataBrakePressureVoltageTempCalc.State            = DATA_BrakePressureVoltage_TEMP_STATE_DELAY;
    g_DataBrakePressureVoltageTempCalc.Wait             = DATA_BrakePressureVoltage_TEMP_WAIT_SEC * 10;
    g_DataBrakePressureVoltageTempCalc.Prescaler        = 0u;
    g_DataBrakePressureVoltageTempCalc.OutputEnable     = 0u;
    g_DataBrakePressureVoltageTempCalc.DispTimer        = 0u;
    g_DataBrakePressureVoltageTempCalc.EngineStartTimer = 0u;
}

/******************************************************************************
函数名：Data_BrakePressureVoltage_Temp_Processing_Service
功  能：SOC数据处理函数
参  数：无
返回值：无
*******************************************************************************
注  意：该函数必须每20ms被调用一次
******************************************************************************/
void Data_BrakePressureVoltage_Temp_Processing_Service(void)
{
    uint16_t  Data_Brake_Pressure_Voltage    = 0u;
    uint8_t  Delta                   = 0u;
    uint16_t DataBrakePressureVoltage_Temp  = 0u;
    uint8_t Up_Down                  = 0u;

    Data_Brake_Pressure_Voltage = ADC_Read_Signal(ADC_CH_BRAKEAIRPRESSURE_VOLTAGE); 

    if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        if((Data_Brake_Pressure_Voltage >=500) && (Data_Brake_Pressure_Voltage <=4600) && (Up_Down == 1))
        {
            Up_Down = 0;
        }
        if ( Data_Brake_Pressure_Voltage < 200 )
        {
            g_BrakePressureVoltageValid   = 0u;
            DataBrakePressureVoltage_Temp = 0u;
            Up_Down = 1;
        }
        else
        {
            if ( Data_Brake_Pressure_Voltage > 4800 )
            {
                g_BrakePressureVoltageValid = 0;
                Data_Brake_Pressure_Voltage  = 0;
                Up_Down = 1;
            }
            else
            {
                if(Up_Down == 1)
                {
                    g_BrakePressureVoltageValid   = 0u;
                    DataBrakePressureVoltage_Temp = 0u;
                }
                else
                {
                    DataBrakePressureVoltage_Temp = Data_Brake_Pressure_Voltage;
                    g_BrakePressureVoltageValid = 1u;
                }
                
            }
        }

        // 第2步：获取制动气压格数
        if ( g_BrakePressureVoltageValid )
        {
            if ( DataBrakePressureVoltage_Temp > g_DataBrakePressureVoltageTempCalc.Last )    // 新制动气压高于前次制动气压,查上升表
            {
                while ( g_DataBrakePressureVoltageTempCalc.DstSeg < DATA_BrakePressureVoltage_TEMP_TOTAL_SEG )
                {
                    if ( DataBrakePressureVoltage_Temp < DataBrakePressureVoltageTable_Up [ g_DataBrakePressureVoltageTempCalc.DstSeg ] )
                        break;
                    g_DataBrakePressureVoltageTempCalc.DstSeg++;
                }
            }
            else if ( DataBrakePressureVoltage_Temp < g_DataBrakePressureVoltageTempCalc.Last )    // 新制动气压低于前次制动气压,查下降表
            {
                while ( g_DataBrakePressureVoltageTempCalc.DstSeg )
                {
                    if ( DataBrakePressureVoltage_Temp > DataBrakePressureVoltageTable_Dn [ g_DataBrakePressureVoltageTempCalc.DstSeg - 1 ] )
                        break;
                    g_DataBrakePressureVoltageTempCalc.DstSeg--;
                }
            }

            g_DataBrakePressureVoltageTempCalc.Last = DataBrakePressureVoltage_Temp;
        }

        // 第3步：状态转换,每100ms执行一次
        g_DataBrakePressureVoltageTempCalc.Prescaler++;
        if ( g_DataBrakePressureVoltageTempCalc.Prescaler >= 5 )
        {
            g_DataBrakePressureVoltageTempCalc.Prescaler = 0;

            switch ( g_DataBrakePressureVoltageTempCalc.State )
            {
                case DATA_BrakePressureVoltage_TEMP_STATE_DELAY:
                    if ( g_DataBrakePressureVoltageTempCalc.Wait )
                        g_DataBrakePressureVoltageTempCalc.Wait--;
                    else
                        g_DataBrakePressureVoltageTempCalc.State = DATA_BrakePressureVoltage_TEMP_STATE_INIT;

                    break;

                case DATA_BrakePressureVoltage_TEMP_STATE_INIT:
                    if ( g_BrakePressureVoltageValid )
                    {
                        if ( g_DataBrakePressureVoltageTempCalc.DstSeg )
                        {
                            g_DataBrakePressureVoltageTempCalc.OutputEnable = 1;
                            g_DataBrakePressureVoltageTempCalc.FastMode     = 1;
                            g_DataBrakePressureVoltageTempCalc.State        = DATA_BrakePressureVoltage_TEMP_STATE_FAST;
                        }
                    }
                    else
                    {
                        g_DataBrakePressureVoltageTempCalc.OutputEnable = 1;
                        g_DataBrakePressureVoltageTempCalc.FastMode     = 1;
                        g_DataBrakePressureVoltageTempCalc.Last         = 0;
                        g_DataBrakePressureVoltageTempCalc.DstSeg       = 0;

                        g_DataBrakePressureVoltageTempCalc.State = DATA_BrakePressureVoltage_TEMP_STATE_FAULT;
                    }

                    break;

                case DATA_BrakePressureVoltage_TEMP_STATE_FAST:
                    if ( g_BrakePressureVoltageValid )
                    {
                        if ( g_DataBrakePressureVoltageTempCalc.FastMode == 0 )
                            g_DataBrakePressureVoltageTempCalc.State = DATA_BrakePressureVoltage_TEMP_STATE_NORMAL;
                    }
                    else
                    {
                        g_DataBrakePressureVoltageTempCalc.OutputEnable = 1;
                        g_DataBrakePressureVoltageTempCalc.FastMode     = 1;
                        g_DataBrakePressureVoltageTempCalc.Last         = 0;
                        g_DataBrakePressureVoltageTempCalc.DstSeg       = 0;

                        g_DataBrakePressureVoltageTempCalc.State = DATA_BrakePressureVoltage_TEMP_STATE_FAULT;
                    }

                    break;

                case DATA_BrakePressureVoltage_TEMP_STATE_NORMAL:
                    if ( g_BrakePressureVoltageValid == 0 )
                    {
                        g_DataBrakePressureVoltageTempCalc.OutputEnable = 1;
                        g_DataBrakePressureVoltageTempCalc.FastMode     = 1;
                        g_DataBrakePressureVoltageTempCalc.Last         = 0;
                        g_DataBrakePressureVoltageTempCalc.DstSeg       = 0;

                        g_DataBrakePressureVoltageTempCalc.State = DATA_BrakePressureVoltage_TEMP_STATE_FAULT;
                    }

                    break;

                case DATA_BrakePressureVoltage_TEMP_STATE_FAULT:
                    if ( g_BrakePressureVoltageValid )
                        g_DataBrakePressureVoltageTempCalc.State = DATA_BrakePressureVoltage_TEMP_STATE_INIT;

                    break;

                default:
                    g_BrakePressureVoltageSegNum_Disp               = 0;
                    DataBrakePressureVoltage_Temp                   = 0;
                    g_BrakePressureVoltageValid                     = 0;
                    g_DataBrakePressureVoltageTempCalc.OutputEnable = 1;
                    g_DataBrakePressureVoltageTempCalc.FastMode     = 1;
                    g_DataBrakePressureVoltageTempCalc.Last         = 0;
                    g_DataBrakePressureVoltageTempCalc.DstSeg       = 0;

                    g_DataBrakePressureVoltageTempCalc.State = DATA_BrakePressureVoltage_TEMP_STATE_FAULT;

                    break;
            }
        }

        // 第4步：显示输出格数
        if ( g_DataBrakePressureVoltageTempCalc.OutputEnable )
        {
            if ( g_BrakePressureVoltageSegNum_Disp < g_DataBrakePressureVoltageTempCalc.DstSeg )    // 需要增加段数时
            {
                if ( g_DataBrakePressureVoltageTempCalc.FastMode )
                    Delta = ( uint8_t )(DATA_BrakePressureVoltage_TEMP_SEG_STEP_FAST / 20);
                else
                    Delta = ( uint8_t )(DATA_BrakePressureVoltage_TEMP_SEG_STEP_SLOW / 20);

                g_DataBrakePressureVoltageTempCalc.DispTimer++;
                if ( g_DataBrakePressureVoltageTempCalc.DispTimer >= Delta )
                {
                    g_DataBrakePressureVoltageTempCalc.DispTimer = 0;
                    g_BrakePressureVoltageSegNum_Disp++;
                }
            }
            else if ( g_BrakePressureVoltageSegNum_Disp > g_DataBrakePressureVoltageTempCalc.DstSeg )    // 需要减少段数时
            {
                if ( g_DataBrakePressureVoltageTempCalc.FastMode )
                    Delta = ( uint8_t )(DATA_BrakePressureVoltage_TEMP_SEG_STEP_FAST / 20);
                else
                    Delta = ( uint8_t )(DATA_BrakePressureVoltage_TEMP_SEG_STEP_SLOW / 20);

                g_DataBrakePressureVoltageTempCalc.DispTimer++;
                if ( g_DataBrakePressureVoltageTempCalc.DispTimer >= Delta )
                {
                    g_DataBrakePressureVoltageTempCalc.DispTimer = 0;
                    g_BrakePressureVoltageSegNum_Disp--;
                }
            }
            else
            {
                g_DataBrakePressureVoltageTempCalc.DispTimer = 0;
                g_DataBrakePressureVoltageTempCalc.FastMode  = 0;
            }
        }
    }
    else
    {
        g_DataBrakePressureVoltageTempCalc.EngineStartTimer = 0;
        g_DataBrakePressureVoltageTempCalc.Backup           = DataBrakePressureVoltage_Temp;
    }
}

uint8_t Get_Brake_Pressure_Voltage_Valid(void)
{
    return g_BrakePressureVoltageValid;
}
uint8_t Get_Brake_Pressure_Voltage_Display(void)
{
    return g_BrakePressureVoltageSegNum_Disp;
}
