#ifndef _BRAKE_PRESSURE_VOLTAGE_TABLE_
#define _BRAKE_PRESSURE_VOLTAGE_TABLE_

#include "TYW_stdint.h"

/*** 状态定义 ***/
#define DATA_BrakePressureVoltage_TEMP_STATE_DELAY  0x00
#define DATA_BrakePressureVoltage_TEMP_STATE_INIT   0x01
#define DATA_BrakePressureVoltage_TEMP_STATE_FAST   0x02
#define DATA_BrakePressureVoltage_TEMP_STATE_NORMAL 0x03
#define DATA_BrakePressureVoltage_TEMP_STATE_FAULT  0x04

/*** 参数设置 ***/
#define DATA_BrakePressureVoltage_TEMP_WAIT_SEC        0
#define DATA_BrakePressureVoltage_TEMP_SEG_STEP_FAST   300      //快速走动时,每走一格间隔的时间,单位ms
#define DATA_BrakePressureVoltage_TEMP_SEG_STEP_SLOW   700     //慢速走动时,每走一格间隔的时间,单位ms
#define DATA_BrakePressureVoltage_TEMP_ENGINE_WAIT_SEC 10000    //等待发动机启动时间,单位ms

#define DATA_BrakePressureVoltage_TEMP_SEG_PER_GROUP 1
#define DATA_BrakePressureVoltage_TEMP_TOTAL_GROUP   5
#define DATA_BrakePressureVoltage_TEMP_TOTAL_SEG     (DATA_BrakePressureVoltage_TEMP_SEG_PER_GROUP * DATA_BrakePressureVoltage_TEMP_TOTAL_GROUP)
#define DATA_HI_BrakePressureVoltage_TEMP_SEG        7


// #define DATA_DrivingEnergy_Timer  1

/*** 控制结构 ***/
typedef struct
{
    uint16_t Backup;
    uint16_t EngineStartTimer;
    uint16_t RecoverTimer;
    uint16_t Last;
    uint8_t  InvalidCnt;
    uint8_t  DstSeg;
    uint8_t  State;
    uint8_t  Wait;
    uint8_t  Prescaler;
    uint8_t  FastMode;
    uint8_t  OutputEnable;
    uint8_t  DispTimer;
} DataBrakePressureVoltageCalcStruct;

typedef struct
{
    uint16_t Up [ DATA_BrakePressureVoltage_TEMP_TOTAL_GROUP / 2 + 1 ];
    uint16_t Dn [ DATA_BrakePressureVoltage_TEMP_TOTAL_GROUP / 2 + 1 ];
} DataBrakePressureVoltageTableStruct;

void Data_BrakePressureVoltage_TempPara_KL30_Init(void);
void Data_BrakePressureVoltage_TempPara_Wakeup_Init(void);
void Data_BrakePressureVoltage_Temp_Processing_Service(void);
uint8_t Get_Brake_Pressure_Voltage_Valid(void);
uint8_t Get_Brake_Pressure_Voltage_Display(void);


#endif