#ifndef CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH0_CAN_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CAN_Lib.h"

extern st_CanMsgOp CAN_CH0_CanMsgOp;

extern st_CanMsgTxOp CAN_CH0_CanMsgTxOp;

typedef enum
{
    CAN_CH0_ID_DM1_ECU_Msg_Count,
    CAN_CH0_ID_DM1_BCU_Msg_Count,
    CAN_CH0_ID_DM1_AMT_Msg_Count,
    CAN_CH0_ID_Tx_057F_Msg_Count,
    CAN_CH0_ID_Tx_FEB1_Msg_Count,
    CAN_CH0_ID_Tx_FEFB_Msg_Count,
    CAN_CH0_ID_Tx_Request_21_Msg_Count,
    CAN_CH0_ID_Tx_Request_17_Msg_Count,
    CAN_CH0_ID_Tx_TCO1_Msg_Count,
    CAN_CH0_ID_Rx_ZFCC_Msg_Count,
    CAN_CH0_ID_Rx_ZF_Msg_Count,
    CAN_CH0_ID_Rx_TRF1_Msg_Count,
    CAN_CH0_ID_Rx_TOT_Msg_Count,
    CAN_CH0_ID_Rx_TC2_Msg_Count,
    CAN_CH0_ID_Rx_TC1_Msg_Count,
    CAN_CH0_ID_Rx_Shutdown_Msg_Count,
    CAN_CH0_ID_Rx_OI_Msg_Count,
    CAN_CH0_ID_Rx_OHCSS_Msg_Count,
    CAN_CH0_ID_Rx_LFE_27_Msg_Count,
    CAN_CH0_ID_Rx_LFE_Msg_Count,
    CAN_CH0_ID_Rx_LFC_Msg_Count,
    CAN_CH0_ID_Rx_IO_Msg_Count,
    CAN_CH0_ID_Rx_IC1_Msg_Count,
    CAN_CH0_ID_RX_HOURS_Msg_Count,
    CAN_CH0_ID_Rx_GPS_Msg_Count,
    CAN_CH0_ID_Rx_Gas_Msg_Count,
    CAN_CH0_ID_Rx_FF45_Msg_Count,
    CAN_CH0_ID_Rx_FF44_Msg_Count,
    CAN_CH0_ID_Rx_FF43_Msg_Count,
    CAN_CH0_ID_Rx_FF42_Msg_Count,
    CAN_CH0_ID_Rx_FF41_Msg_Count,
    CAN_CH0_ID_Rx_FF32_Msg_Count,
    CAN_CH0_ID_Rx_FF31_Msg_Count,
    CAN_CH0_ID_Rx_FE6C_Msg_Count,
    CAN_CH0_ID_Rx_FD95_Msg_Count,
    CAN_CH0_ID_Rx_FD7B_Msg_Count,
    CAN_CH0_ID_Rx_FC2A_Msg_Count,
    CAN_CH0_ID_Rx_F005_Msg_Count,
    CAN_CH0_ID_Rx_ETC7_Msg_Count,
    CAN_CH0_ID_Rx_ET1_Msg_Count,
    CAN_CH0_ID_Rx_ERC1_Msg_Count,
    CAN_CH0_ID_Rx_EP_Msg_Count,
    CAN_CH0_ID_Rx_EFLP1_Msg_Count,
    CAN_CH0_ID_Rx_EEC2_Msg_Count,
    CAN_CH0_ID_Rx_EEC1_0C_Msg_Count,
    CAN_CH0_ID_Rx_EB08_Msg_Count,
    CAN_CH0_ID_Rx_DPFC_Msg_Count,
    CAN_CH0_ID_Rx_DLCC1_Msg_Count,
    CAN_CH0_ID_Rx_DANA_Msg_Count,
    CAN_CH0_ID_Rx_CLUSTER_Msg_Count,
    CAN_CH0_ID_Rx_CCVS1_00_Msg_Count,
    CAN_CH0_ID_Rx_AMB_27_Msg_Count,
    CAN_CH0_ID_Rx_AMB_Msg_Count,
    CAN_CH0_ID_Rx_A1DOC2_Msg_Count,
    CAN_CH0_ID_AT1TI1_A3_Msg_Count,
    CAN_CH0_ID_AT1TI1_3D_Msg_Count,
    CAN_CH0_ID_AT1TI1_00_Msg_Count,

    CAN_CH0_ID_TOTAL_MAX,
} CAN_CH0_CAN_MSG_ID_t;

typedef enum
{
    MSGID_0CFE6C17,
    ID_0CFE6CEE_COUNT,
	ID_18EA0017_COUNT,
	ID_18EA0021_COUNT,
	ID_18FEFB17_COUNT,
	ID_18FEB117_COUNT,
	ID_18057F17_COUNT,
    CAN_CH0_ID_SEND_TOTAL,
} CAN_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] ;

#define  CAN_CH0_ID_DM1_ECU_Msg          0x18FECA00ul
#define  CAN_CH0_ID_DM1_BCU_Msg          0x18FECA21ul
#define  CAN_CH0_ID_DM1_AMT_Msg          0x18FECA03ul
#define  CAN_CH0_ID_Tx_057F_Msg          0x18057F17ul
#define  CAN_CH0_ID_Tx_FEB1_Msg          0x18FEB117ul
#define  CAN_CH0_ID_Tx_FEFB_Msg          0x18FEFB17ul
#define  CAN_CH0_ID_Tx_Request_21_Msg    0x18EA0021ul
#define  CAN_CH0_ID_Tx_Request_17_Msg    0x18EA0017ul
#define  CAN_CH0_ID_Tx_TCO1_Msg          0x0CFE6CEEul
#define  CAN_CH0_ID_Rx_ZFCC_Msg          0x18FF0103ul
#define  CAN_CH0_ID_Rx_ZF_Msg            0x18FF1E03ul
#define  CAN_CH0_ID_Rx_TRF1_Msg          0x18FEF803ul
#define  CAN_CH0_ID_Rx_TOT_Msg           0x18FF1F03ul
#define  CAN_CH0_ID_Rx_TC2_Msg           0x0CF00203ul
#define  CAN_CH0_ID_Rx_TC1_Msg           0x18FF2203ul
#define  CAN_CH0_ID_Rx_Shutdown_Msg      0x18FEE400ul
#define  CAN_CH0_ID_Rx_OI_Msg            0x18FEFF00ul
#define  CAN_CH0_ID_Rx_OHCSS_Msg         0x18FDC700ul
#define  CAN_CH0_ID_Rx_LFE_27_Msg        0x18FEE227ul
#define  CAN_CH0_ID_Rx_LFE_Msg           0x18FEE200ul
#define  CAN_CH0_ID_Rx_LFC_Msg           0x18FEE900ul
#define  CAN_CH0_ID_Rx_IO_Msg            0x18FEDC00ul
#define  CAN_CH0_ID_Rx_IC1_Msg           0x18FEF600ul
#define  CAN_CH0_ID_RX_HOURS_Msg         0x18FEE500ul
#define  CAN_CH0_ID_Rx_GPS_Msg           0x18FBFBF1ul
#define  CAN_CH0_ID_Rx_Gas_Msg           0x18FFFF00ul
#define  CAN_CH0_ID_Rx_FF45_Msg          0x18FF4503ul
#define  CAN_CH0_ID_Rx_FF44_Msg          0x18FF4421ul
#define  CAN_CH0_ID_Rx_FF43_Msg          0x18FF4321ul
#define  CAN_CH0_ID_Rx_FF42_Msg          0x18FF4221ul
#define  CAN_CH0_ID_Rx_FF41_Msg          0x18FF4121ul
#define  CAN_CH0_ID_Rx_FF32_Msg          0x18FF3203ul
#define  CAN_CH0_ID_Rx_FF31_Msg          0x18FF3103ul
#define  CAN_CH0_ID_Rx_FE6C_Msg          0x18FE6C27ul
#define  CAN_CH0_ID_Rx_FD95_Msg          0x18FD9503ul
#define  CAN_CH0_ID_Rx_FD7B_Msg          0x18FD7B00ul
#define  CAN_CH0_ID_Rx_FC2A_Msg          0x18FC2A00ul
#define  CAN_CH0_ID_Rx_F005_Msg          0x00F00503ul
#define  CAN_CH0_ID_Rx_ETC7_Msg          0x18FE4A03ul
#define  CAN_CH0_ID_Rx_ET1_Msg           0x18FEEE00ul
#define  CAN_CH0_ID_Rx_ERC1_Msg          0x18F00029ul
#define  CAN_CH0_ID_Rx_EP_Msg            0x18FF0800ul
#define  CAN_CH0_ID_Rx_EFLP1_Msg         0x18FEEF00ul
#define  CAN_CH0_ID_Rx_EEC2_Msg          0x0CF00300ul
#define  CAN_CH0_ID_Rx_EEC1_0C_Msg       0x0CF00400ul
#define  CAN_CH0_ID_Rx_EB08_Msg          0x18EB0800ul
#define  CAN_CH0_ID_Rx_DPFC_Msg          0x18FD7C00ul
#define  CAN_CH0_ID_Rx_DLCC1_Msg         0x18FD0700ul
#define  CAN_CH0_ID_Rx_DANA_Msg          0x0CFF3003ul
#define  CAN_CH0_ID_Rx_CLUSTER_Msg       0x18FFC100ul
#define  CAN_CH0_ID_Rx_CCVS1_00_Msg      0x18FEF100ul
#define  CAN_CH0_ID_Rx_AMB_27_Msg        0x18FEF527ul
#define  CAN_CH0_ID_Rx_AMB_Msg           0x18FEF500ul
#define  CAN_CH0_ID_Rx_A1DOC2_Msg        0x10FBF5AAul
#define  CAN_CH0_ID_AT1TI1_A3_Msg        0x18FE56A3ul
#define  CAN_CH0_ID_AT1TI1_3D_Msg        0x18FE563Dul
#define  CAN_CH0_ID_AT1TI1_00_Msg        0x18FE5600ul

extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_FlashMalfuctionIndicatorLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_FlashRedWarningLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_FlashAmberWarningLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_FlashProtectLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_MalfuctionIndicatorLampStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_RedWarningLampStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_AmberWarningLampStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_ProtectLampStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA21_Sig_RedWarningLampStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA21_Sig_ProtectLampStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_RedWarningLampStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_AmberWarningLampStatus(void);
extern uint16_t Get_CAN_CH0_ID_18057F17_Sig_TransmissionOilTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18057F17_Sig_AirPressure(void);
extern uint8_t  Get_CAN_CH0_ID_18057F17_Sig_WetBrake(void);
extern uint8_t  Get_CAN_CH0_ID_18057F17_Sig_EldingLevelPercent(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_CoolantLevelLow(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_Seatbelt(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_AutoShiftGear(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_AxleDifferentialLocked(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_DEFResistanceHigh(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_ForbiddenRegenerationIndicator(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_RegenerationIndicator(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_EmergencySteeringSolenoidValve(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_ExhaustedGasTemperatureHigh(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_CoolingFanReversal(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_EngineStop(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_TransmissionFailure(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_RadiatingOilFilterBlocked(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_HydraulicOilFilterBlocked(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_WaterInFuelPreheating(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_AxleFilterBlocked(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_HydraulicOilTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_FuelFilterBlocked(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_TransmissionOilFilterBlocked(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_PowerCutoff(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_TransmissionOilPressureWarning(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_AxleOilTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_AirFilterBlocked(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_ParkingBrake(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_TransmissionOilTemperatureHigh(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_FuelLevelLow(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_CoolantTemperatureHigh(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_EngineOilPressureWarning(void);
extern uint8_t  Get_CAN_CH0_ID_18FEB117_Sig_AirPressureWarning(void);
extern uint32_t Get_CAN_CH0_ID_18FEB117_Sig_Odometer(void);
extern uint8_t  Get_CAN_CH0_ID_18FEFB17_Sig_HydraulicOilTemperature(void);
extern uint32_t Get_CAN_CH0_ID_18EA0021_Sig_PGN(void);
extern uint32_t Get_CAN_CH0_ID_18EA0017_Sig_PGN(void);
extern uint16_t Get_CAN_CH0_ID_0CFE6CEE_Sig_TachographVehicleSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_CalibrationStartConditions(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCR(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCG(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCF(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCC(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCB(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_ClutchStatusCA(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_CalibrationBrakeConditions(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0103_Sig_CalibrationFinished(void);
extern uint8_t  Get_CAN_CH0_ID_18FF1E03_Sig_GearDirection(void);
extern uint8_t  Get_CAN_CH0_ID_18FF1E03_Sig_GearNumber(void);
extern uint16_t Get_CAN_CH0_ID_18FF1E03_Sig_OutputShaftSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF803_Sig_TransmissionOilPressure(void);
extern uint16_t Get_CAN_CH0_ID_18FEF803_Sig_TransmissionOilTankTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTankTemofZF(void);
extern uint8_t  Get_CAN_CH0_ID_18FF1F03_Sig_AEBSubCode(void);
extern uint8_t  Get_CAN_CH0_ID_18FF1F03_Sig_AEBMainCode(void);
extern uint8_t  Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTemperatureofZF(void);
extern uint16_t Get_CAN_CH0_ID_0CF00203_Sig_TorqueConverterInputShaftSpeed(void);
extern uint16_t Get_CAN_CH0_ID_0CF00203_Sig_TorqueConverterOutputShaftSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_0CF00203_Sig_TransmissionDrivelineEngaged(void);
extern uint16_t Get_CAN_CH0_ID_18FF2203_Sig_TorqueConverterTurboTorque(void);
extern uint16_t Get_CAN_CH0_ID_18FF2203_Sig_TorqueConverterPumpWheelTorque(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE400_Sig_EngineWaittoStartLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_DriverWarningSystem(void);
extern uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_WaterInFuel(void);
extern uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_DrivabilityLimitationSystem(void);
extern uint8_t  Get_CAN_CH0_ID_18FDC700_Sig_EngineAlternateRatingSelectState(void);
extern uint16_t Get_CAN_CH0_ID_18FEE227_Sig_InstantaneousFuelConsumption(void);
extern uint16_t Get_CAN_CH0_ID_18FEE200_Sig_InstantaneousFuelConsumption(void);
extern uint32_t Get_CAN_CH0_ID_18FEE900_Sig_TotalFuelConsumption(void);
extern uint32_t Get_CAN_CH0_ID_18FEDC00_Sig_EngineTotalIdleHours(void);
extern uint32_t Get_CAN_CH0_ID_18FEDC00_Sig_EngineTotalIdleFuelUsed(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF600_Sig_IntakeManifoldAirTemperature(void);
extern uint32_t Get_CAN_CH0_ID_18FEE500_Sig_EngineTotalHoursofOperation(void);
extern uint8_t  Get_CAN_CH0_ID_18FBFBF1_Sig_GPSCommand(void);
extern uint8_t  Get_CAN_CH0_ID_18FBFBF1_Sig_GPSLockedShield(void);
extern uint32_t Get_CAN_CH0_ID_18FFFF00_Sig_TotalGasConsumption(void);
extern uint16_t Get_CAN_CH0_ID_18FFFF00_Sig_InstantaneousGasConsumption(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_TorqueConverterOilTemHigh(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_TransmissionOilPanTemHigh(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_OutputShaftTorqueTooHigh(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_InputShaftTorqueTooHigh(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_OutputShaftOverSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_EngineOverSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4503_Sig_GearFailure(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_SteeringWheelLockStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_InPositionStatusIndication(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_ECO(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_AutoShiftGear(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_FNRIndication(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_PowerCutoff(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_MachineQuickChange(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_EmergencySteering(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_StableModuleIndication(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_FanReversal(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_RearviewMirrorHeating(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_OneButtonShaking(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_TheTranslationalLifting(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_BucketAutoReturn(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_BucketAutoFlip(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_MovableArmInching(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_MovableArmAutoRise(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4421_Sig_MovableArmAutoDown(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4321_Sig_BucketMotionStatusIndication(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4321_Sig_MovableArmMotionStatusIndication(void);
extern uint16_t Get_CAN_CH0_ID_18FF4321_Sig_ClampCloseSolenoidValve(void);
extern uint16_t Get_CAN_CH0_ID_18FF4321_Sig_ClampOpenSolenoidValve(void);
extern uint16_t Get_CAN_CH0_ID_18FF4321_Sig_FanSpeedSolenoidValve(void);
extern uint16_t Get_CAN_CH0_ID_18FF4221_Sig_MovableArmDeclineValve(void);
extern uint16_t Get_CAN_CH0_ID_18FF4221_Sig_MovableArmRisingValve(void);
extern uint16_t Get_CAN_CH0_ID_18FF4221_Sig_PullBucketSolenoidValve(void);
extern uint16_t Get_CAN_CH0_ID_18FF4221_Sig_FlipBucketSolenoidValve(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4121_Sig_StabilityModuleOutSolenoidVa2(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4121_Sig_StabilityModuleOuttSolenoidVal1(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4121_Sig_EmergencySteeringSolenoidValve(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4121_Sig_FanReversingValve(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4121_Sig_HydraulicLockStatus(void);
extern uint16_t Get_CAN_CH0_ID_18FF3203_Sig_TransmissionOilPressure(void);
extern uint8_t  Get_CAN_CH0_ID_18FF3203_Sig_FNRIndicator(void);
extern uint8_t  Get_CAN_CH0_ID_18FF3203_Sig_TransmissionOilFilterBlocked(void);
extern uint8_t  Get_CAN_CH0_ID_18FF3203_Sig_NeutralGear(void);
extern uint8_t  Get_CAN_CH0_ID_18FF3203_Sig_PowerCutoff(void);
extern uint16_t Get_CAN_CH0_ID_18FF3203_Sig_MiddleShaftSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_18FF3203_Sig_AutoShiftGear(void);
extern uint8_t  Get_CAN_CH0_ID_18FF3103_Sig_CurrentCalibrationClutch(void);
extern uint8_t  Get_CAN_CH0_ID_18FF3103_Sig_OfflineCalibrationStates(void);
extern uint8_t  Get_CAN_CH0_ID_18FE6C27_Sig_GPSLockVehicleStatus(void);
extern uint16_t Get_CAN_CH0_ID_18FD9503_Sig_TransmissionOilTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18FD7B00_Sig_DPFInternalsootLoad(void);
extern uint16_t Get_CAN_CH0_ID_18FC2A00_Sig_SeverelyLimitSysActiRemaTime(void);
extern uint16_t Get_CAN_CH0_ID_18FC2A00_Sig_PriLimitSysActRemainingTime(void);
extern uint16_t Get_CAN_CH0_ID_00F00503_Sig_TransmissionStates(void);
extern uint8_t  Get_CAN_CH0_ID_00F00503_Sig_TransmissionGear(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmissionMode5Indicator(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmissionMode3Indicator(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmissionMode1Indicator(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmissionMode4Indicator(void);
extern uint16_t Get_CAN_CH0_ID_18FEEE00_Sig_EngineOilTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18FEEE00_Sig_FuelTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18FEEE00_Sig_CoolantTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18F00029_Sig_ActualRetarderPercentTorque(void);
extern uint8_t  Get_CAN_CH0_ID_18FF0800_Sig_EnginePreheating(void);
extern uint8_t  Get_CAN_CH0_ID_18FEEF00_Sig_EngineOilPressure(void);
extern uint8_t  Get_CAN_CH0_ID_0CF00300_Sig_AcceleratorPedalPosition1(void);
extern uint16_t Get_CAN_CH0_ID_0CF00400_Sig_EngineSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_ActualEnginePercentTorque(void);
extern uint8_t  Get_CAN_CH0_ID_18EB0800_Sig_LockVehicleStatusofYunnei(void);
extern uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_ExhaustedGasTemperatureHigh(void);
extern uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_ForbiddenRegenDuetoSysFaultAc(void);
extern uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_AftertreatDieselPartiFilterPas(void);
extern uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_ForbiddenRegenerationIndictor(void);
extern uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_ForbiddenRegenerationDueto(void);
extern uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampCommand(void);
extern uint8_t  Get_CAN_CH0_ID_18FD0700_Sig_OBDMalfunctionIndiLampCom(void);
extern uint8_t  Get_CAN_CH0_ID_18FD0700_Sig_EngineProtectLampCommand(void);
extern uint8_t  Get_CAN_CH0_ID_0CFF3003_Sig_VehicleSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_0CFF3003_Sig_TransmissionOilPressure(void);
extern uint8_t  Get_CAN_CH0_ID_0CFF3003_Sig_TransmissionOilTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_0CFF3003_Sig_GearNumber(void);
extern uint8_t  Get_CAN_CH0_ID_0CFF3003_Sig_GearDirection(void);
extern uint8_t  Get_CAN_CH0_ID_18FFC100_Sig_EnginePTOStatusLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FFC100_Sig_DPFAutoRegLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FFC100_Sig_DPFManualRegLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FFC100_Sig_PMLevel(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseControlStates(void);
extern uint16_t Get_CAN_CH0_ID_18FEF527_Sig_AmbientAirTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF527_Sig_AtmosphericPressure(void);
extern uint16_t Get_CAN_CH0_ID_18FEF500_Sig_AmbientAirTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF500_Sig_AtmosphericPressure(void);
extern uint16_t Get_CAN_CH0_ID_10FBF5AA_Sig_VehicleSpeed(void);
extern uint16_t Get_CAN_CH0_ID_10FBF5AA_Sig_TirePressure(void);
extern uint16_t Get_CAN_CH0_ID_10FBF5AA_Sig_BackwardMinimumCurrent(void);
extern uint16_t Get_CAN_CH0_ID_10FBF5AA_Sig_ForwardMinimumCurrent(void);
extern uint8_t  Get_CAN_CH0_ID_18FE56A3_Sig_AdBlueTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18FE56A3_Sig_AdBlueLevel(void);
extern uint8_t  Get_CAN_CH0_ID_18FE563D_Sig_AdBlueLevel(void);
extern uint8_t  Get_CAN_CH0_ID_18FE5600_Sig_DEFHighResistance(void);
extern uint8_t  Get_CAN_CH0_ID_18FE5600_Sig_AdBlueTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18FE5600_Sig_AdBlueLevel(void);

extern uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID);

#endif
