#include "Common_Interface.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "System_Monitor.h"
#include "Data_VSpeed.h"
#include "Data_ESpeed.h"

#pragma ghs section bss = ".myNonInitArea"

static uint32_t PowerIgnOnTimeLine;
static uint32_t PowerIgnOffTimeLine;
static uint32_t PowerRunningTimeLine;

static COMMON_PowerStatus_t PowerSts;    /*1 ON ;  0 OFF*/
static uint16_t             Act_V_Speed; /*实际值,十倍的*/
static uint16_t             Act_E_Speed;
static uint16_t             Disp_V_Speed; /*显示值,十倍的*/
static uint16_t             Disp_E_Speed;
static DataValid_t          PowerSts_Valid;
static DataValid_t          Act_V_Speed_Valid;
static DataValid_t          Act_E_Speed_Valid;
static DataValid_t          Disp_V_Speed_Valid;
static DataValid_t          Disp_E_Speed_Valid;

#pragma ghs section bss = default

/*每次唤醒调用*/
void Common_DataInit(void)
{
    PowerSts     = COMMON_POWER_UNKNOW;
    Act_V_Speed  = 0xFFFFU;
    Act_E_Speed  = 0xFFFFU;
    Disp_V_Speed = 0xFFFFU;
    Disp_E_Speed = 0xFFFFU;

    PowerSts_Valid       = COMMON_Valid_UNKNOW;
    Act_V_Speed_Valid    = COMMON_Valid_UNKNOW;
    Act_E_Speed_Valid    = COMMON_Valid_UNKNOW;
    Disp_V_Speed_Valid   = COMMON_Valid_UNKNOW;
    Disp_E_Speed_Valid   = COMMON_Valid_UNKNOW;
    PowerIgnOnTimeLine   = 0x0ul;
    PowerIgnOffTimeLine  = 0x0ul;
    PowerRunningTimeLine = 0x0ul;
}

/*以下由各个处理模块按需调用*/
/*使用数据之前,需要先判断数据是否有效,如果无效,则不可以使用*/

uint8_t Common_Get_IG_Sts(void)
{
    return ( uint8_t )PowerSts;
}

uint16_t Common_Get_Act_V_Speed(void)
{
    return Act_V_Speed;
}
uint16_t Common_Get_Act_E_Speed(void)
{
    return Act_E_Speed;
}
uint16_t Common_Get_Disp_V_Speed(void)
{
    return Disp_V_Speed;
}
uint16_t Common_Get_Disp_E_Speed(void)
{
    return Disp_E_Speed;
}

uint16_t Common_Get_TireSize(void)
{
    return 1u;
}

void Common_Set_IG_Sts(COMMON_PowerStatus_t Val)
{
    PowerSts = Val;
}
void Common_Set_Act_V_Speed(uint16_t Val)
{
    Act_V_Speed = Val;
}
void Common_Set_Act_E_Speed(uint16_t Val)
{
    Act_E_Speed = Val;
}
void Common_Set_Disp_V_Speed(uint16_t Val)
{
    Disp_V_Speed = Val;
}
void Common_Set_Disp_E_Speed(uint16_t Val)
{
    Disp_E_Speed = Val;
}

DataValid_t Common_Get_IG_Sts_Valid(void)
{
    return PowerSts_Valid;
}
DataValid_t Common_Get_Act_V_Speed_Valid(void)
{
    return Act_V_Speed_Valid;
}
DataValid_t Common_Get_Act_E_Speed_Valid(void)
{
    return Act_E_Speed_Valid;
}
DataValid_t Common_Get_Disp_V_Speed_Valid(void)
{
    return Disp_V_Speed_Valid;
}
DataValid_t Common_Get_Disp_E_Speed_Valid(void)
{
    return Disp_E_Speed_Valid;
}

void Common_Set_IG_Sts_Valid(DataValid_t Val)
{
    PowerSts_Valid = Val;
}
void Common_Set_Act_V_Speed_Valid(DataValid_t Val)
{
    Act_V_Speed_Valid = Val;
}
void Common_Set_Act_E_Speed_Valid(DataValid_t Val)
{
    Act_E_Speed_Valid = Val;
}
void Common_Set_Disp_V_Speed_Valid(DataValid_t Val)
{
    Disp_V_Speed_Valid = Val;
}
void Common_Set_Disp_E_Speed_Valid(DataValid_t Val)
{
    Disp_E_Speed_Valid = Val;
}

uint16_t Common_Get_DispSpeed(void)
{
    uint16_t m_Res;
    if ( Disp_V_Speed_Valid )
    {
        m_Res = (((Disp_V_Speed / 10u) * 16u) / 9u);
    }
    else
    {
        m_Res = 0x1fffu;
    }
    return m_Res;
}

void Common_Input_Para(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        Common_Set_IG_Sts(COMMON_POWER_ON);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        Common_Set_Act_V_Speed(Get_ActualVechileSpeed( ));
        Common_Set_Act_E_Speed(Get_ActualEngineSpeed( ));
        Common_Set_Disp_V_Speed(Get_DispVechileSpeed( ));
        Common_Set_Disp_E_Speed(Get_DispEngineSpeed( ));
        if ( Get_VechileSpeedValid( ) == COMMON_Valid )
        {
            Common_Set_Act_V_Speed_Valid(COMMON_Valid);
            Common_Set_Disp_V_Speed_Valid(COMMON_Valid);
        }
        else
        {
            Common_Set_Act_V_Speed_Valid(COMMON_InValid);
            Common_Set_Disp_V_Speed_Valid(COMMON_InValid);
        }

        if ( Get_EngineValid( ) == COMMON_Valid )
        {
            Common_Set_Act_E_Speed_Valid(COMMON_Valid);
            Common_Set_Disp_E_Speed_Valid(COMMON_Valid);
        }
        else
        {
            Common_Set_Act_E_Speed_Valid(COMMON_InValid);
            Common_Set_Disp_E_Speed_Valid(COMMON_InValid);
        }

        PowerIgnOffTimeLine = 0ul;
        if ( PowerIgnOnTimeLine < 0x7ffffffful )
        {
            PowerIgnOnTimeLine += 2u;
        }
    }
    else
    {
        PowerIgnOnTimeLine = 0ul;
        if ( PowerIgnOffTimeLine < 0x7ffffffful )
        {
            PowerIgnOffTimeLine += 2u;
        }
        Common_Set_IG_Sts(COMMON_POWER_OFF);
        Common_Set_IG_Sts_Valid(COMMON_Valid);

        /*车转真实值OFF为0*/
        Common_Set_Act_V_Speed(0u);
        Common_Set_Act_E_Speed(0u);
        Common_Set_Disp_V_Speed(0u);
        Common_Set_Disp_E_Speed(0u);
    }

    // if ( Get_CAN_CH0_ID_1A6_Sig_EMS_EngineStatus( ) == 2u )
    // {
    //     if ( PowerRunningTimeLine < 0x7ffffffful )
    //     {
    //         PowerRunningTimeLine += 2;
    //     }
    // }
    // else
    {
        PowerRunningTimeLine = 0u;
    }
}

uint32_t Common_GetIgnOnTime(void)
{
    return PowerIgnOnTimeLine;
}

uint32_t Common_GetIgnOffTime(void)
{
    return PowerIgnOffTimeLine;
}

uint32_t Common_GetRunningTime(void)
{
    return PowerRunningTimeLine;
}
