#ifndef _COMMON_INTERFACE_H_
#define _COMMON_INTERFACE_H_

#include "TYW_stdint.h"

void Common_DataInit(void);
void Common_Input_Para(void);

uint8_t     Common_Get_IG_Sts(void);
DataValid_t Common_Get_IG_Sts_Valid(void);

void Common_Set_IG_Sts(COMMON_PowerStatus_t Val);
void Common_Set_IG_Sts_Valid(DataValid_t Val);

uint16_t Common_Get_Act_V_Speed(void);
uint16_t Common_Get_Act_E_Speed(void);
uint16_t Common_Get_Disp_V_Speed(void);
uint16_t Common_Get_Disp_E_Speed(void);

DataValid_t Common_Get_Act_V_Speed_Valid(void);
DataValid_t Common_Get_Act_E_Speed_Valid(void);
DataValid_t Common_Get_Disp_V_Speed_Valid(void);
DataValid_t Common_Get_Disp_E_Speed_Valid(void);

void     Common_Set_Act_V_Speed(uint16_t Val);
void     Common_Set_Act_E_Speed(uint16_t Val);
void     Common_Set_Disp_V_Speed(uint16_t Val);
void     Common_Set_Disp_E_Speed(uint16_t Val);
uint16_t Common_Get_TireSize(void);

void Common_Set_Act_V_Speed_Valid(DataValid_t Val);
void Common_Set_Act_E_Speed_Valid(DataValid_t Val);
void Common_Set_Disp_V_Speed_Valid(DataValid_t Val);
void Common_Set_Disp_E_Speed_Valid(DataValid_t Val);

uint16_t Common_Get_DispSpeed(void);

uint32_t Common_GetIgnOnTime(void);   /*ms*/
uint32_t Common_GetIgnOffTime(void);  /*ms*/
uint32_t Common_GetRunningTime(void); /*ms*/

#endif
