#ifndef _CONFIGURATION_H_
#define _CONFIGURATION_H_

#include "TYW_stdint.h"

typedef enum                //发动机类型配置
{
    NULLSTARTER ,
    WEICHAI     ,
    SHANGCHAI   ,
    KANGMINGSI  ,
    YUNNEI      ,
    YUCHAI      ,
    LUOTUO      ,
} Starter_Type;

typedef enum                        
{
    valid,
    invalid,

} Enable_Type;


typedef struct 
{
    double slope;
    double intercept;
} LinearFunction;

LinearFunction calculateLinearFunction(double x1, double y1, double x2, double y2);

Starter_Type Get_Stater_Type(void);
Enable_Type VSpeed_Enable(void);    //车速使能配置
uint16_t VSpeed_Error_Value(void);  //车速误差系数配置
uint32_t K_Value(void);             //K值配置
uint16_t Get_Voltage_Threshold_Low(void);
uint16_t Get_Voltage_Threshold_High(void);
uint16_t Get_Power_Cut_Off_Configuration_Valid_High(void);        //配置高有效或低有效
uint16_t Get_Barometric_Threshold_Low(void);                                                //制动气压低阈值配置（十倍参数）
uint16_t Get_Barometric_Threshold_High(void);                                               //制动气压高阈值配置（十倍参数）
uint16_t Wet_Get_Barometric_Threshold_Low(void);                                            //湿式制动气压低阈值配置(一倍)
uint16_t Brake_Pressure_Acquisition(uint16_t Brake_Pressure_Voltage );                      //制动气压电压换算成气压
uint16_t Brake_Pressure_Acquisition_Resistance(uint16_t Brake_Pressure_Resistance );        //制动气压电阻换算成气压
uint16_t Wet_Brake_Pressure_Acquisition(uint16_t Wet_Brake_Pressure_Voltage );              //湿式制动气压电压换算成气压
uint16_t Get_Transmission_Oil_Temperature_threshold_High(void);                             //变速箱油温高阈值配置
uint16_t Transmission_Oil_Temperature_Resistance(uint16_t Oil_Temperature_Resistance );     //变速箱油温电阻换算成温度
uint16_t Get_Coolant_Temperature_threshold_High(void);                                      //水温高阈值配置


uint16_t Get_EngineOilPressure_Threshold_Low(void);
uint16_t Get_EngineOilPressure_Threshold_High(void);
uint16_t Get_Urea_Threshold_Low(void);
uint16_t Get_EldingLevel_Low(void);
uint16_t Get_Hydraulic_Oil_Temperature_High(void);
uint16_t Get_TransmissionOilPressure_Low(void);
uint16_t Get_TransmissionOilPressure_High(void);
uint32_t Get_EldingLevel_status(void);            //燃油液位低指示灯 电阻转液位
uint32_t Get_Transmission_Oil_Pressure(void);     //变速箱油压   由电压值获取油压值
uint32_t Get_TransmissionOilPressure(void);       //变速箱油压   由输入值（CAN、硬线）获取油压值  
uint32_t Get_Hydraulic_Oil_Resistance_Temperature(void);   //由液压油温高的电阻值得到对应温度
#endif
