#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Common_Interface.h"
#include "Data_Gear.h"
#include "EOL_Para.h"

static Data_Gear_Number DataGearNmber;
static Data_Gear_Direction DataGearDirection;
static uint8_t DataGear;
static uint8_t DataGearValid;

/*该服务函数首次KL30是调用一次*/
void Data_Gear_KL30_Wakeup_Init(void)
{
    DataGearNmber = GEAR_NONE;
    DataGearDirection = GEAR_NULL;
    DataGearValid = 0;
}

/*档位处理服务*/
void Data_Gear_Service_Processing(void)
{

    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {

        // 变速箱类型为ZF变速箱或徐工自制变速箱
        if ((Val_EOL_0300_Transmission_Type_Configuration() == 1) ||
            (Val_EOL_0300_Transmission_Type_Configuration() == 3))
        {
            if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_ZF_Msg_Count) == CAN_SIG_LOST))
            {
                if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_F005_Msg_Count) == CAN_SIG_LOST)
                {
                    DataGearNmber = GEAR_NONE;
                    DataGearDirection = GEAR_NULL;
                }
                else
                {
                    DataGear = Get_CAN_CH0_ID_00F00503_Sig_TransmissionGear();
                    switch (DataGear)
                    {
                    case 0x7A:
                        DataGearNmber = GEAR_3;
                        DataGearDirection = GEAR_R;
                        break;

                    case 0x7B:
                        DataGearNmber = GEAR_2;
                        DataGearDirection = GEAR_R;
                        break;

                    case 0x7C:
                        DataGearNmber = GEAR_1;
                        DataGearDirection = GEAR_R;
                        break;

                    case 0x7D:
                        DataGearNmber = GEAR_NONE;
                        DataGearDirection = GEAR_N;
                        break;

                    case 0x7E:
                        DataGearNmber = GEAR_1;
                        DataGearDirection = GEAR_F;
                        break;

                    case 0x7F:
                        DataGearNmber = GEAR_2;
                        DataGearDirection = GEAR_F;
                        break;

                    case 0x80:
                        DataGearNmber = GEAR_3;
                        DataGearDirection = GEAR_F;
                        break;

                    case 0x81:
                        DataGearNmber = GEAR_4;
                        DataGearDirection = GEAR_F;
                        break;

                    case 0x82:
                        DataGearNmber = GEAR_5;
                        DataGearDirection = GEAR_F;
                        break;

                    case 0x83:
                        DataGearNmber = GEAR_6;
                        DataGearDirection = GEAR_F;
                        break;

                    default:
                        DataGearNmber = GEAR_NONE;
                        DataGearDirection = GEAR_NULL;
                        break;
                    }
                }
            }
            else
            {
                DataGearDirection = (Data_Gear_Direction)((Get_CAN_CH0_ID_18FF1E03_Sig_GearDirection()) + 1);
                if (Get_CAN_CH0_ID_18FF1E03_Sig_GearNumber() <= 8)
                {
                    DataGearNmber = (Data_Gear_Number)(Get_CAN_CH0_ID_18FF1E03_Sig_GearNumber());
                }
                else
                {
                    DataGearNmber = GEAR_NONE;
                }
            }
        }

        //变速箱为DANA变速箱时
        else if((Val_EOL_0300_Transmission_Type_Configuration() == 2))
        {
            if((Get_CAN_CH0_ID_0CFF3003_Sig_GearDirection() == 3) ||
            (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_DANA_Msg_Count) == CAN_SIG_LOST))
            {
                DataGearDirection = GEAR_NULL;
            }
            else
            {
                DataGearDirection = (Data_Gear_Direction)(Get_CAN_CH0_ID_0CFF3003_Sig_GearDirection() + 1);
            }

            if ((Get_CAN_CH0_ID_0CFF3003_Sig_GearNumber() == 0) ||
                (Get_CAN_CH0_ID_0CFF3003_Sig_GearNumber() > 8)  ||
                (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_DANA_Msg_Count) == CAN_SIG_LOST))
            {
                DataGearNmber = GEAR_NONE;
            }
            else
            {
                DataGearNmber = (Data_Gear_Number)(Get_CAN_CH0_ID_0CFF3003_Sig_GearNumber());
            }
        }
    }
}

/******************************************************************************
函数名：Get_Gear_Disp_Nmber
功  能: 获得档位数字
返回值：NONE/1~8
******************************************************************************/
Data_Gear_Number Get_Gear_Disp_Nmber(void)
{
    return DataGearNmber;
}

/******************************************************************************
函数名：Get_Gear_Disp_Direction
功  能: 获得档位方向
返回值：NULL/N/F/R
******************************************************************************/
Data_Gear_Direction Get_Gear_Disp_Direction(void)
{
    return DataGearDirection;
}
