#ifndef Data_IGN_OFF_Timing_H
#define Data_IGN_OFF_Timing_H

#ifdef Platform_16Bit
    #define OffTimeLib_uint8_t  unsigned char
    #define OffTimeLib_uint16_t unsigned int
    #define OffTimeLib_uint32_t unsigned long
#else
    #define OffTimeLib_uint8_t  unsigned char
    #define OffTimeLib_uint16_t unsigned short
    #define OffTimeLib_uint32_t unsigned int
    #define OffTimeLib_uint64_t unsigned long long
#endif

#define OffTime_COMMON_POWER_OFF 0u
#define OffTime_COMMON_POWER_ON  1u

typedef OffTimeLib_uint8_t (*g_OffTime_Get_Sys_IG_Sts)(void);

typedef struct
{
    OffTimeLib_uint8_t (*Use_OffTime_Get_Sys_IG_Sts)(void);
    OffTimeLib_uint8_t  IGNStatus;
    OffTimeLib_uint16_t RoCBackup;
    OffTimeLib_uint32_t time;
} DataIGNOffTimingStruct;

OffTimeLib_uint32_t Get_IGN_SLEEP_TIME(void);
void                Data_IGN_Off_Timing_Service(void);
void                Data_IGN_Off_Timing_KL15_Init(DataIGNOffTimingStruct *data, OffTimeLib_uint8_t *MemSpace);
void                Data_IGN_OFF_RollingCounter(void);
OffTimeLib_uint32_t Get_IGN_OFF_Time(OffTimeLib_uint32_t Time_compensate);
void                Data_IGN_Off_Timing_KL30_Init(DataIGNOffTimingStruct *data, OffTimeLib_uint8_t *MemSpace);
#endif