#include "Data_IGN_OFF_Timing_User.h"
#include <string.h>
#include "Data_IGN_OFF_Timing.h"
#include "Common_Interface.h"

#include "Services_UTC.h"
#include "RTC.h"
#define OffTime_MEM_Block_Size 4u
/*backram*/
#pragma ghs section bss = ".myNonInitArea"
#pragma alignvar(8)
OffTimeLib_uint8_t  OffTime_Mem [ OffTime_MEM_Block_Size ];
_MYTIME_STRUCT      Save_Time;
_MYTIME_STRUCT      Power_ON_Time;
#pragma ghs section bss = default

void Data_IGN_OFF_Timing_User_KL30_Init(void)
{
    DataIGNOffTimingStruct data = {0u};
    data.IGNStatus              = 0u;
    data.RoCBackup              = 0u;

    Save_Time.nYear                 = 0U;
    Save_Time.nMonth                = 0U;
    Save_Time.nDay                  = 0U;
    Save_Time.nHour                 = 0U;
    Save_Time.nMin                  = 0U;
    Save_Time.nSec                  = 0U;
    Power_ON_Time.nYear             = 0U;
    Power_ON_Time.nMonth            = 0U;
    Power_ON_Time.nDay              = 0U;
    Power_ON_Time.nHour             = 0U;
    Power_ON_Time.nMin              = 0U;
    Power_ON_Time.nSec              = 0U;
    data.Use_OffTime_Get_Sys_IG_Sts = ( g_OffTime_Get_Sys_IG_Sts )Common_Get_IG_Sts;
    memset(OffTime_Mem, 0, sizeof(OffTime_Mem));
    Data_IGN_Off_Timing_KL30_Init(&data, OffTime_Mem);
}

void Data_IGN_OFF_Timing_User_KL15_Init(void)
{
    DataIGNOffTimingStruct data = {0u};

    data.Use_OffTime_Get_Sys_IG_Sts = ( g_OffTime_Get_Sys_IG_Sts )Common_Get_IG_Sts;

    Data_IGN_Off_Timing_KL15_Init(&data, OffTime_Mem);
}

void Data_Clear_OFF_Time(void)
{
    /*  uint8_t i;
  for(i=0;i<4;i++)
  {
    OffTime_Mem[i] = 0;
  }             */
}

void Data_Save_Cur_Time(void)
{
    Save_Time.nYear  = RTC_YEAR + 2000U;
    Save_Time.nMonth = RTC_MONTH;
    Save_Time.nDay   = RTC_DATE;
    Save_Time.nHour  = RTC_HOUR;
    Save_Time.nMin   = RTC_MINUTE;
    Save_Time.nSec   = RTC_SECOND;
}
void Data_Cal_Elapse(void)
{
    unsigned long int Total_Time  = 0ul;
    unsigned long int IG_OFF_TIME = 0ul;
    unsigned long int IG_ON_TIME  = 0ul;
    Power_ON_Time.nYear           = RTC_YEAR + 2000u;
    Power_ON_Time.nMonth          = RTC_MONTH;
    Power_ON_Time.nDay            = RTC_DATE;
    Power_ON_Time.nHour           = RTC_HOUR;
    Power_ON_Time.nMin            = RTC_MINUTE;
    Power_ON_Time.nSec            = RTC_SECOND;

    IG_OFF_TIME = mytime_2_utc_sec(&Save_Time);
    IG_ON_TIME  = mytime_2_utc_sec(&Power_ON_Time);

    if ( IG_OFF_TIME < IG_ON_TIME )
    {
        Total_Time = IG_ON_TIME - IG_OFF_TIME;
    }
    else
    {
        Total_Time = 0ul;
    }
    if ( Total_Time > 65534u )
    {
        Total_Time = 65535u;
    }
    Get_IGN_OFF_Time(Total_Time);
}