#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Common_Interface.h"
#include "Data_Water_Tem_Table.h"
#include "LED_Map.h"
#include "RTE_LED.h"
#include "DisplaySch.h"

static uint8_t                g_PowerSocSegNum_Disp;
static uint8_t                g_PowerSocValid;          //  -0 无效 -1 有效
static DataPowerSOCCalcStruct g_DataPowerSocTempCalc;

/*** 水温上升表格 ***/
static const uint16_t DataPowerSocTable_Up [ DATA_POWERSOC_TEMP_TOTAL_SEG ] =
    /*显示段：|    0     |    1     |    2     |    3     |    4     |    5     |    6    |     7    |*/
    {41, 51, 61, 71, 81, 91, 106, 111};    // 上升时小于等于表值则熄灭相应段

/*** 水温下降表格 ***/
static const uint16_t DataPowerSocTable_Dn [ DATA_POWERSOC_TEMP_TOTAL_SEG ] =
    /*显示段：|    0     |    1     |    2     |    3     |    4     |    5     |    6    |     7    |*/
    {38, 48, 58, 68, 78, 88, 103, 108};    // 下降时小于等于表值则熄灭相应段

void Data_PowerSoc_TempPara_KL30_Init(void)
{
    g_DataPowerSocTempCalc.FastMode         = 0u;
    g_PowerSocSegNum_Disp                   = 0u;
    g_PowerSocValid                         = 1u;
    g_DataPowerSocTempCalc.Last             = 0u;
    g_DataPowerSocTempCalc.InvalidCnt       = 0u;
    g_DataPowerSocTempCalc.DstSeg           = 0u;
    g_DataPowerSocTempCalc.State            = DATA_POWERSOC_TEMP_STATE_DELAY;
    g_DataPowerSocTempCalc.Wait             = DATA_POWERSOC_TEMP_WAIT_SEC * 10;
    g_DataPowerSocTempCalc.Prescaler        = 0u;
    g_DataPowerSocTempCalc.OutputEnable     = 0u;
    g_DataPowerSocTempCalc.DispTimer        = 0u;
    g_DataPowerSocTempCalc.EngineStartTimer = 0u;
    g_DataPowerSocTempCalc.Backup           = 0u;
}

void Data_PowerSoc_TempPara_Wakeup_Init(void)
{
    g_PowerSocSegNum_Disp                   = 0u;
    g_PowerSocValid                         = 1u;
    g_DataPowerSocTempCalc.Last             = 0u;
    g_DataPowerSocTempCalc.InvalidCnt       = 0u;
    g_DataPowerSocTempCalc.DstSeg           = 0u;
    g_DataPowerSocTempCalc.State            = DATA_POWERSOC_TEMP_STATE_DELAY;
    g_DataPowerSocTempCalc.Wait             = DATA_POWERSOC_TEMP_WAIT_SEC * 10;
    g_DataPowerSocTempCalc.Prescaler        = 0u;
    g_DataPowerSocTempCalc.OutputEnable     = 0u;
    g_DataPowerSocTempCalc.DispTimer        = 0u;
    g_DataPowerSocTempCalc.EngineStartTimer = 0u;
}

/******************************************************************************
函数名：Data_PowerSoc_Temp_Processing_Service
功  能：SOC数据处理函数
参  数：无
返回值：无
*******************************************************************************
注  意：该函数必须每20ms被调用一次
******************************************************************************/
void Data_PowerSoc_Temp_Processing_Service(void)
{
    uint8_t  Data_Power_SOC    = 0u;
    uint8_t  Delta             = 0u;
    uint16_t DataPowerSoc_Temp = 0u;

    if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_ET1_Msg_Count) == CAN_SIG_LOST)
        {
            g_PowerSocValid   = 0u;
            DataPowerSoc_Temp = 0u;
        }
        else
        {
            Data_Power_SOC = Get_CAN_CH0_ID_18FEEE00_Sig_CoolantTemperature( );

            if(Data_Power_SOC < 40)
            {
                Data_Power_SOC = 0;
            }
            else
            {
                Data_Power_SOC -= 40;
            }

            if ( Data_Power_SOC > 210 )
            {
                g_PowerSocValid = 0u;
                Data_Power_SOC  = 0;
            }
            else
            {
                DataPowerSoc_Temp = ( uint16_t )Data_Power_SOC;
                // g_DataPowerSocTempCalc.Backup = DataPowerSoc_Temp;

                g_PowerSocValid = 1u;
            }
        }
        // if ( DataPowerSocFristPower == 2u )
        // {
        //     DataPowerSocFristPower = 1u;
        // }

        // 第2步：获取水温格数
        if ( g_PowerSocValid )
        {
            if ( DataPowerSoc_Temp > g_DataPowerSocTempCalc.Last )    // 新水温高于前次水温,查上升表
            {
                while ( g_DataPowerSocTempCalc.DstSeg < DATA_POWERSOC_TEMP_TOTAL_SEG )
                {
                    if ( DataPowerSoc_Temp < DataPowerSocTable_Up [ g_DataPowerSocTempCalc.DstSeg ] )
                        break;
                    g_DataPowerSocTempCalc.DstSeg++;
                }
            }
            else if ( DataPowerSoc_Temp < g_DataPowerSocTempCalc.Last )    // 新水温低于前次水温,查下降表
            {
                while ( g_DataPowerSocTempCalc.DstSeg )
                {
                    if ( DataPowerSoc_Temp > DataPowerSocTable_Dn [ g_DataPowerSocTempCalc.DstSeg - 1 ] )
                        break;
                    g_DataPowerSocTempCalc.DstSeg--;
                }
            }

            g_DataPowerSocTempCalc.Last = DataPowerSoc_Temp;
        }

        // 第3步：状态转换,每100ms执行一次
        g_DataPowerSocTempCalc.Prescaler++;
        if ( g_DataPowerSocTempCalc.Prescaler >= 5 )
        {
            g_DataPowerSocTempCalc.Prescaler = 0;

            switch ( g_DataPowerSocTempCalc.State )
            {
                case DATA_POWERSOC_TEMP_STATE_DELAY:
                    if ( g_DataPowerSocTempCalc.Wait )
                        g_DataPowerSocTempCalc.Wait--;
                    else
                        g_DataPowerSocTempCalc.State = DATA_POWERSOC_TEMP_STATE_INIT;

                    break;

                case DATA_POWERSOC_TEMP_STATE_INIT:
                    if ( g_PowerSocValid )
                    {
                        if ( g_DataPowerSocTempCalc.DstSeg )
                        {
                            g_DataPowerSocTempCalc.OutputEnable = 1;
                            g_DataPowerSocTempCalc.FastMode     = 1;
                            g_DataPowerSocTempCalc.State        = DATA_POWERSOC_TEMP_STATE_FAST;
                        }
                    }
                    else
                    {
                        g_DataPowerSocTempCalc.OutputEnable = 1;
                        g_DataPowerSocTempCalc.FastMode     = 1;
                        g_DataPowerSocTempCalc.Last         = 0;
                        g_DataPowerSocTempCalc.DstSeg       = 0;

                        g_DataPowerSocTempCalc.State = DATA_POWERSOC_TEMP_STATE_FAULT;
                    }

                    break;

                case DATA_POWERSOC_TEMP_STATE_FAST:
                    if ( g_PowerSocValid )
                    {
                        if ( g_DataPowerSocTempCalc.FastMode == 0 )
                            g_DataPowerSocTempCalc.State = DATA_POWERSOC_TEMP_STATE_NORMAL;
                    }
                    else
                    {
                        g_DataPowerSocTempCalc.OutputEnable = 1;
                        g_DataPowerSocTempCalc.FastMode     = 1;
                        g_DataPowerSocTempCalc.Last         = 0;
                        g_DataPowerSocTempCalc.DstSeg       = 0;

                        g_DataPowerSocTempCalc.State = DATA_POWERSOC_TEMP_STATE_FAULT;
                    }

                    break;

                case DATA_POWERSOC_TEMP_STATE_NORMAL:
                    if ( g_PowerSocValid == 0 )
                    {
                        g_DataPowerSocTempCalc.OutputEnable = 1;
                        g_DataPowerSocTempCalc.FastMode     = 1;
                        g_DataPowerSocTempCalc.Last         = 0;
                        g_DataPowerSocTempCalc.DstSeg       = 0;

                        g_DataPowerSocTempCalc.State = DATA_POWERSOC_TEMP_STATE_FAULT;
                    }

                    break;

                case DATA_POWERSOC_TEMP_STATE_FAULT:
                    if ( g_PowerSocValid )
                        g_DataPowerSocTempCalc.State = DATA_POWERSOC_TEMP_STATE_INIT;

                    break;

                default:
                    g_PowerSocSegNum_Disp               = 0;
                    DataPowerSoc_Temp                   = 0;
                    g_PowerSocValid                     = 0;
                    g_DataPowerSocTempCalc.OutputEnable = 1;
                    g_DataPowerSocTempCalc.FastMode     = 1;
                    g_DataPowerSocTempCalc.Last         = 0;
                    g_DataPowerSocTempCalc.DstSeg       = 0;

                    g_DataPowerSocTempCalc.State = DATA_POWERSOC_TEMP_STATE_FAULT;

                    break;
            }
        }

        // 第4步：显示输出格数
        if ( g_DataPowerSocTempCalc.OutputEnable )
        {
            if ( g_PowerSocSegNum_Disp < g_DataPowerSocTempCalc.DstSeg )    // 需要增加段数时
            {
                if ( g_DataPowerSocTempCalc.FastMode )
                    Delta = ( uint8_t )(DATA_POWERSOC_TEMP_SEG_STEP_FAST / 20);
                else
                    Delta = ( uint8_t )(DATA_POWERSOC_TEMP_SEG_STEP_SLOW / 20);

                g_DataPowerSocTempCalc.DispTimer++;
                if ( g_DataPowerSocTempCalc.DispTimer >= Delta )
                {
                    g_DataPowerSocTempCalc.DispTimer = 0;
                    g_PowerSocSegNum_Disp++;
                }
            }
            else if ( g_PowerSocSegNum_Disp > g_DataPowerSocTempCalc.DstSeg )    // 需要减少段数时
            {
                if ( g_DataPowerSocTempCalc.FastMode )
                    Delta = ( uint8_t )(DATA_POWERSOC_TEMP_SEG_STEP_FAST / 20);
                else
                    Delta = ( uint8_t )(DATA_POWERSOC_TEMP_SEG_STEP_SLOW / 20);

                g_DataPowerSocTempCalc.DispTimer++;
                if ( g_DataPowerSocTempCalc.DispTimer >= Delta )
                {
                    g_DataPowerSocTempCalc.DispTimer = 0;
                    g_PowerSocSegNum_Disp--;
                }
            }
            else
            {
                g_DataPowerSocTempCalc.DispTimer = 0;
                g_DataPowerSocTempCalc.FastMode  = 0;
            }
        }
    }
    else
    {
        g_DataPowerSocTempCalc.EngineStartTimer = 0;
        g_DataPowerSocTempCalc.Backup           = DataPowerSoc_Temp;
        // if ( DataPowerSocFristPower == 1 )
        // {
        //     DataPowerSocFristPower = 0;
        // }
    }
}

uint8_t Get_Power_Soc_Valid(void)
{
    return g_PowerSocValid;
}
uint8_t Get_Power_Soc_Display(void)
{
    return g_PowerSocSegNum_Disp;
}

//水温段数处理
void Water_Tem_Table_Processing(uint8_t table)
{
    switch (table)
    {
    case 1:
        GPIO_SET_LED_WATER_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM3_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM4_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM5_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM6_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM7_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

        case 2:
        GPIO_SET_LED_WATER_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM3_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM4_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM5_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM6_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;
        
        case 3:
        GPIO_SET_LED_WATER_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM3_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM4_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM5_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM6_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

        case 4:
        GPIO_SET_LED_WATER_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM3_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM4_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM5_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM6_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

        case 5:
        GPIO_SET_LED_WATER_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM3_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM4_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM5_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM6_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

        case 6:
        GPIO_SET_LED_WATER_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM3_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM4_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM5_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM6_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

        case 7:
        GPIO_SET_LED_WATER_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM2_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM3_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM4_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM5_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM6_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

        case 8:
        GPIO_SET_LED_WATER_TEM1_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM2_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM3_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM4_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM5_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM6_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

    default:
        GPIO_SET_LED_WATER_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM3_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM4_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM5_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM6_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM7_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_WATER_TEM8_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        break;
    }
}

void Display_Water_Tem_Table(void)
{
    
    
    uint8_t table = Get_Power_Soc_Display();
    if(Get_HMI_Sys_Type() >= Disp_SelfCheck)
    {
        Water_Tem_Table_Processing(table);
    }
    else
    {
        Water_Tem_Table_Processing(0);
    }

}