#ifndef _DISPLAY_SCH_H_
#define _DISPLAY_SCH_H_

#include "TYW_stdint.h"

#define DisplayStartAnimationTime    300u    //3000u / 10u
#define DisplayWelAnimationTime      1500u   //15000u / 10u
#define DisplayStandyAnimationTime   200u    //2000u / 10u
#define DisplayPowerOffAnimationTime 900u    //9000u / 10u
#define DisplaySelfCheckTime         303u    //3030u / 10u
#define DisplayMenuTime              500u    //5000u / 10u
#define DisplayTelTime               500u    //5000u / 10u
#define DisplayStandyTime            66000ul //11ul * 60ul * 100ul
#define DisplayChargeTime            66000ul //11ul * 60ul * 100ul
#define DisplayWelAnimExitTime       300u    //3000u / 10u
#define DisplayCarEnterTime          600u    //6000u / 10u

typedef enum
{
    Disp_PowerOff,
    Disp_StartAnimation,
    Disp_SelfCheck,
    Disp_SelfCheckFinish,
    Disp_StandbyAnimation,
    Disp_Standby1,
    Disp_Standby2,
    Disp_Charging,
    Disp_PowerOffAnimation,
    Disp_CarEnterAnimation,
    Disp_WelcomeAnimation,
    Disp_WelcomeExitAnim,
} enDispSys_Type_t;

typedef enum
{
    WinAlway_Init,
    WinAlway_Media,
    WinAlway_Navi,
    WinAlway_TPMS,
    WinAlway_ShortTimeDrive,
    WinAlway_LongTimeDrive,
    WinAlway_ODO,
    WinAlway_EngRunODO,
    WinAlway_Trip,
    WinAlway_AvgSpeed,
    WinAlway_ESpeed,
    WinAlway_Coolant,
    WinAlway_DTE,
    WinAlway_Empty = 0x1F,
    WinAlway_Max,
} enWinAlway_Type_t;

typedef enum
{
    WinOFF_Car,
    WinOFF_Popup,
    WinOFF_Max,
} enWinOFF_Type_t;

typedef struct
{
    uint8_t u8KEY_Enable;
} HMI_KEY_Struct_t;

typedef struct
{
    uint32_t u32StartAnim_Timer;
    uint32_t u32WelAnim_Timer;
    uint32_t u32StandyAnim_Timer;
    uint32_t u32SelfCheck_Timer;
    uint32_t u32Standby_Timer;
    uint32_t u32Menu_Timer;
    uint32_t u32PowerOffAnim_Timer;
    uint32_t u32SperialODO_Timer;
    uint32_t u32Media_Timer;
    uint32_t u32TPMS_Timer;
    uint32_t u32Exit_Timer;
    uint32_t u32Tel_Timer;
    uint32_t u32Charge_Timer;
    uint32_t u32CarEnter_Timer;
    uint32_t u32StandbyWait_Timer;
} HMI_Timing_Struct_t;

typedef enum
{
    Disp_Trip,
    Disp_AvgEnergy,
    MAX_MenuPage,
} enMenu_Type_t;

typedef enum
{
    Disp_ODODis,
    Disp_TripDis,
    Disp_AvgEnergyDis,
    Disp_ODO_CARDIS,
    MAX_DriveInfoPage,
} enDriveInfo_Type_t;

typedef enum
{
    Disp_Menu,
    Disp_Max,
} enDispMain_Type_t;

typedef struct
{
    HMI_KEY_Struct_t    HMI_KEYInfo;
    HMI_Timing_Struct_t HMI_TIMER;
    uint8_t             HMI_PowerStatus;
    uint8_t             HMI_AnimStatus;
    uint8_t             HMI_DriverDoorStatus;
    uint8_t             HU_Seeoffanimation;
    uint8_t             HMI_SleepStatus;
    uint8_t             HMI_NaviStatus;
    uint8_t             HMI_MediaStatus;
    uint8_t             HMI_HUType;
    uint8_t             HMI_ChargeSts;
    uint8_t             HMI_LockSts;
    uint32_t            HMI_CoreSleep;
    enDispSys_Type_t    HMI_Sys_Type;
    enWinOFF_Type_t     HMI_MidOFF_Type;
    enWinAlway_Type_t   HMI_Alway_Type;
    enWinAlway_Type_t   HMI_Alway2_Type;
    enDispMain_Type_t    HMI_Main_Type;
    enDriveInfo_Type_t   HMI_DriveInfo_Last;
    enDriveInfo_Type_t   HMI_DriveInfo_Current;
    enMenu_Type_t        HMI_Menu_Current;
    uint32_t            HMI_Menu_Type;
} UE_CtrlInfo_Struct_t;

void              Display_Schedule_KL30_Init(void);
void              Display_Schedule_Wakeup_Init(void);
void              Display_Schedule_Service(void);
uint32_t          Get_HMI_SelfCheck_Timer(void);
uint8_t           Get_HMI_KEY_Control(void);
uint32_t          Get_MenuInto_Item(void);

uint8_t Get_LongTermClrFlg_Clear(void);
void Set_LongTermClrFlg_Clear(uint8_t m_Long);

void HMI_Set_KEY_Trip(uint8_t u8KeyVal);
uint8_t Get_HMI_DriveInfo_Type(void);
enDispSys_Type_t Get_HMI_Sys_Type(void);

#endif