#ifndef _FUEL_LEVEL_TABLE_
#define _FUEL_LEVEL_TABLE_

#include "TYW_stdint.h"

/*** 状态定义 ***/
#define DATA_FuelLevel_TEMP_STATE_DELAY  0x00
#define DATA_FuelLevel_TEMP_STATE_INIT   0x01
#define DATA_FuelLevel_TEMP_STATE_FAST   0x02
#define DATA_FuelLevel_TEMP_STATE_NORMAL 0x03
#define DATA_FuelLevel_TEMP_STATE_FAULT  0x04

/*** 参数设置 ***/
#define DATA_FuelLevel_TEMP_WAIT_SEC        0
#define DATA_FuelLevel_TEMP_SEG_STEP_FAST   100      //快速走动时,每走一格间隔的时间,单位ms
#define DATA_FuelLevel_TEMP_SEG_STEP_SLOW   100     //慢速走动时,每走一格间隔的时间,单位ms
#define DATA_FuelLevel_TEMP_ENGINE_WAIT_SEC 10000    //等待发动机启动时间,单位ms

#define DATA_FuelLevel_TEMP_SEG_PER_GROUP 1
#define DATA_FuelLevel_TEMP_TOTAL_GROUP   5
#define DATA_FuelLevel_TEMP_TOTAL_SEG     (DATA_FuelLevel_TEMP_SEG_PER_GROUP * DATA_FuelLevel_TEMP_TOTAL_GROUP)
#define DATA_HI_FuelLevel_TEMP_SEG        7


// #define DATA_DrivingEnergy_Timer  1

/*** 控制结构 ***/
typedef struct
{
    uint16_t Backup;
    uint16_t EngineStartTimer;
    uint16_t RecoverTimer;
    uint16_t Last;
    uint8_t  InvalidCnt;
    uint8_t  DstSeg;
    uint8_t  State;
    uint8_t  Wait;
    uint8_t  Prescaler;
    uint8_t  FastMode;
    uint8_t  OutputEnable;
    uint8_t  DispTimer;
} DataFuelLevelCalcStruct;

typedef struct
{
    uint16_t Up [ DATA_FuelLevel_TEMP_TOTAL_GROUP / 2 + 1 ];
    uint16_t Dn [ DATA_FuelLevel_TEMP_TOTAL_GROUP / 2 + 1 ];
} DataFuelLevelTableStruct;

void Data_FuelLevel_TempPara_KL30_Init(void);
void Data_FuelLevel_TempPara_Wakeup_Init(void);
void Data_FuelLevel_Temp_Processing_Service(void);
uint8_t Get_Fuel_Level_Valid(void);
uint8_t Get_Fuel_Level_Display(void);


#endif