#ifndef LED_DRIVER_H__
#define LED_DRIVER_H__
#include "Simulated_IIC_2_Master.h"
/*
说明：
该LDE驱动仅支持AW21036。  V1.5
*/
#define LED_DRIVER_PLATFORM_16BIT 0U
#define LED_DRIVER_PLATFORM_32BIT 1U
#define LED_DRIVER_PLATFORM_SELECT LED_DRIVER_PLATFORM_32BIT
#if (LED_DRIVER_PLATFORM_SELECT == LED_DRIVER_PLATFORM_16BIT)
typedef unsigned char LED_Driver_uint8_t;
typedef unsigned int LED_Driver_uint16_t;
typedef unsigned long LED_Driver_uint32_t;
#define LED_DRIVER_INT_SIZE 2U
#define LED_DRIVER_ENUM_SIZE 2U
#elif (LED_DRIVER_PLATFORM_SELECT == LED_DRIVER_PLATFORM_32BIT)
typedef unsigned char LED_Driver_uint8_t;
typedef unsigned short LED_Driver_uint16_t;
typedef unsigned int LED_Driver_uint32_t;
#define LED_DRIVER_INT_SIZE 4U
#define LED_DRIVER_ENUM_SIZE 4U
#else
#error platform select error!!!
#endif
/*-------------------------------------------------------------------------------------------*/
typedef void (*LEDDriver_ShutdownPin_Set)(LED_Driver_uint8_t u8Level);
typedef void (*LEDDriver_Feed_Dog)(void);
typedef void (*LEDDriver_Delay_10us)(LED_Driver_uint16_t u16Count);
typedef struct
{
	/*芯片数量*/
	LED_Driver_uint8_t u8LEDDriverChipNum;
	/*shutdown 引脚控制函数*/
	LEDDriver_ShutdownPin_Set pfnLEDDriverShutdownPinSetCallBack;
	/*喂狗函数*/
	LEDDriver_Feed_Dog pfnLEDDriverFeedDogCallBack;
	/*10us 延时函数*/
	LEDDriver_Delay_10us pfnLEDDriverDelay10usCallBack;
	/*3236芯片地址数组*/
	const LED_Driver_uint8_t *pu8IS31ChipAddress;
	/*21036芯片地址数组*/
	const LED_Driver_uint8_t *pu8AW21036ChipAddress;
	/*open threshold   0:0.1V  1:0.2V    other :forbid */
	LED_Driver_uint8_t u8LEDDriverOpenThreshold;
	/*short threshold   0:VDD-1V  1:VDD-0.5V    other :forbid */
	LED_Driver_uint8_t u8LEDDriverShortThreshold;
} LED_Driver_Par_st_t;
/*-------------------------------------------------------------------------------------------*/
/*芯片数量*/
#define LED_DRIVER_CHIP_NUM 1U
#define LED_DRIVER_FIXED_PART_LEN 40U
#define LED_DRIVER_VARIABLE_PART_LEN 36U
#define LED_DRIVER_RAM_LEN (LED_DRIVER_CHIP_NUM * (LED_DRIVER_VARIABLE_PART_LEN + 5U) * 2U + LED_DRIVER_FIXED_PART_LEN)
/*21036 芯片地址 */
#define AW21036_CHIP1_ADDRESS 0X68U /* AD_PIN~GND*/
#define AW21036_CHIP2_ADDRESS 0X6AU /* AD_PIN~VDD*/
#define AW21036_CHIP3_ADDRESS 0X6CU /* AD_PIN~SCL*/
#define AW21036_CHIP4_ADDRESS 0X6EU /* AD_PIN~SDA*/
/*3236  芯片地址 */
#define IS31_CHIP1_ADDRESS 0X78U /* AD_PIN~GND*/
#define IS31_CHIP2_ADDRESS 0X7EU /* AD_PIN~VDD*/
#define IS31_CHIP3_ADDRESS 0X7AU /* AD_PIN~SCL*/
#define IS31_CHIP4_ADDRESS 0X7CU /* AD_PIN~SDA*/
/*-------------------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------------*/
/*-------------以下为提供的接口函数--------------------------------------*/
/*上30电调用,唤醒时调用*/
extern void LED_Driver_Init_KL30(LED_Driver_uint8_t *pu8LEDDriverRamData, LED_Driver_Par_st_t *pstLEDInitPar);
/*休眠时调用*/
extern void LED_Driver_Init_Sleep(void);
/*主函数内实时调用*/
extern void LED_Driver_Service(void);
/*50ms调用一次*/
extern void LED_Driver_Scan_Refresh(void);
/*需要立即执行完成时调用，初始化完之后调用*/
extern void LED_Driver_Service_Immediate(void);
/*初始建议1S调用一次。如发生故障时恢复较慢，可更改为500ms，200ms，100ms均可。不建议更低*/
extern void LED_Driver_Work_Check(void);
/*具体操作函数，亮度设置
u8Chip：选择操作的芯片 0~~（LED_DRIVER_CHIP_NUM-1U）
u8Channel： 选择操作的通道 0~~35
u8Brightness：选择亮度  0：熄灭 ， 255：最亮 。（根据具体灯选择一个合适的数值）
*/
extern void LED_Driver_Channel_Set(LED_Driver_uint8_t u8Chip, LED_Driver_uint8_t u8Channel, LED_Driver_uint8_t u8Brightness);
/*获取亮度，参数同上*/
extern LED_Driver_uint8_t LED_Driver_Channel_Get(LED_Driver_uint8_t u8Chip, LED_Driver_uint8_t u8Channel);
/*获取通道故障检测结果 
u8Chip:读取哪个芯片
u8ChannelGroup：8个通道为一组。
	0：通道1--通道8
	1：通道9--通道16
	2：通道17--通道24
	3：通道25--通道32
	4：通道33--通道36
u8FaultType：读取哪种故障类型。0：短路   1：开路
返回值:每个bit表示一个通道，数值0表示对应故障未发生，1表示对应故障已发生。
*/
extern LED_Driver_uint8_t LED_Driver_Channel_Fault_Get(LED_Driver_uint8_t u8Chip, LED_Driver_uint8_t u8ChannelGroup, LED_Driver_uint8_t u8FaultType);
/*获取芯片当前状态  1表示已经进入休眠状态,0还没进入*/
extern LED_Driver_uint8_t LED_Driver_Status_Get(void);
/*-----------------------------------------------------------*/
#endif
