#include "RTE_GPIO.h"
#include "Common_Interface.h"
#include "Line_in.h"
#include "Line_In_user.h"
#include "RTE_GPIO.h"
#include <string.h>
#include "TCA6416.h"
#include "Configuration.h"

#pragma alignvar(8)
Linelib_uint8_t LINE_IN_Men [ LINE_IN_MAX * LINE_IN_BLOCK_SIZE ];

static Linelib_uint8_t LINE_IN_Get_BREAKFLUID(void);
static Linelib_uint8_t LINE_IN_Get_OilPressure(void);
static Linelib_uint8_t LINE_IN_Get_Bridgefilterblocked(void);
static Linelib_uint8_t LINE_IN_Get_Wheeldifferentiallocksignal(void);
static Linelib_uint8_t LINE_IN_Get_EPB(void);
static Linelib_uint8_t LINE_IN_Get_Washing(void);
// static Linelib_uint8_t LINE_IN_Get_CHARGE(void);
static Linelib_uint8_t LINE_IN_Get_HIBEAM(void);
static Linelib_uint8_t LINE_IN_Get_GearDirection_Neutral(void);
static Linelib_uint8_t LINE_IN_Get_Can_Warning(void);
static Linelib_uint8_t LINE_IN_GET_PARKING_BRAKING(void);
static Linelib_uint8_t LINE_IN_Get_CHARGE(void);
static Linelib_uint8_t LINE_IN_Get_LED_RIGHT(void);
static Linelib_uint8_t LINE_IN_Get_LED_LAMPLET(void);
static Linelib_uint8_t LINE_IN_Get_LED_LEFT(void);
static Linelib_uint8_t LINE_IN_GET_BRAKE_PRESSURE(void);
static Linelib_uint8_t LINE_IN_Get_Reversal_Cooling_fan(void);      //冷却风扇反转硬线控制
static Linelib_uint8_t LINE_IN_Get_Gearbox_Breakdown_J(void);      //变速箱故障+
static Linelib_uint8_t LINE_IN_Get_Gearbox_Breakdown_L(void);      //变速箱故障-
static Linelib_uint8_t LINE_IN_Get_Stabilization_Module(void);      //稳定模块指示灯硬线控制
static Linelib_uint8_t LINE_IN_Get_Power_Cut_Off(void);             //动力切断硬线控制
static Linelib_uint8_t LINE_IN_Get_Emergency_Steering(void);             //应急转向硬线控制
static Linelib_uint8_t LINE_IN_Get_Bridge_Oil_Temperature_Is_High(void); //桥油温高硬线控制
static Linelib_uint8_t LINE_IN_Get_Water_In_The_Oil(void);               //油中有水硬线控制
static Linelib_uint8_t LINE_IN_Get_Low_Cooling_Level(void);              //冷却液位低硬线控制
static Linelib_uint8_t LINE_IN_Get_Oil_Water_Separation(void);           //油水分离预热硬线控制
static Linelib_uint8_t LINE_IN_Get_Safety_Belt(void);                    //安全带硬线控制
static Linelib_uint8_t LINE_IN_Get_Fuel_Filter_Plugging(void);           //燃油滤堵塞硬线控制
static Linelib_uint8_t LINE_IN_Get_Air_Filter_Blocked(void);             //空滤器堵塞硬线控制
static Linelib_uint8_t LINE_IN_Get_High_Exhaust_Temperature(void);       //排气温度高硬线控制
static Linelib_uint8_t LINE_IN_Get_Hydraulicoilfilterblockagesignal(void);
static Linelib_uint8_t LINE_IN_Get_RadiatingOilFilterBlocked(void);
static Linelib_uint8_t LINE_IN_Get_LCD_Transmission_failure(void);
static Linelib_uint8_t LINE_IN_Get_MachineQuickChange(void);
static Linelib_uint8_t LINE_IN_Get_FuelEconomy(void);
static Linelib_uint8_t LINE_IN_Get_AutoShiftGear(void);
static Linelib_uint8_t LINE_IN_Get_TransmissionOilFilterBlocked(void);
static Linelib_uint8_t LINE_IN_Get_EngineWaittoStartLamp(void);
static Linelib_uint8_t LINE_IN_Get_YellowWarningLampStatus(void);

/*属性表与硬线索引号Line_In_Channel_en_t一一对应*/
const Line_In_Attribute_st g_stLineInAttribute [ LINE_IN_MAX ] = {
    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        100U,
        100U,
        LINE_IN_Get_OilPressure,

    }, /*机油液位*/

    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        2000U,
        2000U,
        LINE_IN_Get_BREAKFLUID,
    }, /*制动液位*/
    // {
    //     LEVEL_HIGH,
    //     LEVEL_LOW,
    //     LINE_IN_IG_ON,
    //     300U,
    //     100U,
    //     LINE_IN_Get_CHARGE,
    // }, /*蓄电池充电*/
    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_Bridgefilterblocked,
    }, /*桥滤清器堵塞报警灯*/

    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_Wheeldifferentiallocksignal,
    }, /*轮间差速锁止信号灯*/

    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_Hydraulicoilfilterblockagesignal,
    }, /*液压油滤堵塞信号灯*/

    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_RadiatingOilFilterBlocked,
    }, /*散热油滤堵塞指示灯*/

    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_LCD_Transmission_failure,
    }, /*变速箱故障指示灯液晶屏   高配置*/

    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_LCD_Transmission_failure,
    }, /*变速箱故障指示灯液晶屏   低配置*/

    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_MachineQuickChange,
    }, /*机具快换未锁指示灯*/

    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_FuelEconomy,
    }, /*燃油经济性指示灯*/


    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_EPB,
    }, /*手刹*/
    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_HIBEAM,
    } ,/*远光灯*/
    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_GearDirection_Neutral,
    },/*空挡指示灯*/
    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_Can_Warning,
    },/*CAN报警*/
    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_GET_PARKING_BRAKING,
    },/*驻车制动*/
    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_CHARGE,
    },/*充电指示*/

    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_Gearbox_Breakdown_L,
    },/*变速箱故障-*/

    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_Gearbox_Breakdown_J,
    },/*变速箱故障+*/

    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ON,
        60U,
        60U,
        LINE_IN_Get_LED_RIGHT,
    },/*右转向*/
    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_Get_LED_LAMPLET,
    },/*小灯*/
    {
        LEVEL_LOW,
        LEVEL_HIGH,
        LINE_IN_IG_ON,
        60U,
        60U,
        LINE_IN_Get_LED_LEFT,
    },/*左转向*/
    {
        LEVEL_HIGH,
        LEVEL_LOW,
        LINE_IN_IG_ON,
        300U,
        100U,
        LINE_IN_GET_BRAKE_PRESSURE,
    },/*制动气压报警*/

    {
        LEVEL_LOW,                  
        LEVEL_HIGH,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_Reversal_Cooling_fan,           

    }, /*冷却风扇反转*/

   {
        LEVEL_LOW,                  
        LEVEL_HIGH,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_Stabilization_Module,           

    }, /*稳定模块指示灯逻辑函数*/

    {
        LEVEL_LOW,                  
        LEVEL_HIGH,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_Power_Cut_Off,           

    }, /*动力切断高有效*/

    {
        LEVEL_HIGH,                  
        LEVEL_LOW,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_Power_Cut_Off,           

    }, /*动力切断低有效*/

    {
        LEVEL_LOW,                  
        LEVEL_HIGH,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_Emergency_Steering,           

    }, /*应急转向*/

    {
        LEVEL_HIGH,                  
        LEVEL_LOW,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_Bridge_Oil_Temperature_Is_High,           

    }, /*桥油温高*/

      {
        LEVEL_HIGH,                  
        LEVEL_LOW,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_Water_In_The_Oil,           

    }, /*油中有水*/
    {
        LEVEL_HIGH,                  
        LEVEL_LOW,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_Low_Cooling_Level,           

    }, /*冷却液位低*/

    {
        LEVEL_LOW,                  
        LEVEL_HIGH,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_Oil_Water_Separation,           

    }, /* //油水分离预热*/

    {
        LEVEL_HIGH,                  
        LEVEL_LOW,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_Safety_Belt,           

    }, /*安全带*/

    {
        LEVEL_HIGH,                  
        LEVEL_LOW,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_Fuel_Filter_Plugging,          

    }, /*燃油滤堵塞硬线控制*/

     {
        LEVEL_HIGH,                  
        LEVEL_LOW,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_Air_Filter_Blocked,          

    }, /*空滤器堵塞硬线控制*/

    {
        LEVEL_HIGH,                  
        LEVEL_LOW,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_High_Exhaust_Temperature,          

    }, /*排气温度高*/

    {
        LEVEL_LOW,                  
        LEVEL_HIGH,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_AutoShiftGear,          

    }, /*自动换挡 高有效配置*/

    {
        LEVEL_LOW,                  
        LEVEL_HIGH,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_TransmissionOilFilterBlocked,          

    }, /*变速箱油滤堵塞 高有效配置*/

    {
        LEVEL_LOW,                  
        LEVEL_HIGH,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_EngineWaittoStartLamp,          

    }, /*发动机预热 高有效配置*/

    {
        LEVEL_LOW,                  
        LEVEL_HIGH,                 
        LINE_IN_IG_ON,              
        300U,                       
        100U,
        LINE_IN_Get_YellowWarningLampStatus,          

    }, /*故障报警灯 高有效配置*/

};

static Linelib_uint8_t LINE_IN_Get_BREAKFLUID(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_OilPressure(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Bridgefilterblocked(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_Bridgefilterblocked == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Wheeldifferentiallocksignal(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_Wheeldifferentiallocksignal == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Hydraulicoilfilterblockagesignal(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_Hydraulicoilfilterblockagesignal == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_RadiatingOilFilterBlocked(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_RadiatingOilFilterBlocked == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_LCD_Transmission_failure(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_LCD_Transmissionfailure == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_MachineQuickChange(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_MachineQuickChange == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_FuelEconomy(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_FuelEconomy == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_EPB(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

// static Linelib_uint8_t LINE_IN_Get_CHARGE(void)
// {
//     Linelib_uint8_t Res = LEVEL_LOW;
//     if ( 1u )
//     {
//         Res = LEVEL_HIGH;
//     }
//     else
//     {
//         Res = LEVEL_LOW;
//     }
//     return Res;
// }

static Linelib_uint16_t LINE_GET_PWR(void)
{
    Linelib_uint16_t Res;
    Res = Common_Get_IG_Sts( ) & 0x00FFu;
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_HIBEAM(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LED_HI_BEAM == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_GearDirection_Neutral(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_GearDirection_Neutral == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Can_Warning(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_CAN_WARNING == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

//驻车制动
static Linelib_uint8_t LINE_IN_GET_PARKING_BRAKING(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_PARKING_BRAKING == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

//充电指示
static Linelib_uint8_t LINE_IN_Get_CHARGE(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_CHARGE == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Gearbox_Breakdown_J(void) // 变速箱故障+
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if (LINE_IN_Transmission_FailureJust == 1u)
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Gearbox_Breakdown_L(void) // 变速箱故障-
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if (LINE_IN_Transmission_FailureLose == 1u)
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

//右转向
static Linelib_uint8_t LINE_IN_Get_LED_RIGHT(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LED_RIGHT == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

//小灯
static Linelib_uint8_t LINE_IN_Get_LED_LAMPLET(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LED_LAMPLET == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

//左转向
static Linelib_uint8_t LINE_IN_Get_LED_LEFT(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LED_LEFT == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_GET_BRAKE_PRESSURE(void)
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_BRAKE_PRESSURE == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Reversal_Cooling_fan(void)       //冷却风扇反转硬线控制
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_Reversal_Cooling_fan == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}


static Linelib_uint8_t LINE_IN_Get_Stabilization_Module(void)       //稳定模块指示灯硬线控制
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_Stabilization_Module == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Power_Cut_Off(void)       //动力切断硬线控制
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_Power_Cut_Off == 1u )
     {
        Res = LEVEL_HIGH;
     }
     else
     {
        Res = LEVEL_LOW;
     }
        return Res;
    
}

static Linelib_uint8_t LINE_IN_Get_Emergency_Steering(void)       //应急转向硬线控制
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_Emergency_Steering == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Bridge_Oil_Temperature_Is_High(void)       //桥油温高硬线控制
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_Get_Bridge_Oil_Temperature_IsHigh == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Water_In_The_Oil(void)           //油中有水硬线控制
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_Get_Water_InThe_Oil == 1u )
    {
        Res = LEVEL_HIGH;
    }
    else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}
static Linelib_uint8_t LINE_IN_Get_Low_Cooling_Level(void)           //冷却液位低硬线控制
{
    Linelib_uint8_t Res = LEVEL_LOW;
     if ( LINE_IN_Low_CoolingLevel== 1u )
    {
        Res = LEVEL_HIGH;
    }
     else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}
static Linelib_uint8_t LINE_IN_Get_Oil_Water_Separation(void)           //油水分离预热硬线控制
{
    Linelib_uint8_t Res = LEVEL_LOW;
     if ( LINE_IN_Oil_Water_Separation == 1u )
    {
        Res = LEVEL_HIGH;
    }
     else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Safety_Belt(void)           //安全带硬线控制
{
    Linelib_uint8_t Res = LEVEL_LOW;
     if ( LINE_IN_Low_Safety_Belt  == 1u )
    {
        Res = LEVEL_HIGH;
    }
     else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Fuel_Filter_Plugging(void)          //燃油滤堵塞硬线控制
{
    Linelib_uint8_t Res = LEVEL_LOW;
     if ( LINE_IN_Fuel_Filter_Plugging   == 1u )
    {
        Res = LEVEL_HIGH;
    }
     else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_Air_Filter_Blocked(void)          //空滤器堵塞硬线控制
{
    Linelib_uint8_t Res = LEVEL_LOW;
     if ( LINE_IN_Air_Filter_Blocked   == 1u )
    {
        Res = LEVEL_HIGH;
    }
     else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_High_Exhaust_Temperature(void)       //排气温度高硬线控制
{
    Linelib_uint8_t Res = LEVEL_LOW;
     if ( LINE_IN_High_Exhaust_Temperature   == 1u )
    {
        Res = LEVEL_HIGH;
    }
     else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_AutoShiftGear(void)       //自动换挡硬线控制  高有效配置
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_AutoShiftGear  == 1u )
    {
        Res = LEVEL_HIGH;
    }
     else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_TransmissionOilFilterBlocked(void)       //变速箱油滤堵塞硬线控制  高有效配置
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_TransmissionOilFilterBlocked  == 1u )
    {
        Res = LEVEL_HIGH;
    }
     else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_EngineWaittoStartLamp(void)       //发动机预热硬线控制  高有效配置
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_EngineWaittoStartLamp  == 1u )
    {
        Res = LEVEL_HIGH;
    }
     else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

static Linelib_uint8_t LINE_IN_Get_YellowWarningLampStatus(void)       //故障报警灯  高有效配置
{
    Linelib_uint8_t Res = LEVEL_LOW;
    if ( LINE_IN_YellowWarningLampStatus  == 1u )
    {
        Res = LEVEL_HIGH;
    }
     else
    {
        Res = LEVEL_LOW;
    }
    return Res;
}

void LINE_IN_Init(void)
{
    memset(LINE_IN_Men, 0, sizeof(LINE_IN_Men));
    Line_In_KL30_WakeUp_Init(LINE_IN_Men, g_stLineInAttribute, LINE_IN_MAX, LINE_GET_PWR);
}
