#ifndef MEMU_FUNCTION_H__
#define MEMU_FUNCTION_H__
#include "TYW_stdint.h"

typedef struct 
{
    uint8_t CAN_or_LINE;   // CAN:0  ;  LINE:1
    uint32_t CAN_Oil_Tem;   //CAN输入
    uint32_t LINE_Oil_Tem;  //硬线输入
}Transmission_Oil_Temperature; //变速箱油温
extern Transmission_Oil_Temperature Menu;
extern uint16_t Battery_Voltage;

/*
节气门后进气温度
1.显示范围：-40 ~ 210 ℃，传参为0~250，传入0xFF时显示--- ℃
2.显示分辨率： 1 ℃
3.刷新时间定义： 1秒
*/
uint16_t Intake_Manifold_Air_Tem_Menu(void);

/*
燃油温度
[配置-发动机类型配置] =潍柴或者上柴或者康明斯或者云内或者洛拖时显示
1.显示范围：-40 ~ 210 ℃，传参为0~250，传入0xFF时显示--- ℃
2.显示分辨率： 1 ℃
3.刷新时间定义： 1秒
*/
uint16_t Fuel_Tem_Menu(void);

/*
机油温度
[配置-发动机类型配置] = 潍柴或者上柴或者康明斯或者云内或者洛拖时显示
1.显示范围：-273 ~ 1735 ℃，传参为0~2008,传入0xFFFF时显示---- ℃
2.显示分辨率： 1 ℃
3.刷新时间定义： 1秒
*/
uint32_t Engine_Oil_Tem_Menu(void);

/*
油门踏板位置
1.显示范围：0 ~ 100 %，传参为0~100，传入0xFF时显示--- %
2.显示分辨率： 1 %
3.刷新时间定义： 1秒。
*/
uint16_t Accelerator_Pedal_Position_Menu(void);

/*
燃料液位
1.显示范围：0 ~ 100 %，传参为0~100，传入0xFF时显示--- %
2.显示分辨率： 1 %
3.刷新时间定义： 1秒。
4.可配置燃料液位的任一表头配置了该功能，仪表需要根据所配置的液燃油液位表显示燃料液位，否则不显示
*/
uint16_t Fuel_Level_Menu(void);

/*
水温
1.显示范围：-40 ~ 210 ℃，传参为0-250，传入0xFF时显示--- ℃
2.显示分辨率： 1℃
3.刷新时间定义： 1秒。
*/
uint16_t Water_Temperature_Menu(void); 

/*
机油压力
1.显示范围：0.0 ~ 10.0 bar，传参为0-100，传入0xFF时显示--- bar
2.显示分辨率： 0.1 bar
3.刷新时间定义： 1秒。
4.可配置机油压力的任一表头配置了该功能，仪表需根据所配置的机油压力表显示机油压力。否则，仪表不显示机油压力。
*/
uint16_t Oil_Pressure_Menu(void); 

/*
尿素液位
1.显示范围：0 ~ 100 %，传参为0-100，传入0xFF时显示--- %
2.显示分辨率： 1 %
3.刷新时间定义： 1秒。
4.可配置尿素液位的任一表头配置了该功能，仪表需根据所配置的尿素液位输入显示尿素液位。否则，不显示
*/
uint16_t Urea_Level_Menu(void);

/*
电池电压
1.显示范围：16.0 ~ 32.0 V，传参为160-320
2.显示分辨率： 0.1 V
3.刷新时间定义： 1秒
4.可配置电池电压的任一表头配置了该功能，仪表需根据所配置的表头输入显示。否则，不显示。
*/
uint16_t Battery_Voltage_Menu(void); 

/*
 DPF积尘量
1.显示范围：0 ~ 11，传参为0-11，传入0xFF时显示-- 
2.显示分辨率： 1
3.刷新时间定义： 1秒。
*/
uint16_t DPF_Menu(void); 

/*
大气压力
1.显示范围：0.0 ~ 125.0KPa，传参为0-1250，传入0xFFFF时显示---.- KPa
2.显示分辨率： 0.5 KPa
3.刷新时间定义： 1秒。
4.如果[配置-发动机类型配置] =潍柴或上柴或康明斯或云内或玉柴或洛拖，仪表显示
*/
uint16_t Atmospheric_Pressure_Menu(void); 

/*
发动机怠速时间
1.显示范围：0.0 ~ 99999.9 h，传参为0-9999990，传入0xFFFFFFFF时显示-----.- h
2.显示分辨率： 0.1 h
3.刷新时间定义： 1秒。
4.[配置-发动机类型配置] =上柴或者康明斯或者云内或者玉柴或者洛拖时，仪表显示发动机怠速时间。否则，仪表不显示此功能。
*/
uint32_t Engine_Total_Idle_Hours_Menu(void); 

/*
内部碳烟加载量
1.显示范围：0 ~ 250%，传参为0-250，传入0xFFFF时显示--- %
2.显示分辨率： 1 %
3.刷新时间定义： 1秒。
*/
uint16_t DPF_Internalsoot_Load_Menu(void); 

/*
变速箱油温
一、CAN输入  Menu.CAN_or_LINE = 0；
1.显示范围：-50 ~ 200 ℃，传参为0-250，传入0xFFFF时显示--- ℃
2.显示分辨率： 1 ℃
3.刷新时间定义： 1秒。
二、硬线输入  Menu.CAN_or_LINE = 1；
1.显示范围：55——140℃，传参为55——140，当输入0时，显示< 55 ℃；当输入0xFFFF时，显示>140℃；当输入0xFFFFFFFF时，显示--- ℃
2.显示分辨率： 1 ℃
3.刷新时间定义： 1秒。

注意：调用时调用：Menu.CAN_or_LINE 确定是CAN输入还是模拟量输入；Menu.CAN_Oil_Tem 是CAN输入的温度；Menu.LINE_Oil_Tem 是模拟量输入的温度
*/
Transmission_Oil_Temperature Transmission_Oil_Temperature_Menu(void); // 变速箱油温 

/*
发动机扭矩百分比
1.显示范围：-125 ~ 125 %，传参为0-250，传入0xFF时显示--- %
2.显示分辨率： 1 %
3.刷新时间定义： 1秒。
*/
uint16_t Actual_Engine_Percent_Torque_Menu(void); 

/*
尿素温度
1.显示范围：-40 ~ 210 ℃，传参为0-250，传入0xFF时显示--- %
2.显示分辨率：1 ℃
3.刷新时间定义： 1秒。
4.当[配置-发动机类型配置] =潍柴或康明斯或者云内或者玉柴或洛拖时，显示尿素温度，否则，仪表不显示此功能。
*/
uint16_t Ad_Blue_Temperature_Menu(void);

/*
发动机怠速油耗
1.显示范围：0 ~ 999999 L，传参为0-9999990，传入0xFFFFFFFF时显示------ L
2.显示分辨率： 1 L
3.刷新时间定义： 1秒。
4.当[配置-发动机类型配置] =上柴或者康明斯或者云内或者玉柴或者洛拖时，仪表需要显示发动机怠速油耗。否则，仪表不显示此功能。
*/
uint32_t Engine_Total_Idle_Fuel_Used_Menu(void); 

/*
变速箱油压
1.显示范围：0.0 ~ 25.0 bar，传参为0-250，传入0xFF时显示--.- bar
2.显示分辨率： 0.1 bar
3.刷新时间定义： 1秒。
4.任一可配置为变速箱油压的表头配置了该功能
*/
uint16_t Transmission_Oil_Pressure_Menu(void);  

/*
变速箱油槽温度
1.显示范围：-50 ~ 200 ℃，传参为0-250，传入0xFFFF时显示--- ℃
2.显示分辨率： 1 ℃
3.刷新时间定义： 1秒。
4.当[配置-变速箱类型配置] =ZF变速箱或徐工自制变速箱时，仪表显示变速箱油槽温度。否则，不显示此功能
*/
uint32_t Transmission_Oil_Tank_Temperature_Menu(void);  

/*
变矩器涡轮扭矩
1.显示范围：-32000 ~ 32255 Nm，传参为0 ~ 64255，传入0xFFFF时显示----- Nm
2.显示分辨率： 1 Nm
3.刷新时间定义： 1秒。
4.当[配置-变速箱类型配置] =ZF变速箱或者徐工自制变速箱时，仪表显示矩器涡轮扭矩。否则，仪表不显示此功能。
*/
uint16_t Torque_Converter_Turbo_Torque_Menu(void); 

/*
变矩器输出轴转速
1.显示范围：0 ~ 8031.875 rpm，传参为0 ~ 64255，传入0xFFFF时显示---- rpm
2.显示分辨率： 1 rpm
3.刷新时间定义： 1秒。
4.当[配置-变速箱类型配置] =ZF变速箱或者徐工自制变速箱时，仪表显示变矩器输出轴转速。否则，仪表不显示此功能。
*/
uint16_t Torque_Converter_Output_Shaft_Speed_Menu(void); 

/*
变矩器输入轴转速
1.显示范围：0 ~ 8031.875 rpm，传参为0 ~ 64255，传入0xFFFF时显示---- rpm
2.显示分辨率： 1 rpm
3.刷新时间定义： 1秒。
4.当[配置-变速箱类型配置] =ZF变速箱或者徐工自制变速箱时，仪表显示变矩器输入轴转速。否则，仪表不显示此功能。
*/
uint16_t Torque_Converter_Iutput_Shaft_Speed_Menu(void); 

/*
中间轴转速
1.显示范围：0 ~ 8031.875 rpm，传参为0 ~ 64255，传入0xFFFF时显示---- rpm
2.显示分辨率： 1 rpm
3.刷新时间定义： 1秒。
4.当[配置-变速箱类型配置] =徐工自制变速箱时，仪表显示中间轴转速。否则，仪表不显示此功能。
*/
uint16_t Middle_Shaft_Speed_Menu(void); 

/*
制动气压 
1.显示范围：0.0 ~ 10.0 bar，传参为0-100，传入0xFF时显示--.- bar
2.显示分辨率： 0.1 bar
3.刷新时间定义： 1秒。
4.可配置制动气压的任一表头配置了该功能，仪表需根据所配置的制动气压表显示制动气压。否则，仪表不显示。
*/
uint16_t Brake_Pressure_Menu(void); 

/*
湿式制动
1.显示范围：0.0 ~ 200.0 bar，传参为0-2000，传入0xFFFF时显示--- bar
2.显示分辨率： 0.1 bar
3.刷新时间定义： 1秒。
4.任一可配置为湿式制动的表头配置了该功能，则显示。否则，不显示
*/
uint16_t Wet_Brake_Menu(void); 

/*
液压油温
1.显示范围：40 ~ 120 ℃，传参为40 ~ 120，传入0xFF时显示--- ℃, 传入0时显示> 120℃, 传入200时显示< 40℃
2.显示分辨率： 1 ℃
3.刷新时间定义： 1秒
4.若任一可配置为液压油温的表头配置了该功能，则根据该表头显示。否则，不显示
*/
uint16_t Hydraulic_Oil_Temperature_Menu(void);

/*
风扇换向阀
传入1时，指示灯的颜色为绿色；否则，指示灯的颜色为灰色。
*/
uint16_t FanReversing_Valve_Menu(void);

/*
应急转向电磁阀
传入1时，指示灯的颜色为绿色；否则，指示灯的颜色为灰色。
*/
uint16_t Emergency_Steering_Solenoid_Valve_Menu(void);

/*
稳定模块输出电磁阀1
传入1时，指示灯的颜色为绿色；否则，指示灯的颜色为灰色。
*/
uint16_t Stability_Module_Output_Solenoid_Valve1_Menu(void);

/*
稳定模块输出电磁阀2
传入1时，指示灯的颜色为绿色；否则，指示灯的颜色为灰色。
*/
uint16_t Stability_Module_Output_Solenoid_Valve2_Menu(void);

/*
收铲斗电磁阀
1.显示范围：0 ~ 1500 mA，传参为0 ~ 1500，传入0xFFFF时显示---- mA
2.显示分辨率： 1 mA
3.刷新时间定义： 1秒
*/
uint16_t Pull_Bucket_Solenoid_Valve_Menu(void);

/*
翻铲斗电磁阀
1.显示范围：0 ~ 1500 mA，传参为0 ~ 1500，传入0xFFFF时显示---- mA
2.显示分辨率： 1 mA
3.刷新时间定义： 1秒
*/
uint16_t Flip_Bucket_Solenoid_Valve_Menu(void);

/*
动臂升电磁阀
1.显示范围：0 ~ 1500 mA，传参为0 ~ 1500，传入0xFFFF时显示---- mA
2.显示分辨率： 1 mA
3.刷新时间定义： 1秒
*/
uint16_t Movable_Arm_Rising_Valve_Menu(void);

/*
动臂降电磁阀
1.显示范围：0 ~ 1500 mA，传参为0 ~ 1500，传入0xFFFF时显示---- mA
2.显示分辨率： 1 mA
3.刷新时间定义： 1秒
*/
uint16_t Movable_Arm_Decline_Valve_Menu(void);

/*
风扇调速电磁阀
1.显示范围：0 ~ 1500 mA，传参为0 ~ 1500，传入0xFFFF时显示---- mA
2.显示分辨率： 1 mA
3.刷新时间定义： 1秒
*/
uint16_t Fan_Speed_Solenoid_Valve_Menu(void);

/*
夹钳开电磁阀
1.显示范围：0 ~ 1500 mA，传参为0 ~ 1500，传入0xFFFF时显示---- mA
2.显示分辨率： 1 mA
3.刷新时间定义： 1秒
*/
uint16_t Clamp_Open_Solenoid_Valve_Menu(void);

/*
夹钳关电磁阀
1.显示范围：0 ~ 1500 mA，传参为0 ~ 1500，传入0xFFFF时显示---- mA
2.显示分辨率： 1 mA
3.刷新时间定义： 1秒
*/
uint16_t Clamp_Close_Solenoid_Valve_Menu(void);

/*
动臂运动状态指示
1.显示范围：0 ~ 200，传参为0 ~ 200，传入0xFFFF时显示---
2.显示分辨率： 1
3.刷新时间定义： 1秒
*/
uint16_t Movable_Arm_Motion_Status_Indication_Menu(void);

/*
铲斗运动状态指示
1.显示范围：0 ~ 200，传参为0 ~ 200，传入0xFFFF时显示---
2.显示分辨率： 1
3.刷新时间定义： 1秒
*/
uint16_t Bucket_Motion_Status_Indication_Menu(void);
#endif