#include "Popup_Message_List.h"
#include "Services_Mileage.h"
#include "Popup_Scheduler.h"
#include "Sound_Player.h"
#include "DisplaySch.h"
#include "TYW_stdint.h"
#include "Popup_List.h"
#include "EOL_Para.h"
#include "CAN_APP.h"
#include "Menu.h"
#include "NVM.h"
#include "UDS_Common.h"
#include <string.h>
/*-------------------------------------------------------*/

/*-----------------------------------------------------------------*/

unsigned char u8MenuKeyExecute;
unsigned char LongTimeNoKeyCnt;
unsigned char MenuPopupCurIdx       = 0;
uint16_t      MenuPopupList [ 256 ] = {0u};
uint16_t      MenuPopupNum          = 0;

/*--------------------------The following usage is recommended, but not required--------------------------------*/
/*--------------------------The following usage is recommended, but not required--------------------------------*/
/*--------------------------The following usage is recommended, but not required--------------------------------*/

static void Menu_Cursor_Preprocess(Menu_Key_en_t enMenuKey);
static void Menu_Cursor_Postprocess(Menu_Key_en_t enMenuKey);
void        Menu_Service(Menu_Key_en_t enMenuKey);

/*-------------------Logic_Operation Call Back---------------------*/
/*-------------------Logic_Operation Call Back---------------------*/
/*主页*/
void Menu_Logic_Operation_ITEM_Home_Page(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Total_Fuel_Consumption(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Instananeous_Fuel_Consumption(Menu_Key_en_t enKeyType);

/*菜单里*/
void Menu_Logic_Operation_ITEM_Menu_Back(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Travel_Info(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Fault(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Set(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Factory_Set(Menu_Key_en_t enKeyType);

/*行车信息里*/
void Menu_Logic_Operation_ITEM_Travel_Info_Back(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Engine(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Gearbox(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Hydraulic_Sys(Menu_Key_en_t enKeyType);



/*故障查询*/



void Menu_Logic_Operation_ITEM_Chinese(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_English(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Russian(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Portuguese(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Alarm_Volume_High(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Alarm_Volume_Mid(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Alarm_Volume_Low(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Alarm_Sound_1(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Alarm_Sound_2(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ITEM_Alarm_Sound_3(Menu_Key_en_t enKeyType);

/************************************************************************************/
/*清除某一层中的选中*/
void Menu_Clear_Items_Select(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem);
/*设置某一层中的选中*/
void MENU_Intf_Inside_Item_Select_Set(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem, Menu_Item_en_t SelectItem);
void MENU_Intf_Inside_Item_Select_Set_Close(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem, Menu_Item_en_t SelectItem);
/*获取某一层中的选中*/
/*当前光标是MENU_ITEM_ENTRANCE_FIX时，表示退出了菜单，此时是否需要显示行车电脑显示哪个行车电脑，调用此函数*/
Menu_Item_en_t Get_INTF_Travel_Info_Select(void);
/*获取选中的导航*/
Menu_Item_en_t Get_INTF_Theme_Navigation(void);
/*获取选中的主题*/
Menu_Item_en_t Get_INTF_Theme_Select(void);
/*获取选中的语言*/
Menu_Item_en_t Get_INTF_Language_Select(void);
/*获取选中的音量*/
Menu_Item_en_t Get_INTF_Alarm_Volume_Select(void);
/*获取选中的声音*/
Menu_Item_en_t Get_INTF_Alarm_Sound_Select(void);

/*设置导航的选中*/
void INTF_Navigation_Select_Item_Set(Menu_Item_en_t SelectItem);
void INTF_Navigation_Select_Item_Set_Close(Menu_Item_en_t SelectItem);
/*设置行车电脑的选中*/
void INTF_Travel_Info_Select_Item_Set(Menu_Item_en_t SelectItem);
/*设置语言的选中*/
void INTF_Language_Select_Item_Set(Menu_Item_en_t SelectItem);
/*设置音量的选中*/
void INTF_Alarm_Volume_Select_Item_Set(Menu_Item_en_t SelectItem);
/*设置声音的选中*/
void INTF_Alarm_Sound_Select_Item_Set(Menu_Item_en_t SelectItem);
/*设置主题的选中*/
void INTF_Theme_Select_Item_Set(Menu_Item_en_t SelectItem);

/*短按mode进入菜单时，调用此函数*/
void External_Ctrl_Enter_Menu_Service(void);
/*长按mode退出菜单时，调用此函数*/
void External_Ctrl_Quit_Menu_Service(void);
/*30和15电初始化调用一下*/
void Menu_User_Init(Menu_User_Init_PowerTypeEnum PowerType);

// void Menu_LongTimeNoKey(void);

/*-------------------Logic_Operation Call Back---------------------*/
/*-------------------Logic_Operation Call Back---------------------*/
/*主页*/
uint8_t Get_Home_Page(void)
{
    uint8_t HomePage = 0;
    HomePage = Menu_Get_Current_Cursor_Information();
    if((HomePage == 0) || (HomePage == 1) || (HomePage == 2))
    {
        HomePage += 1;
        return HomePage;
    }
    else
    {
        HomePage = 0;
        return HomePage;
    }
}

void Menu_Logic_Operation_ITEM_Home_Page(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_LEFT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Menu_Back, MENU_ITEM_Factory_Set, MENU_ITEM_Menu_Back);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Home_Page, MENU_ITEM_Instananeous_Fuel_Consumption, MENU_ITEM_Total_Fuel_Consumption);
    }
}

void Menu_Logic_Operation_ITEM_Total_Fuel_Consumption(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_LEFT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Menu_Back, MENU_ITEM_Factory_Set, MENU_ITEM_Menu_Back);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Home_Page, MENU_ITEM_Instananeous_Fuel_Consumption, MENU_ITEM_Instananeous_Fuel_Consumption);
    }
}

void Menu_Logic_Operation_ITEM_Instananeous_Fuel_Consumption(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_LEFT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Menu_Back, MENU_ITEM_Factory_Set, MENU_ITEM_Menu_Back);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Home_Page, MENU_ITEM_Instananeous_Fuel_Consumption, MENU_ITEM_Home_Page);
    }
}


/*菜单*/
void Menu_Logic_Operation_ITEM_Menu_Back(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Home_Page, MENU_ITEM_Instananeous_Fuel_Consumption, MENU_ITEM_Home_Page);
    }
}

void Menu_Logic_Operation_ITEM_Travel_Info(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_LEFT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Menu_Back, MENU_ITEM_Factory_Set, MENU_ITEM_Menu_Back);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Menu_Back, MENU_ITEM_Factory_Set, MENU_ITEM_Fault);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_LONG )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Travel_Info_Back, MENU_ITEM_Hydraulic_Sys, MENU_ITEM_Travel_Info_Back);
    }
}

void Menu_Logic_Operation_ITEM_Fault(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_LEFT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Menu_Back, MENU_ITEM_Factory_Set, MENU_ITEM_Travel_Info);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Menu_Back, MENU_ITEM_Factory_Set, MENU_ITEM_Set);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_LONG )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Fault_Back, MENU_ITEM_Aftertreatment_Fault, MENU_ITEM_Fault_Back);
    }
}

void Menu_Logic_Operation_ITEM_Set(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_LEFT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Menu_Back, MENU_ITEM_Factory_Set, MENU_ITEM_Fault);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Menu_Back, MENU_ITEM_Factory_Set, MENU_ITEM_Factory_Set);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_LONG )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Set_Back, MENU_ITEM_SW_Version, MENU_ITEM_Set_Back);
    }
}

void Menu_Logic_Operation_ITEM_Factory_Set(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_LEFT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Menu_Back, MENU_ITEM_Factory_Set, MENU_ITEM_Set);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Menu_Back, MENU_ITEM_Factory_Set, MENU_ITEM_Menu_Back);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_LONG )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITME_KValue_Set, MENU_ITME_Engine_Timing_Set, MENU_ITME_KValue_Set);
    }
}


/*行车信息*/
void Menu_Logic_Operation_ITEM_Travel_Info_Back(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_LEFT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Travel_Info_Back, MENU_ITEM_Hydraulic_Sys, MENU_ITEM_Hydraulic_Sys);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Travel_Info_Back, MENU_ITEM_Hydraulic_Sys, MENU_ITEM_Engine);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_LONG )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Menu_Back, MENU_ITEM_Factory_Set, MENU_ITEM_Menu_Back);
    }
}

// void Menu_Logic_Operation_ITEM_Engine(Menu_Key_en_t enKeyType)
// {
//     if ( enKeyType == MENU_KEY_LEFT_SHORT )
//     {
//         MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Travel_Info_Back, MENU_ITEM_Hydraulic_Sys, MENU_ITEM_Travel_Info_Back);
//     }
//     else if ( enKeyType == MENU_KEY_RIGHT_SHORT )
//     {
//         MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Travel_Info_Back, MENU_ITEM_Hydraulic_Sys, MENU_ITEM_Gearbox);
//     }
//     else if ( enKeyType == MENU_KEY_RIGHT_LONG )
//     {
//         MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Engine_Page_1, MENU_ITEM_Engine_Page_4, MENU_ITEM_Engine_Page_1);
//     }
// }

void Menu_Logic_Operation_ITEM_Gearbox(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_LEFT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Travel_Info_Back, MENU_ITEM_Hydraulic_Sys, MENU_ITEM_Engine);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Travel_Info_Back, MENU_ITEM_Hydraulic_Sys, MENU_ITEM_Hydraulic_Sys);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_LONG )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Gearbox_Page_1, MENU_ITEM_Gearbox_Page_2, MENU_ITEM_Gearbox_Page_1);
    }
}

void Menu_Logic_Operation_ITEM_Hydraulic_Sys(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_LEFT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Travel_Info_Back, MENU_ITEM_Hydraulic_Sys, MENU_ITEM_Gearbox);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Travel_Info_Back, MENU_ITEM_Hydraulic_Sys, MENU_ITEM_Travel_Info_Back);
    }
    else if ( enKeyType == MENU_KEY_RIGHT_LONG )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Hydraulic_Sys_Page_1, MENU_ITEM_Hydraulic_Sys_Page_1, MENU_ITEM_Hydraulic_Sys_Page_1);
    }
}

uint16_t Get_Menu_FaultMsg(void)
{
    uint16_t PopupMsg;
    uint16_t PopupMsgIndex;

    PopupMsg = PopupAttributeTable [ MenuPopupList [ MenuPopupCurIdx ] ].Message;

    PopupMsgIndex = PopupMsgAttributeTable [ PopupMsg ].Number;
    PopupMsgIndex |= (PopupMsgAttributeTable [ PopupMsg ].Function << 8);

    return PopupMsgIndex;
}

uint8_t Get_Menu_Fault_CurIdx(void)
{
    if ( MenuPopupCurIdx >= MenuPopupNum )
    {
        MenuPopupCurIdx = MenuPopupNum - 1;
    }

    return MenuPopupCurIdx + 1;
}

uint8_t Get_Menu_Fault_TotalNum(void)
{
    return ( uint8_t )MenuPopupNum;
}

uint8_t Menu_Fault_Service(void)
{
    MenuPopupNum = Popup_Get_Exception_Msg(MenuPopupList, 256);

    return ( uint8_t )MenuPopupNum;
}

void Menu_Logic_Operation_ITEM_Chinese(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
    {
        (void)memcpy(EOL_0300.Data, EOL0300ToDFlashInfo.DID_0300,sizeof(EOL0300ToDFlashInfo.DID_0300));
        EOL_0300.Data [ 8u ] = 0;
        EOL_Set0300(EOL_0300.Data, 90);
    }
}

void Menu_Logic_Operation_ITEM_English(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
    {
        (void)memcpy(EOL_0300.Data, EOL0300ToDFlashInfo.DID_0300,sizeof(EOL0300ToDFlashInfo.DID_0300));
        EOL_0300.Data [ 8u ] = 1;
        EOL_Set0300(EOL_0300.Data, 90);
    }
}

void Menu_Logic_Operation_ITEM_Russian(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
    {
        (void)memcpy(EOL_0300.Data, EOL0300ToDFlashInfo.DID_0300,sizeof(EOL0300ToDFlashInfo.DID_0300));
        EOL_0300.Data [ 8u ] = 2;
        EOL_Set0300(EOL_0300.Data, 90);
    }
}

void Menu_Logic_Operation_ITEM_Portuguese(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
    {
        (void)memcpy(EOL_0300.Data, EOL0300ToDFlashInfo.DID_0300,sizeof(EOL0300ToDFlashInfo.DID_0300));
        EOL_0300.Data [ 8u ] = 3;
        EOL_Set0300(EOL_0300.Data, 90);
    }
}

// void Menu_Logic_Operation_ITEM_Alarm_Volume_High(Menu_Key_en_t enKeyType)
// {
//     if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
//     {
//         MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Alarm_Volume_High, MENU_ITEM_Alarm_Volume_Low, MENU_ITEM_Alarm_Volume_High);
//         // USER_Setting_UpDate( );
//         if ( Get_Sound_Volume( ) != 3U )
//         {
//             Set_Sound_Volume(3U);    //设定并预览
//         }
//     }
// }

// void Menu_Logic_Operation_ITEM_Alarm_Volume_Mid(Menu_Key_en_t enKeyType)
// {
//     if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
//     {
//         MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Alarm_Volume_High, MENU_ITEM_Alarm_Volume_Low, MENU_ITEM_Alarm_Volume_Mid);
//         // USER_Setting_UpDate( );
//         if ( Get_Sound_Volume( ) != 2U )
//         {
//             Set_Sound_Volume(2U);    //设定并预览
//         }
//     }
// }

// void Menu_Logic_Operation_ITEM_Alarm_Volume_Low(Menu_Key_en_t enKeyType)
// {
//     if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
//     {
//         MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Alarm_Volume_High, MENU_ITEM_Alarm_Volume_Low, MENU_ITEM_Alarm_Volume_Low);
//         // USER_Setting_UpDate( );
//         if ( Get_Sound_Volume( ) != 1U )
//         {
//             Set_Sound_Volume(1U);    //设定并预览
//         }
//     }
// }

void Menu_Logic_Operation_ITEM_Alarm_Sound_1(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Alarm_Sound_1, MENU_ITEM_Alarm_Sound_3, MENU_ITEM_Alarm_Sound_1);
        if ( Get_Sound_Type( ) != 1U )
        {
            Set_Sound_Type(1);
        }
    }
}

void Menu_Logic_Operation_ITEM_Alarm_Sound_2(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Alarm_Sound_1, MENU_ITEM_Alarm_Sound_3, MENU_ITEM_Alarm_Sound_2);
        if ( Get_Sound_Type( ) != 2U )
        {
            Set_Sound_Type(2);
        }
    }
}

void Menu_Logic_Operation_ITEM_Alarm_Sound_3(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Alarm_Sound_1, MENU_ITEM_Alarm_Sound_3, MENU_ITEM_Alarm_Sound_3);
        if ( Get_Sound_Type( ) != 3U )
        {
            Set_Sound_Type(3);
        }
    }
}

void Menu_Logic_Operation_ITEM_Alarm_Sound_4(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Alarm_Sound_1, MENU_ITEM_Alarm_Sound_3, MENU_ITEM_Alarm_Sound_3);
        if ( Get_Sound_Type( ) != 3U )
        {
            Set_Sound_Type(3);
        }
    }
}

void Menu_Logic_Operation_ITEM_Alarm_Sound_5(Menu_Key_en_t enKeyType)
{
    if ( enKeyType == MENU_KEY_CONFIRM_SHORT )
    {
        MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Alarm_Sound_1, MENU_ITEM_Alarm_Sound_3, MENU_ITEM_Alarm_Sound_3);
        if ( Get_Sound_Type( ) != 3U )
        {
            Set_Sound_Type(3);
        }
    }
}

/************************************************************************************/

void Menu_Clear_Items_Select(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem)
{
    Menu_Item_en_t i = StartItem;
    if ( StartItem > EndItem )
    {
        return;
    }
    if ( EndItem >= MENU_ITEM_MAX )
    {
        return;
    }

    for ( i = StartItem; i <= EndItem; i++ )
    {
        Menu_Item_Select_Set(i, 0);
    }
}

void MENU_Intf_Inside_Item_Select_Set(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem, Menu_Item_en_t SelectItem)
{
    Menu_Item_en_t i = StartItem;
    if ( StartItem > EndItem )
    {
        return;
    }
    if ( EndItem >= MENU_ITEM_MAX )
    {
        return;
    }
    if ( (SelectItem < StartItem) || (SelectItem > EndItem) )
    {
        return;
    }
    for ( i = StartItem; i <= EndItem; i++ )
    {
        Menu_Item_Select_Set(i, 0);
    }
    Menu_Item_Select_Set(SelectItem, 1);
}

void MENU_Intf_Inside_Item_Select_Set_Close(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem, Menu_Item_en_t SelectItem)
{
    Menu_Item_en_t i = StartItem;
    if ( StartItem > EndItem )
    {
        return;
    }
    if ( EndItem >= MENU_ITEM_MAX )
    {
        return;
    }
    if ( (SelectItem < StartItem) || (SelectItem > EndItem) )
    {
        return;
    }
    for ( i = StartItem; i <= EndItem; i++ )
    {
        Menu_Item_Select_Set(i, 0);
    }
    Menu_Item_Select_Set(SelectItem, 0);
}

/*获取某一层中选中的光标情�?*/
Menu_Item_en_t MENU_Intf_Inside_Item_Select_Get(Menu_Item_en_t StartItem, Menu_Item_en_t EndItem)
{
    Menu_Item_en_t i   = StartItem;
    Menu_Item_en_t ret = MENU_ITEM_MAX;
    if ( StartItem > EndItem )
    {
        return ret;
    }
    if ( EndItem >= MENU_ITEM_MAX )
    {
        return ret;
    }

    for ( i = StartItem; i <= EndItem; i++ )
    {
        if ( Menu_Item_Select_Get(i) )
        {
            ret = i;
            break;
        }
    }
    return ret;
}

/*当前光标是MENU_ITEM_ENTRANCE_FIX时，表示退出了菜单，�?�时�?否需要显示�?�车电脑显示�?�?行车电脑，调用�?�函�?*/
// Menu_Item_en_t Get_INTF_Travel_Info_Select(void)
// {
//     Menu_Item_en_t ret = MENU_ITEM_MAX;
//     ret                = MENU_Intf_Inside_Item_Select_Get(MENU_ITEM_TPMS, MENU_ITEM_DTE);
//     return ret;
// }

// Menu_Item_en_t Get_INTF_Theme_Navigation(void)
// {
//     Menu_Item_en_t ret = MENU_ITEM_MAX;
//     ret                = MENU_Intf_Inside_Item_Select_Get(MENU_ITME_RULE, MENU_ITME_CLOSE);
//     return ret;
// }

// Menu_Item_en_t Get_INTF_Theme_Select(void)
// {
//     Menu_Item_en_t ret = MENU_ITEM_MAX;
//     ret                = MENU_Intf_Inside_Item_Select_Get(MENU_ITEM_Classics_Theme, MENU_ITEM_Auto_Theme);
//     return ret;
// }

// Menu_Item_en_t Get_INTF_Language_Select(void)
// {
//     Menu_Item_en_t ret = MENU_ITEM_MAX;
//     ret                = MENU_Intf_Inside_Item_Select_Get(MENU_ITEM_Chinese, MENU_ITEM_English);
//     return ret;
// }

// Menu_Item_en_t Get_INTF_Alarm_Volume_Select(void)
// {
//     Menu_Item_en_t ret = MENU_ITEM_MAX;
//     ret                = MENU_Intf_Inside_Item_Select_Get(MENU_ITEM_Alarm_Volume_High, MENU_ITEM_Alarm_Volume_Low);
//     return ret;
// }

// Menu_Item_en_t Get_INTF_Alarm_Sound_Select(void)
// {
//     Menu_Item_en_t ret = MENU_ITEM_MAX;
//     ret                = MENU_Intf_Inside_Item_Select_Get(MENU_ITEM_Alarm_Sound_1, MENU_ITEM_Alarm_Sound_3);
//     return ret;
// }

void INTF_Travel_Info_Select_Item_Set(Menu_Item_en_t SelectItem)
{
    MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Home_Page, MENU_ITEM_Instananeous_Fuel_Consumption, SelectItem);
}

// void INTF_Navigation_Select_Item_Set(Menu_Item_en_t SelectItem)
// {
//     MENU_Intf_Inside_Item_Select_Set(MENU_ITME_RULE, MENU_ITME_CLOSE, SelectItem);
// }


// void INTF_Navigation_Select_Item_Set_Close(Menu_Item_en_t SelectItem)
// {
//     MENU_Intf_Inside_Item_Select_Set_Close(MENU_ITME_RULE, MENU_ITME_CLOSE, SelectItem);
// }

// void INTF_Language_Select_Item_Set(Menu_Item_en_t SelectItem)
// {
//     MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Chinese, MENU_ITEM_English, SelectItem);
//     // USER_Setting_UpDate( );
// }

// void INTF_Alarm_Volume_Select_Item_Set(Menu_Item_en_t SelectItem)
// {
//     MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Alarm_Volume_High, MENU_ITEM_Alarm_Volume_Low, SelectItem);
//     // USER_Setting_UpDate( );
// }

// void INTF_Alarm_Sound_Select_Item_Set(Menu_Item_en_t SelectItem)
// {
//     MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Alarm_Sound_1, MENU_ITEM_Alarm_Sound_3, SelectItem);
//     // USER_Setting_UpDate( );
// }

// void INTF_Theme_Select_Item_Set(Menu_Item_en_t SelectItem)
// {
//     MENU_Intf_Inside_Item_Select_Set(MENU_ITEM_Classics_Theme, MENU_ITEM_Auto_Theme, SelectItem);
//     // USER_Setting_UpDate( );
// }

/*�?按mode进入菜单时，调用此函�?*/
// void External_Ctrl_Enter_Menu_Service(void)
// {
//     Menu_Item_en_t MenuItem = MENU_ITEM_MAX;

//     MenuItem = Menu_Get_Current_Cursor_Information( );

//     if ( Menu_Fault_Service( ) == 0 )
//     {
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Fault_Info, 0u);
//     }
//     else
//     {
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Fault_Info, 1u);
//     }

//     if (1)//( Val_EOL_F1F8_MultimediaDisplay( ) == FUNCTION_DISABLE )
//     {
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Media_Info, 0u);
//     }
//     else
//     {
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Media_Info, 1u);
//     }

//     if (1)//( Val_EOL_F1F8_Menu_Settings( ) == FUNCTION_DISABLE )
//     {
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Set, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Language, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Volume, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Sound, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Chinese, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_English, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Arabic, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Volume_High, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Volume_Mid, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Volume_Low, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Sound_1, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Sound_2, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Sound_3, 0u);
//     }
//     else
//     {
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Set, 1u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Language, 1u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Volume, 1u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Sound, 1u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Chinese, 1u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_English, 1u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Arabic, 0u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Volume_High, 1u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Volume_Mid, 1u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Volume_Low, 1u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Sound_1, 1u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Sound_2, 1u);
//         Menu_Item_Exist_Condition_Set(MENU_ITEM_Alarm_Sound_3, 1u);
//     }

//     if ( MenuItem == MENU_ITEM_ENTRANCE_FIX )
//     {
//         Menu_Service(MENU_KEY_CONFIRM_SHORT);
//     }
//     else
//     {
//         if ( ((MenuItem >= MENU_ITEM_TPMS) && (MenuItem <= MENU_ITEM_DTE)) || (MenuItem == MENU_ITEM_Media_Info) )
//         {
//             Menu_Service(MENU_KEY_CANCEL_SHORT);
//         }
//         // else
//         // {
//         //     Menu_Service(MENU_KEY_CONFIRM_SHORT);
//         // }
//     }
// }

/*长按mode退出菜单时，调用�?�函�?*/
// void External_Ctrl_Quit_Menu_Service(void)
// {
//     MenuPopupCurIdx = 0;
//     Menu_Clear_Items_Select(MENU_ITEM_TPMS, MENU_ITEM_DTE);
//     Menu_Change_Branch(0, MENU_CHANGE_FIRST);
// }

void Menu_User_Init(Menu_User_Init_PowerTypeEnum PowerType)
{
    Menu_Init_st_t Menu_Init_st;

    Menu_Init_st.enMenuBranchLen           = MENU_BRANCH_MAX;
    Menu_Init_st.enMenuInterfaceLen        = MENU_INTERFACE_MAX;
    Menu_Init_st.enMenuItemLen             = MENU_ITEM_MAX;
    Menu_Init_st.uintMenuConfig            = 0x0001;
    Menu_Init_st.uintMenuCursorMemoryDepth = 0;

    if ( PowerType == Menu_User_Init_Power_K30 )
    {
        Menu_Init(( Menu_uint8_t * )u8MenuRamData, ( Menu_Item_Attribute_st_t * )stMenuItemAttribute, ( Menu_Init_st_t * )&Menu_Init_st);
        INTF_Travel_Info_Select_Item_Set(MENU_ITEM_Home_Page);
        // INTF_Navigation_Select_Item_Set_Close(MENU_ITME_RULE);
        // INTF_Language_Select_Item_Set(MENU_ITEM_Chinese);
        // INTF_Alarm_Volume_Select_Item_Set(MENU_ITEM_Alarm_Volume_Mid);
        // INTF_Alarm_Sound_Select_Item_Set(MENU_ITEM_Alarm_Sound_1);
        // INTF_Theme_Select_Item_Set(MENU_ITEM_Classics_Theme);
    }
    else if ( PowerType == Menu_User_Init_Power_WakeUp )
    {
        Menu_Wake_Up_Init(( Menu_uint8_t * )u8MenuRamData, ( Menu_Item_Attribute_st_t * )stMenuItemAttribute, ( Menu_Init_st_t * )&Menu_Init_st);
    }
    else
    {
    }

    u8MenuKeyExecute = 1;
}

// void Menu_LongTimeNoKey(void)
// {
//     if ( (Menu_Get_Current_Cursor_Information( ) > MENU_ITEM_ENTRANCE_FIX) && (Menu_Get_Current_Cursor_Information( ) < MENU_ITEM_MAX) )
//     {
//         if ( LongTimeNoKeyCnt >= 50u )
//         {
//             LongTimeNoKeyCnt = 0u;
//             Menu_Service(MENU_KEY_TIMEOUT);
//         }
//         else
//         {
//             LongTimeNoKeyCnt++;
//         }
//     }
//     else
//     {
//         LongTimeNoKeyCnt = 0u;
//     }
// }

/*---------------------------------------------------------------------------------------*/
// clang-format off
const Menu_Item_Attribute_st_t stMenuItemAttribute [ MENU_ITEM_MAX ] = {
/*                                                  定位在哪个分支上            定位在哪个菜单界面内            归属哪个上级菜单项      该菜单项所在界面位置，从0开始       该菜单项所在界面的所有项数      屏幕内可显示的，每一列最多有几个横向行      该菜单项所在分支的位置      该菜单项所在分支的所有项数              菜单方向                         0xFF        下一级菜单界面,没有填0xFFFF     按下确认按键光标跳转类型        上一级菜单界面，没有填0xFFFF        按下返回按键光标跳转类型           按键超时时需要返回到的菜单界面      超时返回界面中光标跳转的类型        回调函数*/
    // /*MENU_ITEM_ENTRANCE_FIX     */                 {MENU_BRANCH_ANIMATION,    MENU_INTF_ENTRANCE,             MENU_ITEM_MAX,           0U,                                 1U,                                 1U,                                 0U,                 MENU_ITEM_MAX,        MENU_DIRECTION_LONGITUDINAL,                   0XFFU,       MENU_INTF_Home_Page,             MENU_JUMP_FIRST,              MENU_INTERFACE_MAX,                 MENU_JUMP_FIRST,              MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                       0U},

    /*主页*/
    /*MENU_ITEM_Home_Page*/                         {MENU_BRANCH_ANIMATION,    MENU_INTF_Home_Page,        MENU_ITEM_MAX,               0U,                                 3U,                                 1U,                        MENU_ITEM_Home_Page,                     MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,       MENU_INTF_Set_Main_Face,         MENU_JUMP_FIRST,              MENU_INTERFACE_MAX,                 MENU_JUMP_FIRST,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Total_Fuel_Consumption*/            {MENU_BRANCH_ANIMATION,    MENU_INTF_Home_Page,        MENU_ITEM_MAX,               1U,                                 3U,                                 1U,                        MENU_ITEM_Total_Fuel_Consumption,        MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,       MENU_INTF_Set_Main_Face,         MENU_JUMP_FIRST,              MENU_INTERFACE_MAX,                 MENU_JUMP_FIRST,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Instananeous_Fuel_Consumption*/     {MENU_BRANCH_ANIMATION,    MENU_INTF_Home_Page,        MENU_ITEM_MAX,               2U,                                 3U,                                 1U,                        MENU_ITEM_Instananeous_Fuel_Consumption, MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,       MENU_INTF_Set_Main_Face,         MENU_JUMP_FIRST,              MENU_INTERFACE_MAX,                 MENU_JUMP_FIRST,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},

    /*主菜单*/
    /*MENU_ITEM_Menu_Back*/                         {MENU_BRANCH_ANIMATION,    MENU_INTF_Set_Main_Face,    MENU_ITEM_Home_Page,         0U,                                 5U,                                 4U,                          MENU_ITEM_Menu_Back,                   MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,       MENU_INTF_Home_Page,             MENU_JUMP_FIRST,              MENU_INTF_Home_Page,                MENU_JUMP_FIRST,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                Menu_Logic_Operation_ITEM_Menu_Back},
    /*MENU_ITEM_Travel_Info*/                       {MENU_BRANCH_ANIMATION,    MENU_INTF_Set_Main_Face,    MENU_ITEM_Home_Page,         1U,                                 5U,                                 4U,                          MENU_ITEM_Travel_Info,                 MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,       MENU_INTF_Travel_Info,           MENU_JUMP_FIRST,              MENU_INTF_Home_Page,                MENU_JUMP_FIRST,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Fault*/                             {MENU_BRANCH_ANIMATION,    MENU_INTF_Set_Main_Face,    MENU_ITEM_Home_Page,         2U,                                 5U,                                 4U,                          MENU_ITEM_Fault,                       MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,       MENU_INTF_Fault,                 MENU_JUMP_FIRST,              MENU_INTF_Home_Page,                MENU_JUMP_FIRST,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Set*/                               {MENU_BRANCH_ANIMATION,    MENU_INTF_Set_Main_Face,    MENU_ITEM_Home_Page,         3U,                                 5U,                                 4U,                          MENU_ITEM_Set,                         MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,       MENU_INTF_Set,                   MENU_JUMP_FIRST,              MENU_INTF_Home_Page,                MENU_JUMP_FIRST,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Factory_Set*/                       {MENU_BRANCH_ANIMATION,    MENU_INTF_Set_Main_Face,    MENU_ITEM_Home_Page,         4U,                                 5U,                                 4U,                          MENU_ITEM_Factory_Set,                 MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,       MENU_INTF_Factory_Set,           MENU_JUMP_FIRST,              MENU_INTF_Home_Page,                MENU_JUMP_FIRST,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
   
    /*行车信息*/
    /*MENU_ITEM_Travel_Info_Back*/                  {MENU_BRANCH_ANIMATION,    MENU_INTF_Travel_Info,    MENU_ITEM_Travel_Info,         0U,                                 4U,                                 4U,                          MENU_ITEM_Travel_Info_Back,            MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,       MENU_INTF_Set_Main_Face,         MENU_JUMP_SELECT,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Engine*/                            {MENU_BRANCH_ANIMATION,    MENU_INTF_Travel_Info,    MENU_ITEM_Travel_Info,         1U,                                 4U,                                 4U,                          MENU_ITEM_Engine,                      MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,       MENU_INTF_Engine,                MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Gearbox*/                           {MENU_BRANCH_ANIMATION,    MENU_INTF_Travel_Info,    MENU_ITEM_Travel_Info,         2U,                                 4U,                                 4U,                          MENU_ITEM_Gearbox,                     MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,       MENU_INTF_Gearbox,               MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Hydraulic_Sys*/                     {MENU_BRANCH_ANIMATION,    MENU_INTF_Travel_Info,    MENU_ITEM_Travel_Info,         3U,                                 4U,                                 4U,                          MENU_ITEM_Hydraulic_Sys,               MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,       MENU_INTF_Hydraulic_Sys,         MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
   
    /*故障查询*/
    /*MENU_ITEM_Fault_Back*/                        {MENU_BRANCH_ANIMATION,    MENU_INTF_Fault,          MENU_ITEM_Fault,               0U,                                 7U,                                 4U,                          MENU_ITEM_Fault_Back,                 MENU_ITEM_MAX,               MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set_Main_Face,                 MENU_JUMP_SELECT,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Engine_Fault*/                      {MENU_BRANCH_ANIMATION,    MENU_INTF_Fault,          MENU_ITEM_Fault,               1U,                                 7U,                                 4U,                          MENU_ITEM_Engine_Fault,                 MENU_ITEM_MAX,             MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Engine_Fault,                  MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Gearbox_Fault*/                     {MENU_BRANCH_ANIMATION,    MENU_INTF_Fault,          MENU_ITEM_Fault,               2U,                                 7U,                                 4U,                          MENU_ITEM_Gearbox_Fault,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Gearbox_Fault,                 MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Independent_Heat_Dissipation*/      {MENU_BRANCH_ANIMATION,    MENU_INTF_Fault,          MENU_ITEM_Fault,               3U,                                 7U,                                 4U,                          MENU_ITEM_Independent_Heat_Dissipation,  MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Independent_Heat_Dissipation,  MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Hydraulic_Sys_Fault*/               {MENU_BRANCH_ANIMATION,    MENU_INTF_Fault,          MENU_ITEM_Fault,               4U,                                 7U,                                 4U,                          MENU_ITEM_Hydraulic_Sys_Fault,           MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Hydraulic_Sys_Fault,           MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Power_Matching_Sys*/                {MENU_BRANCH_ANIMATION,    MENU_INTF_Fault,          MENU_ITEM_Fault,               5U,                                 7U,                                 4U,                          MENU_ITEM_Power_Matching_Sys,            MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Power_Matching_Sys,            MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Aftertreatment_Fault*/              {MENU_BRANCH_ANIMATION,    MENU_INTF_Fault,          MENU_ITEM_Fault,               6U,                                 7U,                                 4U,                          MENU_ITEM_Aftertreatment_Fault,          MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Aftertreatment_Fault,          MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    
    /*系统设置*/
    /*MENU_ITEM_Set_Back*/                          {MENU_BRANCH_ANIMATION,    MENU_INTF_Set,            MENU_ITEM_Set,               0U,                                 5U,                                 4U,                            MENU_ITEM_Set_Back,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set_Main_Face,                 MENU_JUMP_SELECT,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Language*/                          {MENU_BRANCH_ANIMATION,    MENU_INTF_Set,            MENU_ITEM_Set,               1U,                                 5U,                                 4U,                            MENU_ITEM_Language,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Language,                      MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Alarm_Backlight_Set*/               {MENU_BRANCH_ANIMATION,    MENU_INTF_Set,            MENU_ITEM_Set,               2U,                                 5U,                                 4U,                            MENU_ITEM_Alarm_Backlight_Set,      MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Alarm_Backlight_Set,           MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Alarm_Sound*/                       {MENU_BRANCH_ANIMATION,    MENU_INTF_Set,            MENU_ITEM_Set,               3U,                                 5U,                                 4U,                            MENU_ITEM_Alarm_Sound,                 MENU_ITEM_MAX,         MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Alarm_Sound,                   MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_SW_Version*/                        {MENU_BRANCH_ANIMATION,    MENU_INTF_Set,            MENU_ITEM_Set,               4U,                                 5U,                                 4U,                            MENU_ITEM_SW_Version,                 MENU_ITEM_MAX,          MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_SW_Version,                    MENU_JUMP_FIRST,              MENU_INTF_Set_Main_Face,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
 
    /*行车信息——发动机*/
    /*MENU_ITEM_Engine_Page_1*/                     {MENU_BRANCH_ANIMATION,    MENU_INTF_Engine,         MENU_ITEM_Engine,               0U,                              3U,                                 1U,                            MENU_ITEM_Engine_Page_1,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Travel_Info,                MENU_JUMP_SELECT,              MENU_INTF_Travel_Info,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Engine_Page_2*/                     {MENU_BRANCH_ANIMATION,    MENU_INTF_Engine,         MENU_ITEM_Engine,               1U,                              3U,                                 1U,                            MENU_ITEM_Engine_Page_2,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Travel_Info,                MENU_JUMP_SELECT,              MENU_INTF_Travel_Info,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Engine_Page_3*/                     {MENU_BRANCH_ANIMATION,    MENU_INTF_Engine,         MENU_ITEM_Engine,               2U,                              3U,                                 1U,                            MENU_ITEM_Engine_Page_3,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Travel_Info,                MENU_JUMP_SELECT,              MENU_INTF_Travel_Info,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
   
    /*行车信息——变速箱*/
    /*MENU_ITEM_Gearbox_Page_1*/                    {MENU_BRANCH_ANIMATION,    MENU_INTF_Gearbox,         MENU_ITEM_Gearbox,               0U,                              2U,                                 1U,                            MENU_ITEM_Gearbox_Page_1,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Travel_Info,              MENU_JUMP_SELECT,              MENU_INTF_Travel_Info,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Gearbox_Page_2*/                    {MENU_BRANCH_ANIMATION,    MENU_INTF_Gearbox,         MENU_ITEM_Gearbox,               1U,                              2U,                                 1U,                            MENU_ITEM_Gearbox_Page_2,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Travel_Info,              MENU_JUMP_SELECT,              MENU_INTF_Travel_Info,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
   
    /*行车信息——液压系统*/
    /*MENU_ITEM_Hydraulic_Sys_Page_1*/              {MENU_BRANCH_ANIMATION,    MENU_INTF_Hydraulic_Sys,      MENU_ITEM_Hydraulic_Sys,               0U,                    3U,                                 1U,                            MENU_ITEM_Hydraulic_Sys_Page_1,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Travel_Info,             MENU_JUMP_SELECT,              MENU_INTF_Travel_Info,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Hydraulic_Sys_Page_1*/              {MENU_BRANCH_ANIMATION,    MENU_INTF_Hydraulic_Sys,      MENU_ITEM_Hydraulic_Sys,               1U,                    3U,                                 1U,                            MENU_ITEM_Hydraulic_Sys_Page_2,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Travel_Info,             MENU_JUMP_SELECT,              MENU_INTF_Travel_Info,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Hydraulic_Sys_Page_1*/              {MENU_BRANCH_ANIMATION,    MENU_INTF_Hydraulic_Sys,      MENU_ITEM_Hydraulic_Sys,               2U,                    3U,                                 1U,                            MENU_ITEM_Hydraulic_Sys_Page_3,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Travel_Info,             MENU_JUMP_SELECT,              MENU_INTF_Travel_Info,            MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
   
    /*故障查询——变速箱*/
    /*MENU_ITEM_Gearbox_Fault_Back*/                {MENU_BRANCH_ANIMATION,    MENU_INTF_Gearbox_Fault,         MENU_ITEM_Gearbox_Fault,           0U,                      3U,                                 4U,                            MENU_ITEM_Gearbox_Fault_Back,             MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Fault,                    MENU_JUMP_SELECT,             MENU_INTF_Fault,                       MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_DM1_Fault*/                         {MENU_BRANCH_ANIMATION,    MENU_INTF_Gearbox_Fault,         MENU_ITEM_Gearbox_Fault,           1U,                      3U,                                 4U,                            MENU_ITEM_DM1_Fault,                      MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_DM1_Fault,                MENU_JUMP_SELECT,              MENU_INTF_Fault,                       MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Ordinary_Fault*/                    {MENU_BRANCH_ANIMATION,    MENU_INTF_Gearbox_Fault,         MENU_ITEM_Gearbox_Fault,           2U,                      3U,                                 4U,                            MENU_ITEM_Ordinary_Fault,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Ordinary_Fault,           MENU_JUMP_SELECT,              MENU_INTF_Fault,                       MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
   
    /*系统设置——语言设置*/
    /*MENU_ITEM_Chinese*/                           {MENU_BRANCH_ANIMATION,    MENU_INTF_Language,             MENU_ITEM_Language,               0U,                   4U,                                 4U,                            MENU_ITEM_Chinese,                            MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                Menu_Logic_Operation_ITEM_Chinese},
    /*MENU_ITEM_English*/                           {MENU_BRANCH_ANIMATION,    MENU_INTF_Language,             MENU_ITEM_Language,               1U,                   4U,                                 4U,                            MENU_ITEM_English,                            MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                Menu_Logic_Operation_ITEM_English},
    /*MENU_ITEM_Russian*/                           {MENU_BRANCH_ANIMATION,    MENU_INTF_Language,             MENU_ITEM_Language,               2U,                   4U,                                 4U,                            MENU_ITEM_Russian,                            MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                Menu_Logic_Operation_ITEM_Russian},
    /*MENU_ITEM_Portuguese*/                        {MENU_BRANCH_ANIMATION,    MENU_INTF_Language,             MENU_ITEM_Language,               3U,                   4U,                                 4U,                            MENU_ITEM_Portuguese,                         MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                Menu_Logic_Operation_ITEM_Portuguese},
   
    /*系统设置——背光亮度调节*/
    /*MENU_ITEM_Backlight_1*/                       {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Backlight_Set,       MENU_ITEM_Alarm_Backlight_Set,      0U,                   5U,                                 4U,                            MENU_ITEM_Backlight_1,                   MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Backlight_2*/                       {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Backlight_Set,       MENU_ITEM_Alarm_Backlight_Set,      1U,                   5U,                                 4U,                            MENU_ITEM_Backlight_2,                   MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Backlight_3*/                       {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Backlight_Set,       MENU_ITEM_Alarm_Backlight_Set,      2U,                   5U,                                 4U,                            MENU_ITEM_Backlight_3,                   MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Backlight_4*/                       {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Backlight_Set,       MENU_ITEM_Alarm_Backlight_Set,      3U,                   5U,                                 4U,                            MENU_ITEM_Backlight_4,                   MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Backlight_5*/                       {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Backlight_Set,       MENU_ITEM_Alarm_Backlight_Set,      4U,                   5U,                                 4U,                            MENU_ITEM_Backlight_5,                   MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
   
    /*系统设置——蜂鸣器响度设置*/
    /*MENU_ITEM_Alarm_Sound_1*/                     {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Sound,              MENU_ITEM_Alarm_Sound,               0U,                   5U,                                 4U,                            MENU_ITEM_Alarm_Sound_1,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Alarm_Sound_2*/                     {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Sound,              MENU_ITEM_Alarm_Sound,               1U,                   5U,                                 4U,                            MENU_ITEM_Alarm_Sound_2,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Alarm_Sound_3*/                     {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Sound,              MENU_ITEM_Alarm_Sound,               2U,                   5U,                                 4U,                            MENU_ITEM_Alarm_Sound_3,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Alarm_Sound_4*/                     {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Sound,              MENU_ITEM_Alarm_Sound,               3U,                   5U,                                 4U,                            MENU_ITEM_Alarm_Sound_4,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
    /*MENU_ITEM_Alarm_Sound_5*/                     {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Sound,              MENU_ITEM_Alarm_Sound,               4U,                   5U,                                 4U,                            MENU_ITEM_Alarm_Sound_5,                 MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
            
    /*系统设置——仪表软件版本号*/
    /*MENU_ITEM_SW_Version_Display*/                {MENU_BRANCH_ANIMATION,    MENU_INTF_SW_Version,               MENU_ITEM_SW_Version,               0U,                   1U,                                 1U,                            MENU_ITEM_SW_Version_Display,             MENU_ITEM_MAX,            MENU_DIRECTION_LONGITUDINAL,    0XFFU,     MENU_INTF_Set,                             MENU_JUMP_SELECT,              MENU_INTF_Set,                          MENU_JUMP_SELECT,            MENU_INTERFACE_MAX,             MENU_JUMP_FIRST,                0},
   

    // /*MENU_ITEM_Chinese */                  {MENU_BRANCH_ANIMATION,    MENU_INTF_Language,        MENU_ITEM_Language,  0U, 3U, 1U, 39U, 48, MENU_DIRECTION_LONGITUDINAL, 0XFFU,            MENU_INTERFACE_MAX, MENU_JUMP_FIRST,           MENU_INTF_Set, MENU_JUMP_LAST_POSITION, MENU_INTF_ENTRANCE, MENU_JUMP_FIRST, Menu_Logic_Operation_ITEM_Chinese},
    // /*MENU_ITEM_English */                  {MENU_BRANCH_ANIMATION,    MENU_INTF_Language,        MENU_ITEM_Language,  1U, 3U, 1U, 40U, 48, MENU_DIRECTION_LONGITUDINAL, 0XFFU,            MENU_INTERFACE_MAX, MENU_JUMP_FIRST,           MENU_INTF_Set, MENU_JUMP_LAST_POSITION, MENU_INTF_ENTRANCE, MENU_JUMP_FIRST, Menu_Logic_Operation_ITEM_English},
    // /*MENU_ITEM_Arabic */                   {MENU_BRANCH_ANIMATION,    MENU_INTF_Language,        MENU_ITEM_Language,  2U, 3U, 1U, 41U, 48, MENU_DIRECTION_LONGITUDINAL, 0XFFU,            MENU_INTERFACE_MAX, MENU_JUMP_FIRST,           MENU_INTF_Set, MENU_JUMP_LAST_POSITION, MENU_INTF_ENTRANCE, MENU_JUMP_FIRST, Menu_Logic_Operation_ITEM_Arabic},

    // /*MENU_ITEM_Alarm_Volume_High */        {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Volume,    MENU_ITEM_Alarm_Volume,  0U, 3U, 1U, 42U, 48, MENU_DIRECTION_LONGITUDINAL, 0XFFU,            MENU_INTERFACE_MAX, MENU_JUMP_FIRST,           MENU_INTF_Set, MENU_JUMP_LAST_POSITION, MENU_INTF_ENTRANCE, MENU_JUMP_FIRST, Menu_Logic_Operation_ITEM_Alarm_Volume_High},
    // /*MENU_ITEM_Alarm_Volume_Mid */         {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Volume,    MENU_ITEM_Alarm_Volume,  1U, 3U, 1U, 43U, 48, MENU_DIRECTION_LONGITUDINAL, 0XFFU,            MENU_INTERFACE_MAX, MENU_JUMP_FIRST,           MENU_INTF_Set, MENU_JUMP_LAST_POSITION, MENU_INTF_ENTRANCE, MENU_JUMP_FIRST, Menu_Logic_Operation_ITEM_Alarm_Volume_Mid},
    // /*MENU_ITEM_Alarm_Volume_Low */         {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Volume,    MENU_ITEM_Alarm_Volume,  2U, 3U, 1U, 44U, 48, MENU_DIRECTION_LONGITUDINAL, 0XFFU,            MENU_INTERFACE_MAX, MENU_JUMP_FIRST,           MENU_INTF_Set, MENU_JUMP_LAST_POSITION, MENU_INTF_ENTRANCE, MENU_JUMP_FIRST, Menu_Logic_Operation_ITEM_Alarm_Volume_Low},

    // /*MENU_ITEM_Alarm_Sound_1 */            {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Sound,     MENU_ITEM_Alarm_Sound,  0U, 3U, 1U, 45U, 48, MENU_DIRECTION_LONGITUDINAL, 0XFFU,            MENU_INTERFACE_MAX, MENU_JUMP_FIRST,           MENU_INTF_Set, MENU_JUMP_LAST_POSITION, MENU_INTF_ENTRANCE, MENU_JUMP_FIRST, Menu_Logic_Operation_ITEM_Alarm_Sound_1},
    // /*MENU_ITEM_Alarm_Sound_2 */            {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Sound,     MENU_ITEM_Alarm_Sound,  1U, 3U, 1U, 46U, 48, MENU_DIRECTION_LONGITUDINAL, 0XFFU,            MENU_INTERFACE_MAX, MENU_JUMP_FIRST,           MENU_INTF_Set, MENU_JUMP_LAST_POSITION, MENU_INTF_ENTRANCE, MENU_JUMP_FIRST, Menu_Logic_Operation_ITEM_Alarm_Sound_2},
    // /*MENU_ITEM_Alarm_Sound_3 */            {MENU_BRANCH_ANIMATION,    MENU_INTF_Alarm_Sound,     MENU_ITEM_Alarm_Sound,  2U, 3U, 1U, 47U, 48, MENU_DIRECTION_LONGITUDINAL, 0XFFU,            MENU_INTERFACE_MAX, MENU_JUMP_FIRST,           MENU_INTF_Set, MENU_JUMP_LAST_POSITION, MENU_INTF_ENTRANCE, MENU_JUMP_FIRST, Menu_Logic_Operation_ITEM_Alarm_Sound_3},
};
// clang-format on
/*-------------------------------------------------------------------------------------------------*/

/*--------------------------The following usage is recommended, but not required--------------------------------*/
/*--------------------------The following usage is recommended, but not required--------------------------------*/
/*--------------------------The following usage is recommended, but not required--------------------------------*/

/*传入按键动作执�?�之前需要�?�先处理的动�?*/
// static void Menu_Cursor_Preprocess(Menu_Key_en_t enMenuKey)
// {

//     /*预�?�理�?执�?�过�?次按�?了，后续不必执�?�时调用一�?*/
//     /*u8MenuKeyExecute = 0U;*/
//     u8MenuKeyExecute = 1U;
//     if ( (Menu_Get_Current_Cursor_Information( ) == MENU_ITEM_Chinese) || (Menu_Get_Current_Cursor_Information( ) == MENU_ITEM_Alarm_Volume_High) || (Menu_Get_Current_Cursor_Information( ) == MENU_ITEM_Alarm_Sound_1) )
//     {
//         if ( enMenuKey == MENU_KEY_UP_SHORT )
//         {
//             //    Menu_Cursor_Process(MENU_KEY_CANCEL_SHORT); 上 取消回到上一级
//             u8MenuKeyExecute = 0U;
//         }
//     }
//     else if ( (Menu_Get_Current_Cursor_Information( ) == MENU_ITEM_Arabic) /* || (Menu_Get_Current_Cursor_Information( ) == MENU_ITEM_Alarm_Volume_Low)  */ )
//     {
//         if ( enMenuKey == MENU_KEY_DOWN_SHORT )
//         {
//             Menu_Cursor_Process(MENU_KEY_CANCEL_SHORT);
//         }
//     }
//     else if ( Menu_Get_Current_Cursor_Information( ) == MENU_ITEM_Alarm_Sound_3 )
//     {
//         /*   if ( enMenuKey == MENU_KEY_DOWN_SHORT )
//           {
//               u8MenuKeyExecute = 0U;
//           } */
//     }
// }
/*传入按键动作执�?�之后需要后�?处理的动�?*/
static void Menu_Cursor_Postprocess(Menu_Key_en_t enMenuKey)
{
}

/*------------传入按键类型-----------------------*/
void Menu_Service(Menu_Key_en_t enMenuKey)
{
    /*功能回调函数的调�?*/
    Menu_Logic_Process(enMenuKey);
    /*--------------------------------------------------*/
    /*按键动作对光标的处理*/
    // Menu_Cursor_Preprocess(enMenuKey);
    if ( u8MenuKeyExecute )
    {
        Menu_Cursor_Process(enMenuKey);
    }
    u8MenuKeyExecute = 1;
    Menu_Cursor_Postprocess(enMenuKey);
    /*--------------------------------------------------*/
}

/*------------请放在休眠，唤醒之后不会�?清除的RAM区域�?-------------------------*/
/*------------请放在休眠，唤醒之后不会�?清除的RAM区域�?-------------------------*/
/*------------请放在休眠，唤醒之后不会�?清除的RAM区域�?-------------------------*/
#pragma ghs section bss = ".myNonInitArea"
Menu_uint8_t        u8MenuRamData [ MENU_RAM_DATA_LEN ];
#pragma ghs section bss = default
/*---------------------------------------*/
/*---------------------------------------*/
/*---------------------------------------*/
