#include "Sound_Player.h"
#include "TYW_stdint.h"
#include "NVM.h"
#include "Internal_EEPROM.h"
// #include "Menu.h"
#include <string.h>
#include "Services_Mileage_User.h"

#define EEPROM_BASE_ADDR 0
#define EEPROM_PAGE_SIZE 16
#pragma ghs section bss = ".myNonInitArea"
uint8_t             USR_SETTING [ 10 ];
#pragma ghs section bss = default

void NVM_Usr_Init(void)
{
    uint8_t        readbuff [ 256 ];
    uint8_t        writebuff [ 256 ];
    r_eel_status_t loc_condition;

    // CAFD
    // user setting CTRL
    memset(readbuff, 0, sizeof(readbuff));
    memset(writebuff, 0, sizeof(writebuff));
    loc_condition = Internal_EEL_Read(INTERNAL_EE_BLOCK_03, readbuff, INTERNAL_EE_BLOCK_03_size);
    if ( (readbuff [ 0 ] != 0x35) || (readbuff [ 1 ] != 0x53) || (readbuff [ 2 ] != 0x7A) || (readbuff [ 3 ] != 0xA7) || (loc_condition == R_EEL_ERR_NO_INSTANCE) )
    {
        writebuff [ 0 ]   = 0x35u;
        writebuff [ 1 ]   = 0x53u;
        writebuff [ 2 ]   = 0x7Au;
        writebuff [ 3 ]   = 0xA7u;
        // USR_SETTING [ 0 ] = MENU_ITEM_Classics_Theme;      // theme
        // USR_SETTING [ 1 ] = MENU_ITEM_Chinese;             // language
        // USR_SETTING [ 2 ] = MENU_ITEM_Alarm_Sound_1;       // soundtype
        // USR_SETTING [ 3 ] = MENU_ITEM_Alarm_Volume_Mid;    // soundvol
        USR_SETTING [ 0 ] = 0;
        USR_SETTING [ 1 ] = 0;
        USR_SETTING [ 2 ] = 0;
        USR_SETTING [ 3 ] = 0;
        USR_SETTING [ 4 ] = 0;
        USR_SETTING [ 5 ] = 0;
        USR_SETTING [ 6 ] = 0;
        USR_SETTING [ 7 ] = 0;
        // USR_SETTING [ 8 ] = 0;
        // USR_SETTING [ 9 ] = 0;
        memcpy(&writebuff [ 4 ], &USR_SETTING, 8);//sizeof(USR_SETTING));
        Internal_EEL_Write(INTERNAL_EE_BLOCK_03, writebuff, INTERNAL_EE_BLOCK_03_size);
        Internal_EEL_Read(INTERNAL_EE_BLOCK_03, readbuff, INTERNAL_EE_BLOCK_03_size);
        USR_SETTING [ 0 ] = readbuff [ 4 ];
        USR_SETTING [ 1 ] = readbuff [ 5 ];
        USR_SETTING [ 2 ] = readbuff [ 6 ];
        USR_SETTING [ 3 ] = readbuff [ 7 ];
    }
    else
    {
        USR_SETTING [ 0 ] = readbuff [ 4 ];
        USR_SETTING [ 1 ] = readbuff [ 5 ];
        USR_SETTING [ 2 ] = readbuff [ 6 ];
        USR_SETTING [ 3 ] = readbuff [ 7 ];
        // if ( Get_ChangAn_ODOClear( ) != USR_SETTING [ 0 ] )
        {
            Set_ChangAn_ODOClear(readbuff [ 4 ]);
        }
        // if ( Get_INTF_Theme_Select( ) != USR_SETTING [ 0 ] )
        // {
        //     INTF_Theme_Select_Item_Set(readbuff [ 4 ]);
        // }
        // if ( Get_INTF_Language_Select( ) != USR_SETTING [ 1 ] )
        // {
        //     INTF_Language_Select_Item_Set(readbuff [ 5 ]);
        // }
        // if ( Get_INTF_Alarm_Sound_Select( ) != USR_SETTING [ 2 ] )
        // {
        //     INTF_Alarm_Sound_Select_Item_Set(readbuff [ 6 ]);
        // }
        // if ( Get_INTF_Alarm_Volume_Select( ) != USR_SETTING [ 3 ] )
        // {
        //     INTF_Alarm_Volume_Select_Item_Set(readbuff [ 7 ]);
        // }

        // if ( Get_INTF_Language_Select( ) == MENU_ITEM_English )
        // {
        //     Set_Global_Language(1u);
        // }
        // else
        // {
        //     Set_Global_Language(0u);
        // }

        // if ( Get_INTF_Alarm_Sound_Select( ) == MENU_ITEM_Alarm_Sound_1 )
        // {
        //     Set_Sound_Type(1U);
        //     Set_Global_Sound_Type(1U);
        // }
        // else if ( Get_INTF_Alarm_Sound_Select( ) == MENU_ITEM_Alarm_Sound_2 )
        // {
        //     Set_Sound_Type(2U);
        //     Set_Global_Sound_Type(2U);
        // }
        // else if ( Get_INTF_Alarm_Sound_Select( ) == MENU_ITEM_Alarm_Sound_3 )
        // {
        //     Set_Sound_Type(3U);
        //     Set_Global_Sound_Type(3U);
        // }
        // else
        // {
        //     Set_Sound_Type(1U);
        //     Set_Global_Sound_Type(1U);
        // }

        // if ( Get_INTF_Alarm_Volume_Select( ) == MENU_ITEM_Alarm_Volume_Low )
        // {
        //     Set_Global_Volume(1U);
        //     Set_Sound_Volume(1U);
        // }
        // else if ( Get_INTF_Alarm_Volume_Select( ) == MENU_ITEM_Alarm_Volume_Mid )
        // {
        //     Set_Global_Volume(2U);
        //     Set_Sound_Volume(2U);
        // }
        // else if ( Get_INTF_Alarm_Volume_Select( ) == MENU_ITEM_Alarm_Volume_High )
        // {
        //     Set_Global_Volume(3U);
        //     Set_Sound_Volume(3U);
        // }
        // else
        // {
        //     Set_Global_Volume(2U);
        //     Set_Sound_Volume(2U);
        // }
    }
}

void CAFD_NVM_Update(uint8_t cmd)
{
}

void CAFD_CTRL_Update(uint8_t status)
{
}

void USER_Setting_UpDate(void)
{

    uint8_t        readbuff [ 512 ];
    uint8_t        writebuff [ 512 ];
    r_eel_status_t loc_condition;

    // if ( (USR_SETTING [ 0 ] != Get_INTF_Theme_Select( )) || (USR_SETTING [ 1 ] != Get_INTF_Language_Select( )) || (USR_SETTING [ 2 ] != Get_INTF_Alarm_Sound_Select( )) || (USR_SETTING [ 3 ] != Get_INTF_Alarm_Volume_Select( )) )
    {

        // USER_Setting
        memset(readbuff, 0, sizeof(readbuff));
        memset(writebuff, 0, sizeof(writebuff));
        writebuff [ 0 ] = 0x35u;
        writebuff [ 1 ] = 0x53u;
        writebuff [ 2 ] = 0x7Au;
        writebuff [ 3 ] = 0xA7u;

        // USR_SETTING [ 0 ] = Get_INTF_Theme_Select( );           // theme
        // USR_SETTING [ 1 ] = Get_INTF_Language_Select( );        // language
        // USR_SETTING [ 2 ] = Get_INTF_Alarm_Sound_Select( );     // soundtype
        // USR_SETTING [ 3 ] = Get_INTF_Alarm_Volume_Select( );    // soundvol
        USR_SETTING [ 0 ] = Get_ChangAn_ODOClear();
        USR_SETTING [ 1 ] = 0;
        USR_SETTING [ 2 ] = 0;
        USR_SETTING [ 3 ] = 0;
        USR_SETTING [ 4 ] = 0;
        USR_SETTING [ 5 ] = 0;
        USR_SETTING [ 6 ] = 0;
        USR_SETTING [ 7 ] = 0;
        //USR_SETTING [ 8 ] = 0;
        //USR_SETTING [ 9 ] = 0;
        memcpy(&writebuff [ 4 ], &USR_SETTING, 8);//sizeof(USR_SETTING));

        Internal_EEL_Write(INTERNAL_EE_BLOCK_03, writebuff, INTERNAL_EE_BLOCK_03_size);
        /*     Internal_EEL_Read(INTERNAL_EE_BLOCK_03, readbuff, INTERNAL_EE_BLOCK_03_size);
            INTF_Theme_Select_Item_Set(readbuff [ 4 ]);
            INTF_Language_Select_Item_Set(readbuff [ 5 ]);
            INTF_Alarm_Sound_Select_Item_Set(readbuff [ 6 ]);
            INTF_Alarm_Volume_Select_Item_Set(readbuff [ 7 ]);
        } */
    }
}

void CAFD_NVM_Save(void)
{
}

void USER_Setting_Clear(void)
{

    uint8_t        readbuff [ 512 ];
    uint8_t        writebuff [ 512 ];
    r_eel_status_t loc_condition;

    memset(readbuff, 0, sizeof(readbuff));
    memset(writebuff, 0, sizeof(writebuff));
    writebuff [ 0 ]   = 0x35u;
    writebuff [ 1 ]   = 0x53u;
    writebuff [ 2 ]   = 0x7Au;
    writebuff [ 3 ]   = 0xA7u;
    // USR_SETTING [ 0 ] = MENU_ITEM_Classics_Theme;      // theme
    // USR_SETTING [ 1 ] = MENU_ITEM_Chinese;             // language
    // USR_SETTING [ 2 ] = MENU_ITEM_Alarm_Sound_1;       // soundtype
    // USR_SETTING [ 3 ] = MENU_ITEM_Alarm_Volume_Mid;    // soundvol
    USR_SETTING [ 0 ] = 0;
    USR_SETTING [ 1 ] = 0;
    USR_SETTING [ 2 ] = 0;
    USR_SETTING [ 3 ] = 0;
    USR_SETTING [ 4 ] = 0;
    USR_SETTING [ 5 ] = 0;
    USR_SETTING [ 6 ] = 0;
    USR_SETTING [ 7 ] = 0;
    // USR_SETTING [ 8 ] = 0;
    // USR_SETTING [ 9 ] = 0;
    memcpy(&writebuff [ 4 ], &USR_SETTING, 8);//sizeof(USR_SETTING));
    Internal_EEL_Write(INTERNAL_EE_BLOCK_03, writebuff, INTERNAL_EE_BLOCK_03_size);
}