

#ifndef _POPUPS_H_
#define _POPUPS_H_

#include "TYW_stdint.h"

#define POPUP_DELAY_TIMER 3000 / 100

typedef union
{
    uint16_t msg;
    struct
    {
        uint16_t Steering_NotRelieved       : 1;
        uint16_t TheftPrevention_Auth_Fault : 1;
        uint16_t CheckReturnLockSys         : 1;
        uint16_t LEFT_IN_CAR_Lock           : 1;
        uint16_t SHIFT_TO_P                 : 1;
        uint16_t SHIFT_TO_N                 : 1;
        uint16_t Brake_To_Start             : 1;
        uint16_t Clutch_To_Start            : 1;
        uint16_t NoKey_Faul                 : 1;
        uint16_t PowerAllot_Fault           : 1;
        uint16_t NO_KEY_FOUND               : 1;
        uint16_t KEYINHUCUP                 : 1;
        uint16_t Revers                     : 4;
    } Sig;
} PopupPEPSUnion;

void Popups_Management_KL30_Init(void);
void Popups_Management_Wakeup_Init(void);
void Popups_Management_KL15_Init(void);
void Popups_Management_Service(void);
extern uint16_t Get_Popups_PrimaryLimitSystemActivationRemainingTime(void);  //返回初级限制系统激活剩余的时间
extern uint16_t Get_Popups_SeverelyLimitSystemActivationRemainingTime(void);  //返回严重限制系统激活剩余的时间
void Popups_Maintenance_Tips(void);
uint8_t Get_Transmission_Self_Learning_ZF(void);
void Popups_Ig_OFF(void);
static void Popups_PrimaryLimitSystemActivationRemainingTime(void);//初级限制系统激活剩余时间
static void Popups_SeverelyLimitSystemActivationRemainingTime(void);//严重限制系统激活剩余时间
uint8_t Get_Xugong_gearbox_self_learning(void); //徐工自制变速箱弹出事件

#endif