#include "PowerManagement.h"
#include "PowerManag_user.h"
#include "System_Monitor_User.h"
#include "System_Monitor.h"
#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "Line_In_user.h"
// #include "NM_Config.h"
#include "Sound_Scheduler.h"
#include "GenDelay.h"
#include "TYW_stdint.h"
#include "Key.h"
#include "Data_VSpeed.h"
#include "Data_ESpeed.h"
#include "Common_Interface.h"
#include "Services_Mileage_User.h"
#include "Popup_Scheduler.h"
#include "Telltales_user.h"
// #include "NMUserControl.h"
#include "BackLight.h"
#include "RTE_WDT.h"
#include "Task.h"
#include "./AMT630H/AMT630H.h"
#include "Sound_Player.h"
#include "UDS_Common.h"
#include "RTE_CAN.h"
#include "NVM.h"
#include "eepromManage.h"
#include "DisplaySch.h"
#include "Sound.h"
#include "Popups.h"
#include "RTE_GPIO.h"
#include "RTE_ADC.h"
#include "RTC.h"
#include "CAN_CFG.h"
#include "Data_IGN_OFF_Timing_User.h"
#include "Display.h"
#include "LED_Driver_Interface.h"
#include "Data_Gear.h"
#include "LED_Driver.h"
#include "CAN_APP.h"
#include "RSCAN.h"
#include "Transmission_oil_Tem_Table.h"
#include "Data_Water_Tem_Table.h"
#include "Data_Time.h"
#include "./AMT630H/AMT630H_Datas.h"
#include "Fuel_Level_Table.h"
#include "Brake_Pressure_Table.h"
#include "Brake_Pressure_Voltage_Table.h"
#include "Brake_Pressure_Service.h"
#include "FreIn_User.h"
#include "FreIn.h"
#include "TimerB.h"
#include "Menu.h"


static void Power_KL30_Init(void);
static void Power_Wakeup_Init(void);
static void Power_LVP_Init(void);
static void Power_OVP_Init(void);
static void Power_IG_OFF_Init(void);
static void Power_IG_ON_Init(void);
static void Power_Sleep_Init(void);

static Power_Status_em     Power_Stay_ON(void);
static Power_Status_em     Power_Stay_OFF(void);
static Power_Status_em     Power_Stay_Protect(void);
static Power_Status_em     Power_Stay_Sleep(void);
extern void FDL_Init(void);
uint32_t                   Power_Change_Flag;
static const st_PowerGroup g_stPwrTasks = {
    Power_KL30_Init,
    Power_IG_OFF_Init,
    Power_Stay_OFF,
    Power_Sleep_Init,
    Power_Stay_Sleep,
    Power_Wakeup_Init,
    Power_IG_ON_Init,
    Power_Stay_ON,
    Power_LVP_Init,
    Power_OVP_Init,
    Power_Stay_Protect,
};

void PwrMemInit(void)
{
    PowerMemInit(&g_stPwrTasks);
}

static void Power_KL30_Init(void)
{
    NVM_Usr_Init( );
    FDL_Init();
    ReadAllDFlashData( );
    Common_DataInit( );
    BusOff_Init( );
    Telltales_Init( );
    BREAKFLUID_3S_Init();
    Key_Init( );
    RTE_GPIO_Open_Device();
    Data_Vehicle_Speed_KL30_Init( );
    Data_Engine_Speed_KL30_Wakeup_Init( );
    Display_Schedule_KL30_Init( );
    BackLight_30_Init( );
    SoundType30Init( );
    LINE_IN_Init( );
    Sys_KL30_Init( );
    eeprom_StoreInfo_Init( );
    Data_User_Mileage_KL30Init( );

    LED_Driver_Init_Example();
    Amt630hInit();
    Sound_Player_Init( );
    Data_Brake_Pressure_Service_KL30_Init();
    Sound_Scheduler_Init( );
    Sound_Management_Init( );
    Popups_Management_KL30_Init( );
    Popup_Scheduler_Init( );
    Display_Data_Init( );
    Data_CAN_APP_Init();
    Set_Key_KL_Init();
    BackLight_LV_30_Init();
    Power_Change_Flag = 0ul;
    // PR_Light_En = 1u;
    Data_PowerSoc_TempPara_KL30_Init();
    Data_OilTem_TempPara_KL30_Init();
    Data_Time_KL30_Init();
    Data_FuelLevel_TempPara_KL30_Init( );
    Data_BrakePressure_TempPara_KL30_Init( );
    Data_BrakePressureVoltage_TempPara_KL30_Init( );

    Fre_In_Init_Example();
    TimerB_Input_Channel_Init(TIMERB_0_CH13, TIMERB_CLOCK_3, TIMERB_RISING_FALL);
    TimerB_Input_Channel_Start(TIMERB_0_CH13);
    Menu_User_Init(Menu_User_Init_Power_K30);
}

static void Power_Wakeup_Init(void)
{
    Data_Time_KL30_Init( );
    Common_DataInit( );
    BusOff_Init( );
    // NVM_Usr_Init( );
    FDL_Init();
    ReadAllDFlashData( );
    Data_Vehicle_Speed_Wakeup_Init( );
    Data_Engine_Speed_KL30_Wakeup_Init( );
    Data_User_Mileage_WakeupInit( ); 
    BackLight_WakeUp_Init( );
    Telltales_Init( );
    RTE_GPIO_Open_Device();
    Amt630hInit();
    LED_Driver_Init_Example();
    Sound_Player_Init( );
    Sound_Scheduler_Init( );
    Sound_Management_Init( );
    Popups_Management_Wakeup_Init( );
    Popup_Scheduler_Init( );
    Display_Schedule_Wakeup_Init( );
    Display_Data_Wakeup_Init();

    LINE_IN_Init( );
    Key_Init( );
    Set_Key_KL_Init();
    // Core_Start_Data_Inital( );
    Data_CAN_APP_Init();
    Sys_WakeUp_Init( );
    Power_Change_Flag = 0ul;
    
    // PR_Light_En = 1u;
    Data_PowerSoc_TempPara_Wakeup_Init();
    Data_Brake_Pressure_Service_Wakeup_Init();
    Data_OilTem_TempPara_Wakeup_Init();
    Data_FuelLevel_TempPara_Wakeup_Init();
    Data_BrakePressure_TempPara_Wakeup_Init();
    Data_BrakePressureVoltage_TempPara_Wakeup_Init( );

    Fre_In_Init_Example();
    TimerB_Input_Channel_Init(TIMERB_0_CH13, TIMERB_CLOCK_3, TIMERB_RISING_FALL);
    TimerB_Input_Channel_Start(TIMERB_0_CH13);
    Menu_User_Init(Menu_User_Init_Power_WakeUp);
}

static void Power_LVP_Init(void)
{
}
static void Power_OVP_Init(void)
{
}

static void Power_IG_OFF_Init(void)
{
    Data_Clear_OFF_Time( );
    Popup_Scheduler_OFF_Init( );
    if ( Power_Change_Flag == 0x22222222UL )
    {
        Sound_Delete(SND_New_ID_149);
        // Sound_Clear();
        Sound_Scheduling_Service( );
        Sound_Request(SND_New_ID_150, 1u);
        Sound_Scheduling_Service( );
        Popups_Ig_OFF();
    }
    Power_Change_Flag = 0x11111111UL;
    Data_Gear_KL30_Wakeup_Init();
    Set_Key_KL_Init();
    Boot_Animation_KL15_Off();
}

static void Power_IG_ON_Init(void)
{
    Data_Time_KL30_Init( );
    BackLight_15_Init( );
    Telltales_KL15_Init( );
    BREAKFLUID_3S_Init();
    Popup_Scheduler_ON_Init( );
    if ( Power_Change_Flag == 0x11111111UL )
    {
        Sound_Delete(SND_New_ID_150);
        // Sound_Clear();
        Sound_Scheduling_Service( );
        Sound_Request(SND_New_ID_149, 1u);
        Sound_Scheduling_Service( );
    }
    Popups_Management_KL15_Init();
    Data_CAN_APP_Init();
    Power_Change_Flag = 0x22222222UL;
    Data_Gear_KL30_Wakeup_Init();
    Display_Data_Wakeup_Init();
    Set_Key_KL_Init();
    Boot_Animation_KL15_Init();
    Menu_User_Init(Menu_User_Init_Power_K15);
}

static void Power_Sleep_Init(void)
{
    //-----PowerDownTimming-------
    BackLight_Sleep_Init( );    // Close Backlight
    AMT630H_Sleep();
    Gen_TimeDelay(25000u, 50u);
    RTE_GPIO_OFF_Device();
    WDT_Clear( );
    // RTE_PowerOFF_Squence( );
    // PR_Light_En = 0u;
    B_CAN_STB = 1;
    WDT_Clear( );

    Fre_In_Sleep_Init();
    TimerB_Input_Channel_Stop(TIMERB_0_CH13);
}

static Power_Status_em Power_Stay_ON(void)
{
    Power_Status_em u8PowerSts;

    u8PowerSts = EM_IGN_ON;

    Sound_Delete(SND_New_ID_150);
    /*-关机模式-*/
    if ( SYS_OPR_STAT_IGN_OFF )
    {
        u8PowerSts = EM_IGN_OFF_Init;
    }

    /*-停止模式-*/
    if ( SYS_OPR_STAT_HALT )
    {
        u8PowerSts = EM_IGN_LIMIT;
    }

    return u8PowerSts;
}

static Power_Status_em Power_Stay_OFF(void)
{
    Power_Status_em u8PowerSts;

    uint8_t m_conditon_0;
    uint8_t m_conditon_1;
    u8PowerSts   = EM_IGN_OFF;
    m_conditon_1 = Read_KL30_ConvertFinish( );

    if ( RSCAN0_CH4_RX_Sts( ) == 1U )
    {
        Sleep_Count_Clr( );
    }


    if ( SYS_OPR_STAT_IGN_ON )
    {
        u8PowerSts = EM_IGN_ON_Init;
    }
    else
    {
        /*电源管理唤醒*/
        if ( (Get_Sleep_Count( ) >= 300UL) /*&& (Line_In_Get_Status(nLINE_IN_DOOROPEN) == 0) && (Line_In_Get_Status(nLINE_IN_SOC_CC) == 0)*/ )
        {
            u8PowerSts = EM_IGN_Sleep_Init;
        }
        else
        {
            u8PowerSts = EM_IGN_OFF;
        }
    }

    return u8PowerSts;
}

static Power_Status_em Power_Stay_Protect(void)
{
    Power_Status_em u8PowerSts;

    /*-关闭所有外设功能，只保留AD采集，电源状态切换-*/
    {
        /*- 关闭电机待添加 -*/
        /*- 关闭扬声器待添加 -*/
        BackLight_30_Init( );
        BackLight_Sleep_Init( );                      //*关闭背光*/
        /*CanNm_NetworkRelease ( NM_REQ_KL15_OFF );*/ /*40202-2*/
    }

    u8PowerSts = EM_IGN_OFF_Init;

    for ( ;; )
    {
        /*喂狗*/
        WDT_Clear( );
        if((SYS_OPR_STAT_LIM_LVP) || (SYS_OPR_STAT_LIM_OVP))
        {
            CAN_SET_APP_SEND(1u);
            CAN_SET_NM_SEND(1u);
        }
        else 
        {
            CAN_SET_APP_SEND(0u);
            CAN_SET_NM_SEND(0u);
        }
        /*一定周期调用2ms*/
        Gen_TimeDelay(2000u, 50u);

        DoCAN_Communication_Service( );
        UDS_Server_Application_Service( );
        UDS_10ms_Service( );
        SET_LED_ALL_Light_CLOSE();
        LED_Driver_Service();
        LED_Driver_Scan_Refresh();
        RTE_ADC_Services( );
        Sys_Status_Update_Service( );
        // Delaycnt++;
        // if ( Delaycnt >= 5u )
        // {
        //     Delaycnt = 0u;
        //     // Can_BusOff_Fun();pr
        // }

        if ( GetBusOffState( ) != 0u )
        {
            CanBusoffRecover( );
        }

        /*- 电源模式正常，退出 -*/
        if ( SYS_OPR_STAT_RUN )
        {
            CAN_SET_APP_SEND(0u);
            CAN_SET_NM_SEND(0u);
            BackLight_30_Init( );
            return u8PowerSts;
        }
    }
}

static Power_Status_em Power_Stay_Sleep(void)
{
    Power_Status_em u8PowerSts = EM_IGN_OFF_Init;

    RTC_Timing_Service( );
    Data_Save_Cur_Time( );

    WDT_Clear( );
    /*-诊断休眠-*/
    UDS_Slepp( );
    Sys_Enter_Sleep_Mode( );
    u8PowerSts = EM_IGN_Wakeup;

    return u8PowerSts;
}

uint32_t Sleep_Counter;
void     PowerSleepCount(void)
{
    if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        Sleep_Counter = 0U;
    }
    else
    {
        if (Popup_Get_Current_PopupID() == 0)
        {
        }
        else
        {
            if (Sleep_Counter <= 0xFFFFFF00UL)
            {
                Sleep_Counter++;
            }
        }
    }
}
uint32_t Get_Sleep_Count(void)
{
    return Sleep_Counter;
}
void Sleep_Count_Clr(void)
{
    Sleep_Counter = 0U;
}
