#ifndef POWER_MANAGEMENT_H
#define POWER_MANAGEMENT_H

#ifdef Platform_16Bit
    #define PwrLib_uint8_t  unsigned char
    #define PwrLib_uint16_t unsigned int
    #define PwrLib_uint32_t unsigned long
#else

    #define PwrLib_uint8_t  unsigned char
    #define PwrLib_uint16_t unsigned short
    #define PwrLib_uint32_t unsigned int
    #define PwrLib_uint64_t unsigned long long
#endif

#define PowerKL30   (( PwrLib_uint8_t )(0x00u))
#define PowerWAKEUP (( PwrLib_uint8_t )(0x55u))

typedef enum
{
    EM_IGN_OFF_Init,
    EM_IGN_OFF,
    EM_IGN_Sleep_Init,
    EM_IGN_Sleep,
    EM_IGN_Wakeup,
    EM_IGN_ON_Init,
    EM_IGN_ON,
    EM_IGN_LVP_Init,
    EM_IGN_OVP_Init,
    EM_IGN_LIMIT,
} Power_Status_em;

typedef void (*pfunPower_IG_OFF_Init)(void);
typedef void (*pfunPower_IG_ON_Init)(void);
typedef void (*pfunPower_Sleep_Init)(void);
typedef void (*pfunPower_IG_LVP_Init)(void);
typedef void (*pfunPower_IG_OVP_Init)(void);
typedef void (*pfunPower_KL30_Init)(void);
typedef void (*pfunPower_Wakeup_Init)(void);

typedef Power_Status_em (*pfunc_Power_OFF)(void);
typedef Power_Status_em (*pfunc_Power_ON)(void);
typedef Power_Status_em (*pfunc_Power_SLEEP)(void);
typedef Power_Status_em (*pfunc_Power_LIM)(void);

typedef struct
{
    pfunPower_KL30_Init   Pwr_KL30_Init;
    pfunPower_IG_OFF_Init Pwr_IG_OFF_Init;
    pfunc_Power_OFF       Pwr_Stay_OFF;
    pfunPower_Sleep_Init  Pwr_Sleep_Init;
    pfunc_Power_SLEEP     Pwr_Stay_Sleep;
    pfunPower_Wakeup_Init Pwr_Wakeup_Init;
    pfunPower_IG_ON_Init  Pwr_IG_ON_Init;
    pfunc_Power_ON        Pwr_Stay_ON;
    pfunPower_IG_LVP_Init Pwr_IG_LVP_Init;
    pfunPower_IG_OVP_Init Pwr_IG_OVP_Init;
    pfunc_Power_LIM       Pwr_Stay_Protect;
} st_PowerGroup;

extern void PowerMemInit(const st_PowerGroup *PowerGroup);
extern void Power_Management_Init(PwrLib_uint8_t u8InitFlag);
extern void Power_Management_Service(void);
PwrLib_uint32_t Get_Sleep_Count(void);

extern PwrLib_uint16_t Get_PwrLibVersion(void);
#endif
