#include "RTE_Memory.h"
#include "Internal_EEPROM.h"
#include "r_fdl_types.h"

extern r_fdl_status_t FDL_ReadDataBlock(uint32_t id,uint32_t* data, uint16_t len);
extern r_fdl_status_t FDL_WriteDataBlock(uint32_t id,uint32_t* data, uint16_t len);
uint8_t DFlash_ReadData(uint32_t Adrr, uint32_t *Data, uint16_t len, uint8_t ReadType)
{
    uint8_t enResult = 0u;
    if(ReadType == 0xEE)
    {
        enResult = (uint8_t)Internal_EEL_Read(Adrr, (uint8_t *)Data, len);
    }
    else if(ReadType == 0xFD)
    {
        enResult = (uint8_t)FDL_ReadDataBlock(Adrr, Data, len/4);
    }
    else
    {

    }
    return enResult;
}

uint8_t DFlash_WriteData(uint32_t Adrr, uint32_t *Data, uint16_t len, uint8_t WriteType)
{
    uint8_t enResult = 0u;
    if(WriteType == 0xEE)
    {
        enResult = Internal_EEL_Write(Adrr, (uint8_t *)Data, len);
    }
    else if(WriteType == 0xFD)
    {
        enResult = FDL_WriteDataBlock(Adrr, Data, len/4);
    }
    else
    {
        
    }
    return enResult;
}
