
#include "Services_Mileage_User.h"
#include "Services_Mileage.h"
#include "Common_Interface.h"
#include "eepromManage.h"
#include "key.h"
#include "Display.h"
#include <string.h>
#include "UDS_2EService_Main.h"
#include "NVM.h"
#include "DisplaySch.h"
#include "Data_Time.h"

#pragma ghs section bss = ".myNonInitArea"

#pragma alignvar(8)
uint8_t DataMilleageBuf [ Data_MEM_Block_Mileage ];
#pragma alignvar(8)
uint8_t DataODOBuf [ Data_MEM_Block_ODO ];
#pragma alignvar(8)
uint8_t DataTripBuf [ Data_MEM_Block_Trip * EM_TRIP_MAX ];
#pragma alignvar(8)
Mileage_t g_WriteMileage;
#pragma alignvar(8)
Mileage_t           g_ReadMileage;
#pragma ghs section bss = default
uint8_t             odo_writeState;
uint8_t             odo_readState;
static uint8_t      DataMileageConfirmKey = 0u;
static uint8_t      DataMileageChangAnKey = 0u;
static void         Data_User_EEPROM_Write(Data_EEPROM_Enum_t BlockID, uint32_t u32Data [], uint16_t u16Len);


uint32_t Milleage_InitFlag = 0U;
uint32_t RiskStop_Flag = 0u;

uint8_t ChangAn_ODOClear_Sts;
uint8_t ChangAn_ODOClear_Timer;
uint8_t ChangAn_ODOClear;
static uint32_t Display_Data_ODO = 0;

/******************************************************************************
  Function：Data_ODO_KL30Init
  Description：
  Input:
  Output:
 ******************************************************************************/
void Data_User_Mileage_KL30Init(void)
{
    uint32_t       TempBuf [ 15 ]  = {0};
    Mileage_Init_t MileInit       = {0};
    Mileage_Func_t Func           = {0};
    ODO_Init_t     ODOInit        = {0};
    Trip_Init_t    TripInit [ 4 ] = {0};
    Milleage_InitFlag             = 0U;
    // �������ݴ�EEPROM�ж�ȡ
    ( void )Data_User_EEPROM_Read(EM_MILEAGE_BLOCK, TempBuf, 1);
    if ( TempBuf [ 0 ] == 0xFFFFFFFF )
    {
        MileInit.Mileage = 0u;
    }
    else
    {
        MileInit.Mileage = TempBuf [ 0 ];
    }
    Func.Get_Sys_IG_Sts        = Common_Get_IG_Sts;
    Func.Get_Act_V_Speed_Valid = Common_Get_Act_V_Speed_Valid;
    Func.Get_Act_V_Speed       = Common_Get_Act_V_Speed;
    Func.Get_TireSize          = ( void          *)0;
    Func.EEPromWrite_Cbk       = Data_User_EEPROM_Write;    // ��ʱδ����
    Data_Mileage_KL30_Init(DataMilleageBuf, &MileInit, &Func);

    ( void )Data_User_EEPROM_Read(EM_ODO_BLOCK, TempBuf + 1, 2);
    if ( TempBuf [ 1 ] == 0xFFFFFFFF )
    {
        ODOInit.Stamp = 0;
    }
    else
    {
        ODOInit.Stamp = TempBuf [ 1 ];
    }
    if ( TempBuf [ 1 ] == 0xFFFFFFFF )
    {
        ODOInit.Offset = 0;
    }
    else
    {
        ODOInit.Offset = TempBuf [ 2 ];
    }
    ODOInit.MaxValue = 9999999;
    Data_ODO_KL30_Init(DataODOBuf, &ODOInit, Func.EEPromWrite_Cbk);

    ( void )Data_User_EEPROM_Read(EM_TRIP_BLOCK, TempBuf + 3, 4);
    TripInit [ EM_TRIP_A ].Stamp     = 0xFFFFFFFFu;
    TripInit [ EM_TRIP_A ].MaxValue  = 99999;
    TripInit [ EM_TRIP_A ].IsRestart = 1u;

    TripInit [ EM_TRIP_B ].Stamp     = 0xFFFFFFFFu;
    TripInit [ EM_TRIP_B ].MaxValue  = 9999;
    TripInit [ EM_TRIP_B ].IsRestart = 1u;

    TripInit [ EM_TRIP_C ].Stamp     = 0xFFFFFFFFu;
    TripInit [ EM_TRIP_C ].MaxValue  = 99999;
    TripInit [ EM_TRIP_C ].IsRestart = 1u;

    TripInit [ EM_TRIP_D ].Stamp     = 0xFFFFFFFFu;
    TripInit [ EM_TRIP_D ].MaxValue  = 99999;
    TripInit [ EM_TRIP_D ].IsRestart = 1u;

    Data_Trip_KL30_Init(DataTripBuf, TripInit, EM_TRIP_MAX, Func.EEPromWrite_Cbk);

    Milleage_InitFlag = 0X5AA53AA3UL;
    RiskStop_Flag = 0;
    ChangAn_ODOClear_Sts = 0xAA;
    ChangAn_ODOClear_Timer = 0;
}

void Data_User_Mileage_WakeupInit(void)
{
    Mileage_Func_t Func = {0};
    Milleage_InitFlag   = 0U;

    Func.Get_Sys_IG_Sts        = Common_Get_IG_Sts;
    Func.Get_Act_V_Speed_Valid = Common_Get_Act_V_Speed_Valid;
    Func.Get_Act_V_Speed       = Common_Get_Act_V_Speed;
    Func.Get_TireSize          = ( void          *)0;
    Func.EEPromWrite_Cbk       = Data_User_EEPROM_Write;    // ��ʱδ����
    Data_Mileage_Wakeup_Init(DataMilleageBuf, &Func);

    Data_ODO_Wakeup_Init(DataODOBuf, Func.EEPromWrite_Cbk);

    Data_Trip_Wakeup_Init(DataTripBuf, EM_TRIP_MAX, Func.EEPromWrite_Cbk);
    Milleage_InitFlag = 0X5AA53AA3UL;
    RiskStop_Flag = 0;
}

/******************************************************************************
  Function：TYW_Data_ODO_Clear
  Description：天有为清总计里程策略
  Input:
  Output:
 ******************************************************************************/
void TYW_Data_ODO_Clear(void)
{
    uint16_t       VSpeed            = 0u;
    uint16_t       ESpeed            = 0u;
    static uint8_t DataODOClearTimer = 0u;

    if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        if ( DataMileageConfirmKey == KEY_EVENT_LONG_PRESS )
        {
            VSpeed = Common_Get_Act_V_Speed( );
            ESpeed = Common_Get_Act_E_Speed( );
            if ( (VSpeed >= 2400) && (ESpeed >= 8000) )
            {
                if ( DataODOClearTimer < 0xFFu )
                {
                    DataODOClearTimer++;
                }

                if ( DataODOClearTimer >= 50u )
                {
                    Data_Mileage_Clear( );
                    //EOL_InitVal( );
                    UDS_2E_CLEAR_0300( );
                    UDS_2E_CLEAR_0301( );
                    USER_Setting_Clear( );
                    Display_Factory_Ctrl( );
                    RiskStop_Flag = 0x7887A55A;
                    DataODOClearTimer     = 0u;
                    DataMileageConfirmKey = KEY_EVENT_NONE;
                }
            }
            else
            {
                DataMileageConfirmKey = KEY_EVENT_NONE;
                DataODOClearTimer     = 0u;
            }
        }
        else
        {
            DataODOClearTimer     = 0u;
            DataMileageConfirmKey = KEY_EVENT_NONE;
        }
    }
}


uint32_t Get_MileageInit_Status(void)
{
    return Milleage_InitFlag;
}

void Data_ODO_ChangAn_Clear(void)
{
    if(DataMileageChangAnKey == KEY_EVENT_LONG_PRESS)
    {
        if((ChangAn_ODOClear_Sts == 0xAAu) && (ChangAn_ODOClear != 0xCC) && (RiskStop_Flag == 0))
        {
            if(ChangAn_ODOClear_Timer > 200)
            {
                if((Data_ODO_Read() / 10) < 256u)
                {
                    ChangAn_ODOClear = 0xCC;
                    USER_Setting_UpDate();
                    Data_ODO_Clear();
                    Data_Clear_Trip(EM_TRIP_A);
                    DataMileageChangAnKey = 0;
                }
                else 
                {
                    ChangAn_ODOClear_Sts = 0u;
                    DataMileageChangAnKey = 0;
                }
            }
            else 
            {
                ChangAn_ODOClear_Timer ++;
            }
        }
        else 
        {
            ChangAn_ODOClear_Sts = 0;
            DataMileageChangAnKey = 0;
        }
    }
    else
    {
        if(Get_HMI_SelfCheck_Timer() > 3000u)
        {
            ChangAn_ODOClear_Sts = 0;
            DataMileageChangAnKey = 0;
        }
    }
}

uint8_t Get_ChangAn_ODOClear(void)
{
    return ChangAn_ODOClear;
}
void Set_ChangAn_ODOClear(uint8_t Flag)
{
    ChangAn_ODOClear = Flag;
}
void Data_ODO_Key_Set(uint8_t KeyVal)
{
    DataMileageConfirmKey = KeyVal;
    DataMileageChangAnKey = KeyVal;
}

static const uint32_t SperialODOTbl [ 27u ] = {
    1000,
    5000,
    6666,
    8888,
    10000,
    20000,
    30000,
    40000,
    50000,
    60000,
    66666,
    70000,
    80000,
    88888,
    90000,
    99999,
    100000,
    200000,
    300000,
    400000,
    500000,
    600000,
    666666,
    700000,
    800000,
    888888,
    999999,
};

uint32_t Get_Sperial_ODO(void)
{
    uint8_t  i;
    uint32_t SperailODO;
    Milleage_InitFlag = 0X5AA53AA3UL;
    SperailODO        = Data_ODO_Read( ) / 10;
    for ( i = 0; i < 27u; i++ )
    {
        if ( SperailODO < SperialODOTbl [ i ] )
        {
            break;
        }
    }

    if ( i == 0 )
    {
        return 0;
    }
    else
    {
        if ( SperailODO == SperialODOTbl [ i - 1 ] )
        {
            return SperailODO;
        }
        else
        {
            return 0;
        }
    }
}

/******************************************************************************
 Function：TYW_Data_ODO_Clear
 Description：固定距离固定次数 清总计里程
 Input:
 Output:
******************************************************************************/
void Data_ODO_Clear_Mileage_Num(void)
{
}

uint32_t Data_User_EEPROM_Read(uint16_t u16BlockID, uint32_t u32Data [], uint16_t u16Len)
{
    switch ( u16BlockID )
    {
        case EM_MILEAGE_BLOCK:
            odo_readState = eeprom_ReadODO(&g_ReadMileage);
            u32Data [ 0 ] = g_ReadMileage.Odo;
            // eeprom_ReadRecord(EEPROM_BLOCK_00, ( uint8_t * )u32Data, u16Len * 4);
            break;

        case EM_ODO_BLOCK:
            eeprom_ReadRecord(EEPROM_BLOCK_01, ( uint8_t * )u32Data, u16Len * 4);
            break;

        case EM_TRIP_BLOCK:
            eeprom_ReadRecord(EEPROM_BLOCK_03, ( uint8_t * )u32Data, u16Len * 4);
            break;
        case EM_Eng_Time_BLOCK:
            eeprom_ReadRecord(EEPROM_BLOCK_05, ( uint8_t * )u32Data, u16Len * 4);
            break;

        default:
            break;
    }

    return 0;
}

static void Data_User_EEPROM_Write(Data_EEPROM_Enum_t BlockID, uint32_t u32Data [], uint16_t u16Len)
{
    uint8_t i = 0u;
    
    switch ( BlockID )
    {
        case EM_MILEAGE_BLOCK:
            if ( u32Data [ 0 ] == 0 )
            {
                eeprom_ClearOdoSection( );
            }
            else
            {
               g_WriteMileage.Odo = u32Data [ 0 ];
                // g_WriteMileage.Trip = 0;
                g_WriteMileage.IsTripClear = 0;
                // g_WriteMileage.Trip = g_EngineRunMileage;
                odo_writeState = WRITE_FAIL;
                if(g_WriteMileage.Odo % 10 == 0)
                {
                    while(odo_writeState != WRITE_COMPLETE)
                    {
                        odo_writeState     = eeprom_WriteODO(&g_WriteMileage, distance_10m, 1);
                        i++;
                        if(i > 10)
                        {
                            break;
                        }
                    }
                }
            }
            // eeprom_WriteRecord(EEPROM_BLOCK_00, ( uint8_t * )u32Data, u16Len * 4);
            break;

        case EM_ODO_BLOCK:
            eeprom_WriteRecord(EEPROM_BLOCK_01, ( uint8_t * )u32Data, u16Len * 4);
            break;

        case EM_TRIP_BLOCK:
            eeprom_WriteRecord(EEPROM_BLOCK_03, ( uint8_t * )u32Data, u16Len * 4);
            break;
        // case EM_Eng_Time_BLOCK:
        //     eeprom_WriteRecord(EEPROM_BLOCK_05, ( uint8_t * )u32Data, u16Len * 4);
        //     break;

        default:
            break;
    }
}

void Services_Mileage_Callback(void)
{
    if ( Milleage_InitFlag == 0X5AA53AA3UL )
    {
        Data_Mileage_ISR( );
    }
}

uint32_t Get_Display_ODO_Read(void)
{
    Display_Data_ODO = Data_ODO_Read();
    return Display_Data_ODO;
}
