#ifndef __SERVICE_ODO_USER_H__
#define __SERVICE_ODO_USER_H__

#include "TYW_stdint.h"

//#define  ONLY_CLEAR_ODO_MIL    0x01u        /*仅根据距离信息进行ODO清除*/
//#define  ONLY_CLEAR_ODO_NUM    0x01u        /*仅根据次数信息进行ODO清除*/
#define CLEAR_ODO_NUM_MIL 0x01u /*以距离信息以及次数信息进行ODO清除*/

#define ODO_CLEAR_NUM 5u     /*清除次数上限值 */
#define ODO_CLEAR_MIL 50000u /*清除距离上限值 单位0.1KM*/

#define EEPROM_BLOCK_00 0
#define EEPROM_BLOCK_01 16
#define EEPROM_BLOCK_02 32
#define EEPROM_BLOCK_03 48
#define EEPROM_BLOCK_04 64
#define EEPROM_BLOCK_05 80
#define EEPROM_BLOCK_06 96
#define EEPROM_BLOCK_07 112
#define EEPROM_BLOCK_08 128
#define EEPROM_BLOCK_09 144
#define EEPROM_BLOCK_10 160
#define EEPROM_BLOCK_11 176

extern uint8_t ODO_Clear_Num_Value;

void Data_User_Mileage_KL30Init(void);
void Data_User_Mileage_WakeupInit(void);
void Services_Mileage_Callback(void);

void Data_ODO_Clear_KL30Init(void);
void Data_ODO_Clear_KL15Init(void);

void Data_ODO_Clear_Mileage_Num(void);
void TYW_Data_ODO_Clear(void);

void Data_ODO_Key_Set(uint8_t KeyVal);
uint32_t Get_MileageInit_Status(void);

uint32_t Get_Sperial_ODO(void);
void Data_ODO_ChangAn_Clear(void);
uint8_t Get_ChangAn_ODOClear(void);
void Set_ChangAn_ODOClear(uint8_t Flag);
uint32_t Get_Display_ODO_Read(void);
uint32_t     Data_User_EEPROM_Read(uint16_t u16BlockID, uint32_t u32Data [], uint16_t u16Len);
#endif
