/******************************************************************************
文 件 名：Simulated_IIC_Master.h
功能描述：IO端口模拟的IIC(I2C)主机函数库头文件
作    者：张暄
版    本：V1.0
日    期：2016.12.21
******************************************************************************/

#ifndef SIMULATED_IIC_2_MASTER_H__
#define SIMULATED_IIC_2_MASTER_H__

#include "RTE_GPIO.h"

/******************************************************************************
1us延时校准
******************************************************************************/
#define SIMULATED_IIC_2_FREQ_CALIBRATION 80U  /*可根据项目需要自行修改*/

/******************************************************************************
确认信号
******************************************************************************/
#define SIMULATED_IIC_2_ACK         0U    //肯定应答
#define SIMULATED_IIC_2_NAK         1U    //否定应答
#define SIMULATED_IIC_2_INVALID_ACK 2U    //无效的应答信号(应答信号还未收到)

/******************************************************************************
引脚定义
******************************************************************************/
/******************************************************************************
确认信号
******************************************************************************/
#define IIC_ACK              0 //肯定应答
#define IIC_NAK              1 //否定应答
#define IIC_INVALID_ACK      2 //无效的应答信号(应答信号还未收到)
/******************************************************************************
函数声明
******************************************************************************/
void    Simulated_IIC_2_Init(void);
void    Simulated_IIC_2_Start(void);
void    Simulated_IIC_2_Stop(void);
void    Simulated_IIC_2_Transmit_Data(uint8_t Data);
uint8_t Simulated_IIC_2_Receive_Data(void);
void    Simulated_IIC_2_Transmit_ACK(uint8_t ACK);
uint8_t Simulated_IIC_2_Receive_ACK(void);
void    Simulated_IIC_2_Delay(void);

void IIC_Start(uint8_t s);
void IIC_Stop(uint8_t s);
void IIC_Transmit_Data(uint8_t Data, uint8_t s);
uint8_t IIC_Receive_Data(uint8_t s);
void IIC_Transmit_ACK(uint8_t ACK, uint8_t s);
uint8_t IIC_Receive_ACK(uint8_t s);

/*void Simulated_IIC_2_Slave_Service(void);*/

#endif