
#include "Sound_List.h"
#include "Sound_Source.h"
#include "Sound_Player.h"
#include "Sound_Scheduler.h"

// clang-format off

/******************************************************************************************
声音属性列表
******************************************************************************************/
#pragma alignvar(8)
const SoundAttributeStruct SoundList [ SND_TOTAL_NUM ] =
{
    /*===========================================================================================
                 声音名称                   |              音源              |        模式
    -------------------------------------------------------------------------------------------*/
    { /* SND_TICK_LEFT          */ SND_SRC_TICK1_252729,                          SND_TYPE_NORMAL,    OP5,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x01U,0x02U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x01U,0x02U,0x01U,0x00U, },
    { /* SND_TOCK_LEFT          */ SND_SRC_TOCK1_262830,                          SND_TYPE_NORMAL,    OP5,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x01U,0x03U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x01U,0x02U,0x01U,0x00U, },
    { /* SND_TICK_RIGHT         */ SND_SRC_TICK1_252729,                          SND_TYPE_NORMAL,    OP5,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x01U,0x02U,0x01U,0x01U,0x03U,0x01U,0x01U,0x01U,0x02U,0x01U,0x02U,0x00U, },
    { /* SND_TOCK_RIGHT         */ SND_SRC_TOCK1_262830,                          SND_TYPE_NORMAL,    OP5,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x01U,0x03U,0x01U,0x01U,0x03U,0x01U,0x01U,0x01U,0x02U,0x01U,0x02U,0x00U, },
    { /* SND_TICK_ALL           */ SND_SRC_TICK1_252729,                          SND_TYPE_NORMAL,    OP5,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x01U,0x02U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },
    { /* SND_TOCK_ALL           */ SND_SRC_TOCK1_262830,                          SND_TYPE_NORMAL,    OP5,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x01U,0x03U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },
    { /* SND_RADAR_F_Continuous */ SND_SRC_RADAR_FRONT_409ms_41,                  SND_TYPE_RADAR,     OP2,    SND_CYCLE_NONSTOP,    SND_MODE_LOOP, POWER_ALL, {     0UL,       0UL,      0UL },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },
    { /* SND_RADAR_R_Continuous */ SND_SRC_RADAR_REAR_413ms_43,                   SND_TYPE_RADAR,     OP2,    SND_CYCLE_NONSTOP,    SND_MODE_LOOP, POWER_ALL, {     0UL,       0UL,      0UL },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },
    { /* SND_RADAR_F_1          */ SND_SRC_RADAR_FRONT_140ms_42,                  SND_TYPE_RADAR,     OP2,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ALL, {   220UL,     220UL,    220UL },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },
    { /* SND_RADAR_F_2          */ SND_SRC_RADAR_FRONT_140ms_42,                  SND_TYPE_RADAR,     OP2,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ALL, {   450UL,     450UL,    450UL },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },
    { /* SND_RADAR_F_3          */ SND_SRC_RADAR_FRONT_409ms_41,                  SND_TYPE_RADAR,     OP2,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ALL, {  2500ul,    2500ul,   2500ul },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },
    { /* SND_RADAR_R_1          */ SND_SRC_RADAR_REAR_140ms_44,                   SND_TYPE_RADAR,     OP2,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ALL, {   220UL,     220UL,    220UL },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },
    { /* SND_RADAR_R_2          */ SND_SRC_RADAR_REAR_140ms_44,                   SND_TYPE_RADAR,     OP2,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ALL, {   450UL,     450UL,    450UL },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },
    { /* SND_RADAR_R_3          */ SND_SRC_RADAR_REAR_413ms_43,                   SND_TYPE_RADAR,     OP2,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ALL, {  2500ul,    2500ul,   2500ul },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },
    { /* SND_RADAR_F_R          */ SND_SRC_RADAR_REAR_140ms_44,                   SND_TYPE_RADAR,     OP2,                   1U,  SND_MODE_SINGLE, POWER_ALL, {   450UL,     450UL,    450UL },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },
    { /* SND_RADAR_ERROR        */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,     W2,                   3U,  SND_MODE_SINGLE, POWER_ALL, {   600UL,     600UL,    600UL },  0x02U,0x01U,0x01U,0x01U,0x05U,0x0EU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },
    { /* SND_RADAR_ERROR_02     */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,     W2,    SND_CYCLE_NONSTOP,  SND_MODE_SINGLE, POWER_ALL, {   600UL,     600UL,    600UL },  0x02U,0x01U,0x01U,0x01U,0x02U,0x0EU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },
    { /* SND_RADAR_OK           */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     W2,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },
    { /* SND_SetVolumnTest      */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,     200UL,    400UL },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },
    { /* SND_New_ID_0           */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   3U,  SND_MODE_SINGLE, POWER_ON,  {   600UL,     600UL,    600UL },  0x02U,0x01U,0x01U,0x01U,0x05U,0x01U,0x08U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 手动限速功能故障提示 */
    { /* SND_New_ID_1           */ SND_SRC_OVERSPEED_400ms_31,                    SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {   600UL,     600UL,    600UL },  0x11U,0x01U,0x01U,0x01U,0x03U,0x01U,0x08U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 手动限速超速提示 */
    { /* SND_New_ID_2           */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,     W2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 变速器油温高声音报警 */
    { /* SND_New_ID_3           */ SND_SRC_Seatbelt_789,                          SND_TYPE_NORMAL,    OP2,                   6U,  SND_MODE_SINGLE, POWER_ON,  {   400UL,     300UL,    200UL },  0x01U,0x01U,0x02U,0x01U,0x08U,0x01U,0x08U,0x02U,0x01U,0x01U,0x01U,0x00U, },              /* 主驾安全带未系声音提示 */
    { /* SND_New_ID_4           */ SND_SRC_Seatbelt_789,                          SND_TYPE_NORMAL,    OP2,                   6U,  SND_MODE_SINGLE, POWER_ON,  {   400UL,     300UL,    200UL },  0x01U,0x01U,0x02U,0x01U,0x08U,0x01U,0x08U,0x01U,0x02U,0x01U,0x01U,0x00U, },              /* 副驾安全带未系声音提示 */
    { /* SND_New_ID_5           */ SND_SRC_Seatbelt_789,                          SND_TYPE_NORMAL,    OP2,                   6U,  SND_MODE_SINGLE, POWER_ON,  {   400UL,     300UL,    200UL },  0x01U,0x01U,0x02U,0x01U,0x08U,0x01U,0x08U,0x01U,0x01U,0x02U,0x02U,0x00U, },              /* 后排安全带未系声音提示 */
    { /* SND_New_ID_6           */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 蓄电池电量低，请启动发动机 */
    { /* SND_New_ID_7           */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 电量消耗过多，请启动发动机 */
    { /* SND_New_ID_8           */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_OFF, {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 切换到P档声音提示 */
    { /* SND_New_ID_9           */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP2,                   5U,  SND_MODE_SINGLE, POWER_ALL, {  1000UL,    1000UL,   1000UL },  0x01U,0x01U,0x01U,0x02U,0x07U,0x16U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 车辆未下电提示 */
    { /* SND_New_ID_10          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP2,                   2U,  SND_MODE_SINGLE, POWER_ALL, {   500UL,     500UL,    500UL },  0x13U,0x01U,0x01U,0x01U,0x04U,0x0CU,0x01U,0x02U,0x01U,0x01U,0x01U,0x00U, },              /* 左前车门未关声音报警 */
    { /* SND_New_ID_11          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP2,                   2U,  SND_MODE_SINGLE, POWER_ALL, {   500UL,     500UL,    500UL },  0x13U,0x01U,0x01U,0x01U,0x04U,0x0CU,0x01U,0x01U,0x02U,0x01U,0x01U,0x00U, },              /* 右前车门未关声音报警 */
    { /* SND_New_ID_12          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP2,                   2U,  SND_MODE_SINGLE, POWER_ALL, {   500UL,     500UL,    500UL },  0x13U,0x01U,0x01U,0x01U,0x04U,0x0CU,0x01U,0x01U,0x01U,0x02U,0x01U,0x00U, },              /* 左后车门未关声音报警 */
    { /* SND_New_ID_13          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP2,                   2U,  SND_MODE_SINGLE, POWER_ALL, {   500UL,     500UL,    500UL },  0x13U,0x01U,0x01U,0x01U,0x04U,0x0CU,0x01U,0x01U,0x01U,0x01U,0x02U,0x00U, },              /* 右后车门未关声音报警 */
    { /* SND_New_ID_14          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP2,                   3U,  SND_MODE_SINGLE, POWER_OFF, {   500UL,     500UL,    500UL },  0x05U,0x01U,0x01U,0x01U,0x05U,0x0CU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 门未关闭锁声音报警 */
    { /* SND_New_ID_15          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP2,                   3U,  SND_MODE_SINGLE, POWER_ALL, {   500UL,     500UL,    500UL },  0x05U,0x01U,0x01U,0x01U,0x05U,0x0CU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 未检测到钥匙声音提示 */
    { /* SND_New_ID_16          */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   3U,  SND_MODE_SINGLE, POWER_ALL, {   500UL,     500UL,    500UL },  0x02U,0x01U,0x01U,0x01U,0x05U,0x0CU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 请将钥匙放置在备用启动区域提示 */
    { /* SND_New_ID_17          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP2,                   9U,  SND_MODE_SINGLE, POWER_ALL, {   500UL,     500UL,    500UL },  0x05U,0x01U,0x01U,0x01U,0x0BU,0x0CU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 钥匙电量低声音提示 */
    { /* SND_New_ID_18          */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   3U,  SND_MODE_SINGLE, POWER_OFF, {   500UL,     500UL,    500UL },  0x02U,0x01U,0x01U,0x01U,0x05U,0x0CU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 钥匙在车内闭锁声音报警 */
    { /* SND_New_ID_19          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     D1,                   1U,  SND_MODE_SINGLE, POWER_OFF, {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 驾驶员门解锁模式设置为取消 */
    { /* SND_New_ID_20          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     D1,                   1U,  SND_MODE_SINGLE, POWER_OFF, {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 驾驶员门解锁模式设置为激活 */
    { /* SND_New_ID_21          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     D1,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 钥匙学习成功提示 */
    { /* SND_New_ID_22          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     D1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 速度落锁设置为取消 */
    { /* SND_New_ID_23          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 此蓝牙钥匙无启动权限 */
    { /* SND_New_ID_24          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 请通过手机APP重新连接蓝牙钥匙 */
    { /* SND_New_ID_25          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     D1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 速度落锁设置为激活 */
    { /* SND_New_ID_26          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 后背门无法打开提示 */
    { /* SND_New_ID_27          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP4,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_OFF, {   500UL,     500UL,    500UL },  0x05U,0x01U,0x01U,0x01U,0x02U,0x0CU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 天窗未关声音提示 */
    { /* SND_New_ID_28          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     D2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 座椅记忆设置成功提示 */
    { /* SND_New_ID_29          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     D2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 请在3秒内按下记忆按键1或2或3 */
    { /* SND_New_ID_30          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP2,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 车速过高，泊车退出 */
    { /* SND_New_ID_31          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 找到车位，请停车 */
    { /* SND_New_ID_32          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 已踩油门，泊车中断 */
    { /* SND_New_ID_33          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 换挡被干预，泊车中断 */
    { /* SND_New_ID_34          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 泊车中打开车门 */
    { /* SND_New_ID_35          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 手刹被拉起，泊车中断 */
    { /* SND_New_ID_36          */ SND_SRC_ParkFinish_1500ms_6,                   SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {  1500UL,    1500UL,   1500UL },  0x01U,0x01U,0x01U,0x03U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 泊车完成 */
    { /* SND_New_ID_37          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 已踩油门，泊车中断 */
    { /* SND_New_ID_38          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 换挡被干预，泊车中断 */
    { /* SND_New_ID_39          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 车门未关,泊出已中断 */
    { /* SND_New_ID_40          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 手刹被拉起，泊车中断 */
    { /* SND_New_ID_41          */ SND_SRC_ParkFinish_1500ms_6,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x03U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 泊车完成，请接管车辆 */
    { /* SND_New_ID_42          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 前方空间不足，泊车系统退出 */
    { /* SND_New_ID_43          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 坡度过大，泊车系统退出 */
    { /* SND_New_ID_44          */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,     W1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 车辆未静止，系统无法退出 */
    { /* SND_New_ID_45          */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,     W1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 档位非P档，系统无法退出 */
    { /* SND_New_ID_46          */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,     W1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 电子手刹未夹紧，系统无法退出 */
    { /* SND_New_ID_47          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 移动障碍物侵入，泊车退出 */
    { /* SND_New_ID_48          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 泊车退出 */
    { /* SND_New_ID_49          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x01U,0x01U,0x01U,0x02U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 请关闭车门 */
    { /* SND_New_ID_52          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 非法干预，泊车结束 */
    { /* SND_New_ID_53          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 网络延时，泊车结束 */
    { /* SND_New_ID_54          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 已踩油门，泊车中断 */
    { /* SND_New_ID_55          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 换挡被干预，泊车中断 */
    { /* SND_New_ID_56          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 泊车中打开车门 */
    { /* SND_New_ID_57          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 手刹被拉起，泊车中断 */
    { /* SND_New_ID_58          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 请将挡位拨为自动模式 */
    { /* SND_New_ID_59          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 请关闭自适应巡航系统 */
    { /* SND_New_ID_60          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 请按泊车按钮恢复 */
    { /* SND_New_ID_61          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 手机遥控泊车暂停 */
    { /* SND_New_ID_62          */ SND_SRC_ParkFinish_1500ms_6,                   SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x03U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 手机遥控泊车完成 */
    { /* SND_New_ID_63          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 手机遥控左转向中 */
    { /* SND_New_ID_64          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 手机遥控右转向中 */
    { /* SND_New_ID_65          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 手机泊车结束 */
    { /* SND_New_ID_66          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 坡度过大，泊车系统退出 */
    { /* SND_New_ID_67          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 前方空间不足，泊车系统退出 */
    { /* SND_New_ID_68          */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,     W1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 车辆未静止，系统无法退出 */
    { /* SND_New_ID_69          */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,     W1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 档位非P档，系统无法退出 */
    { /* SND_New_ID_70          */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,     W1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 电子手刹未夹紧，系统无法退出 */
    { /* SND_New_ID_71          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 移动障碍物侵入，泊车退出 */
    { /* SND_New_ID_72          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 泊车退出 */
    { /* SND_New_ID_73          */ SND_SRC_ParkFinish_1500ms_6,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x03U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 泊车结束 */
    { /* SND_New_ID_74          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 请求熄火，闭锁完成 */
    { /* SND_New_ID_75          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 请求熄火，闭锁失败 */
    { /* SND_New_ID_76          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 已踩油门，泊车中断 */
    { /* SND_New_ID_77          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 换挡被干预，泊车中断 */
    { /* SND_New_ID_78          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 车门未关,泊出已中断 */
    { /* SND_New_ID_79          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 手刹被拉起，泊车中断 */
    { /* SND_New_ID_80          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 泊出暂停 */
    { /* SND_New_ID_81          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 障碍物侵入，请确认清除后恢复泊车 */
    { /* SND_New_ID_82          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 蓝牙信号丢失，RPA暂停 */
    { /* SND_New_ID_83          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 泊车退出（由于心跳信号丢失） */
    { /* SND_New_ID_84          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 钥匙遥控泊车激活 */
    { /* SND_New_ID_85          */ SND_SRC_ParkFinish_1500ms_6,                   SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x03U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 钥匙遥控泊车完成 */
    { /* SND_New_ID_86          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 钥匙泊车结束 */
    { /* SND_New_ID_87          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 钥匙遥控前进中 */
    { /* SND_New_ID_88          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 钥匙遥控后退中 */
    { /* SND_New_ID_89          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 找到车位 */
    { /* SND_New_ID_90          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* ASP超过行驶距离退出 */
    { /* SND_New_ID_91          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 驾驶员干预退出 */
    { /* SND_New_ID_92          */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* ASP超时退出 */
    { /* SND_New_ID_93          */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* ASP找到车位 */
    { /* SND_New_ID_94          */ SND_SRC_LCDA_500ms_23,                         SND_TYPE_NORMAL,     W1,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x0FU,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x01U,0x02U,0x01U,0x00U, },              /* 左侧二级报警 */
    { /* SND_New_ID_95          */ SND_SRC_LCDA_500ms_23,                         SND_TYPE_NORMAL,     W1,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x0FU,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x01U,0x02U,0x01U,0x02U,0x00U, },              /* 右侧二级报警 */
    { /* SND_New_ID_96          */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车前探头故障，请检查维修 */
    { /* SND_New_ID_97          */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车前探头故障，请检查维修 */
    { /* SND_New_ID_98          */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 摄像头被遮挡，请检查维修 */
    { /* SND_New_ID_99          */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 摄像头故障，请检查维修 */
    { /* SND_New_ID_100         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 摄像头故障，请检查维修 */
    { /* SND_New_ID_101         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 摄像头故障，请检查维修 */
    { /* SND_New_ID_102         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 摄像头故障，请检查维修 */
    { /* SND_New_ID_103         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车故障，请检查维修 */
    { /* SND_New_ID_104         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车外部故障，请检查维修 */
    { /* SND_New_ID_105         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车外部故障，请检查维修 */
    { /* SND_New_ID_106         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车外部故障，请检查维修 */
    { /* SND_New_ID_107         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车外部故障，请检查维修 */
    { /* SND_New_ID_108         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车外部故障，请检查维修 */
    { /* SND_New_ID_109         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车外部故障，请检查维修 */
    { /* SND_New_ID_110         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车外部故障，请检查维修 */
    { /* SND_New_ID_111         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车外部故障，请检查维修 */
    { /* SND_New_ID_112         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车外部故障，请检查维修 */
    { /* SND_New_ID_113         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自动泊车外部故障，请检查维修 */
    { /* SND_New_ID_114         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* DVR不可用，泊车退出 */
    { /* SND_New_ID_115         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 低速自动紧急制动不可用，请检查维修 */
    { /* SND_New_ID_116         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 自搜索泊车不可用，请检查维修 */
    { /* SND_New_ID_117         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 侧视辅助不可用，请检查维修 */
    { /* SND_New_ID_118         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 倒挡提示音 */
    { /* SND_New_ID_119         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,     W2,                   3U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x05U,0x0EU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 普通倒车雷达-倒车雷达自检有故障提示 */
    { /* SND_New_ID_120         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     D2,                   1U,  SND_MODE_SINGLE, POWER_OFF, {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 跟随回家开启提示 */
    { /* SND_New_ID_125         */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_OFF, {   500UL,     500UL,    500UL },  0x05U,0x01U,0x01U,0x01U,0x02U,0x0CU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },                /* 灯未关提示 */
    { /* SND_New_ID_126         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 前位置灯故障状态 */
    { /* SND_New_ID_127         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 后位置灯故障状态 */
    { /* SND_New_ID_128         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 左位置灯故障状态 */
    { /* SND_New_ID_129         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 右位置灯故障状态 */
    { /* SND_New_ID_130         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 左近光灯故障状态 */
    { /* SND_New_ID_131         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 右近光灯故障状态 */
    { /* SND_New_ID_132         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 左前雾灯故障状态 */
    { /* SND_New_ID_133         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 右前雾灯故障状态 */
    { /* SND_New_ID_134         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 左后雾灯故障状态 */
    { /* SND_New_ID_135         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 右后雾灯故障状态 */
    { /* SND_New_ID_136         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 左转向灯故障状态 */
    { /* SND_New_ID_137         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 右转向灯故障状态 */
    { /* SND_New_ID_138         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 刹车灯故障状态 */
    { /* SND_New_ID_139         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 高位制动灯灯故障状态 */
    { /* SND_New_ID_140         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 倒车灯故障状态 */
    { /* SND_New_ID_141         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 左日间行车灯故障状态 */
    { /* SND_New_ID_142         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 右日间行车灯故障状态 */
    { /* SND_New_ID_143         */ SND_SRC_OVERSPEED_400ms_31,                    SND_TYPE_NORMAL,     W1,                  10U,  SND_MODE_SINGLE, POWER_ON,  {   600UL,     600UL,    600UL },  0x11U,0x01U,0x01U,0x01U,0x0CU,0x01U,0x08U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 120km/h超速报警声音提示 */
    { /* SND_New_ID_144         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 转向回正提示 */
    { /* SND_New_ID_145         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ALL, {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /*  */
    { /* SND_New_ID_146         */ SND_SRC_WelcomeGuests_383940,                  SND_TYPE_NORMAL,     W0,                   1U,  SND_MODE_SINGLE, POWER_OFF, {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x07U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 迎宾声音 */
    { /* SND_New_ID_147         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 燃油低提示 */
    { /* SND_New_ID_147_2       */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 燃油低提示 */
    { /* SND_New_ID_147_3       */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 燃油低提示 */
    { /* SND_New_ID_148         */ SND_SRC_KA_CHA_500ms_46,                       SND_TYPE_NORMAL,     D2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x09U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 截屏提示 */
    { /* SND_New_ID_149         */ SND_SRC_PowerON_323334,                        SND_TYPE_OPEN_CLOSE, W0,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x05U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 上电音 */
    { /* SND_New_ID_150         */ SND_SRC_PowerOFF_353637,                       SND_TYPE_OPEN_CLOSE, W0,                   1U,  SND_MODE_SINGLE, POWER_OFF, {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x06U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 下电音 */
    { /* SND_New_ID_151         */ SND_SRC_LOADHINT_600ms_45,                     SND_TYPE_NORMAL,    OP2,                   3U,  SND_MODE_SINGLE, POWER_ON,  {   400UL,     400UL,    400UL },  0x12U,0x01U,0x01U,0x01U,0x05U,0x0AU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 道路出口分心提醒 */
    { /* SND_New_ID_152         */ SND_SRC_LOADHINT_600ms_45,                     SND_TYPE_NORMAL,    OP2,                   3U,  SND_MODE_SINGLE, POWER_ON,  {   400UL,     400UL,    400UL },  0x12U,0x01U,0x01U,0x01U,0x05U,0x0AU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /*  */
    { /* SND_New_ID_153         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 弹射起步激活提示 */
    { /* SND_New_ID_154         */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   500UL,     500UL,    500UL },  0x05U,0x01U,0x01U,0x01U,0x02U,0x0CU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 系统故障提示 */
    { /* SND_New_ID_155         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     W2,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {  2000UL,    2200UL,   2400UL },  0x01U,0x01U,0x01U,0x02U,0x02U,0x01U,0x0BU,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 临时功率限制提示 */
    { /* SND_New_ID_156         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     D1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x01U,0x01U,0x01U,0x02U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* Ready提示 */
    { /* SND_New_ID_157         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 自适应巡航系统故障 */
    { /* SND_New_ID_158         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 功能暂不可用 */
    { /* SND_New_ID_159         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请先松手刹 */
    { /* SND_New_ID_160         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请先挂D档 */
    { /* SND_New_ID_161         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请先系安全带 */
    { /* SND_New_ID_162         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请先启动车辆 */
    { /* SND_New_ID_163         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请先开启ESC */
    { /* SND_New_ID_164         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请先关闭引擎盖 */
    { /* SND_New_ID_165         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请先减速到120km/h */
    { /* SND_New_ID_166         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 功能暂不可用动力系统不支持 */
    { /* SND_New_ID_167         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 功能暂不可用 */
    { /* SND_New_ID_168         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 雪地模式下，功能无法激活 */
    { /* SND_New_ID_169         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 赛道模式下，功能无法激活 */
    { /* SND_New_ID_170         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 车辆前方可通行，请起步 */
    { /* SND_New_ID_171         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请先关闭所有车门 */
    { /* SND_New_ID_172         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 您正在踩刹车，功能无法激活 */
    { /* SND_New_ID_173         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 自适应巡航系统故障 */
    { /* SND_New_ID_174         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 方向盘转向过大，功能无法激活 */
    { /* SND_New_ID_175         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 功能暂不可用 */
    { /* SND_New_ID_176         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 车道线不清晰，功能无法激活车道线不满足激活条件，功能无法激活 */
    { /* SND_New_ID_177         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请检查环视行车记录仪 */
    { /* SND_New_ID_178         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 智能驾驶辅助暂不可用 */
    { /* SND_New_ID_179         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请先减速到120km/h */
    { /* SND_New_ID_180         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 正在转动方向盘，功能无法激活 */
    { /* SND_New_ID_181         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 功能已禁用，请稍后再试 */
    { /* SND_New_ID_182         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 功能已禁用本次点火周期不可用 */
    { /* SND_New_ID_183         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请先关闭转向灯 */
    { /* SND_New_ID_184         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请手握方向盘，观察路况 */
    { /* SND_New_ID_185         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* L2级显示：请在车辆中心开启集成式自适应巡航L2.9及以上显示：请在车辆中心开启自动智能驾驶辅助 */
    { /* SND_New_ID_186         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 弯道过大，功能无法激活 */
    { /* SND_New_ID_187         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 激活失败请保持在车道中行驶 */
    { /* SND_New_ID_188         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 疲劳驾驶，功能无法激活 */
    { /* SND_New_ID_189         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 天气条件差，功能无法激活 */
    { /* SND_New_ID_191         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管 */
    { /* SND_New_ID_192         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管正在停车 */
    { /* SND_New_ID_193         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管 */
    { /* SND_New_ID_194         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管正在停车 */
    { /* SND_New_ID_195         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管功能异常 */
    { /* SND_New_ID_196         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管正在停车 */
    { /* SND_New_ID_197         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管正在停车 */
    { /* SND_New_ID_198         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管系统故障 */
    { /* SND_New_ID_199         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管系统故障 */
    { /* SND_New_ID_200         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管胎压异常 */
    { /* SND_New_ID_201         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管胎压异常 */
    { /* SND_New_ID_202         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管前摄像头被遮挡 */
    { /* SND_New_ID_203         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管前摄像头被遮挡 */
    { /* SND_New_ID_204         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管雷达被遮挡 */
    { /* SND_New_ID_205         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管雷达被遮挡 */
    { /* SND_New_ID_206         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管 */
    { /* SND_New_ID_208         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管 */
    { /* SND_New_ID_209         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管功能异常 */
    { /* SND_New_ID_210         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管功能即将退出 */
    { /* SND_New_ID_211         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管车道线不清晰 */
    { /* SND_New_ID_212         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管车道线不清晰 */
    { /* SND_New_ID_213         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管前方有行人 */
    { /* SND_New_ID_214         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管前方有行人 */
    { /* SND_New_ID_215         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管前方有危险车辆 */
    { /* SND_New_ID_216         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管前方有危险车辆 */
    { /* SND_New_ID_217         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管天气条件较差 */
    { /* SND_New_ID_218         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管天气条件较差 */
    { /* SND_New_ID_219         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管前方施工区域 */
    { /* SND_New_ID_220         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管前方施工区域 */
    { /* SND_New_ID_221         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管道路太宽或太窄 */
    { /* SND_New_ID_222         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请立即接管道路太宽或太窄 */
    { /* SND_New_ID_223         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 自适应巡航已退出，请注意控制车速 */
    { /* SND_New_ID_224         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 自适应巡航已退出前雷达不可用 */
    { /* SND_New_ID_225         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 自适应巡航已退出前摄像头不可用 */
    { /* SND_New_ID_226         */ SND_SRC_IACC_Activation_Exit_800ms_15,         SND_TYPE_NORMAL,     D2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x07U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 集成式自适应巡航已退出 */
    { /* SND_New_ID_227         */ SND_SRC_IACC_Activation_Exit_800ms_15,         SND_TYPE_NORMAL,     D2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x07U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 集成式自适应巡航系统故障 */
    { /* SND_New_ID_228         */ SND_SRC_IACC_Activation_800ms_14,              SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x04U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请保持手握方向盘，观察路况 */
    { /* SND_New_ID_230         */ SND_SRC_IACC_Activation_Exit_800ms_15,         SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x07U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 集成式自适应巡航已退出请注意控制车辆 */
    { /* SND_New_ID_231         */ SND_SRC_IACC_Activation_Exit_800ms_15,         SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x07U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请注意控制方向盘 */
    { /* SND_New_ID_232         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请注意观察路况 */
    { /* SND_New_ID_233         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请注意控制方向盘 */
    { /* SND_New_ID_234         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请保持手握方向盘，观察路况 */
    { /* SND_New_ID_235         */ SND_SRC_IACC_TAKEOVER_400ms_16,                SND_TYPE_NORMAL,     W1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x08U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 前方下匝道，请恢复手动驾驶 */
    { /* SND_New_ID_236         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 环境限制，智能限速 */
    { /* SND_New_ID_237         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 经过隧道，车辆自动智能限速中 */
    { /* SND_New_ID_238         */ SND_SRC_IACC_TAKEOVER_400ms_16,                SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   600UL,     600UL,    600UL },  0x08U,0x01U,0x01U,0x01U,0x02U,0x0EU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 前方收费站，请恢复手动驾驶 */
    { /* SND_New_ID_239         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 车辆紧急制动，请注意 */
    { /* SND_New_ID_240         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 车辆自动智能限速中 */
    { /* SND_New_ID_241         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 按方向盘左侧      键将限速值设置为巡航车速 */
    { /* SND_New_ID_242         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请打开车灯 */
    { /* SND_New_ID_249         */ SND_SRC_IACC_TAKEOVER_400ms_16,                SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   600UL,     600UL,    600UL },  0x08U,0x01U,0x01U,0x01U,0x02U,0x0EU,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请轻转方向盘，注意观察路况 */
    { /* SND_New_ID_250         */ SND_SRC_IACC_TAKEOVER_800ms_17,                SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x09U,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请轻转方向盘，注意观察路况 */
    { /* SND_New_ID_251         */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,     D2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x05U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请注意控制车辆集成式自适应巡航临时退出 */
    { /* SND_New_ID_252         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 推荐您向左换道 */
    { /* SND_New_ID_253         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 推荐您向右换道 */
    { /* SND_New_ID_254         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 前方匝道，请提前换道 */
    { /* SND_New_ID_255         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 等待超时，换道终止 */
    { /* SND_New_ID_256         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请先提速到45km/h，再激活自动换道换道辅助 */
    { /* SND_New_ID_257         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 前方有车辆汇入，推荐换道行驶 */
    { /* SND_New_ID_258         */ SND_SRC_LCDA_666ms_24,                         SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x10U,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x01U,0x02U,0x01U,0x00U, },             /* 左侧下车有碰撞危险 */
    { /* SND_New_ID_259         */ SND_SRC_LCDA_666ms_24,                         SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_OFF, {   200UL,     200UL,    200UL },  0x10U,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x01U,0x02U,0x01U,0x00U, },             /* 左侧下车有碰撞危险 */
    { /* SND_New_ID_260         */ SND_SRC_LCDA_666ms_24,                         SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x10U,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x01U,0x02U,0x01U,0x02U,0x00U, },             /* 右侧下车有碰撞危险 */
    { /* SND_New_ID_261         */ SND_SRC_LCDA_666ms_24,                         SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_OFF, {   200UL,     200UL,    200UL },  0x10U,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x01U,0x02U,0x01U,0x02U,0x00U, },             /* 右侧下车有碰撞危险 */
    { /* SND_New_ID_262         */ SND_SRC_LCDA_666ms_24,                         SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ALL, {   200UL,     200UL,    200UL },  0x10U,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 下车有碰撞危险 */
    { /* SND_New_ID_263         */ SND_SRC_LCDA_666ms_24,                         SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ALL, {   200UL,     200UL,    200UL },  0x10U,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 下车有碰撞危险 */
    { /* SND_New_ID_264         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,    OP1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x08U,0x01U,0x02U,0x01U,0x02U,0x01U,0x00U, },             /* 请注意后方车辆 */
    { /* SND_New_ID_265         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,    OP1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x08U,0x01U,0x01U,0x02U,0x01U,0x02U,0x00U, },             /* 请注意后方车辆 */
    { /* SND_New_ID_266         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x01U,0x01U,0x01U,0x01U,0x00U, },             /* 后方追尾危险 */
    { /* SND_New_ID_267         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 请保持安全车距 */
    { /* SND_New_ID_268         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     W1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 碰撞危险 */
    { /* SND_New_ID_269         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 碰撞危险 */
    { /* SND_New_ID_270         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 碰撞危险，自动紧急制动 */
    { /* SND_New_ID_271         */ SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,           SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x0BU,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 碰撞危险，自动紧急制动 */
    { /* SND_New_ID_272         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 自适应巡航系统通讯异常 */
    { /* SND_New_ID_273         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 集成式自适应巡航系统通讯异常 */
    { /* SND_New_ID_275         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 自动紧急制动系统不可用 */
    { /* SND_New_ID_276         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 自动紧急制动系统不可用 */
    { /* SND_New_ID_277         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 车道辅助系统故障 */
    { /* SND_New_ID_278         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 车道辅助系统通讯异常 */
    { /* SND_New_ID_279         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 后向辅助系统异常 */
    { /* SND_New_ID_280         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x01U,0x01U,0x02U,0x01U,0x00U, },             /* （左图标）后向辅助雷达遮挡 */
    { /* SND_New_ID_281         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x01U,0x01U,0x01U,0x02U,0x00U, },             /* （右图标）后向辅助雷达遮挡 */
    { /* SND_New_ID_282         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x01U,0x01U,0x02U,0x01U,0x00U, },             /* （左图标）后向辅助雷达故障 */
    { /* SND_New_ID_283         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x01U,0x01U,0x01U,0x02U,0x00U, },             /* （右图标）后向辅助雷达故障 */
    { /* SND_New_ID_284         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 前向毫米波雷达遮挡 */
    { /* SND_New_ID_285         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x01U,0x01U,0x01U,0x00U, },             /* （左图标）前向辅助雷达遮挡 */
    { /* SND_New_ID_286         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x01U,0x02U,0x01U,0x01U,0x00U, },             /* （右图标）前向辅助雷达遮挡 */
    { /* SND_New_ID_287         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x01U,0x01U,0x01U,0x00U, },             /* 前方横向碰撞辅助不可用 */
    { /* SND_New_ID_288         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x01U,0x02U,0x01U,0x01U,0x00U, },             /* 前方横向碰撞辅助不可用 */
    { /* SND_New_ID_289         */ SND_SRC_Error_Waring_400ms_0,                  SND_TYPE_NORMAL,    OP4,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x02U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 前置智能摄像头遮挡 */
    { /* SND_New_ID_290         */ SND_SRC_IACC_TAKEOVER_1100ms_48,               SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   250UL,     250UL,    250UL },  0x0AU,0x01U,0x01U,0x01U,0x02U,0x07U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 紧急车道保持工作中 */
    { /* SND_New_ID_291         */ SND_SRC_IACC_Activation_Fail_600ms_1,          SND_TYPE_NORMAL,    OP2,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x03U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 自动智能驾驶辅助需重新认证请检查维修 */
    { /* SND_New_ID_295         */ SND_SRC_LCDA_666ms_24,                         SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x10U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x02U,0x01U,0x02U,0x01U,0x00U, },             /* LCA/BSD左侧二级报警 注：不显示 */
    { /* SND_New_ID_296         */ SND_SRC_LCDA_666ms_24,                         SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x10U,0x01U,0x01U,0x01U,0x03U,0x01U,0x01U,0x01U,0x02U,0x01U,0x02U,0x00U, },             /* LCA/BSD右侧二级报警 注：不显示 */
    { /* SND_New_ID_297         */ SND_SRC_LCDA_1100ms_22,                        SND_TYPE_NORMAL,    OP1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   300UL,     300UL,    300UL },  0x0EU,0x01U,0x01U,0x01U,0x02U,0x08U,0x01U,0x02U,0x01U,0x02U,0x01U,0x00U, },             /* CTA左侧报警Level1 注：不显示 */
    { /* SND_New_ID_298         */ SND_SRC_LCDA_666ms_24,                         SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x10U,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x02U,0x01U,0x02U,0x01U,0x00U, },             /* CTA左侧报警Level3 注：不显示 */
    { /* SND_New_ID_299         */ SND_SRC_LCDA_1100ms_22,                        SND_TYPE_NORMAL,    OP1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   300UL,     300UL,    300UL },  0x0EU,0x01U,0x01U,0x01U,0x02U,0x08U,0x01U,0x01U,0x02U,0x01U,0x02U,0x00U, },             /* CTA右侧报警Level1 注：不显示 */
    { /* SND_New_ID_301         */ SND_SRC_LCDA_666ms_24,                         SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x10U,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x01U,0x02U,0x01U,0x02U,0x00U, },             /* CTA右侧报警Level3 注：不显示 */
    { /* SND_New_ID_301_1       */ SND_SRC_LCDA_666ms_24,                         SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x10U,0x01U,0x01U,0x01U,0x02U,0x06U,0x01U,0x01U,0x02U,0x01U,0x02U,0x00U, },             /* CTA右侧报警Level3 注：不显示 */
    { /* SND_New_ID_302         */ SND_SRC_LDW_600ms_47,                          SND_TYPE_NORMAL,    OP1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   400UL,     400UL,    400UL },  0x06U,0x01U,0x01U,0x01U,0x02U,0x0AU,0x01U,0x02U,0x01U,0x02U,0x01U,0x00U, },             /* LDW激活-左侧偏离声音+图像报警 注：不显示 */
    { /* SND_New_ID_303         */ SND_SRC_LDW_600ms_47,                          SND_TYPE_NORMAL,    OP1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   400UL,     400UL,    400UL },  0x06U,0x01U,0x01U,0x01U,0x02U,0x0AU,0x01U,0x01U,0x02U,0x01U,0x02U,0x00U, },             /* LDW激活-右侧偏离声音+图像报警 注：不显示 */
    { /* SND_New_ID_304         */ SND_SRC_OVERSPEED_400ms_31,                    SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x11U,0x01U,0x01U,0x01U,0x03U,0x01U,0x08U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 超速提醒(注：不显示) */
    { /* SND_New_ID_305         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* NDA已退出 */
    { /* SND_New_ID_306         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* NDA已启动 */
    { /* SND_New_ID_307         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,    OP3,    SND_CYCLE_NONSTOP,  SND_MODE_LOOP  , POWER_ON,  {     0UL,       0UL,      0UL },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },             /* 工厂检测预览音 */
    { /* SND_New_ID_308         */ SND_SRC_Seatbelt_789,                          SND_TYPE_NORMAL,    OP3,    SND_CYCLE_NONSTOP,  SND_MODE_LOOP  , POWER_ON,  {     0UL,       0UL,      0UL },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },             /* 工厂检测预览音 */
    { /* SND_New_ID_309         */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP3,    SND_CYCLE_NONSTOP,  SND_MODE_LOOP  , POWER_ON,  {     0UL,       0UL,      0UL },  0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U,0x00U, },             /* 工厂检测预览音 */
    { /* SND_New_ID_310         */ SND_SRC_InforWarning_234,                      SND_TYPE_NORMAL,     W1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {     0UL,       0UL,      0UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },             /* 碰撞危险 */
    { /* SND_New_ID_311         */ SND_SRC_LDW_600ms_47,                          SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   400UL,     400UL,    400UL },  0x06U,0x01U,0x01U,0x01U,0x02U,0x0AU,0x01U,0x02U,0x01U,0x02U,0x01U,0x00U, },             /* 碰撞危险 */
    { /* SND_New_ID_312         */ SND_SRC_LDW_600ms_47,                          SND_TYPE_NORMAL,     W1,         0XFFFFFFF0UL,  SND_MODE_SINGLE, POWER_ON,  {   400UL,     400UL,    400UL },  0x06U,0x01U,0x01U,0x01U,0x02U,0x0AU,0x01U,0x01U,0x02U,0x01U,0x02U,0x00U, },             /* 碰撞危险 */
    { /* SND_New_ID_58_1        */ SND_SRC_LightWarning_101112,                   SND_TYPE_NORMAL,    OP1,                   2U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x05U,0x01U,0x01U,0x01U,0x04U,0x06U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, },              /* 请将挡位拨为自动模式 */


    { /* SND_New_ID_313        */ SND_SRC_InforWarning_234,                       SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, }, /* 泊车退出-近程代客泊车不支持 */
    { /* SND_New_ID_314        */ SND_SRC_InforWarning_234,                       SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, }, /* 泊车退出-近程代客泊车失败 */
    { /* SND_New_ID_315        */ SND_SRC_ParkFinish_1500ms_6,                    SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x01U,0x01U,0x01U,0x03U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, }, /* 近程代客泊车成功-手机 */
    { /* SND_New_ID_316        */ SND_SRC_ParkFinish_1500ms_6,                    SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x01U,0x01U,0x01U,0x03U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, }, /* 近程代客泊车成功-钥匙 */
    { /* SND_New_ID_317        */ SND_SRC_InforWarning_234,                       SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, }, /* 近程代客泊车不支持 */
    { /* SND_New_ID_318        */ SND_SRC_InforWarning_234,                       SND_TYPE_NORMAL,    OP1,                   1U,  SND_MODE_SINGLE, POWER_ON,  {   200UL,     200UL,    200UL },  0x01U,0x01U,0x01U,0x02U,0x03U,0x01U,0x01U,0x02U,0x02U,0x02U,0x02U,0x00U, }, /* 近程代客泊车失败 */




    /*========================================================================================*/
};
/**********************************************************************************************************
 音源属性表     12-1  是11-3 SND_SRC_IACC_TAKEOVER_1100ms_18  12-2 是12 SND_SRC_IACC_TAKEOVER_NOW2_720ms_19
**********************************************************************************************************/
#pragma alignvar(8)
const SndAttributeStruct SndAttributeTable [ SND_SRC_TOTAL_NUM ] =
{
    /*======================================================================================================
    音源名称                                      | 音源序号 |               | 周期(ms)                          |音量
    ------------------------------------------------------------------------------------------------------*/
    {/* SND_SRC_Error_Waring_400ms_0         */ {   0U,    0U,    0U},     {  410UL,    410UL,    410UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_IACC_Activation_Fail_600ms_1 */ {   1U,    1U,    1U},     {  610UL,    610UL,    610UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_InforWarning_234             */ {   2U,    3U,    4U},     { 1010UL,    810UL,    610UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_TouchInfo_20ms_5             */ {   5U,    5U,    5U},     {   30UL,     30UL,     30UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_ParkFinish_1500ms_6          */ {   6U,    6U,    6U},     { 1510UL,   1510UL,   1510UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_Seatbelt_789                 */ {   7U,    8U,    9U},     {  610UL,    710UL,    810UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_LightWarning_101112          */ {  10U,   11U,   12U},     {  510UL,    410UL,   1210UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_LDW_600ms_13                 */ {  13U,   13U,   13U},     {  610UL,    610UL,    610UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_IACC_Activation_800ms_14     */ {  14U,   14U,   14U},     {  810UL,    810UL,    810UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_IACC_Activation_Exit_800ms_15*/ {  15U,   15U,   15U},     {  810UL,    810UL,    810UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_IACC_TAKEOVER_400ms_16       */ {  16U,   16U,   16U},     {  410UL,    410UL,    410UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_IACC_TAKEOVER_800ms_17       */ {  17U,   17U,   17U},     {  810UL,    810UL,    810UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_IACC_TAKEOVER_1100ms_18      */ {  18U,   18U,   18U},     { 1110UL,   1110UL,   1110UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_IACC_TAKEOVER_NOW_720ms_19   */ {  18U,   18U,   18U},     {  850UL,    850UL,    850UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_IACC_TAKEOVER_NOW2_720ms_19  */ {  19U,   19U,   19U},     {  730UL,    730UL,    730UL }, {   40U,   35U,   30U},},
    {/* SND_SRC_IACC_FCW_200ms_20            */ {  20U,   20U,   20U},     {  210UL,    210UL,    210UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_IACC_FCW_750ms_21            */ {  21U,   21U,   21U},     {  760UL,    760UL,    760UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_LCDA_1100ms_22               */ {  22U,   22U,   22U},     { 1010UL,   1010UL,   1010UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_LCDA_500ms_23                */ {  23U,   23U,   23U},     {  510UL,    510UL,    510UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_LCDA_666ms_24                */ {  24U,   24U,   24U},     {  676UL,    676UL,    676UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_TICK1_252729                 */ {  25U,   27U,   29U},     {  200UL,     40UL,     40UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_TOCK1_282930                 */ {  26U,   28U,   30U},     {  200UL,     40UL,     40UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_OVERSPEED_400ms_31           */ {  31U,   31U,   31U},     {  400UL,    400UL,    400UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_PowerON_323334               */ {  32U,   33U,   34U},     { 3010UL,   3510UL,   3210UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_PowerOFF_353637              */ {  35U,   36U,   37U},     { 2800UL,   2600UL,   2900UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_WelcomeGuests                */ {  38U,   39U,   40U},     { 6510UL,   3510UL,   4310UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_RADAR_FRONT_409ms_41         */ {  41U,   41U,   41U},     { 409UL,     409UL,    409UL }, {   70U,   65U,   60U},},
    {/* SND_SRC_RADAR_FRONT_140ms_42         */ {  42U,   42U,   42U},     { 140UL,     140UL,    140UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_RADAR_REAR_413ms_43          */ {  43U,   43U,   43U},     { 413UL,     413UL,    413UL }, {   70U,   65U,   60U},},
    {/* SND_SRC_RADAR_REAR_140ms_44          */ {  44U,   44U,   44U},     { 140UL,     140UL,    140UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_LOADHINT_600ms_45            */ {  45U,   45U,   45U},     {  610UL,    610UL,    610UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_KA_CHA_500ms_46              */ {  46U,   46U,   46U},     {  510UL,    510UL,    510UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_LDW_600ms_47                 */ {  47U,   47U,   47U},     {  610UL,    610UL,    610UL }, {   70U,   60U,   50U},},
    {/* SND_SRC_IACC_TAKEOVER_1100ms_48      */ {  48U,   48U,   48U},     { 1110UL,   1110UL,   1110UL }, {   65U,   55U,   40U},},
    {/* SND_SRC_IACC_TAKEOVER_NOW2_720ms_49  */ {  49U,   49U,   49U},     {  730UL,    730UL,    730UL }, {   70U,   60U,   50U},},
    /*======================================================================================================*/
};
// clang-format on

uint8_t               SoundEnableCode [ SND_TOTAL_NUM ];
SoundSchedulingStruct SoundScheduling;

void Sound_Scheduler_Init(void)
{
    uint32_t i;

    for ( i = 0u; i < SND_TOTAL_NUM; i++ )
    {
        SoundEnableCode [ i ] = 0u;
    }

    Sound_Clear( );
    SoundScheduling.Current = SND_NONE;
    SoundScheduling.Next    = SND_NONE;
    SoundScheduling.ReqCode = 0u;
    SoundScheduling.StopReq = 0u;
}

void Sound_Request(uint32_t Sound, uint8_t ReqCode)
{
    uint32_t PriorityRef = 0U;
    uint32_t PriorityNew = 0U;

    if ( (Sound < SND_TOTAL_NUM) && (ReqCode) )
    {
        if ( (SoundEnableCode [ Sound ] != ReqCode) || (SoundList [ Sound ].Type != SND_TYPE_NORMAL) )
        {
            if ( SoundScheduling.Next < SND_TOTAL_NUM )
            {
                if ( Sound != SoundScheduling.Next )
                {
                    PriorityRef = SoundList [ SoundScheduling.Next ].Priority;
                    PriorityNew = SoundList [ Sound ].Priority;

                    if ( PriorityNew < PriorityRef )
                    {
                        SoundScheduling.Next    = Sound;
                        SoundScheduling.ReqCode = ReqCode;
                    }
                    else if ( PriorityNew == PriorityRef )
                    {
                        if ( SoundList [ Sound ].Type == SND_TYPE_RADAR )
                        {
                            SoundScheduling.Next    = Sound;
                            SoundScheduling.ReqCode = ReqCode;
                        }
                    }
                    else
                    {
                    }
                }
            }
            else
            {
                if ( Sound != SoundScheduling.Current )
                {
                    PriorityRef = Sound_Priority_Query(SND_SRC_CURRENT);
                    if ( PriorityRef == SND_SRC_NONE )
                    {
                        SoundScheduling.Current = SND_NONE;
                    }

                    PriorityNew = SoundList [ Sound ].Priority;

                    if ( PriorityNew < PriorityRef )
                    {
                        SoundScheduling.Next    = Sound;
                        SoundScheduling.ReqCode = ReqCode;
                        if ( SoundScheduling.Current < SND_TOTAL_NUM )
                        {
                            if ( SoundEnableCode [ SoundScheduling.Current ] > 0u )
                            {
                                SoundEnableCode [ SoundScheduling.Current ] = 0U;
                            }
                        }
                    }
                    else if ( PriorityNew == PriorityRef )
                    {
                        if ( SoundList [ Sound ].Type == SND_TYPE_RADAR )
                        {
                            SoundScheduling.Next    = Sound;
                            SoundScheduling.ReqCode = ReqCode;
                        }
                        else if ( SoundList [ Sound ].Type == SND_TYPE_OPEN_CLOSE )
                        {
                            SoundScheduling.Next    = Sound;
                            SoundScheduling.ReqCode = ReqCode;
                        }
                    }
                }
            }
        }
    }
}

void Sound_Delete(uint32_t Sound)
{
    if ( Sound < SND_TOTAL_NUM )
    {
        // if (SoundEnableCode[Sound])                      /*是已播放过的声音*/
        {
            if ( Sound == SoundScheduling.Current )
            {
                SoundScheduling.StopReq = 1u;
            }
            else
            {
                if ( Sound == SoundScheduling.Next )
                {
                    SoundScheduling.Next = SND_NONE;
                }

                SoundEnableCode [ Sound ] = 0u;
            }
        }
    }
}

/*50ms*/
void Sound_Scheduling_Service(void)
{

    if ( SoundScheduling.StopReq )
    {
        if ( SoundScheduling.Current < SND_TOTAL_NUM )
        {
            if ( Sound_Stop(SoundList [ SoundScheduling.Current ].Src) == 0u )
            {
                SoundScheduling.StopReq                     = 0u;
                SoundEnableCode [ SoundScheduling.Current ] = 0u;
                SoundScheduling.Current                     = SND_NONE;
            }
        }
    }

    if ( SoundScheduling.Current < SND_TOTAL_NUM )
    {
        if ( Sound_Priority_Query(SND_SRC_CURRENT) == SND_SRC_NONE )
        {
            SoundScheduling.Current = SND_NONE;
        }
    }

    if ( SoundScheduling.Next < SND_TOTAL_NUM )
    {
        if ( SoundScheduling.Current < SND_TOTAL_NUM )
        {
            ( void )Sound_Stop(SoundList [ SoundScheduling.Current ].Src);
        }

        if ( Sound_Play(SoundScheduling.Next) == 0u )
        {
            SoundEnableCode [ SoundScheduling.Next ] = SoundScheduling.ReqCode;
            SoundScheduling.Current                  = SoundScheduling.Next;
            SoundScheduling.Next                     = SND_NONE;
        }
    }
}

uint32_t Get_SoundScheduling_Current(void)
{
    return SoundScheduling.Current;
}

uint32_t Get_SoundScheduling_Next(void)
{
    return SoundScheduling.Next;
}
