

#ifndef _SOUND_SOURCE_H_
#define _SOUND_SOURCE_H_

#include "TYW_stdint.h"

/******************************************************************************
音源名称列表

注意：音源名称所指代的序号应与该声音位于声音属性表中的序号一一对应
******************************************************************************/
enum
{
    SND_SRC_Error_Waring_400ms_0,
    SND_SRC_IACC_Activation_Fail_600ms_1,
    SND_SRC_InforWarning_234,
    SND_SRC_TouchInfo_20ms_5,
    SND_SRC_ParkFinish_1500ms_6,
    SND_SRC_Seatbelt_789,
    SND_SRC_LightWarning_101112,
    SND_SRC_LDW_600ms_13,
    SND_SRC_IACC_Activation_800ms_14,
    SND_SRC_IACC_Activation_Exit_800ms_15,
    SND_SRC_IACC_TAKEOVER_400ms_16,
    SND_SRC_IACC_TAKEOVER_800ms_17,
    SND_SRC_IACC_TAKEOVER_1100ms_18,
    SND_SRC_IACC_TAKEOVER_NOW_720ms_19,
    SND_SRC_IACC_TAKEOVER_NOW2_720ms_19,
    SND_SRC_IACC_FCW_200ms_20,
    SND_SRC_IACC_FCW_750ms_21,
    SND_SRC_LCDA_1100ms_22,
    SND_SRC_LCDA_500ms_23,
    SND_SRC_LCDA_666ms_24,
    SND_SRC_TICK1_252729,
    SND_SRC_TOCK1_262830,
    SND_SRC_OVERSPEED_400ms_31,
    SND_SRC_PowerON_323334,
    SND_SRC_PowerOFF_353637,
    SND_SRC_WelcomeGuests_383940,
    SND_SRC_RADAR_FRONT_409ms_41,
    SND_SRC_RADAR_FRONT_140ms_42,
    SND_SRC_RADAR_REAR_413ms_43,
    SND_SRC_RADAR_REAR_140ms_44,
    SND_SRC_LOADHINT_600ms_45,
    SND_SRC_KA_CHA_500ms_46,
    SND_SRC_LDW_600ms_47,
    SND_SRC_IACC_TAKEOVER_1100ms_48,
    SND_SRC_IACC_TAKEOVER_NOW2_720ms_49,
    SND_SRC_TOTAL_NUM,
};

/******************************************************************************
伪音源名称列表
******************************************************************************/
#define SND_SRC_NONE    0xFFFFFFFFUL /*没有声音*/
#define SND_SRC_CURRENT 0xFFFFFFFEUL /*当前播放的声音*/

/******************************************************************************
音源循环次数
******************************************************************************/
#define SND_CYCLE_NONSTOP 0xFFFFFFFFUL /*不停播放*/

/******************************************************************************
音源播放模式
******************************************************************************/
#define SND_MODE_SINGLE 0x00u /*使用ISD_Play_Vp方法播放*/
#define SND_MODE_LOOP   0x01u /*使用ISD_Play_Vp_Loop方法播放*/

#endif
