#include "GenDelay.h"
#include "RTE_GPIO.h"
#include "RTE_ADC.h"
#include "System_Monitor.h"
#include "Analog_Signals.h"
#include "System_Monitor_User.h"

#define u16Base_Vol           0u
#define u16ENTER_LOW_N_RANGE  15000U
#define u16EXIT_LOW_N_RANGE   16000U
#define u16ENTER_LOW_Y_RANGE  17000U
#define u16EXIT_LOW_Y_RANGE   18000U
#define u16EXIT_HIGH_Y_RANGE  30000U
#define u16ENTER_HIGH_Y_RANGE 31000U
#define u16EXIT_HIGH_N_RANGE  32000U
#define u16ENTER_HIGH_N_RANGE 33000U
#define u16Top_Vol            0xffffu

#pragma alignvar(8)
static const monitorlib_uint16_t SysFun_Range [ 28u ] = {
    u16Base_Vol,

    u16ENTER_LOW_N_RANGE,
    u16EXIT_LOW_N_RANGE,

    u16ENTER_LOW_Y_RANGE,
    u16EXIT_LOW_Y_RANGE,

    u16EXIT_HIGH_Y_RANGE,
    u16ENTER_HIGH_Y_RANGE,

    u16EXIT_HIGH_N_RANGE,
    u16ENTER_HIGH_N_RANGE,

    u16Top_Vol,
    30000u,
    2u,
    u16Base_Vol,

    u16ENTER_LOW_N_RANGE,
    u16EXIT_LOW_N_RANGE,

    u16ENTER_LOW_Y_RANGE,
    u16EXIT_LOW_Y_RANGE,

    u16EXIT_HIGH_Y_RANGE,
    u16ENTER_HIGH_Y_RANGE,

    u16EXIT_HIGH_N_RANGE,
    u16ENTER_HIGH_N_RANGE,

    u16Top_Vol,
    30000u,
    2u,

    1000U,
    2U,
    1000U,
    2U,
};

monitorlib_uint16_t Sys_Read_KL30_Voltage_F(void)
{
    monitorlib_uint16_t u16Voltage;
    u16Voltage = ADC_Conv_Single_Channel(ADC_CH_KL30_VOLTAGE);
    return u16Voltage;
}

monitorlib_uint16_t Sys_Read_KL15_Voltage_F(void)
{
    monitorlib_uint16_t u16Voltage;
    u16Voltage = ADC_Conv_Single_Channel(ADC_CH_KL30_VOLTAGE);
    return u16Voltage;
}

monitorlib_uint16_t Sys_Read_KL30_Voltage(void)
{
    monitorlib_uint16_t u16Voltage;
    u16Voltage = ADC_Read_Signal(ADC_CH_KL30_VOLTAGE);
    return u16Voltage;
}

monitorlib_uint16_t Sys_Read_KL15_Voltage(void)
{
    monitorlib_uint16_t u16Voltage;
    u16Voltage = ADC_Read_Signal(ADC_CH_KL15_VOLTAGE);
    return u16Voltage;
}

monitorlib_uint8_t Sys_Read_KL30_Valid(void)
{
    monitorlib_uint8_t u8Valid;
    u8Valid = ADC_Read_Signal_Valid(ADC_CH_KL30_VOLTAGE);
    return u8Valid;
}

monitorlib_uint8_t Sys_Read_KL15_Valid(void)
{
    monitorlib_uint8_t u8Valid;
    u8Valid = ADC_Read_Signal_Valid(ADC_CH_KL15_VOLTAGE);
    return u8Valid;
}

monitorlib_uint8_t System_LINE_KL15(void)
{
    monitorlib_uint8_t u8KL15;

    if ( Sye_KL15_LINE == 1u )
    {
        u8KL15 = 1u;
    }
    else
    {
        u8KL15 = 0u;
    }

    return u8KL15;
}
monitorlib_uint8_t KL30_Abnormal_2S;
monitorlib_uint8_t KL30_Abnormal_Sts;
void Set_UDS_KL30_Valid(void)
{
    monitorlib_uint16_t UDS_KL30;
    monitorlib_uint16_t UDS_KL15;
    UDS_KL30 = Sys_Read_KL30_Voltage();
    UDS_KL15 = Sys_Read_KL15_Voltage();

    if((UDS_KL15 > 9000) && (UDS_KL15 < 16000))
    {
        if((UDS_KL30 < 9000) /*|| (UDS_KL30 > 16000)*/)
        {
            if(KL30_Abnormal_2S > 20)
            {
                KL30_Abnormal_Sts = 1;
            }
            else 
            {
                KL30_Abnormal_2S ++;
            }
        }
        else 
        {
            KL30_Abnormal_Sts = 0;
            KL30_Abnormal_2S = 0;
        }
    }
    else 
    {
        KL30_Abnormal_Sts = 0;
        KL30_Abnormal_2S = 0;
    }
}

monitorlib_uint8_t Get_UDS_KL30_Abnormal_Status(void)
{
    return KL30_Abnormal_Sts;
}

void Common_BlockDelay(monitorlib_uint32_t u32Ms)
{
    Gen_TimeDelay(u32Ms * 1000u, 50u);
}

void Sys_LogicProcess(void)
{
    /*50402-2*/
}

void Sys_KL30_Init(void)
{
    MonitorExt_st m_st;
    m_st.COM_Delay               = Common_BlockDelay;
    m_st.SysGet_KL15Line         = System_LINE_KL15;
    m_st.SysGet_KL15_Valid       = Sys_Read_KL15_Valid;
    m_st.SysGet_KL30_Valid       = Sys_Read_KL30_Valid;
    m_st.SysGet_KL15_value       = Sys_Read_KL15_Voltage;
    m_st.SysGet_KL30_value       = Sys_Read_KL30_Voltage;
    m_st.SysGet_KL15_value_Force = Sys_Read_KL15_Voltage_F;
    m_st.SysGet_KL30_value_Force = Sys_Read_KL30_Voltage_F;
    m_st.SysMonitorLogic         = Sys_LogicProcess;
    Sys_Set_Pata(SysFun_Range, &m_st);
    System_Monitor_KL30Init( );
    KL30_Abnormal_2S = 0;
    KL30_Abnormal_Sts = 0;
}

void Sys_WakeUp_Init(void)
{
    MonitorExt_st m_st;
    m_st.COM_Delay               = Common_BlockDelay;
    m_st.SysGet_KL15Line         = System_LINE_KL15;
    m_st.SysGet_KL15_Valid       = Sys_Read_KL15_Valid;
    m_st.SysGet_KL30_Valid       = Sys_Read_KL30_Valid;
    m_st.SysGet_KL15_value       = Sys_Read_KL15_Voltage;
    m_st.SysGet_KL30_value       = Sys_Read_KL30_Voltage;
    m_st.SysGet_KL15_value_Force = Sys_Read_KL15_Voltage_F;
    m_st.SysGet_KL30_value_Force = Sys_Read_KL30_Voltage_F;
    m_st.SysMonitorLogic         = Sys_LogicProcess;
    Sys_Set_Pata(SysFun_Range, &m_st);
    System_Monitor_WakeupInit( );
    KL30_Abnormal_2S = 0;
    KL30_Abnormal_Sts = 0;
}
