#include "TCA6416.h"
#include "GenDelay.h"
#include "Simulated_IIC_2_Master.h"
/*---------------------------------------------------------------------------*/
uint16_t IO_TCA6416A_OUT_Last;
/*---------------------------------------------------------------------------*/
_TCA6416A_DATA IO_TCA6416A_1_IN; // 输入,读
_TCA6416A_DATA IO_TCA6416A_2_IN; // 输入,读
_TCA6416A_DATA IO_TCA6416A_OUT;  // 输出寄存器
_TCA6416A_DATA IO_TCA6416A_INV;  // 极性翻转寄存器
_TCA6416A_DATA IO_TCA6416A_DR;   // 配置方向寄存器
/*---------------------------------------------------------------------------*/
TCA6416ARWStruct TCA6416ARW;
/*****************************************************************************/
TCA6416AErrEnum TCA6416_Init(void)
{
    uint32_t i, j, k, a;

    IO_TCA6416A_OUT_Last = 0x0000;
    IO_TCA6416A_INV.Data = 0x0000;
    IO_TCA6416A_DR.Data = 0xFFFF;
    IO_TCA6416A_OUT.Data = 0x0000;

    a = 0;

    do
    {
        i = TCA6416_Data_Out(0x04, IO_TCA6416A_INV.Data); // 输出极性
        // k = TCA6416_Data_Out(0x02, IO_TCA6416A_OUT.Data); //输出
        j = TCA6416_Data_Out(0x06, IO_TCA6416A_DR.Data); // IO方向
    } while (((i != TCA6416A_OK) || (j != TCA6416A_OK)) && (++a < 4));

    if (a < 4)
    {
        return TCA6416A_OK;
    }
    else
    {
        return TCA6416A_NO_RESPONSE;
    }
}
/*---------------------------------------------------------------------------*/
TCA6416AErrEnum TCA6416_Data_Out(uint8_t adr, uint16_t dat)
{
    if (TCA6416ARW.State != TCA6416A_IDLE)
    {
        return TCA6416A_BUSY;
    }

    if (((IO_TCA6416A_OUT_Last != dat) && (adr == 0x2)) || (adr != 0x2))
    {
        uint8_t i, ACK, data[4];

        data[0] = 0x40;                // 器件地址
        data[1] = adr;                 // 寄存器地址
        data[2] = (uint8_t)(dat);      // 输出数据低字节
        data[3] = (uint8_t)(dat >> 8); // 输出数据高字节
        // 启动IIC
        IIC_Start(0);

        for (i = 0; i < 4; i++)
        {
            IIC_Transmit_Data(data[i], 0);
            do
            {
                ACK = IIC_Receive_ACK(0);
            } while (ACK == IIC_INVALID_ACK);

            if (ACK != IIC_ACK)
            {
                IIC_Stop(0);
                return TCA6416A_NO_RESPONSE;
            }
        }
        // 停止IIC
        IIC_Stop(0);

        data[0] = 0x42;                // 器件地址
        data[1] = adr;                 // 寄存器地址
        data[2] = (uint8_t)(dat);      // 输出数据低字节
        data[3] = (uint8_t)(dat >> 8); // 输出数据高字节
        // 启动IIC
        IIC_Start(0);

        for (i = 0; i < 4; i++)
        {
            IIC_Transmit_Data(data[i], 0);
            do
            {
                ACK = IIC_Receive_ACK(0);
            } while (ACK == IIC_INVALID_ACK);

            if (ACK != IIC_ACK)
            {
                IIC_Stop(0);
                return TCA6416A_NO_RESPONSE;
            }
        }
        // 停止IIC
        IIC_Stop(0);

        if (adr == 0x2)
        {
            IO_TCA6416A_OUT_Last = dat;
        }
    }

    // 返回写入结果
    return TCA6416A_OK;
}
/*---------------------------------------------------------------------------*/
uint16_t IO_TCA6416A_DR_Data;
/*---------------------------------------------------------------------------*/
TCA6416AErrEnum TCA6416_Data_In(uint8_t adr)
{
    uint8_t i;
    uint8_t ACK, data[2];
    uint16_t tmp, tmp1, tmp2, tmp3;

    if (TCA6416ARW.State != TCA6416A_IDLE)
    {
        return TCA6416A_BUSY;
    }
    if (adr == 0)
    {
        data[0] = 0x40; // 器件地址,写
        data[1] = 0;    // 输入数据寄存器地址
        // 启动IIC
        IIC_Start(0);

        for (i = 0; i < 2; i++)
        {
            IIC_Transmit_Data(data[i], 0);
            do
            {
                ACK = IIC_Receive_ACK(0);
            } while (ACK == IIC_INVALID_ACK);

            if (ACK != IIC_ACK)
            {
                IIC_Stop(0);
                return TCA6416A_NO_RESPONSE;
            }
        }

        // 重新启动IIC
        IIC_Start(0);
        data[0] = 0x41; // 器件地址,读
        IIC_Transmit_Data(data[0], 0);
        do
        {
            ACK = IIC_Receive_ACK(0);
        } while (ACK == IIC_INVALID_ACK);

        if (ACK != IIC_ACK)
        {
            IIC_Stop(0);
            return TCA6416A_NO_RESPONSE;
        }
        // 读取数据
        tmp1 = IIC_Receive_Data(0);
        IIC_Transmit_ACK(IIC_ACK, 0);
        // IIC_Transmit_ACK(IIC_NAK, 0);
        tmp = IIC_Receive_Data(0);
        IIC_Transmit_ACK(IIC_ACK, 0);
        IIC_Transmit_ACK(IIC_NAK, 0);
        // 停止IIC
        IIC_Stop(0);
        tmp <<= 8;
        tmp &= 0xFF00;
        tmp |= tmp1;

        IO_TCA6416A_1_IN.Data = tmp;
        // 返回写入结果
        return TCA6416A_OK;
    }
    else
    {

        data[0] = 0x42; // 器件地址,写
        data[1] = 1;    // 输入数据寄存器地址
        // 启动IIC
        IIC_Start(0);

        for (i = 0; i < 2; i++)
        {
            IIC_Transmit_Data(data[i], 0);
            do
            {
                ACK = IIC_Receive_ACK(0);
            } while (ACK == IIC_INVALID_ACK);

            if (ACK != IIC_ACK)
            {
                IIC_Stop(0);
                return TCA6416A_NO_RESPONSE;
            }
        }

        // 重新启动IIC
        IIC_Start(0);
        data[0] = 0x43; // 器件地址,读
        IIC_Transmit_Data(data[0], 0);
        do
        {
            ACK = IIC_Receive_ACK(0);
        } while (ACK == IIC_INVALID_ACK);

        if (ACK != IIC_ACK)
        {
            IIC_Stop(0);
            return TCA6416A_NO_RESPONSE;
        }
        // 读取数据
        tmp2 = IIC_Receive_Data(0);
        IIC_Transmit_ACK(IIC_ACK, 0);
        // IIC_Transmit_ACK(IIC_NAK, 0);
        tmp3 = IIC_Receive_Data(0);
        IIC_Transmit_ACK(IIC_ACK, 0);
        IIC_Transmit_ACK(IIC_NAK, 0);
        // 停止IIC
        IIC_Stop(0);
        tmp2 <<= 8;
        tmp2 &= 0xFF00;
        tmp2 |= tmp3;
        IO_TCA6416A_2_IN.Data = tmp2;
        // 返回写入结果
        return TCA6416A_OK;
    }
}
/*****************************************************************************/