#ifndef TCA6416_H_
#define TCA6416_H_
/*===========================================================================*/
#include "TYW_stdint.h"

#define TCA6416A_IDLE 0x00

#define TCA6416A_BUFFER_SIZE 32
/*** 读写错误 ***/
typedef enum
{
    TCA6416A_OK = 0,              // 操作成功,没有错误发生
    TCA6416A_BUSY,                // EEPROM忙
    TCA6416A_INVALID_DEVICE_ADDR, // 无效的器件地址
    TCA6416A_INVALID_DATA_ADDR,   // 无效的数据地址
    TCA6416A_DATA_LENGTH_ERR,     // 错误的数据长度
    TCA6416A_NO_RESPONSE,         // EEPROM没有响应
} TCA6416AErrEnum;
/*** 读写过程 ***/
typedef enum
{
    TCA6416A_RW_IDLE = 0, // 空闲状态,允许新数据读写
    TCA6416A_RW_REQ,      // 已有数据请求读写
    TCA6416A_RW_BUSY,     // 数据读写进行中
} TCA6416ARWStateEnum;
/*===========================================================================*/
/*** 读写结果 ***/
typedef enum
{
    TCA6416A_RW_NONE = 0,    // 未发起过读写
    TCA6416A_RW_DONE,        // 数据读写完成
    TCA6416A_RW_FAIL,        // 数据读写失败
    TCA6416A_RW_IN_PROGRESS, // 数据读写中
} TCA6416ARWResultEnum;
typedef struct
{
    uint8_t State;
    uint8_t Cnt;
    uint8_t WRAddrLen;
    uint8_t WRAddr[3];
    uint8_t WRDataLen;
    uint8_t WRData[TCA6416A_BUFFER_SIZE];
    TCA6416ARWStateEnum WRState;
    TCA6416ARWResultEnum WRResult;
    uint8_t RDAddrLen;
    uint8_t RDAddr[3];
    uint8_t RDDataLen;
    uint8_t RDData[TCA6416A_BUFFER_SIZE];
    TCA6416ARWStateEnum RDState;
    TCA6416ARWResultEnum RDResult;
} TCA6416ARWStruct;
/*****************************************************************************/
// TCA6416A À©Õ¹IO¿ØÖÆ½á¹¹
typedef union
{
    uint16_t Data;
    struct
    {
        uint8_t D00 : 1;
        uint8_t D01 : 1;
        uint8_t D02 : 1;
        uint8_t D03 : 1;
        uint8_t D04 : 1;
        uint8_t D05 : 1;
        uint8_t D06 : 1;
        uint8_t D07 : 1;

        // uint8_t D08 : 1;
        // uint8_t D09 : 1;
        uint8_t D10 : 1;
        uint8_t D11 : 1;
        uint8_t D12 : 1;
        uint8_t D13 : 1;
        uint8_t D14 : 1;
        uint8_t D15 : 1;
        uint8_t D16 : 1;
        uint8_t D17 : 1;
    } bits;
} _TCA6416A_DATA;
/*---------------------------------------------------------------------------*/
extern _TCA6416A_DATA IO_TCA6416A_1_IN; // ÊäÈë,¶Á
extern _TCA6416A_DATA IO_TCA6416A_2_IN; // ÊäÈë,¶Á
extern _TCA6416A_DATA IO_TCA6416A_OUT;  // Êä³ö¼Ä´æÆ÷
extern _TCA6416A_DATA IO_TCA6416A_INV;  // ¼«ÐÔ·­×ª¼Ä´æÆ÷
extern _TCA6416A_DATA IO_TCA6416A_DR;   // ÅäÖÃ·½Ïò¼Ä´æÆ÷

extern uint16_t IO_TCA6416A_DR_Data;
/*---------------------------------------------------------------------------*/
// TCA6416A_REG0~1
#define LINE_IN_PARKING_BRAKING     IO_TCA6416A_1_IN.bits.D04  //驻车制动
#define LINE_IN_CHARGE              IO_TCA6416A_1_IN.bits.D14  //充电指示
#define LINE_IN_CAN_WARNING         IO_TCA6416A_1_IN.bits.D16  //CAN报警
#define LINE_IN_BRAKE_PRESSURE      IO_TCA6416A_1_IN.bits.D06  //制动气压报警
#define LINE_IN_Low_CoolingLevel             IO_TCA6416A_1_IN.bits.D02  //冷却液位低
#define LINE_IN_Air_Filter_Blocked           IO_TCA6416A_1_IN.bits.D12  //空滤器堵塞
#define LINE_IN_High_Exhaust_Temperature     IO_TCA6416A_1_IN.bits.D01  //排气温度高
#define LINE_IN_Transmission_FailureLose     IO_TCA6416A_1_IN.bits.D11  //变速箱故障-

#define LINE_IN_Transmission_FailureJust  IO_TCA6416A_2_IN.bits.D05  //变速箱故障+
#define LINE_IN_YellowWarningLampStatus  IO_TCA6416A_2_IN.bits.D07  //故障报警灯
#define LINE_IN_EngineWaittoStartLamp    IO_TCA6416A_2_IN.bits.D14  //发动机预热
#define LINE_IN_TransmissionOilFilterBlocked  IO_TCA6416A_2_IN.bits.D12  //变速箱油滤堵塞
#define LINE_IN_AutoShiftGear            IO_TCA6416A_2_IN.bits.D03  //自动换挡
#define LINE_IN_Reversal_Cooling_fan     IO_TCA6416A_2_IN.bits.D00  //冷却风扇反转
#define LINE_IN_Stabilization_Module     IO_TCA6416A_2_IN.bits.D01  //稳定模块指示灯
#define LINE_IN_Power_Cut_Off            IO_TCA6416A_2_IN.bits.D11  //动力切断指示灯
#define LINE_IN_Emergency_Steering       IO_TCA6416A_2_IN.bits.D10  //应急转向指示灯
#define LINE_IN_Get_Bridge_Oil_Temperature_IsHigh      IO_TCA6416A_2_IN.bits.D17  //桥油温高指示灯
#define LINE_IN_Oil_Water_Separation     IO_TCA6416A_2_IN.bits.D06  //油水预热分离指示灯
#define LINE_IN_Low_Safety_Belt          IO_TCA6416A_2_IN.bits.D15  //安全带指示灯
#define LINE_IN_Fuel_Filter_Plugging     IO_TCA6416A_2_IN.bits.D13  //燃油滤堵塞指示灯
#define LINE_IN_GearDirection_Neutral    IO_TCA6416A_2_IN.bits.D02
#define LINE_IN_Bridgefilterblocked      IO_TCA6416A_1_IN.bits.D03  //桥滤清器堵塞报警灯
#define LINE_IN_Wheeldifferentiallocksignal      IO_TCA6416A_1_IN.bits.D07  //轮间差速锁止信号灯
#define LINE_IN_Hydraulicoilfilterblockagesignal      IO_TCA6416A_1_IN.bits.D05  //液压油滤堵塞信号灯
#define LINE_IN_MachineQuickChange      IO_TCA6416A_1_IN.bits.D15  //机具快换未锁指示灯
#define LINE_IN_FuelEconomy         IO_TCA6416A_1_IN.bits.D13  //燃油经济性指示灯

#define LINE_IN_RadiatingOilFilterBlocked IO_TCA6416A_2_IN.bits.D16   //散热油滤堵塞指示灯
#define LINE_IN_LCD_Transmissionfailure IO_TCA6416A_2_IN.bits.D04   //变速箱故障指示灯液晶屏
// TCA6416A_REG2~3
#define LDW_DRIVER_OUT IO_TCA6416A_OUT.bits.D04
#define ESP_DRIVER_OUT IO_TCA6416A_OUT.bits.D09
#define ECO_DRIVER_OUT IO_TCA6416A_OUT.bits.D11
#define ISS_DRIVER_OUT IO_TCA6416A_OUT.bits.D13
/*****************************************************************************/
TCA6416AErrEnum TCA6416_Init(void);
TCA6416AErrEnum TCA6416_Data_Out(uint8_t adr, uint16_t dat);
TCA6416AErrEnum TCA6416_Data_In(uint8_t adr);
/*****************************************************************************/
#endif