#ifndef TYWTYPES_H
#define TYWTYPES_H

/*

   变量长度(byte)      XHY      324     3360      rh850   SAMC21
   unsigned int        2       4       4         4       4
   unsigned short      2       2       2         2       2
   unsigned char       1       1       1         1       1
   unsigned long       4       4       4         4       4
   unsigned long long  4       8       8         8       8
   float               4       4       4         4       4
   double              4       8       8         8       8
*/

/*COMMON INTERFACE*/
typedef enum
{
    CAN_SIG_NORMAL = 0u,
    CAN_SIG_LOST   = 0x55U,
} CAN_MSG_Status_t;

typedef enum
{
    COMMON_POWER_OFF    = 0x00u,
    COMMON_POWER_ON     = 0x01u,
    COMMON_POWER_UNKNOW = 0xFFu,
} COMMON_PowerStatus_t;

typedef enum
{
    COMMON_InValid      = 0X00U,
    COMMON_Valid        = 0X01U,
    COMMON_Valid_UNKNOW = 0XFFU,
} DataValid_t;

/*COMMON INTERFACE END*/

typedef enum
{
    Bus_Sleep_Mode,
    Pre_Bus_Sleep_Mode,
    Network_Mode,
} NM_Mode_t;

#if ( ! defined(__cplusplus) )

    #ifndef false
        #define false (0U)
    #endif

    #ifndef true
        #define true (1U)
    #endif

    #ifndef TRUE
        #define TRUE (1U)
    #endif

    #ifndef FALSE
        #define FALSE (0U)
    #endif

#endif

#if defined(Platform_XHY)

    #ifndef uint8_t
typedef unsigned char uint8_t;
typedef unsigned int  uint16_t;
/*typedef unsigned short      uint16_t;*/
typedef unsigned long uint32_t;
/*typedef unsigned long long  uint32_t;*/

typedef char int8_t;
typedef int  int16_t;
/*typedef short               int16_t;*/
typedef long int32_t;
        /*typedef long long           int32_t;*/

        #define float float32_T;
        #define double double32_T;
        #define unsigned char boolean_t;
    #endif /* uint8_t */

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#elif defined(Platform_S6J3360)

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

    #define float float32_T;
    #define double double64;
    #define unsigned char boolean_t;

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#elif defined(Platform_S6J324)

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

    #define float float32_T;
    #define double double64;
    #define unsigned char boolean_t;

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#elif defined(Platform_RH850)

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

    #define float32_T float
    #define double64  double
    #define boolean_t unsigned char

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#elif defined(Platform_SAMC21)

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

    #define float float32_T;
    #define double double64;
    #define unsigned char boolean_t;

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#elif defined(Platform_S32K)

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

    #define float float32_T;
    #define double double64;
    #define unsigned char boolean_t;

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#elif defined(Platform_KEA64)

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

    #define float float32_T;
    #define double double64;
    #define unsigned char boolean_t;

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#else

    #define int8_t   signed char
    #define int16_t  signed short
    #define int32_t  signed int
    #define int64_t  signed long long
    #define uint8_t  unsigned char
    #define uint16_t unsigned short
    #define uint32_t unsigned int
    #define uint64_t unsigned long long

    #define float32_T float
    #define double64  double
    #define boolean_t unsigned char

    #define MAX_int8_t  (( int8_t )(127))
    #define MIN_int8_t  (( int8_t )(-128))
    #define MAX_uint8_T (( uint8_t )(255U))

    #define MAX_int16_t  (( int16_t )(32767))
    #define MIN_int16_t  (( int16_t )(-32768))
    #define MAX_uint16_t (( uint16_t )(65535U))

    #define MAX_int32_t  (( int32_t )(2147483647))
    #define MIN_int32_t  (( int32_t )(-2147483647 - 1))
    #define MAX_uint32_t (( uint32_t )(0xFFFFFFFFU))

    #define MAX_int64_t  (( int64_t )(9223372036854775807LL))
    #define MIN_int64_t  (( int64_t )(-9223372036854775807LL - 1LL))
    #define MAX_uint64_t (( uint64_t )(0xFFFFFFFFFFFFFFFFULL))

#endif /* Logical type definitions */

/*语言,缩写参考ISO 639-1*/
#define NVM_LANGUAGE_ZH 0x00u /*中文*/
#define NVM_LANGUAGE_EN 0x01u /*英语*/
#define NVM_LANGUAGE_RU 0x02u /*俄语*/
#define NVM_LANGUAGE_PT 0x03u /*葡萄牙语*/

/*主题*/
#define NVM_THEME_1 0x00u /*主题1 蓝色*/
#define NVM_THEME_2 0x02u /*主题2 红色*/
#define NVM_THEME_3 0x01u /*主题3 黄色*/

/*报警音量*/
#define NVM_ALARM_VOLUME_HI  0x03u /*音量高*/
#define NVM_ALARM_VOLUME_MID 0x02u /*音量中*/
#define NVM_ALARM_VOLUME_LO  0x01u /*音量低*/

/*时间格式*/
#define NVM_TIME_FORMAT_24H 0x01u /*24小时制*/
#define NVM_TIME_FORMAT_12H 0x00u /*12小时制*/

/*温度单位*/
#define NVM_TEMP_UNIT_C 0x00u
#define NVM_TEMP_UNIT_F 0x01u

/*压力单位*/
#define NVM_PRESSURE_UNIT_KPA 0x00u
#define NVM_PRESSURE_UNIT_PSI 0x01u
#define NVM_PRESSURE_UNIT_BAR 0x02u

/*油耗单位*/
#define NVM_FUEL_CONS_UNIT_L_100KM 0x00u
#define NVM_FUEL_CONS_UNIT_KM_L    0x01u
#define NVM_FUEL_CONS_UNIT_MPG_US  0x02u
#define NVM_FUEL_CONS_UNIT_MPG_UK  0x03u

/*距离单位*/
#define NVM_DIST_UNIT_KM   0x00u
#define NVM_DIST_UNIT_MILE 0x01u

/*车辆型号*/
#define NVM_MODEL_C211 0x00u /*FS11*/

/*超速报警*/
#define NVM_OVER_SPEED_ALARM_OFF    0x00u /*关闭*/
#define NVM_OVER_SPEED_ALARM_ENABLE 0x01u /*使能*/

/*私人定制*/
#define NVM_EPSPRIVATE_STANDARD 0x00u /*标准模式*/
#define NVM_EPSPRIVATE_SPORT    0x01u /*运动模式*/
#define NVM_EPSPRIVATE_DISABLE  0x00u /*私人定制禁用*/
#define NVM_EPSPRIVATE_ENABLE   0x01u /*私人订制使能*/

#define NVM_NAVI_DISABLE 0x00u /*导航禁用*/
#define NVM_NAVI_ENABLE  0x01u /*导航使能*/

#define NVM_SIMPLE_TBT    0x00u /*简易模式*/
#define NVM_NAVI_FULL_MAP 0x01u /*全屏模式*/

#define NVM_RelaxRemind_OFF 0u
#define NVM_RelaxRemind_3H  1u
#define NVM_RelaxRemind_4H  2u

#endif
