#include "main.h"
#include "Task.h"
#include "TYW_stdint.h"
#include "GenDelay.h"
#include "PowerManagement.h"
#include "Common_Interface.h"
#include "./AMT630H/AMT630H.h"
#include "System_Monitor.h"
#include "Sound_Player.h"
#include "Sound_Scheduler.h"
#include "COM_CAN.h"
#include "Services_Mileage.h"
#include "Services_Mileage_User.h"
#include "Data_VSpeed.h"
// #include "NMUserControl.h"
#include "Sound.h"
#include "Key.h"
#include "Popups.h"
#include "Sound.h"
#include "Telltales_Lib.h"
#include "RTE_GPIO.h"
#include "BackLight.h"
#include "DisplaySch.h"
#include "Line_in.h"
#include "DoCAN_ISO15765.h"
#include "UDS_Common.h"
#include "Data_IGN_OFF_Timing.h"
#include "Flash_synchronizer.h"
#include "RTE_ADC.h"
#include "init.h"
#include "eepromManage.h"
#include "Data_Gear.h"
#include "Display.h"
#include "Data_ESpeed.h"
#include "Data_DTE.h"
#include "LED_Driver.h"
#include "PowerManag_user.h"
#include "Telltales_user.h"
#include "./AMT630H/AMT630H_Datas.h"
#include "Display.h"
#include "TCA6416.h"
#include "Data_Time.h"
#include "Data_Water_Tem_Table.h"
#include "Transmission_oil_Tem_Table.h"
#include "Fuel_Level_Table.h"
#include "Brake_Pressure_Table.h"
#include "Brake_Pressure_Voltage_Table.h"
#include "FreIn.h"
#include "LED_Task.h"

/*******************************************************************************
 *                                                                              *
 *   ϵͳ��������ģʽ(SYS_MODE_OFF / SYS_MODE_ON / SYS_MODE_STANDBY )�����б�   *
 *                                                                              *
 *******************************************************************************/

/*==============================================================================
αʵʱ����
------------------------------------------------------------------------------*/
void Sys_Run_Mode_Pseudo_Real_Time_Tasks(void)
{
    Power_Management_Service( );
    DoCAN_Communication_Service( );
    UDS_Server_Application_Service( );
    LED_Driver_Service();

    Fre_In_Service(FRE_VEHICLE_0 );
}
/*============================================================================*/

/*==============================================================================
2ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_2ms_Tasks_Group(void)
{
    RTE_ADC_Services( );
    Sys_Status_Update_Service( );
    Common_Input_Para( );

    // Get_Battery_Voltage();
}

/*==============================================================================
2ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_5ms_Tasks_Group(void)
{
    COM_RX_Process( );
    UDS_10ms_Service( );
    Flash_Sync_Signal_Generation_Service( );
    // Popups_Polling_PEPS( );
}

/*==============================================================================
10ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_10ms_Tasks_Group(void)
{
    static uint8_t u_Timer = 0;
    BusOff_Service( );
    // NM_Process( );
    // SendMsg( );
    Key_Service( );
    Data_Gear_Service_Processing( );
    Display_Schedule_Service( );
    // Sound_Play_Service( );
    Data_Mileage_Write_EEPROM( );
    BackLight_Ctrl_Service( );
    Line_In_Debounce_Service(10u);
    //Telltales_Left_Right_Management_Service( );
    // if((Remote_Start_Signal() == 0) && (Get_Display_Factory() != 0x55))
    {
        Telltales_Left_Right_Management_Service( );
    }
    Animation_CB10ms( );
    TCA6416_Data_In(u_Timer);
    u_Timer ++;
    if(u_Timer > 1)
    {
        u_Timer = 0;
    }
}

/*==============================================================================
20ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_20ms_Tasks_Group0(void)
{
    Data_Vehicle_Speed_Processing_Service( );
    Data_Engine_Speed_Processing_Service( );
    Data_PowerSoc_Temp_Processing_Service( );   //水温段数处理
    Data_OilTem_Temp_Processing_Service( );     //油温段数处理
    Data_FuelLevel_Temp_Processing_Service( );  //燃油液位处理
    Data_BrakePressure_Temp_Processing_Service( ); //制动气压表头段数处理
    Data_BrakePressureVoltage_Temp_Processing_Service( ); //制动气压表头段数处理（电压控制）
    // TCA6416_Data_In(0);
}

/*==============================================================================
50ms����ִ������ ��0��
------------------------------------------------------------------------------*/
void Sys_Run_Mode_50ms_Tasks_Group(void)
{
    static uint8_t Remote_Start_BU_Init;
    uint8_t i;
    if((Remote_Start_Signal() == 1))
    {
        SET_LED_ALL_Light_CLOSE();
        Remote_Start_BU_Init = 1;
    }
    else 
    {
        if(Remote_Start_BU_Init == 1)
        {
            Remote_Start_BU_Init = 0;
        }
        // if(Get_Display_Factory() != 0x55)
        {
            Telltales_Management( );
        }
        // else 
        // {
        //     SET_LED_ALL_Light_OPEN();
        // }
    }

    LED_Driver_Scan_Refresh( );    // LED_Driver库调用
    // for ( i = 0; i < 35; i++)
    // {
    //     LED_Driver_Channel_Set(0,i,100);
    // }
    GUI_GraphicsAPP();


    // LED_DEAD_ZONE_Y_Exec( );
    // Sound_Management_Service( );
    // Sound_Scheduling_Service( );

    Fre_In_Time_Out_Handle(50U );
}
/*==============================================================================
100ms����ִ������ ��0��
------------------------------------------------------------------------------*/

void Sys_Run_Mode_100ms_Tasks_Group(void)
{
    static uint8_t i;
    if(i <= 50)
    {
        i++;
    }
    else
    {
    AddIndicationLight();
    DisplayLightService();
    }

    Data_ODO_Processing( );
    Data_Trip_Processing( );
    DisplayService( );
    Popups_Management_Service( );
    Data_IGN_Off_Timing_Service( );
    TYW_Data_ODO_Clear( );
    Audible_Alarm_Service( );  // 声音服务函数
    // SET_LED_ALL_Light_CLOSE();
    Display_Transmission_Oil_Temperature_Gauge(); //左侧小表头变速箱油温表
    Display_Battery_Voltage_Gauge();//电池电压表
    Display_Battery_Voltage(); //电池电压数显
    DisplayEnvironmentTemperature(); //环境温度数显
    Display_Urea_Level(); //尿素液位显示
    Fuel_Level(); //燃油液位显示
    Display_Oil_Pressure(); //机油压力显示
    Display_Water_Tem_Table(); //水温段数显示
    Display_Brake_Pressure(); //制动压力显示
    Display_Oil_Tem_Table(); //变速箱油温灯带显示
    Display_Tire_Pressure(); //胎压表
    TOT_Fuel_Consumption(); //总计油耗
    Instantaneous_Fuel_Consumption(); //瞬时油耗
    Display_Hydraulic_Oil_Temperature();//液压油温表
    Display_Transmission_Oil_Pressure();//变速箱油压表

    // (void)TCA6416_Init();
    Data_DTE_Service( );
    LED_Driver_Work_Check();
    Set_APP_CanBus5S();
    Data_ODO_ChangAn_Clear();
    UDS_Key_Res_buffer();
    Set_UDS_Key_Event_Long_30S();
    Set_UDS_KL30_Valid();

    // Data_ECons_Service( );
    // Set_AVG_Vspeed();
    // Get_Long_Short_Afe();

    // Core_HU_Service( );
    L_FuelSend_OUT = 1;
}
/*=================================================================*/

/*******************************************************************************
 *                                                                              *
 *                           ��ȷ��50us��ʱ�����б�                             *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
��ȷ��50us��ʱ���� ��ֹ�����޸��б��е�����
------------------------------------------------------------------------------*/
void Sys_Exact_50us_Tasks(void)
{
    static uint32_t task_1ms = 0u;
    static uint32_t task_2ms = 0u;

    GenDelay_Tick( );
    DoCAN_Timer_Update(50u);
    UDS_50us_Service( );
    COM_TX_Process();
    // RTE_OPEN_STB( );
    // 网络管理节拍
    task_2ms++;
    if ( task_2ms >= 40 )
    {
        task_2ms = 0;
        // OsekNM_Manage_Main( );
        AMT630H_Timer(2);
    }
    task_1ms++;
    if ( task_1ms >= 20U )    // Accurate 1ms task
    {
        task_1ms = 0U;
        eeprom_1ms_timeCount( );
    }
    
}
/*============================================================================*/

/*******************************************************************************
 *                                                                              *
 *                           ��ȷ��100ms��ʱ�����б�                            *
 *                                                                              *
 *******************************************************************************/
/*==============================================================================
��ȷ��100ms��ʱ���� ��ֹ�����޸��б��е�����
------------------------------------------------------------------------------*/
void Sys_Exact_100ms_Tasks(void)
{
    Services_Mileage_Callback( );
    Data_IGN_OFF_RollingCounter( );
    PowerSleepCount( );
    Data_Driver_Timer_Service( );
}
/*============================================================================*/
void Sys_Enter_Sleep_Mode(void)
{
    Sys_Sleep_Init( );
}
