#include "Telltales_Lib.h"
#include "Telltales_user.h"
#include "TYW_stdint.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Common_Interface.h"
#include "Flash_synchronizer.h"
#include "stddef.h"
#include "RTE_GPIO.h"
#include "Line_in.h"
#include "Line_In_user.h"
#include "EOL_Para.h"
#include "Sound_List.h"
#include "Sound_Scheduler.h"
#include "DisplaySch.h"
#include "RTE_GPIO.h"
#include <string.h>
#include "Analog_Signals.h"
#include "Data_VSpeed.h"
#include "BackLight.h"
#include "RTE_LED.h"
#include "LED_Map.h"
#include "TCA6416.h"
#include "RTE_PWM.h"
#include "Telltales_Lib.h"
#include "Configuration.h"
#include "Brake_Pressure_Service.h"
#include "EOL_Para.h"
#include "Sound_Player.h"

#pragma ghs section bss = ".myNonInitArea"
static uint8_t      Get_DIRMODEBkp;
#pragma ghs section bss = default

#pragma alignvar(8)
Tellib_uint8_t Tel_Mem [ Tel_MEM_Block_Size * LED_Max + Tel_MEM_Block_Addition ];

/* uint8_t LEFT_Fade_Zone_O_H;
uint8_t LEFT_Fade_Zone_O_L;
uint8_t RIGHT_Fade_Zone_O_H;
uint8_t RIGHT_Fade_Zone_O_L; */

uint8_t EPB_Status_Old;
static uint8_t Fuel_R_1Hz_6;
uint8_t PEPS_KeyLearning;
uint8_t PEPS_KeyBattery;
uint8_t BCM_Buzzer;
uint8_t BCM_Buzzer_1;

uint8_t PEPS_KeyUndetected;
uint8_t PEPS_ESCL_LOCK;
uint8_t PEPS_IMMO;
uint8_t PEPS_ESCL_Error;
uint8_t PEPS_KeyInCar;
uint8_t PEPS_Power;
uint8_t PEPS_PEPSFail;

uint8_t KEY_Time_5S_G;
uint8_t KEY_Time_5S_Y;
uint8_t KEY_Time_5S_Y_ON;
uint8_t KEY_Time_5S_Y_OFF;

uint8_t EngSts_Sts;
uint8_t HostLane_3S_Stop;

uint16_t ACC_Vspeed_Dis;
uint16_t time_EPB_flash_15s = 0;
uint8_t UDS_Left;
uint8_t UDS_Right;
uint8_t TransmissionOilPressureStatus = 0u; 

#define SEG_OPEN       1
#define SEG_CLOSE      0


typedef struct
{
    uint8_t LastLeft;
    uint8_t LastRight;
    uint8_t Delay;
} TelltaleLRCtrlStruct;

TelltaleLRCtrlStruct TelltaleLRCtrl;

// static Tellib_uint16_t LED_Turn_L_R_Judge(void);
// static void            LED_Turn_L_R_Exec(Tellib_uint16_t led_status);
// static Tellib_uint16_t LED_Turn_R_R_Judge(void);
// static void            LED_Turn_R_R_Exec(Tellib_uint16_t led_status);
uint16_t Get_Sound_Loudness(void);
static Tellib_uint16_t LED_Rear_Fog_R_Judge(void);
static void            LED_Rear_Fog_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Position_R_Judge(void);
static void            LED_Position_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_HI_Beam_R_Judge(void);
static void            LED_HI_Beam_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_LOW_Beam_R_Judge(void);
static void            LED_LOW_Beam_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_OilPressure_Low_R_Judge(void);
static void            LED_OilPressure_Low_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_P_R_Judge(void);
static void            LED_P_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_FailureLamp_R_Judge(void);
static void            LED_FailureLamp_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Seatbelt_R_Judge(void);
static void            LED_Seatbelt_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Battery_R_Judge(void);
static void            LED_Battery_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_ESP_R_Judge(void);
static void            LED_ESP_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_ESP_OFF_R_Judge(void);
static void            LED_ESP_OFF_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_MIL_R_Judge(void);
static void            LED_MIL_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Coolant_R_Judge(void);
static void            LED_Coolant_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Fuel_R_Judge(void);
static void            LED_Fuel_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_TPMS_R_Judge(void);
static void            LED_TPMS_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_HDC_STATUS_R_Judge(void);
static void            LED_HDC_STATUS_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Autohold_R_Judge(void);
static void            LED_Autohold_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_TFS_R_Judge(void);
static void            LED_TFS_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_RTTW_R_Judge(void);
static void            LED_RTTW_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_CI_R_Judge(void);
static void            LED_CI_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_BrakeLiquid_Low_R_Judge(void);
static void            LED_BrakeLiquid_Low_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Bridge_filter_blocked_Judge(void);
static Tellib_uint16_t LED_Air_Bag_R_Judge(void);
static void            LED_Air_Bag_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_ABS_R_Judge(void);
static void            LED_ABS_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_EPS_R_Judge(void);
static void            LED_EPS_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_HostLaneStatus_R_Judge(void);
static void            LED_HostLaneStatus_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_LCDA_SystemStatus_R_Judge(void);
static void            LED_LCDA_SystemStatus_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_GPF_State_R_Judge(void);
static void            LED_GPF_State_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_KEY_ALL_State_Y_Judge(void);
static void            LED_KEY_ALL_State_Y_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_KEY_ALL_State_G_Judge(void);
static void            LED_KEY_ALL_State_G_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Anti_theft_light_Y_Judge(void);
static void            LED_Anti_theft_light_Y_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Master_Warning_light_Y_Judge(void);
static void            LED_Master_Warning_light_Y_Exec(Tellib_uint16_t led_status);

static Tellib_uint16_t LED_DrvMode_W_Judge(void);
static void            LED_DrvMode_W_Exec(Tellib_uint16_t led_status);

static Tellib_uint16_t LED_Start_UP_Stop_Judge(void);
static void            LED_Start_UP_Stop_Exec(Tellib_uint16_t led_status);

static Tellib_uint16_t LED_GearDirection_Neutral_Judge(void);
static void            LED_GearDirection_Neutral_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_CAN_Judge(void);
static void            LED_CAN_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_TransmissionTop_High_Judge(void);
static void            LED_TransmissionTop_High_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Transmission_High_Judge(void);
static void            LED_Transmission_High_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_EngineOilPressure_Judge(void);
static void            LED_EngineOilPressure_Exec(Tellib_uint16_t led_status);
// static Tellib_uint16_t LED_DEFHigh_R_Judge(void);
// static void            LED_DEFHigh_R_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_DEFHigh_Y_Judge(void);
static void            LED_DEFHigh_Y_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_EldingLevelPercent_Judge(void);
static void            LED_EldingLevelPercent_Exec(Tellib_uint16_t led_status);
// static Tellib_uint16_t LED_Left_Judge(void);
// static Tellib_uint16_t LED_Right_Judge(void);
Tellib_uint16_t LED_Lamplet_Judge(void);
static void            LED_Lamplet_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Charge_Judge(void);
static void            LED_Charge_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Parking_Braking_Judge(void);
static void            LED_Parking_Braking_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Battery_Voltage_Judge(void);
static Tellib_uint16_t LED_Brake_Pressure(void);            //制动气压报警
static Tellib_uint16_t LED_Wet_Brake_Pressure(void);        //湿式制动气压报警
static void            LED_Brake_Pressure_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Transmission_Oil_Pressure(void);
static Tellib_uint16_t LED_Hydraulic_Oil_Temperature(void);

Tellib_uint16_t Get_EngineOilPressure_Flash_status(void);
Tellib_uint16_t EngineOilPressure_Flash_status;
Tellib_uint16_t EngineOilPressure_bright_status;
Tellib_uint16_t Get_DEFHigh_Flash_status(void);
Tellib_uint16_t DEFHigh_Flash_status;
Tellib_uint16_t Get_EldingLevelPercent_Flash_status(void);
Tellib_uint16_t EldingLevelPercent_Flash_status;
Tellib_uint16_t Transmission_Oil_Temperature_Flash_status;
Tellib_uint16_t Get_Transmission_Oil_Temperature_Flash_status(void);
Tellib_uint16_t Get_HydraulicOilTemperatureHigh_Status(void); //液压油温 点亮及闪烁
Tellib_uint16_t LED_HydraulicOilTemperatureHigh_State; // 液压油温高指示灯状态
static Tellib_uint16_t LED_Gearbox_Breakdown_Judge(void);
static void            LED_Gearbox_Breakdown_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Engine_Diagnostic_Judge(void);
static void            LED_Engine_Diagnostic_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Water_Tem_Judge(void);
static void            LED_Water_Tem_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Oil_Tem_Judge(void);
static void            LED_Oil_Tem_Exec(Tellib_uint16_t led_status);
static Tellib_uint16_t LED_Reversal_Cooling_fan_judge(void);                   //冷却风扇反转报警灯逻辑函数
static Tellib_uint16_t  LED_Stabilization_Module_judge(void);                  //稳定模块指示灯逻辑函数
static Tellib_uint16_t LED_Power_cut_off_judge(void); 	                        //动力切断指示灯逻辑函数
static Tellib_uint16_t LED_Emergency_Steering_judge(void); 	                //应急转向指示灯逻辑函数
static Tellib_uint16_t LED_Bridge_Oil_Temperature_Is_High_judge (void);        //桥油温高指示灯逻辑函数
static Tellib_uint16_t LED_Water_In_The_Oil_judge(void);                       //油中有水指示灯逻辑函数
static Tellib_uint16_t LED_Low_Cooling_Level_judge(void);                      //冷却液位低指示灯逻辑函数
static Tellib_uint16_t LED_Oil_Water_Separation_judge(void);                   //油水分离预热指示灯逻辑函数
static Tellib_uint16_t LED_Safety_Belt_judge(void);                     //安全带指示灯逻辑函数
static Tellib_uint16_t LED_Fuel_Filter_Pluggingt_judge(void);           //燃油滤堵塞指示灯逻辑函数
static Tellib_uint16_t LED_One_Click_Shake_Material_judge(void);        //一键抖料指示灯逻辑函数
static Tellib_uint16_t LED_Rearview_Mirror_Heating_Up_judge(void);      //后视镜加热指示灯逻辑函数
static Tellib_uint16_t LED_Presence_Status_Indication_judge(void);      //在位状态指示灯逻辑函数
static Tellib_uint16_t LED_Air_Filter_Blocked_judge(void);              //空滤器堵塞指示逻辑函数
static Tellib_uint16_t LED_Engine_Stop_judge(void);                     //发动机停机指示逻辑函数
static Tellib_uint16_t LED_High_Exhaust_Temperature_judge (void);       //排气温度高指示灯逻辑函数
static Tellib_uint16_t LED_Red_NCD_judge (void);                        //NCD
static Tellib_uint16_t LED_Yellow_NCD_judge (void);                     //NCD
static Tellib_uint16_t LED_Red_PCD_judge (void);                        //PCD
static Tellib_uint16_t LED_Yellow_PCD_judge(void);                      //PCD
static Tellib_uint16_t LED_ResistanceHighDEF_Judge(void);               //阻力高
static Tellib_uint16_t LED_Steering_Wheel_Lock_Condition_One_judge (void);         //方向盘锁状态1
static Tellib_uint16_t LED_Steering_Wheel_Lock_Condition_Two_judge (void);         //方向盘锁状态2
static Tellib_uint16_t LED_Driver_Warning_judge (void);                  //驾驶员警告
static Tellib_uint16_t LED_Wheel_differential_lock_signal(void);
static Tellib_uint16_t LED_Hydraulic_oil_filter_blockage_signal(void);
static Tellib_uint16_t LED_Radiating_Oil_Filter_Blocked(void);
static Tellib_uint16_t LED_FNR_Judge(void);
static Tellib_uint16_t LED_LCD_Transmission_failure_Judge(void);
static Tellib_uint16_t LED_MovableArmAuto_Judge(void);
static Tellib_uint16_t LED_BucketAuto_Judge(void);
static Tellib_uint16_t LED_TheTranslationalLift_Judge(void);
static Tellib_uint16_t LED_MovableArmInch_Judge(void);
static Tellib_uint16_t LED_MachineQuickChange_Judge(void);
static Tellib_uint16_t LED_MachineQuickChangeFinish_Judge(void);
static Tellib_uint16_t LED_FuelEconomy_Judge(void);
static Tellib_uint16_t LED_DPFLampCommand_R_Judge(void);
static Tellib_uint16_t LED_DPFLampCommand_Y_Judge(void);
static Tellib_uint16_t LED_DPFLampCommand_G_Judge(void);
static Tellib_uint16_t LED_Buzzer_Shielding_Judge(void);
static Tellib_uint16_t LED_MIL_Judge(void);
static Tellib_uint16_t LED_Remote_Lock_Judge(void);
static Tellib_uint16_t LED_ForbidDPFLampCommand_R_Judge(void);
static Tellib_uint16_t LED_ForbidDPFLampCommand_Y_Judge(void);
static Tellib_uint16_t LED_HydraulicLockStatus_One_Judge(void);
static Tellib_uint16_t LED_HydraulicLockStatus_Two_Judge(void);
static Tellib_uint16_t LED_AutoShiftGear_Judge(void);
static Tellib_uint16_t LED_TransmissionOilFilterBlocked_Judge(void);
static Tellib_uint16_t LED_EngineWaittoStartLamp_Judge(void);
static Tellib_uint16_t LED_RedWarningLampStatus_Judge(void);
static Tellib_uint16_t LED_YellowWarningLampStatus_Judge(void);
uint8_t Engine_Operation_Judge(void); // 发动机运行判断

uint8_t EldingLevelPercent_bright_status = 0;  //燃油液位
uint8_t LED_HydraulicOilTemperatureHigh_bright_State = 0;  //液压油温
uint8_t TransmissionOilPressureStatus_bright_status = 0;  //变速箱油压
uint8_t Transmission_Oil_Temperature_bright_status = 0;   //变速箱油温高
// clang-format off
const LED_Attribute_st LED_Attribute [ LED_Max ] =
{
    {m_LED_Reversal_Cooling_fan,                NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Reversal_Cooling_fan_judge,                NULL},
    {m_LED_Emergency_Steering,                  NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Emergency_Steering_judge,                  NULL},
    {m_LED_Power_cut_off,                       NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Power_cut_off_judge,                       NULL},
    {m_LED_Stabilization_Module,                NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Stabilization_Module_judge,                NULL},
    {m_LED_GearDirection_Neutral,               NoSelfCheck,   ExterNalCheck,     LED_IGN_ON, 0ul, 3000ul, LED_GearDirection_Neutral_Judge,               NULL},
	{m_LED_HI_Beam          ,                   NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_HI_Beam_R_Judge,                           NULL},
    {m_LED_Bridgefilterblocked,                 NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Bridge_filter_blocked_Judge,               NULL},//桥滤清器堵塞报警灯
    {m_LED_Wheeldifferentiallock,               NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Wheel_differential_lock_signal,            NULL},//轮间差速锁止信号灯
    {m_LED_Hydraulicoilfilterblockagesignal,    NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Hydraulic_oil_filter_blockage_signal,      NULL},//液压油滤堵塞信号灯
    {m_LED_Bridge_Oil_Temperature_Is_High,      NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul,LED_Bridge_Oil_Temperature_Is_High_judge ,      NULL},
    {m_LED_Water_In_The_Oil,                    NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Water_In_The_Oil_judge,                    NULL},
    {m_LED_RadiatingOilFilterBlocked,           NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Radiating_Oil_Filter_Blocked,              NULL},//散热油滤堵塞指示灯
    {m_LED_FNR,                                 NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_FNR_Judge,                                 NULL},//FNR指示灯
    {m_LED_LCD_Transmission_failure,            NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_LCD_Transmission_failure_Judge,            NULL},//变速箱故障指示灯液晶屏
    {m_LED_AutoShiftGear,                       NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_AutoShiftGear_Judge,                       NULL},//自动换挡
    {m_LED_Low_Cooling_Level,                   NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Low_Cooling_Level_judge ,                  NULL},
    {m_LED_Oil_Water_Separation,                NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Oil_Water_Separation_judge  ,              NULL},
    {m_LED_Safety_Belt,                         NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Safety_Belt_judge  ,                       NULL},
    {m_LED_Fuel_Filter_Plugging,                NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Fuel_Filter_Pluggingt_judge ,              NULL},
    {m_LED_Engine_Stop,                         NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Engine_Stop_judge,                         NULL},
    {m_LED_High_Exhaust_Temperature,            NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_High_Exhaust_Temperature_judge,            NULL},
    {m_LED_Air_Filter_Blocked,                  NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Air_Filter_Blocked_judge,                  NULL},
    {m_LED_TransmissionOilFilterBlocked,        NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_TransmissionOilFilterBlocked_Judge,        NULL},//变速箱油滤堵塞
    {m_LED_Red_NCD,                             NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Red_NCD_judge,                             NULL},
    {m_LED_Yellow_NCD,                          NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Yellow_NCD_judge,                          NULL},
    {m_LED_Red_PCD,                             NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Red_PCD_judge,                             NULL},
    {m_LED_Yellow_PCD,                          NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Yellow_PCD_judge,                          NULL},
    {m_LED_DPFLampCommand_R,                    NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_DPFLampCommand_R_Judge,                    NULL},//再生指示灯 红
    {m_LED_DPFLampCommand_Y,                    NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_DPFLampCommand_Y_Judge,                    NULL},//再生指示灯 黄
    {m_LED_DPFLampCommand_G,                    NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_DPFLampCommand_G_Judge,                    NULL},//再生指示灯 绿
    {m_LED_ForbidDPFLampCommand_R,              NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_ForbidDPFLampCommand_R_Judge,              NULL},//禁止再生指示灯 红
    {m_LED_ForbidDPFLampCommand_Y,              NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_ForbidDPFLampCommand_Y_Judge,              NULL},//禁止再生指示灯 黄
    {m_LED_ResistanceHighDEF,                   NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_ResistanceHighDEF_Judge,                   NULL},  
    {m_LED_EngineWaittoStartLamp,               NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_EngineWaittoStartLamp_Judge,               NULL},//发动机预热
    {m_LED_MovableArmAuto,                      NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_MovableArmAuto_Judge,                      NULL},//动臂定位指示灯
    {m_LED_BucketAuto,                          NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_BucketAuto_Judge,                          NULL},//铲斗定位指示灯
    {m_LED_TheTranslationalLift,                NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_TheTranslationalLift_Judge,                NULL},//平动举升指示灯
    {m_LED_MovableArmInch,                      NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_MovableArmInch_Judge,                      NULL},//动臂微动指示灯
    {m_LED_MachineQuickChange,                  NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_MachineQuickChange_Judge,                  NULL},//机具快换未锁指示灯
    {m_LED_MachineQuickChangeFinish,            NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_MachineQuickChangeFinish_Judge,            NULL},//机具快换锁止指示灯
    {m_LED_CAN,                                 NoSelfCheck,   ExterNalCheck,     LED_IGN_ON, 0ul, 3000ul, LED_CAN_Judge,                                 NULL},
    {m_LED_Transmission_High,                   NoSelfCheck,   ExterNalCheck,     LED_IGN_ON, 0ul, 3000ul, LED_Transmission_High_Judge,                   NULL},
	{m_LED_Coolant          ,                   NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Coolant_R_Judge,                           LED_Coolant_R_Exec},
    {m_LED_FuelEconomy,                         NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_FuelEconomy_Judge,                         NULL},//燃油经济性指示灯
    {m_LED_Engine_Maintenance,                  NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, NULL,                                          NULL},//发动机维修指示灯
    {m_LED_RedWarningLampStatus,                NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_RedWarningLampStatus_Judge,                NULL},//故障报警灯  红
    {m_LED_YellowWarningLampStatus,             NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_YellowWarningLampStatus_Judge,             NULL},//故障报警灯  黄
    {m_LED_Buzzer_Shielding,                    NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Buzzer_Shielding_Judge,                    NULL},//蜂鸣器屏蔽
    {m_LED_MIL_Y,                               NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_MIL_Judge,                                 NULL},//MIL排放灯
    {m_LED_Remote_Lock,                         NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Remote_Lock_Judge,                         NULL},//远程锁车
    {m_LED_Steering_Wheel_Lock_Condition_One,   NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Steering_Wheel_Lock_Condition_One_judge,   NULL},
    {m_LED_Steering_Wheel_Lock_Condition_Two,   NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Steering_Wheel_Lock_Condition_Two_judge,   NULL},
    {m_LED_One_Click_Shake_Material,            NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_One_Click_Shake_Material_judge,            NULL},
    {m_LED_HydraulicLockStatus_One,             NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_HydraulicLockStatus_One_Judge,             NULL},//液压锁状态 图标1
    {m_LED_HydraulicLockStatus_Two,             NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_HydraulicLockStatus_Two_Judge,             NULL},//液压锁状态 图标2
    {m_LED_Rearview_Mirror_Heating_Up,          NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Rearview_Mirror_Heating_Up_judge,          NULL},
    {m_LED_Presence_Status_Indication,          NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Presence_Status_Indication_judge,          NULL},
    {m_LED_Driver_Warning,                      NoSelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Driver_Warning_judge,                      NULL},


	// {m_LED_Turn_L           ,NoSelfCheck, NoExterNalCheck, LED_IGN_ON_OFF, 0ul, 3000ul, LED_Turn_L_R_Judge,            LED_Turn_L_R_Exec},
	// {m_LED_Turn_R           ,NoSelfCheck, NoExterNalCheck, LED_IGN_ON_OFF, 0ul, 3000ul, LED_Turn_R_R_Judge,            LED_Turn_R_R_Exec},
	{m_LED_Rear_Fog         ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON,     0ul, 3000ul, LED_Rear_Fog_R_Judge,                LED_Rear_Fog_R_Exec},
	{m_LED_Position         ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON_OFF, 0ul, 3000ul, LED_Position_R_Judge,                LED_Position_R_Exec},
	{m_LED_LOW_Beam         ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON_OFF, 0ul, 3000ul, LED_LOW_Beam_R_Judge,                LED_LOW_Beam_R_Exec},
	{m_LED_OilPressure_Low  ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_OilPressure_Low_R_Judge,         LED_OilPressure_Low_R_Exec},
	{m_LED_P                ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON_OFF, 0ul, 3000ul, LED_P_R_Judge,                       LED_P_R_Exec},
	{m_LED_FailureLamp      ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON,     0ul, 3000ul, LED_FailureLamp_R_Judge,             LED_FailureLamp_R_Exec},
	{m_LED_Seatbelt         ,NoSelfCheck, NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_Seatbelt_R_Judge,                LED_Seatbelt_R_Exec},
	{m_LED_Battery          ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_Battery_R_Judge,                 LED_Battery_R_Exec},
	{m_LED_ESC              ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_ESP_R_Judge,                     LED_ESP_R_Exec},
	{m_LED_ESC_OFF          ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_ESP_OFF_R_Judge,                 LED_ESP_OFF_R_Exec},
	{m_LED_MIL              ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_MIL_R_Judge,                     LED_MIL_R_Exec},
	{m_LED_Fuel             ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_Fuel_R_Judge,                    LED_Fuel_R_Exec},
	{m_LED_TPMS             ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_TPMS_R_Judge,                    LED_TPMS_R_Exec},
	{m_LED_HDC_STATUS       ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON,     0ul, 3000ul, LED_HDC_STATUS_R_Judge,              LED_HDC_STATUS_R_Exec},
	{m_LED_Autohold         ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_Autohold_R_Judge,                LED_Autohold_R_Exec},
	{m_LED_TFS              ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_TFS_R_Judge,                     LED_TFS_R_Exec},
	{m_LED_RTTW             ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_RTTW_R_Judge,                    LED_RTTW_R_Exec},
	{m_LED_CI               ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON,     0ul, 3000ul, LED_CI_R_Judge,                      LED_CI_R_Exec},
	{m_LED_BrakeLiquid_Low  ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_BrakeLiquid_Low_R_Judge,         LED_BrakeLiquid_Low_R_Exec},
	{m_LED_Air_Bag          ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON,     0ul, 3000ul, LED_Air_Bag_R_Judge,                 LED_Air_Bag_R_Exec},
	{m_LED_ABS              ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_ABS_R_Judge,                     LED_ABS_R_Exec},
	{m_LED_EPS              ,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_EPS_R_Judge,                     LED_EPS_R_Exec},
	{m_LED_HostLaneStatus   ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON,     0ul, 3000ul, LED_HostLaneStatus_R_Judge,          LED_HostLaneStatus_R_Exec},
	{m_LED_LCDA_SystemStatus,SelfCheck,   NoExterNalCheck, LED_IGN_ON,     0ul, 3000ul, LED_LCDA_SystemStatus_R_Judge,       LED_LCDA_SystemStatus_R_Exec},
	{m_LED_GPF_State        ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON,     0ul, 3000ul, LED_GPF_State_R_Judge,               LED_GPF_State_R_Exec},
	{m_LED_Key_Y            ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON_OFF, 0ul, 3000ul, LED_KEY_ALL_State_Y_Judge,           LED_KEY_ALL_State_Y_Exec},
	{m_LED_Key_G            ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON_OFF, 0ul, 3000ul, LED_KEY_ALL_State_G_Judge,           LED_KEY_ALL_State_G_Exec},
	{m_LED_Anti_theft       ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON,     0ul, 3000ul, LED_Anti_theft_light_Y_Judge,        LED_Anti_theft_light_Y_Exec},
	{m_LED_Master_Warning   ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON,     0ul, 3000ul, LED_Master_Warning_light_Y_Judge,    LED_Master_Warning_light_Y_Exec},
	{m_LED_DrvMode          ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON,     0ul, 3000ul, LED_DrvMode_W_Judge,                 LED_DrvMode_W_Exec},
	{m_LED_Start_UP_Stop    ,NoSelfCheck, ExterNalCheck,   LED_IGN_ON,     0ul, 3000ul, LED_Start_UP_Stop_Judge,             LED_Start_UP_Stop_Exec},

    
    {m_LED_EngineOilPressure,       SelfCheck,   ExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_EngineOilPressure_Judge,        NULL},
    // {m_LED_DEFHigh_R,               SelfCheck,   ExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_DEFHigh_R_Judge,                NULL},
    {m_LED_DEFHigh_Y,               SelfCheck,   ExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_DEFHigh_Y_Judge,                NULL},
    {m_LED_BatteryVoltage,          SelfCheck,   ExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Battery_Voltage_Judge,          NULL},
    {m_LED_EldingLevelPercent,      SelfCheck,   ExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_EldingLevelPercent_Judge,       NULL},
    {m_LED_BrakePressure,           SelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Brake_Pressure,               LED_Brake_Pressure_Exec},
    {m_LED_TransmissionTop_High,    SelfCheck,   ExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_TransmissionTop_High_Judge,     NULL},
    {m_LED_TransmissionOilPressure, SelfCheck,   ExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Transmission_Oil_Pressure,      NULL},
    {m_LED_HydraulicOilTemperature, SelfCheck,   ExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Hydraulic_Oil_Temperature,      NULL},

    // {m_LED_Turn_L,                  SelfCheck,   ExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Left_Judge,                     NULL},
    // {m_LED_Turn_R,                  SelfCheck,   ExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Right_Judge,                    NULL},
    {m_LED_Lamplet,                             SelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Lamplet_Judge,                             LED_Lamplet_Exec},
    {m_LED_Parking_Braking,                     SelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Parking_Braking_Judge,                     LED_Parking_Braking_Exec},
    {m_LED_Charge,                              SelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Charge_Judge,                              LED_Charge_Exec},
    {m_LED_GEARBOX_BREAKDOWN,                   SelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Gearbox_Breakdown_Judge,                   LED_Gearbox_Breakdown_Exec},
    {m_LED_ENGINE_DIAGNOSTIC,                   SelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Engine_Diagnostic_Judge,                   LED_Engine_Diagnostic_Exec},
    {m_LED_Water_Tem,                           SelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Water_Tem_Judge,                           LED_Water_Tem_Exec},
    {m_LED_Oil_Tem,                             SelfCheck,   NoExterNalCheck,   LED_IGN_ON, 0ul, 3000ul, LED_Oil_Tem_Judge,                             LED_Oil_Tem_Exec},  
    
}; 



// clang-format on
void Telltales_Init(void)
{
    TelExtPara m_ExtPara;
    m_ExtPara.TotalLength           = LED_Max;
    m_ExtPara.LED_PowerOFF_TimerCbk = Common_GetIgnOffTime;
    m_ExtPara.LED_PowerON_TimerCbk  = Get_HMI_SelfCheck_Timer;
    m_ExtPara.LED_PowerCbk          = Common_Get_IG_Sts;
    memset(Tel_Mem, 0, sizeof(Tel_Mem));
    Telltales_KL30_Wakeup_Init(( Tellib_uint8_t * )Tel_Mem, LED_Attribute, &m_ExtPara);
    UDS_Left = 0;
    UDS_Right = 0;
}

void BREAKFLUID_3S_Init(void)
{
    EPB_Status_Old = 0;
    EngSts_Sts = 0;
    HostLane_3S_Stop = 0;
    PEPS_KeyUndetected = 0;
    PEPS_ESCL_LOCK = 0;
    PEPS_IMMO = 0;
    PEPS_ESCL_Error = 0;
    PEPS_KeyInCar = 0;
    PEPS_Power = 0;
    PEPS_PEPSFail = 0;
    PEPS_KeyLearning = 0;
    PEPS_KeyBattery = 0;
    BCM_Buzzer = 0;
    BCM_Buzzer_1 = 0;
    ACC_Vspeed_Dis = 0xFFFFu;
    time_EPB_flash_15s = 0;
    UDS_Left = 0;
    UDS_Right = 0;
}
void UDS_Set_Telltales_Left_Right(uint8_t m_Left, uint8_t m_Right)
{
    UDS_Left = m_Left;
    UDS_Right = m_Right;
}

// void Telltales_Left_Right_Management_Service(void)    // 10ms
// {
//     uint8_t        Edge;
//     uint8_t        Left_Lamp;
//     uint8_t        Right_Lamp;
//     static uint8_t L_Back = 0u;
//     static uint8_t R_Back = 0u;
//     Edge                  = 0xFF;
//     Left_Lamp             = 0;
//     Right_Lamp            = 0;

//     //×ó×ªÏò
//     if(UDS_Left == 0)
//     {
//         if ( Left_Lamp == 1u )
//         {
//             L_Back = 1u;
//         }
//         else
//         {
//         }
//     }
//     else 
//     {
//         if(UDS_Left == 2)
//         {
//         }
//         else 
//         {
//         }
//     }

//     if ( TelltaleLRCtrl.LastLeft != Left_Lamp )
//     {

//         if ( Left_Lamp == 1u )
//         {
//             Edge = 1u;
//         }
//         else
//         {
//             if ( L_Back == 1u )
//             {
//                 Edge   = 0u;
//                 L_Back = 0u;
//             }
//         }
//         TelltaleLRCtrl.LastLeft = Left_Lamp;
//     }

//     //ÓÒ×ªÏò
//     if(UDS_Right == 0)
//     {
//         if ( Right_Lamp == 1u )
//         {
//             R_Back = 1u;
//         }
//         else
//         {
//         }
//     }
//     else 
//     {
//         if(UDS_Right == 2)
//         {
//         }
//         else 
//         {
//         }
//     }

//     if ( TelltaleLRCtrl.LastRight != Right_Lamp )
//     {
//         if ( Right_Lamp == 1u )
//         {
//             Edge = 1u;
//         }
//         else
//         {
//             if ( R_Back == 1u )
//             {
//                 Edge   = 0u;
//                 R_Back = 0u;
//             }
//         }
//         TelltaleLRCtrl.LastRight = Right_Lamp;
//     }

//     if ( TelltaleLRCtrl.Delay )
//     {
//         TelltaleLRCtrl.Delay--;
//     }
//     else
//     {
//         if ( Edge != 0xFF )
//         {
//             if ( Edge )
//             {
//                 // Sound_Request(SND_TICK, 1);
//             }
//             else
//             {
//                 // Sound_Request(SND_TOCK, 1);
//             }

//             TelltaleLRCtrl.Delay = 10;    // 200msÄÚ²»ÔÊÐíÖØ¸´²¥·ÅÉùÒô
//         }
//         else
//         {
//             // Sound_Delete(SND_TICK);
//             // Sound_Delete(SND_TOCK);
//         }
//     }
//     // if(Anti_Theft_MCU == 0)
//     // {
//     //     Anti_Theft_Light_EN = 1;
//     //     SEG_SET_Anti_Theft_Light_R(1);
//     // }
//     // else 
//     // {
//     //     Anti_Theft_Light_EN = 0;
//     //     SEG_SET_Anti_Theft_Light_R(0);
//     // }
// }

// static Tellib_uint16_t LED_Turn_L_R_Judge(void)
// {
//     Tellib_uint16_t LED_STATE = 0U;

//     return LED_STATE;
// }

// static void LED_Turn_L_R_Exec(Tellib_uint16_t led_status)
// {
// }

// static Tellib_uint16_t LED_Turn_R_R_Judge(void)
// {
//     Tellib_uint16_t LED_STATE = 0U;

//     return LED_STATE;
// }

// static void LED_Turn_R_R_Exec(Tellib_uint16_t led_status)
// {
// }

static Tellib_uint16_t LED_Rear_Fog_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    return LED_STATE;
}

static void LED_Rear_Fog_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_Position_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    return LED_STATE;
}

static void LED_Position_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

/*远光灯*/
static Tellib_uint16_t LED_HI_Beam_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    if(Line_In_Get_Status(LINE_IN_HIBEAM) == 1)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static void LED_HI_Beam_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_LOW_Beam_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    return LED_STATE;
}

static void LED_LOW_Beam_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_OilPressure_Low_R_Judge(void)
{
    Tellib_uint16_t LED_STATE    = 0U;
    uint8_t         m_Condition1 = 0U;

    return LED_STATE;
}

static void LED_OilPressure_Low_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_P_R_Judge(void)
{
    Tellib_uint16_t LED_STATE          = 0U;
    uint8_t         singal_value       = 0u;
    uint8_t         m_Condition1;
    return LED_STATE;
}

static void LED_P_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_FailureLamp_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    uint8_t         m_Condition1;
    return LED_STATE;
}

static void LED_FailureLamp_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_Seatbelt_R_Judge(void)
{
    Tellib_uint16_t LED_STATE       = 0U;
    static uint8_t  Seatbelt_Status = 0u;
    static uint16_t Seatbelt_Timer  = 0u;
    uint8_t         m_Condition1 = 0U;//, m_Condition2 = 0U, m_Condition3 = 0U;


    return LED_STATE;
}

static void LED_Seatbelt_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_Battery_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    return LED_STATE;
}

static void LED_Battery_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_ESP_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    uint8_t         m_Condition1;
    uint8_t         m_Condition2;
    uint8_t         m_Condition3;


    return LED_STATE;
}

static void LED_ESP_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_ESP_OFF_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    uint8_t m_Condition1;
    uint8_t m_Condition2;
    uint8_t m_Condition3;
    uint8_t m_Condition4;

    return LED_STATE;
}

static void LED_ESP_OFF_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_MIL_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;

    return LED_STATE;
}

static void LED_MIL_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

/*水温高报警灯*/
/*液晶屏报警图标*/
/*水温高阈值配置105，回溯102，偏移量40*/
/*5秒等待期间保持上一状态*/
/*返回值0熄灭，1点亮，2以1Hz闪烁*/
static Tellib_uint16_t LED_Coolant_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    static Tellib_uint16_t CoolantTimer1 = 0u;
    static Tellib_uint8_t LED_STATE_OLD = 0u;
    static Tellib_uint8_t Coolant_Threshold_H = 0u;
    Coolant_Threshold_H = Get_Coolant_Temperature_threshold_High();
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_ET1_Msg_Count) == CAN_SIG_NORMAL)
    {
        if (Get_CAN_CH0_ID_18FEEE00_Sig_CoolantTemperature() >= (Coolant_Threshold_H + 40))
        {
            if(CoolantTimer1 >= 100)
            {
                LED_STATE = 1u;
                LED_STATE_OLD = 1u;
            }
            else
            {
                CoolantTimer1++;
            }
        }
        else if(Get_CAN_CH0_ID_18FEEE00_Sig_CoolantTemperature() <= (Coolant_Threshold_H + 37))
        {
            LED_STATE = 0u;
            CoolantTimer1 = 0u;
            LED_STATE_OLD = 0u;
        }
        else
        {
            if(LED_STATE_OLD == 1)
            {
                LED_STATE = 1u;
                CoolantTimer1 = 0u;
            }
            else
            {
                LED_STATE = 0u;
                LED_STATE_OLD = 0u;
                CoolantTimer1 = 0u;
            }
        }
    }
    else
    {
        LED_STATE = 2;
        LED_STATE_OLD = 2;
        CoolantTimer1 = 0u;
    }
    return LED_STATE;
}

static void LED_Coolant_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_Fuel_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    uint8_t m_Condition1;
    
    return LED_STATE;
}

static void LED_Fuel_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_TPMS_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    uint8_t m_Condition1;
    uint8_t m_Condition2;
    uint8_t m_Condition3;
    uint8_t m_Condition4;
    uint8_t m_Condition5;
    uint8_t m_Condition6;
    uint8_t m_Condition7;
    return LED_STATE;
}

static void LED_TPMS_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_HDC_STATUS_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    uint8_t m_Condition1;

    return LED_STATE;
}

static void LED_HDC_STATUS_R_Exec(Tellib_uint16_t led_status)
{
    if ( led_status == 1 )
    {
    }
    else
    {
    }
}

/***
 *  retrun:  1 绿 2 白
 */
static Tellib_uint16_t LED_Autohold_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;

    return LED_STATE;    // 1 绿 2 白
}

static void LED_Autohold_R_Exec(Tellib_uint16_t led_status)
{
    if(led_status != 0)
    {
    }
    else 
    {
    }
}

static Tellib_uint16_t LED_TFS_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    return LED_STATE;
}

static void LED_TFS_R_Exec(Tellib_uint16_t led_status)
{
    //if(Val_EOL_F1FA_TCUType() == 0)
    //{
    //}
    //else 
    //{
    //}
}

static Tellib_uint16_t LED_RTTW_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;

    return LED_STATE;
}

static void LED_RTTW_R_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
    }
    else 
    {
    }
}

static Tellib_uint16_t LED_CI_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    uint8_t m_Condition1;
    uint8_t m_Condition2;
    uint8_t m_Condition3;
    uint16_t m_Condition4;


    return LED_STATE;
}

static void LED_CI_R_Exec(Tellib_uint16_t led_status)
{
    if(led_status != 0)
    {
    }
    else 
    {
    }
}

uint16_t Get_CC_Vspeed_Display(void)
{
    return ACC_Vspeed_Dis;
}

static Tellib_uint16_t LED_BrakeLiquid_Low_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;

    uint8_t  m_Condition1;
    uint8_t  m_Condition2;
    uint8_t  m_Condition3;
    uint8_t  m_Condition4;
    uint8_t  CLOSE_SIG_187;

    return LED_STATE;
}

static void LED_BrakeLiquid_Low_R_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
    }
    else 
    {
    }
}

static Tellib_uint16_t LED_Air_Bag_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;

    return LED_STATE;
}

static void LED_Air_Bag_R_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
    }
    else 
    {
    }
}

static Tellib_uint16_t LED_ABS_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    return LED_STATE;
}

static void LED_ABS_R_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
    }
    else 
    {
    }
}

static Tellib_uint16_t LED_EPS_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;

    return LED_STATE;
}

static void LED_EPS_R_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
    }
    else 
    {
    }
}

static Tellib_uint16_t LED_HostLaneStatus_R_Judge(void)
{
    Tellib_uint16_t LED_STATE         = 0U;
    static uint8_t  touch_lane_status = 0;
    uint8_t m_Condition1;
    uint8_t m_Condition2;
    uint8_t m_Condition3;
    uint8_t m_Condition4;

    return LED_STATE;
}

static void LED_HostLaneStatus_R_Exec(Tellib_uint16_t led_status)
{
    if(led_status != 0)
    {
    }
    else
    {
    }
}

static Tellib_uint16_t LED_LCDA_SystemStatus_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    

    return LED_STATE;
}

static void LED_LCDA_SystemStatus_R_Exec(Tellib_uint16_t led_status)
{
}

static Tellib_uint16_t LED_GPF_State_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    return LED_STATE;
}

static void LED_GPF_State_R_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
    }
    else 
    {
    }
}

static Tellib_uint16_t LED_KEY_ALL_State_Y_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    static uint8_t KEY_LIGHT_Y_5S;
    static uint8_t KEY_LIGHT_Y_5S_ON;
    static uint8_t KEY_LIGHT_Y_5S_OFF;
    static uint8_t m_SignSts = 0xFFu;
    uint8_t m_Condition1;
    uint8_t m_Condition2;
    uint8_t m_Condition3;
    uint8_t m_Condition4;
    uint8_t m_Condition5;
    uint8_t m_Condition6;
    uint8_t m_Condition7;


    return LED_STATE;
}

static void LED_KEY_ALL_State_Y_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
    }
    else 
    {
    }
}

static Tellib_uint16_t LED_KEY_ALL_State_G_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    static uint8_t KEY_LIGHT_5S;
    static uint8_t m_SignSts = 0xFFu;
    uint8_t m_Condition1;
    uint8_t m_Condition2;
    uint8_t m_Condition3;

    return LED_STATE;
}

static void LED_KEY_ALL_State_G_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
    }
    else 
    {
    }
}

static Tellib_uint16_t LED_Anti_theft_light_Y_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;

    return LED_STATE;
}

static void LED_Anti_theft_light_Y_Exec(Tellib_uint16_t led_status)
{

}

static Tellib_uint16_t LED_Master_Warning_light_Y_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    uint8_t m_Condition1;
    uint8_t m_Condition2;
    uint8_t m_Condition3;
    uint8_t m_Condition4;
    uint8_t m_Condition5;


    return LED_STATE;
}

static void LED_Master_Warning_light_Y_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
    }
    else 
    {
    }
}

static Tellib_uint16_t LED_DrvMode_W_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    uint8_t m_Condition4;


    return LED_STATE;
}

static void LED_DrvMode_W_Exec(Tellib_uint16_t led_status)
{
}

static Tellib_uint16_t LED_Start_UP_Stop_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0U;
    uint8_t m_Condition1;
    uint8_t m_Condition2;

    return LED_STATE;
}

static void LED_Start_UP_Stop_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
    }
    else 
    {
    }
}
/*空挡指示灯*/
static Tellib_uint16_t LED_GearDirection_Neutral_Judge(void)
{
    Tellib_uint8_t LED_STATE = 0u;
    Tellib_uint8_t condition1 = 0u;
    Tellib_uint8_t condition2 = 0u;
    Tellib_uint8_t condition3 = 0u;
    Tellib_uint8_t condition4 = 0u;
    Tellib_uint8_t condition5 = 0u;
    Tellib_uint8_t condition6 = 0u;
    Tellib_uint8_t condition7 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_DANA_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_ZF_Msg_Count) == CAN_SIG_NORMAL);
    condition3 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF32_Msg_Count) == CAN_SIG_NORMAL);
    condition4 = (Get_CAN_CH0_ID_0CFF3003_Sig_GearDirection() == 0);
    condition5 = (Get_CAN_CH0_ID_18FF1E03_Sig_GearDirection() == 0);
    condition6 = (Get_CAN_CH0_ID_18FF3203_Sig_NeutralGear() == 1);
    condition7 = (Line_In_Get_Status(LINE_IN_GearDirectionNeutral) == 1);
    if((condition1 && condition4) || (condition2 && condition5) || (condition3 && condition6) || (condition7))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*CAN报警*/
static Tellib_uint16_t LED_CAN_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(Line_In_Get_Status(LINE_IN_CANWARNING) == 1)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}
/*变速箱油温高报警灯，变速箱油温高阈值配置120*/
/*液晶屏表头报警图标*/
/*变速箱油温高阈值配置120，偏移量50,50,273*/
/*0灭，1亮，2白灯*/
static Tellib_uint16_t LED_TransmissionTop_High_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    static Tellib_uint16_t TransmissionTimer = 0u;
    static Tellib_uint16_t Transmission_state_old = 0u;  //0熄灭，1点亮，2闪烁
    if(Get_TelltalesLedSts(m_LED_Transmission_High) == 0)
    {
        LED_STATE = 2;
        TransmissionTimer = 0u;
        Transmission_state_old = 0u;
    }
    if(Get_TelltalesLedSts(m_LED_Transmission_High) == 1)
    {
        if(TransmissionTimer >= 100)  //5s
        {
            LED_STATE = 1;
            Transmission_state_old = 1u;
        }
        else
        {
            if(Transmission_state_old == 0u)
            {
                LED_STATE = 2;
            }
            if(Transmission_state_old == 2u)
            {
                LED_STATE = FLASH_SYNC_1Hz;
            }
            TransmissionTimer++;
        }
        
    }
    if(Get_TelltalesLedSts(m_LED_Transmission_High) == 2)
    {
        LED_STATE = FLASH_SYNC_1Hz;
        TransmissionTimer = 0u;
        Transmission_state_old = 2u;
    }
    return LED_STATE;
}


/*变速箱油温高报警灯*/
/*液晶屏报警图标*/
/*变速箱油温高阈值配置120，偏移量50,50,273*/
/*返回值0熄灭，1点亮，2以1Hz闪烁*/
static Tellib_uint16_t LED_Transmission_High_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint16_t TransmissionHigh_resistance = 0u;                 //硬线采集获取阻值
    static Tellib_uint8_t led_state_old = 1u;
    Tellib_uint32_t m_Condition1 = 0u;
    static Tellib_uint8_t Threshold_H = 0u;
    Threshold_H = Get_Transmission_Oil_Temperature_threshold_High();
    TransmissionHigh_resistance = ADC_Read_Signal(ADC_CH_TRANSMISSION_OIL_TEMPERATURE);
    if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TOT_Msg_Count) == CAN_SIG_NORMAL )
    {
        if(Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTemperatureofZF() >= Threshold_H+50)
        {
            LED_STATE = 1u;
            led_state_old = 1u;
        }
        else if(Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTemperatureofZF() <= Threshold_H+47)
        {
            LED_STATE = 0u;
            led_state_old = 0u;
        } 
        else
        {
            if(led_state_old == 1u)
            {
                LED_STATE = 1u;
                led_state_old = 1u;
            }
            else
            {
                LED_STATE = 0u;
                led_state_old = 0u;
            }
        }
    }
    else
    {
        if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_DANA_Msg_Count) == CAN_SIG_NORMAL )
        {
            if(Get_CAN_CH0_ID_0CFF3003_Sig_TransmissionOilTemperature() >= Threshold_H+50)
            {
                LED_STATE = 1u;
                led_state_old = 1u;
            }
            else if(Get_CAN_CH0_ID_0CFF3003_Sig_TransmissionOilTemperature() <= Threshold_H+47)
            {
                LED_STATE = 0u;
                led_state_old = 0u;
            } 
            else
            {
                if(led_state_old == 1u)
                {
                    LED_STATE = 1u;
                    led_state_old = 1u;
                }
                else
                {
                    LED_STATE = 0u;
                    led_state_old = 0u;
                }
            }
        }
        else
        {
            if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FD95_Msg_Count) == CAN_SIG_NORMAL )
            {
                m_Condition1 = Get_CAN_CH0_ID_18FD9503_Sig_TransmissionOilTemperature();
                m_Condition1 /= 32;
                if(m_Condition1 >= Threshold_H+273)
                {
                    LED_STATE = 1u;
                    led_state_old = 1u;
                }
                else if(m_Condition1 <= Threshold_H+270)
                {
                    LED_STATE = 0u;
                    led_state_old = 0u;
                } 
                else
                {
                    if(led_state_old == 1u)
                    {
                        LED_STATE = 1u;
                        led_state_old = 1u;
                    }
                    else
                    {
                        LED_STATE = 0u;
                        led_state_old = 0u;
                    }
                }
            }
            else
            {
                if(TransmissionHigh_resistance <= 30)
                {
                    LED_STATE = 2;
                    led_state_old = 2u;
                }
                else if((TransmissionHigh_resistance > 30) && (TransmissionHigh_resistance < 100))
                {
                    if(led_state_old == 2u)
                    {
                        LED_STATE = 2;
                        led_state_old = 2u;
                    }
                    else
                    {
                        LED_STATE = 1u;
                        led_state_old = 1u;
                    }
                }
                else
                {
                    if ((Transmission_Oil_Temperature_Resistance(TransmissionHigh_resistance)>= Threshold_H) && (TransmissionHigh_resistance >= 100))
                    {
                        LED_STATE = 1u;
                        led_state_old = 1u;
                    }
                    else
                    {
                        if ((Transmission_Oil_Temperature_Resistance(TransmissionHigh_resistance) > (Threshold_H - 3)) &&
                            (Transmission_Oil_Temperature_Resistance(TransmissionHigh_resistance) < Threshold_H))
                        {
                            if (led_state_old == 1u)
                            {
                                LED_STATE = 1u;
                            }
                            if (led_state_old == 0u)
                            {
                                LED_STATE = 0u;
                            }
                        }
                        else
                        {
                            LED_STATE = 0u;
                            led_state_old = 0u;
                        }
                    }
                }
                if (TransmissionHigh_resistance == 65535)
                {
                    LED_STATE = 2;
                    led_state_old = 2u;
                }
            }
        }
    }

    if(led_state_old == 2u)
    {
       Transmission_Oil_Temperature_Flash_status = 1; 
    }
    else
    {
        Transmission_Oil_Temperature_Flash_status = 0;
    }

    if(led_state_old == 1u)
    {
       Transmission_Oil_Temperature_bright_status = 1; 
    }
    else
    {
        Transmission_Oil_Temperature_bright_status = 0;
    }
    return LED_STATE;
}

//返回变速箱油温闪烁标志位
Tellib_uint16_t Get_Transmission_Oil_Temperature_Flash_status(void)
{
    return Transmission_Oil_Temperature_Flash_status;
}

//返回变速箱油温点亮标志位
Tellib_uint16_t Get_Transmission_Oil_Temperature_bright_status(void)
{
    return Transmission_Oil_Temperature_bright_status;
}

// static void LED_Transmission_High_Exec(Tellib_uint16_t led_status)
// {
//     return LED_Transmission_High_Judge();
// }

/*机油压力报警*/
/*液晶屏表头图标*/
/*5秒等待时保持上一状态*/
/*精度4*/
/*0灭，1亮，2白灯*/
static Tellib_uint16_t LED_EngineOilPressure_Judge(void)
{
    Tellib_uint16_t LED_STATE = 2u;
    static Tellib_uint16_t led_state_old = 0u;
    static Tellib_uint16_t EngineOilPressureTimer1 = 0u;
    Tellib_uint32_t m_Condition1 = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_EFLP1_Msg_Count) == CAN_SIG_NORMAL)
    {
        m_Condition1 = Get_CAN_CH0_ID_18FEEF00_Sig_EngineOilPressure();
        m_Condition1 *= 4;
        if((m_Condition1 <= Get_EngineOilPressure_Threshold_Low()) || (m_Condition1 >= Get_EngineOilPressure_Threshold_High()))
        {
            if(EngineOilPressureTimer1 >= 100)
            {
                LED_STATE = 1u;
                led_state_old = 1u;
            }
            else
            {
                EngineOilPressureTimer1++;
                if(led_state_old == 0)
                {
                    LED_STATE = 2u;
                }
                else if(led_state_old == 1)
                {
                    LED_STATE = 1u;
                }
                else
                {
                    LED_STATE = FLASH_SYNC_1Hz;
                }
            }
        }
        else if((m_Condition1 >= (Get_EngineOilPressure_Threshold_Low() + 20)) && (m_Condition1 <= (Get_EngineOilPressure_Threshold_High() - 20)))
        {
            EngineOilPressureTimer1 = 0u;
            LED_STATE = 2u;
            led_state_old = 0u;
        }
        else
        {
            if(led_state_old == 1)
            {
                LED_STATE = 1u;
                led_state_old = 1u;
            }
            else
            {
                LED_STATE = 2u;
                led_state_old = 0u;
            }
        }
    }
    else
    {
        EngineOilPressureTimer1 = 0u;
        LED_STATE = FLASH_SYNC_1Hz;
        led_state_old = 2u;
    }

    /*判断当前是否为闪烁和长亮状态*/
    if((led_state_old == 2u) || (led_state_old == 1u))
    {
        EngineOilPressure_Flash_status = 1u;
    }
    else
    {
        EngineOilPressure_Flash_status = 0u;
    }
    /*判断当前是否为长亮状态*/
    if(led_state_old == 1u)
    {
        EngineOilPressure_bright_status = 1u;
    }
    else
    {
        EngineOilPressure_bright_status = 0u;
    }
    return LED_STATE;
}

Tellib_uint16_t Get_EngineOilPressure_Flash_status(void)
{
    return EngineOilPressure_Flash_status;
}

Tellib_uint16_t Get_EngineOilPressure_bright_status(void)
{
    return EngineOilPressure_bright_status;
}

/*尿素液位低液晶屏表头报警,黄灯*/
/*0灭，1亮，2白灯*/
static Tellib_uint16_t LED_DEFHigh_Y_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint16_t m_Condition1 = 0u;
    static Tellib_uint16_t led_state_old = 0u;
    static Tellib_uint16_t led_state_status = 0u;
    if((Get_Stater_Type() == WEICHAI) || (Get_Stater_Type() == SHANGCHAI) || (Get_Stater_Type() == YUNNEI) || 
       (Get_Stater_Type() == YUCHAI) || (Get_Stater_Type() == LUOTUO))
    {
        led_state_status = 0;
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_AT1TI1_00_Msg_Count) == CAN_SIG_NORMAL)
        {
            m_Condition1 = Get_CAN_CH0_ID_18FE5600_Sig_AdBlueLevel();
            m_Condition1 *= 4;
            // m_Condition1 /= 10;
            if(m_Condition1 <= Get_Urea_Threshold_Low())
            {
                LED_STATE = 1u;
                led_state_old = 1u;
            }
            else if(m_Condition1 >= Get_Urea_Threshold_Low() + 20)
            {
                LED_STATE = 2u;
                led_state_old = 0u;
            }
            else
            {
                if(led_state_old == 1)
                {
                    LED_STATE = 1u;
                }
                else
                {
                    LED_STATE = 2u;
                    led_state_old = 0u;
                }
            }
        }
        else
        {
            LED_STATE = FLASH_SYNC_1Hz;
            led_state_old = 2u;
        }
    }
    else if(Get_Stater_Type() == KANGMINGSI)
    {
        led_state_old = 0u;
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_AT1TI1_00_Msg_Count) == CAN_SIG_NORMAL)
        {
            if(Get_CAN_CH0_ID_18FE5600_Sig_DEFHighResistance() == 1u)
            {
                LED_STATE = 1u;
                led_state_status = 1u;
            }
            else if(Get_CAN_CH0_ID_18FE5600_Sig_DEFHighResistance() == 4u)
            {
                LED_STATE = FLASH_SYNC_1Hz;
                led_state_status = 2u;
            }
            else
            {
                LED_STATE = 2u;
                led_state_status = 0u;
            }
        }
        else
        {
            LED_STATE = FLASH_SYNC_1Hz;
            led_state_status = 2u;
        }
    }
    else
    {
        LED_STATE = 2u;
        led_state_old = 0u;
        led_state_status = 0u;
    }
    
    /*判断当前是否为长亮状态*/
    if((led_state_old == 1u) || (led_state_status == 1u))
    {
        DEFHigh_Flash_status = 1u;
    }
    else
    {
        DEFHigh_Flash_status = 0u;
    }
    return LED_STATE;
}

Tellib_uint16_t Get_DEFHigh_Flash_status(void)
{
    return DEFHigh_Flash_status;
}

/*尿素液位低液晶屏表头报警,黄灯*/
// static Tellib_uint16_t LED_DEFHigh_Y_Judge(void)
// {
//     Tellib_uint16_t LED_STATE = 0u;
//     if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_AT1TI1_00_Msg_Count) == CAN_SIG_NORMAL)
//     {
//         if(Get_CAN_CH0_ID_18FE5600_Sig_DEFHighResistance() == 0x1)
//         {
//             LED_STATE = 1;
//         }
//         else if(Get_CAN_CH0_ID_18FE5600_Sig_DEFHighResistance() == 0x4)
//         {
//             LED_STATE = FLASH_SYNC_1Hz;
//         }
//         else
//         {
//             LED_STATE = 0;
//         }
//     }
//     else
//     {
//         LED_STATE = FLASH_SYNC_1Hz;
//     }
//     return LED_STATE;
// }

/*燃油液位低*/
/*0灭，1亮，2白灯*/
static Tellib_uint16_t LED_EldingLevelPercent_Judge(void)
{
    static Tellib_uint8_t LED_STATE = 0u;
    static Tellib_uint8_t led_state_old = 0u;            // 0白  1亮  2闪烁
    static Tellib_uint8_t pTimer2 = 0u; 
    static Tellib_uint8_t pTimer1 = 0u;                  //错误状态延时判断
    Tellib_uint16_t EldingLevel_Low = 0u;          //燃料液位低阈值配置  液位
    Tellib_uint16_t EldingLevel_Low_hysteresis = 0u;  //燃料液位低阈值配置回滞  液位
    Tellib_uint16_t EldingLevel_Low_AD = 0u;  //AD采集电阻对应的液位
    EldingLevel_Low = Get_EldingLevel_Low();
    EldingLevel_Low_hysteresis = Get_EldingLevel_Low() + 50;
    EldingLevel_Low_AD = Get_EldingLevel_status();
    if(EldingLevel_Low_AD > 1000u)     // 错误
    {
        if(pTimer1 >= 200u)
        {
            LED_STATE = FLASH_SYNC_1Hz;
            led_state_old = 2u;
        }
        else
        {
            pTimer1++;
            if(led_state_old == 2u)
            {
                LED_STATE = FLASH_SYNC_1Hz;
            }
            else if(led_state_old == 1u)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 2u;
            }
        }
        pTimer2 = 0u;
    }
    else if(EldingLevel_Low_AD >= EldingLevel_Low_hysteresis)      //
    {
        LED_STATE = 2;
        led_state_old = 0;
        pTimer2 = 0u;
        pTimer1 = 0u;
    }
    else if(EldingLevel_Low_AD > EldingLevel_Low)   //回滞
    {
        if(led_state_old == 1)
        {
            LED_STATE = 1;
            led_state_old = 1;
        }
        else
        {
            LED_STATE = 2;
            led_state_old = 0;
        }
        pTimer2 = 0u;
        pTimer1 = 0u;
    }
    else
    {   
        if(pTimer2 >= 100u)
        {
            LED_STATE = 1;
            led_state_old = 1;
        }
        else
        {
            if(led_state_old == 2u)
            {
                LED_STATE = FLASH_SYNC_1Hz;
            }
            else if(led_state_old == 1u)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 2u;
            }
            pTimer2++;
        }
        pTimer1 = 0u;
    }

    /*判断当前是否为闪烁及点亮状态*/
    if((led_state_old == 2) || (led_state_old == 1u))
    {
        EldingLevelPercent_Flash_status = 1u;
    }
    else
    {
        EldingLevelPercent_Flash_status = 0u;
    }
    /*判断当前是否为点亮状态*/
    if((led_state_old == 1u))
    {
        EldingLevelPercent_bright_status = 1u;
    }
    else
    {
        EldingLevelPercent_bright_status = 0u;
    }
    return LED_STATE;
}

Tellib_uint16_t Get_EldingLevelPercent_Flash_status(void)
{
    return EldingLevelPercent_Flash_status;
}

Tellib_uint16_t Get_EldingLevelPercent_bright_status(void)
{
    return EldingLevelPercent_bright_status;
}
/*桥滤清器堵塞报警灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_Bridge_filter_blocked_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(Line_In_Get_Status(LINE_IN_Bridge_filter_blocked) == 1u)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*轮间差速锁止信号灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_Wheel_differential_lock_signal(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(Line_In_Get_Status(LINE_IN_Wheel_differential_lock_signal) == 1u)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*液压油滤堵塞信号灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_Hydraulic_oil_filter_blockage_signal(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(Line_In_Get_Status(LINE_IN_Hydraulic_oil_filter_blockage_signal) == 1u)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*散热油滤堵塞指示灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_Radiating_Oil_Filter_Blocked(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(Line_In_Get_Status(LINE_IN_Radiating_Oil_Filter_Blocked) == 1u)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*FNR指示灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_FNR_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint8_t condition1 = 0u;
    Tellib_uint8_t condition2 = 0u;
    Tellib_uint8_t condition3 = 0u;
    Tellib_uint8_t condition4 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF32_Msg_Count) == CAN_SIG_NORMAL);
    condition3 = (Get_CAN_CH0_ID_18FF4421_Sig_FNRIndication());
    condition4 = (Get_CAN_CH0_ID_18FF3203_Sig_FNRIndicator());
    if((condition1 && condition3) || (condition2 && condition4))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*变速箱故障指示灯液晶屏*/
/*0灭，1亮*/
static Tellib_uint16_t  LED_LCD_Transmission_failure_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint8_t condition1 = 0u;
    Tellib_uint8_t condition2 = 0u;
    Tellib_uint8_t condition3 = 0u;
    Tellib_uint8_t condition4 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_DM1_AMT_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FECA03_Sig_RedWarningLampStatus() == 1);
    condition3 = (Line_In_Get_Status(LINE_IN_LCD_Transmission_failure_H) == 1u);      //变速箱故障指示灯液晶屏   高配置
    condition4 = (Line_In_Get_Status(LINE_IN_LCD_Transmission_failure_L) == 1u);      //变速箱故障指示灯液晶屏   低配置
    if(Val_EOL_0300_Transmission_Failure() == 1)
    {
        if((condition1 && condition2) || (condition3))
        {
            LED_STATE = 1u;
        }
        else 
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        if((condition1 && condition2) || (condition4))
        {
            LED_STATE = 1u;
        }
        else 
        {
            LED_STATE = 0u;
        }
    }
    return LED_STATE;
}

/*动臂定位指示灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_MovableArmAuto_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint8_t condition1 = 0u;
    Tellib_uint8_t condition2 = 0u;
    condition1 = (Get_CAN_CH0_ID_18FF4421_Sig_MovableArmAutoDown());
    condition2 = (Get_CAN_CH0_ID_18FF4421_Sig_MovableArmAutoRise());
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL)
    {
        if((condition1) || (condition2))
        {
            LED_STATE = 1u;
        }
        else 
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*铲斗定位指示灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_BucketAuto_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint8_t condition1 = 0u;
    Tellib_uint8_t condition2 = 0u;
    condition1 = (Get_CAN_CH0_ID_18FF4421_Sig_BucketAutoFlip());
    condition2 = (Get_CAN_CH0_ID_18FF4421_Sig_BucketAutoReturn());
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL)
    {
        if((condition1) || (condition2))
        {
            LED_STATE = 1u;
        }
        else 
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*平动举升指示灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_TheTranslationalLift_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL)
    {
        if((Get_CAN_CH0_ID_18FF4421_Sig_TheTranslationalLifting()) == 1)
        {
            LED_STATE = 1u;
        }
        else 
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*动臂微动指示灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_MovableArmInch_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL)
    {
        if((Get_CAN_CH0_ID_18FF4421_Sig_MovableArmInching()) == 1)
        {
            LED_STATE = 1u;
        }
        else 
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*机具快换未锁指示灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_MachineQuickChange_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint8_t condition1 = 0u;
    Tellib_uint8_t condition2 = 0u;
    Tellib_uint8_t condition3 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = ((Get_CAN_CH0_ID_18FF4421_Sig_MachineQuickChange()) == 2u);
    condition3 = (Line_In_Get_Status(LINE_IN_Machine_Quick_Change) == 1u);
    if(((condition1) && (condition2)) || (condition3))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*机具快换锁止指示灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_MachineQuickChangeFinish_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL)
    {
        if((Get_CAN_CH0_ID_18FF4421_Sig_MachineQuickChange()) == 1)
        {
            LED_STATE = 1u;
        }
        else 
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*燃油经济性指示灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_FuelEconomy_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint8_t condition1 = 0u;
    Tellib_uint8_t condition2 = 0u;
    Tellib_uint8_t condition3 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = ((Get_CAN_CH0_ID_18FF4421_Sig_ECO()) == 1u);
    condition3 = (Line_In_Get_Status(LINE_IN_Fuel_Economy) == 1u);
    if(((condition1) && (condition2)) || (condition3))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*再生指示灯  红*/
/*0灭，1亮*/
static Tellib_uint16_t LED_DPFLampCommand_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if((Get_Stater_Type() == WEICHAI) || (Get_Stater_Type() == SHANGCHAI))
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_DPFC_Msg_Count) == CAN_SIG_NORMAL)
        {
            if((Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampCommand()) == 2)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 0u;
            }
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else if((Get_Stater_Type() == KANGMINGSI) || (Get_Stater_Type() == YUNNEI) || (Get_Stater_Type() == YUCHAI))
    {
        LED_STATE = 0u;
    }
    else if(Get_Stater_Type() == LUOTUO)
    {
        LED_STATE = 0u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*再生指示灯  黄*/
/*0灭，1亮 ，2闪烁1Hz , 3闪烁2Hz*/
static Tellib_uint16_t LED_DPFLampCommand_Y_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if((Get_Stater_Type() == WEICHAI) || (Get_Stater_Type() == SHANGCHAI))
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_DPFC_Msg_Count) == CAN_SIG_NORMAL)
        {
            if((Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampCommand()) == 1)
            {
                LED_STATE = 1u;
            }
            else if((Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampCommand()) == 4)
            {
                LED_STATE = 2u;
            }
            else
            {
                LED_STATE = 0u;
            }
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else if((Get_Stater_Type() == KANGMINGSI) || (Get_Stater_Type() == YUNNEI) || (Get_Stater_Type() == YUCHAI))
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_DPFC_Msg_Count) == CAN_SIG_NORMAL)
        {
            if((Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampCommand()) == 1)
            {
                LED_STATE = 1u;
            }
            else if((Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampCommand()) == 2)
            {
                LED_STATE = 2u;
            }
            else if((Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampCommand()) == 4)
            {
                LED_STATE = 3u;
            }
            else
            {
                LED_STATE = 0u;
            }
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else if(Get_Stater_Type() == LUOTUO)
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_DPFC_Msg_Count) == CAN_SIG_NORMAL)
        {
            if((Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampCommand()) == 1)
            {
                LED_STATE = 2u;
            }
            else if((Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampCommand()) == 2)
            {
                LED_STATE = 3u;
            }
            else if((Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampCommand()) == 3)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 0u;
            }
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*再生指示灯  绿*/
/*0灭，1亮*/
static Tellib_uint16_t LED_DPFLampCommand_G_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if((Get_Stater_Type() == WEICHAI) || (Get_Stater_Type() == SHANGCHAI))
    {
        LED_STATE = 0u;
    }
    else if((Get_Stater_Type() == KANGMINGSI) || (Get_Stater_Type() == YUNNEI) || (Get_Stater_Type() == YUCHAI))
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_DPFC_Msg_Count) == CAN_SIG_NORMAL)
        {
            if((Get_CAN_CH0_ID_18FD7C00_Sig_AftertreatDieselPartiFilterPas()) == 1)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 0u;
            }
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else if(Get_Stater_Type() == LUOTUO)
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_DPFC_Msg_Count) == CAN_SIG_NORMAL)
        {
            if((Get_CAN_CH0_ID_18FD7C00_Sig_AftertreatDieselPartiFilterPas()) == 1)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 0u;
            }
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    if((Get_TelltalesLedSts(m_LED_DPFLampCommand_R) == 1) || ((Get_TelltalesLedSts(m_LED_DPFLampCommand_Y) >= 1) && (Get_TelltalesLedSts(m_LED_DPFLampCommand_Y) <= 3))) 
    {
        LED_STATE = 0u;
    }
    else
    {

    }
    return LED_STATE;
}

/*禁止再生指示灯  红*/
/*0灭，1亮*/
static Tellib_uint16_t LED_ForbidDPFLampCommand_R_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if((Get_Stater_Type() == WEICHAI) || (Get_Stater_Type() == SHANGCHAI))
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_DPFC_Msg_Count) == CAN_SIG_NORMAL)
        {
            if((Get_CAN_CH0_ID_18FD7C00_Sig_ForbiddenRegenerationIndictor()) == 1)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 0u;
            }
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else if((Get_Stater_Type() == KANGMINGSI) || (Get_Stater_Type() == YUNNEI) || (Get_Stater_Type() == YUCHAI))
    {
        LED_STATE = 0u;
    }
    else if(Get_Stater_Type() == LUOTUO)
    {
        LED_STATE = 0u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*禁止再生指示灯  黄*/
/*0灭，1亮*/
static Tellib_uint16_t LED_ForbidDPFLampCommand_Y_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if((Get_Stater_Type() == WEICHAI) || (Get_Stater_Type() == SHANGCHAI))
    {
        LED_STATE = 0u;
    }
    else if((Get_Stater_Type() == KANGMINGSI) || (Get_Stater_Type() == YUNNEI) || (Get_Stater_Type() == YUCHAI))
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_DPFC_Msg_Count) == CAN_SIG_NORMAL)
        {
            if((Get_CAN_CH0_ID_18FD7C00_Sig_ForbiddenRegenDuetoSysFaultAc()) == 1)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 0u;
            }
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else if(Get_Stater_Type() == LUOTUO)
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_DPFC_Msg_Count) == CAN_SIG_NORMAL)
        {
            if((Get_CAN_CH0_ID_18FD7C00_Sig_ForbiddenRegenerationDueto()) == 1)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 0u;
            }
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    if(Get_TelltalesLedSts(m_LED_ForbidDPFLampCommand_R) == 1)
    {
        LED_STATE = 0u;
    }
    else
    {

    }
    return LED_STATE;
}

/*MIL排放灯*/
/*0灭，1亮, 2闪烁1Hz， 3闪烁2Hz*/
static Tellib_uint16_t LED_MIL_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if((Get_Stater_Type() == WEICHAI) || (Get_Stater_Type() == SHANGCHAI) || (Get_Stater_Type() == YUNNEI) || (Get_Stater_Type() == YUCHAI))
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_DM1_ECU_Msg_Count) == CAN_SIG_NORMAL)
        {
            if((Get_CAN_CH0_ID_18FECA00_Sig_FlashMalfuctionIndicatorLamp()) == 1)
            {
                LED_STATE = 3u;
            }
            else if((Get_CAN_CH0_ID_18FECA00_Sig_FlashMalfuctionIndicatorLamp()) == 0)
            {
                LED_STATE = 2u;               
            }
            else
            {
                if((Get_CAN_CH0_ID_18FECA00_Sig_MalfuctionIndicatorLampStatus()) == 1)
                {
                    LED_STATE = 1u;
                }
                else
                {
                    LED_STATE = 0u;
                }
            }
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_Buzzer_Shielding_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(g_RightKeyLONGPRESS == 0u)
    {
        LED_STATE = 0u;
    }
    else
    {
        LED_STATE = 1u;
    }
    return LED_STATE;
}
static Tellib_uint16_t LED_Remote_Lock_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    /*逻辑暂时不写*/
    return LED_STATE;
}

/*液压锁状态指示灯  图标1*/
/*0灭，1亮*/
static Tellib_uint16_t LED_HydraulicLockStatus_One_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF41_Msg_Count) == CAN_SIG_NORMAL)
    {
        if((Get_CAN_CH0_ID_18FF4121_Sig_HydraulicLockStatus()) == 0u)
        {
            LED_STATE = 1u;
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*液压锁状态指示灯  图标2*/
/*0灭，1亮*/
static Tellib_uint16_t LED_HydraulicLockStatus_Two_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF41_Msg_Count) == CAN_SIG_NORMAL)
    {
        if((Get_CAN_CH0_ID_18FF4121_Sig_HydraulicLockStatus()) == 1u)
        {
            LED_STATE = 1u;
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*自动换挡指示灯*/
/*0灭，1亮*/
static Tellib_uint16_t LED_AutoShiftGear_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint16_t condition1 = 0u;
    Tellib_uint16_t condition2 = 0u;
    Tellib_uint16_t condition3 = 0u;
    Tellib_uint16_t condition4 = 0u;
    Tellib_uint16_t condition5 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF32_Msg_Count) == CAN_SIG_NORMAL);
    condition3 = (Get_CAN_CH0_ID_18FF4421_Sig_AutoShiftGear());
    condition4 = (Get_CAN_CH0_ID_18FF3203_Sig_AutoShiftGear());
    condition5 = ((Line_In_Get_Status(LINE_IN_Auto_Shift_Gear) == 1u));  //高配置
    if(((condition1) && (condition3)) || ((condition2) && (condition4)) || (condition5))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*变速箱油滤堵塞*/
/*0灭，1亮*/
static Tellib_uint16_t LED_TransmissionOilFilterBlocked_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint16_t condition1 = 0u;
    Tellib_uint16_t condition2 = 0u;
    Tellib_uint16_t condition3 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_FF32_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FF3203_Sig_TransmissionOilFilterBlocked());
    condition3 = ((Line_In_Get_Status(LINE_IN_Transmission_Oil_Filter_Blocked) == 1u));  //高配置
    if(((condition1) && (condition2)) || (condition3))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return 0;
}

/*发动机预热*/
/*0灭，1亮*/
static Tellib_uint16_t LED_EngineWaittoStartLamp_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint16_t condition1 = 0u;
    Tellib_uint16_t condition2 = 0u;
    Tellib_uint16_t condition3 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_Shutdown_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FEE400_Sig_EngineWaittoStartLamp() == 1u);
    condition3 = ((Line_In_Get_Status(LINE_IN_Engine_Waitto_StartP_Lamp) == 1u));  //高配置
    if(((condition1) && (condition2)) || (condition3))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return 0;
}

/*故障报警灯  红*/
/*0灭，1亮*/
static Tellib_uint16_t LED_RedWarningLampStatus_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_DM1_BCU_Msg_Count) == CAN_SIG_NORMAL)
    {
        if(Get_CAN_CH0_ID_18FECA21_Sig_RedWarningLampStatus() == 1u)
        {
            LED_STATE = 1u;
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

/*故障报警灯  黄*/
/*0灭，1亮*/
static Tellib_uint16_t LED_YellowWarningLampStatus_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint16_t condition1 = 0u;
    Tellib_uint16_t condition2 = 0u;
    Tellib_uint16_t condition3 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_DM1_BCU_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FECA21_Sig_ProtectLampStatus() == 1u);
    condition3 = ((Line_In_Get_Status(LINE_IN_Yellow_Warning_Lamp_Status) == 1u));  //高有效配置
    if((condition1 && condition2) || (condition3))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    if(Get_TelltalesLedSts(m_LED_RedWarningLampStatus) == 1u)   //红色优先
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

// /*左转向*/
// static Tellib_uint16_t LED_Left_Judge(void)
// {
//     Tellib_uint16_t LED_STATE = 0u;
//     if(Line_In_Get_Status(lINE_IN_LEFT) == 1)
//     {
//         LED_STATE = 1u;
//     }
//     else
//     {
//         LED_STATE = 0u;
//     }
//     return LED_STATE;
// }

// /*右转向*/
// static Tellib_uint16_t LED_Right_Judge(void)
// {
//     Tellib_uint16_t LED_STATE = 0u;
//     if(Line_In_Get_Status(LINE_IN_RIGHT) == 1)
//     {
//         LED_STATE = 1u;
//     }
//     else
//     {
//         LED_STATE = 0u;
//     }
//     return LED_STATE;
// }

/*小灯*/
Tellib_uint16_t LED_Lamplet_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(Line_In_Get_Status(LINE_IN_LAMPLET) == 1)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static void LED_Lamplet_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
        GPIO_SET_LED_PORTLET_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Lamplet));
    }
    else
    {
        GPIO_SET_LED_PORTLET_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Lamplet));
    }
}

/*充电指示灯*/
static Tellib_uint16_t LED_Charge_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(Line_In_Get_Status(LINE_IN_CHARGE1) == 1)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static void LED_Charge_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
        GPIO_SET_LED_CHARGE_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Lamplet));
    }
    else
    {
        GPIO_SET_LED_CHARGE_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Lamplet));
    }
}

/*驻车制动灯*/
static Tellib_uint16_t LED_Parking_Braking_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if(Line_In_Get_Status(LINE_IN_PARKING_BRAKING1) == 1)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static void LED_Parking_Braking_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
        GPIO_SET_LED_PARKING_BRAKING_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Lamplet));
    }
    else
    {
        GPIO_SET_LED_PARKING_BRAKING_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Lamplet));
    }
}

void Telltales_Left_Right_Management_Service(void) // 10ms
{
    uint8_t Edge;
    uint8_t Cause_Left = 0U;
    uint8_t Cause_Right = 0U;
    uint8_t Left_Lamp;
    uint8_t Right_Lamp;
    static uint8_t L_Back = 0u;
    static uint8_t R_Back = 0u;
    Edge = 0xFF;
    if((Get_HMI_SelfCheck_Timer() <= 3000ul) || (Remote_Start_Signal( ) == 1u))
    {                     
        GPIO_SET_LED_Turn_L_G_LAMP(LED_LAMP_OPEN);
        GPIO_SET_LED_Turn_R_G_LAMP(LED_LAMP_OPEN);
    }
    else
    {
        Left_Lamp = Line_In_Get_Status(lINE_IN_LEFT);
        Right_Lamp = Line_In_Get_Status(LINE_IN_RIGHT);

        // if (TelltaleLRCtrl.LastLeft != Left_Lamp)
        // {
        //     if (Left_Lamp == 1u)
        //     {
        //         TelltaleLRCtrl.LastLeft = 1u;
        //         L_Back = 1u;
        //     }
        //     else
        //     {
        //         TelltaleLRCtrl.LastLeft = 0u;
        //     }

        //     if (Left_Lamp == 1u)
        //     {
        //         Edge = 1u;
        //     }
        //     else
        //     {
        //         if (L_Back == 1u)
        //         {
        //             Edge = 0u;
        //             L_Back = 0u;
        //         }
        //     }
        //     Cause_Left = 1U;
        //     TelltaleLRCtrl.LastLeft = Left_Lamp;
        // }

        if (Left_Lamp == 1)
        {
            GPIO_SET_LED_Turn_L_G_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
            L_Back = 1u;
        }
        else
        {
            GPIO_SET_LED_Turn_L_G_LAMP(LED_LAMP_CLOSE);
        }

        if (Right_Lamp == 1u)
        {
            GPIO_SET_LED_Turn_R_G_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_R));
            R_Back = 1u;
        }
        else
        {
            GPIO_SET_LED_Turn_R_G_LAMP(LED_LAMP_CLOSE);
        }

        // if((Right_Lamp == 1) || (Left_Lamp == 1))  //声音报警
        // {
        //     PWM_Channel_Set_Duty(15, 900);
        // }
        // else 
        // {
        //     PWM_Channel_Set_Duty(15, 0);
        // }

        // if (TelltaleLRCtrl.LastRight != Right_Lamp)
        // {
        //     if (Right_Lamp == 1u)
        //     {
        //         TelltaleLRCtrl.LastRight = 1u;
        //         R_Back = 1u;
        //     }
        //     else
        //     {
        //         TelltaleLRCtrl.LastRight = 0u;
        //     }

        //     if (Right_Lamp == 1u)
        //     {
        //         Edge = 1u;
        //     }
        //     else
        //     {
        //         if (R_Back == 1u)
        //         {
        //             Edge = 0u;
        //             R_Back = 0u;
        //         }
        //     }
        //     Cause_Right = 1U;
        //     TelltaleLRCtrl.LastRight = Right_Lamp;
        // }

        // if (TelltaleLRCtrl.Delay)
        // {
        //     TelltaleLRCtrl.Delay--;
        // }
        // else
        // {
            // if (Edge != 0xFF)
            // {
            //     if (Edge)
            //     {
            //         PWM_Channel_Set_Duty(15, 900);
            //         // Sound_Request(SRC_SRC_TICK1_252729, 1);
            //     }
            //     else
            //     {
            //         PWM_Channel_Set_Duty(15, 900);
            //         // Sound_Request(SRC_SRC_TOCK1_262830, 1);
            //     }
            //     // TelltaleLRCtrl.Delay = 6; // 100ms内不不可连续触发
            // }
            // else
            // {
            //     PWM_Channel_Set_Duty(15, 0);
            //     // Sound_Delete(SRC_SRC_TICK1_252729);
            //     // Sound_Delete(SRC_SRC_TOCK1_262830);
            // }
        // }
    }
}


/*电池电压报警*/
/*
0：白色
1：红色
*/
static Tellib_uint16_t LED_Battery_Voltage_Judge(void)
{
    Tellib_uint16_t LED_STATE = 2u;
    static Tellib_uint8_t led_state_old = 0u;
    static Tellib_uint8_t battery_timer_H = 0u;
    static Tellib_uint8_t battery_timer_L = 0u;
    Tellib_uint32_t Battery_voltage = 0u;
    Tellib_uint32_t disposition_H = (Get_Voltage_Threshold_High() * 100);
    Tellib_uint32_t disposition_L = (Get_Voltage_Threshold_Low() * 100);
    Battery_voltage = ADC_Read_Signal(ADC_CH_KL30_VOLTAGE);
    if(Battery_voltage >= disposition_H)
    {
        battery_timer_L = 0u;
        if(battery_timer_H >= 100)
        {
            LED_STATE = 1u;
            led_state_old = 1u;
        }
        else
        {
            if(led_state_old == 2)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 2u;
            }
            battery_timer_H++;
        }
    }
    else if(Battery_voltage > (disposition_H - 500))
    {
        battery_timer_L = 0u;
        if(led_state_old == 1)
        {
            LED_STATE = 1u;
            led_state_old = 1u;
        }
        else
        {
            LED_STATE = 2u;
            led_state_old = 0u;
        }
    }
    else if(Battery_voltage >= (disposition_L + 500))
    {
        battery_timer_H = 0u;
        battery_timer_L = 0u;
        LED_STATE = 2u;
        led_state_old = 0u;
    }
    else if(Battery_voltage > disposition_L)
    {
        battery_timer_H = 0u;
        if(led_state_old == 2)
        {
            LED_STATE = 1u;
        }
        else
        {
            LED_STATE = 2u;
            led_state_old = 0u;
        }
    }
    else
    {
        battery_timer_H = 0u;
        if(battery_timer_L >= 100)
        {
            LED_STATE = 1u;
            led_state_old = 2u;
        }
        else
        {
            if(led_state_old == 1)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 2u;
            }
            battery_timer_L++;
        }
    }
    return LED_STATE;
}

/*制动压力报警*/
/*0灭，1亮，0xff闪烁,2白灯*/
static Tellib_uint16_t LED_Brake_Pressure(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    Tellib_uint16_t Configuration1 = 0u;
    Tellib_uint16_t Configuration2 = 0u;
    Configuration1 = Val_EOL_0300_LCD_Left_Small_Gauge_Configuration();     //配置2湿式制动表或1制动气压表
    Configuration2 = Val_EOL_0300_LCD_Left_Bar_Graph_Gauge_Configuration(); //配置3制动气压表
    if (Configuration1 == 1 || Configuration2 == 3)
    {
        LED_STATE = Get_Brake_Pressure_Service();
    }
    else
    {
        if (Configuration1 == 2)
        {
            LED_STATE = Get_Wet_Brake_Pressure_Service();
        }
    }

    return LED_STATE;
}

/*制动压力报警闪烁标志位*/
/*0非闪烁状态，1闪烁*/
Tellib_uint16_t Get_Brake_Pressure_Flash_status(void)
{
    Tellib_uint16_t Flash_status = 0;
    Tellib_uint16_t Configuration1 = 0u;
    Tellib_uint16_t Configuration2 = 0u;
    Configuration1 = Val_EOL_0300_LCD_Left_Small_Gauge_Configuration();
    Configuration2 = Val_EOL_0300_LCD_Left_Bar_Graph_Gauge_Configuration();
    if (Configuration1 == 1 || Configuration2 == 3)
    {
        Flash_status = Get_Brake_Pressure_status();
    }
    else
    {
        if (Configuration1 == 2)
        {
            Flash_status = Get_Wet_Brake_Pressure_status();
        }
    }
    return  Flash_status;
}

static void LED_Brake_Pressure_Exec(Tellib_uint16_t led_status)
{
    if (led_status == 1)
    {
        GPIO_SET_LED_BRAKE_PRESSURE_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Lamplet));
    }
    else
    {
        GPIO_SET_LED_BRAKE_PRESSURE_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Lamplet));
    }
}


/*变速箱油压-左侧柱状表报警灯*/
/*高阈值24bar，低阈值16bar*/
/*LED_STATE 0灭 1亮 2白*/
static Tellib_uint16_t LED_Transmission_Oil_Pressure(void)
{
    static Tellib_uint16_t LED_STATE = 0u;
    static Tellib_uint16_t LED_STATE_old = 0u; // 0白 1亮 2闪烁
    Tellib_uint32_t Transmission_Oil_Pressure_High = 0u;    //变速箱油压高阈值配置  
    Tellib_uint32_t Transmission_Oil_Pressure_Low  = 0u;    //变速箱油压低阈值配置 
    static Tellib_uint16_t Time_High = 0u;                    //高阈值配置持续时间
    static Tellib_uint16_t Time_Low = 0u;                     //低阈值配置持续时间
    Tellib_uint32_t Transmission_Oil_Pressure = 0u;  //输入油压
    Transmission_Oil_Pressure = Get_TransmissionOilPressure();
    Transmission_Oil_Pressure_High = Get_TransmissionOilPressure_High();
    Transmission_Oil_Pressure_Low =  Get_TransmissionOilPressure_Low();
    if(Transmission_Oil_Pressure >= 1000000u)      //错误
    {
        LED_STATE = FLASH_SYNC_1Hz;
        LED_STATE_old = 2u;
        Time_High = 0u;  
        Time_Low = 0u;
    }
    else if(Transmission_Oil_Pressure <= Transmission_Oil_Pressure_Low)
    {
        if(Time_Low >= 100u)
        {
            LED_STATE = 1u;
            LED_STATE_old = 1u;
        }
        else
        {
            Time_Low++;
            if(LED_STATE_old == 2u)
            {
                LED_STATE = FLASH_SYNC_1Hz;
            }
            else if(LED_STATE_old == 1u)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 2u;
            }
        }
        Time_High = 0u;
    }
    else if(Transmission_Oil_Pressure < Transmission_Oil_Pressure_High)
    {
        LED_STATE = 2;
        LED_STATE_old = 0u;
        Time_High = 0u;  
        Time_Low = 0u;
    }
    else if(Transmission_Oil_Pressure >= Transmission_Oil_Pressure_High)
    {
        if(Time_High >= 100u)
        {
            LED_STATE = 1u;
            LED_STATE_old = 1u;
        }
        else
        {
            Time_High++;
            if(LED_STATE_old == 2u)
            {
                LED_STATE = FLASH_SYNC_1Hz;
            }
            else if(LED_STATE_old == 1u)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 2u;
            }
        }
        Time_Low = 0u;
    }
    if((LED_STATE_old == 1u) || (LED_STATE_old == 2u))  //判断灯是否为点亮及闪烁
    {
        TransmissionOilPressureStatus = 1u;
    }
    else
    {
        TransmissionOilPressureStatus = 0u;
    }
    if((LED_STATE_old == 1u))  //判断灯是否为点亮
    {
        TransmissionOilPressureStatus_bright_status = 1u;
    }
    else
    {
        TransmissionOilPressureStatus_bright_status = 0u;
    }
    return LED_STATE;
}

Tellib_uint16_t Get_TransmissionOilPressure_Status(void)  //变速箱油压灯的状态  点亮及闪烁
{
    return TransmissionOilPressureStatus;
}

Tellib_uint16_t Get_TransmissionOilPressure_bright_Status(void)  //变速箱油压灯的状态  点亮
{
    return TransmissionOilPressureStatus_bright_status;
}

/*液压油温报警*/
/*LED_STATE 0灭 1亮 2白*/
static Tellib_uint16_t LED_Hydraulic_Oil_Temperature(void)
{
    static Tellib_uint16_t LED_STATE = 0u;
    static Tellib_uint16_t LED_STATE_old = 0u; // 0白 1亮 2闪烁
    static Tellib_uint16_t Time = 0u;                    //高阈值配置持续时间
    Tellib_uint32_t High_Hhreshold = 0u;   //高阈值温度
    Tellib_uint32_t High_Hhreshold_Hysteresis = 0u;  //高阈值温度-3  回滞
    Tellib_uint32_t Hhreshold_Hysteresis_Temperature = 0u;  //由电阻值得到的温度
    Hhreshold_Hysteresis_Temperature = Get_Hydraulic_Oil_Resistance_Temperature();
    High_Hhreshold = Get_Hydraulic_Oil_Temperature_High();
    High_Hhreshold_Hysteresis = (Get_Hydraulic_Oil_Temperature_High() - 3);
    if(Hhreshold_Hysteresis_Temperature > 120u)  //错误状态
    {
        LED_STATE = FLASH_SYNC_1Hz;
        LED_STATE_old = 2u;
        Time = 0u;
    }
    else if(Hhreshold_Hysteresis_Temperature >= High_Hhreshold)  //大于等于高阈值配置
    {
        if(Time >= 100u)
        {
            LED_STATE = 1u;
            LED_STATE_old = 1u;
        }
        else
        {
            if(LED_STATE_old == 2u)
            {
                LED_STATE = FLASH_SYNC_1Hz;
            }
            else if(LED_STATE_old == 1u)
            {
                LED_STATE = 1;
            }
            else
            {
                LED_STATE = 2;
            }
            Time++;
        }
    }
    else if(Hhreshold_Hysteresis_Temperature >= High_Hhreshold_Hysteresis)  //回滞
    {
        if(LED_STATE_old == 0u)
        {
            LED_STATE = 2u;
        }
        else
        {
            LED_STATE = 1u;
            LED_STATE_old = 1u;
        }
        Time = 0u;
    }
    else                             //小于高阈值配置-3
    {
        LED_STATE = 2u;
        LED_STATE_old = 0u;
        Time = 0u;
    }
    if((LED_STATE_old == 1u) || (LED_STATE_old == 2u))  //点亮及闪烁
    {
        LED_HydraulicOilTemperatureHigh_State = 1u;
    }
    else
    {
        LED_HydraulicOilTemperatureHigh_State = 0u;
    }
    if((LED_STATE_old == 1u))                          //点亮
    {
        LED_HydraulicOilTemperatureHigh_bright_State = 1u;
    }
    else
    {
        LED_HydraulicOilTemperatureHigh_bright_State = 0u;
    }
    return LED_STATE;
}

Tellib_uint16_t Get_HydraulicOilTemperatureHigh_Status(void)  
{
    return LED_HydraulicOilTemperatureHigh_State;
}

Tellib_uint16_t Get_HydraulicOilTemperatureHigh_bright_Status(void)  
{
    return LED_HydraulicOilTemperatureHigh_bright_State;
}

/*变速箱故障指示灯*/
static Tellib_uint16_t LED_Gearbox_Breakdown_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (((Line_In_Get_Status(LINE_IN_Transmission_Failur_Just) == 1u) &&
         (Line_In_Get_Status(LINE_IN_Transmission_Failure_Lose) == 1u)) ||
        ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_DM1_AMT_Msg_Count) == CAN_SIG_NORMAL) &&
         (Get_CAN_CH0_ID_18FECA03_Sig_AmberWarningLampStatus() == 1u)))
    {
        LED_STATE = 1u;
    }
    else
    {
       LED_STATE = 0u; 
    }
    return LED_STATE;
}

static void LED_Gearbox_Breakdown_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
        GPIO_SET_LED_GEARBOX_BREAKDOWN_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Lamplet));
    }
    else
    {
        GPIO_SET_LED_GEARBOX_BREAKDOWN_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Lamplet));
    }
}

/*发动机诊断指示灯*/
static Tellib_uint16_t LED_Engine_Diagnostic_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    uint8_t condition3 = 0u;
    uint8_t condition4 = 0u;
    uint8_t condition5 = 0u;
    uint8_t condition6 = 0u;
    condition1 = (Get_CAN_CH0_ID_18FECA00_Sig_ProtectLampStatus() == 1);        //亮
    condition2 = (Get_CAN_CH0_ID_18FECA00_Sig_AmberWarningLampStatus() == 1);   //亮
    condition3 = (Get_CAN_CH0_ID_18FECA00_Sig_FlashProtectLamp() == 0);         //1Hz
    condition4 = (Get_CAN_CH0_ID_18FECA00_Sig_FlashAmberWarningLamp() == 0);    //1Hz
    condition5 = (Get_CAN_CH0_ID_18FECA00_Sig_FlashProtectLamp() == 1);         //2Hz
    condition6 = (Get_CAN_CH0_ID_18FECA00_Sig_FlashAmberWarningLamp() == 1);    //2Hz
    if((Get_Stater_Type() == WEICHAI) || (Get_Stater_Type() == SHANGCHAI) || (Get_Stater_Type() == YUNNEI) ||  \
       (Get_Stater_Type() == YUCHAI) || (Get_Stater_Type() == LUOTUO))
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_DM1_ECU_Msg_Count) == CAN_SIG_NORMAL)
        {
            if(condition5 || condition6)
            {
                LED_STATE = FLASH_SYNC_2Hz;
            }
            else
            {
                if(condition3 || condition4)
                {
                    LED_STATE = FLASH_SYNC_1Hz;
                }
                else
                {
                    if(condition1 || condition2)
                    {
                        LED_STATE = 1u;
                    }
                    else
                    {
                        LED_STATE = 0u;
                    }
                }
            }
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static void LED_Engine_Diagnostic_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
        GPIO_SET_LED_ENGINE_DIAGNOSTIC_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Lamplet));
    }
    else
    {
        GPIO_SET_LED_ENGINE_DIAGNOSTIC_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Lamplet));
    }
}

/*水温LED图标*/
static Tellib_uint16_t LED_Water_Tem_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Get_HMI_Sys_Type() >= Disp_SelfCheck)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
   
    return LED_STATE;
}

static void LED_Water_Tem_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
        GPIO_SET_LED_WATER_TEM_W_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Lamplet));
    }
    else
    {
        GPIO_SET_LED_WATER_TEM_W_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Lamplet));
    }
}

/*变速箱油温温LED图标*/
static Tellib_uint16_t LED_Oil_Tem_Judge(void)
{
    Tellib_uint16_t LED_STATE = 0u;
    if (Get_HMI_Sys_Type() >= Disp_SelfCheck)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    
    return LED_STATE;
}

static void LED_Oil_Tem_Exec(Tellib_uint16_t led_status)
{
    if(led_status == 1)
    {
        GPIO_SET_LED_GEARBOX_W_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Lamplet));
    }
    else
    {
        GPIO_SET_LED_GEARBOX_W_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Lamplet));
    }
}

static Tellib_uint16_t LED_Reversal_Cooling_fan_judge (void)  //冷却风扇反转报警灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    uint8_t condition3 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FF4421_Sig_FanReversal() == 1);
    condition3 = (Line_In_Get_Status(LINE_IN_Reversal_Coolingfan) == 1);
    if ((condition1 && condition2) || (condition3))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;  

}

static Tellib_uint16_t LED_Stabilization_Module_judge (void)  //稳定模块指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    uint8_t condition3 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FF4421_Sig_StableModuleIndication() == 1);
    condition3 = (Line_In_Get_Status(LINE_IN_StabilizationModule) == 1);
    if ((condition1 && condition2) || (condition3))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;  

}

static Tellib_uint16_t LED_Power_cut_off_judge (void)   	  //动力切断指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    uint8_t condition3 = 0u;
    uint8_t condition4 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF32_Msg_Count) == CAN_SIG_NORMAL);
    condition3 = (Get_CAN_CH0_ID_18FF4421_Sig_PowerCutoff() == 1);
    condition4 = (Get_CAN_CH0_ID_18FF3203_Sig_PowerCutoff() == 1);
    if((condition1 && condition3 ) || (condition2 && condition4 ))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
        if(Get_Power_Cut_Off_Configuration_Valid_High() == 1)
       {
            if(Line_In_Get_Status(LINE_IN_LED_Power_CutOff_HIGH) == 1)
           {
              LED_STATE = 1u;
           }
            else
           {
              LED_STATE = 0u;
           }
       }
        else
       {
            if(Line_In_Get_Status(LINE_IN_LED_Power_CutOff_LOW) == 1)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 0u;
            }
       }
    }

     return LED_STATE;  
}

static Tellib_uint16_t LED_Emergency_Steering_judge (void) 	  //应急转向指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    uint8_t condition3 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FF4421_Sig_EmergencySteering() == 1);
    condition3 = (Line_In_Get_Status(LINE_IN_EmergencySteering) == 1);
    if ((condition1 && condition2) || (condition3))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_Bridge_Oil_Temperature_Is_High_judge (void)  //桥油温高指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    condition1 = (Line_In_Get_Status(LINE_IN_Bridge_Oil_Temperature_Is_High) == 1);
    if (condition1)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_Water_In_The_Oil_judge (void)                //油中有水指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    uint8_t condition3 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_OI_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FEFF00_Sig_WaterInFuel() == 1);
    condition3 = (Line_In_Get_Status(LINE_IN_Water_In_TheOil) == 1);
    if ((condition1 && condition2) || (condition3))
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;  

}
static Tellib_uint16_t LED_Low_Cooling_Level_judge (void)               //冷却液位低指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    static uint8_t condition1 = 0u;
    static uint8_t Timer_5s = 0u;
    condition1 = (Line_In_Get_Status(LINE_IN_Low_Cooling_Level) == 1);
    if (condition1)
    {
        if (Timer_5s >= 100)
        {
            LED_STATE = 1u;
        }
        else
        {
            Timer_5s++;
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
        Timer_5s = 0u;
    }
    return LED_STATE;  
}

static Tellib_uint16_t LED_Oil_Water_Separation_judge  (void)          //油水分离指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    condition1 = (Line_In_Get_Status(LINE_IN_Oil_WaterSeparation) == 1);
    if (condition1)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_Safety_Belt_judge(void)          //安全带指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    condition1 = (Line_In_Get_Status(LINE_IN_SafetyBelt) == 1);
    if (condition1)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_Fuel_Filter_Pluggingt_judge(void)          //燃油滤堵塞指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    condition1 = (Line_In_Get_Status(LINE_IN_Fuel_FilterPlugging) == 1);
    if (condition1)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_One_Click_Shake_Material_judge(void)        //一键抖料指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FF4421_Sig_OneButtonShaking() == 1);
    if (condition1 && condition2)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;  
}

static Tellib_uint16_t LED_Rearview_Mirror_Heating_Up_judge(void)        //后视镜加热指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FF4421_Sig_RearviewMirrorHeating() == 1);
    if (condition1 && condition2)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_Presence_Status_Indication_judge(void)        //在位状态指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FF4421_Sig_InPositionStatusIndication() == 1);
    if (condition1 && condition2)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_Air_Filter_Blocked_judge(void)              //空滤器堵塞指示
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    condition1 = (Line_In_Get_Status(LINE_IN_Air_FilterBlocked) == 1);
    if (condition1)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_Engine_Stop_judge(void)                     //发动机停机指示逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition3 = 0u;
    uint8_t condition4 = 0u;
    uint8_t condition5 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_DM1_ECU_Msg_Count) == CAN_SIG_NORMAL);
    condition3 = (Get_CAN_CH0_ID_18FECA00_Sig_RedWarningLampStatus() == 1);
    condition4 = (Get_CAN_CH0_ID_18FECA00_Sig_FlashRedWarningLamp() == 0);
    condition5 = (Get_CAN_CH0_ID_18FECA00_Sig_FlashRedWarningLamp() == 1);
    if ((Get_Stater_Type() == WEICHAI) ||
        (Get_Stater_Type() == KANGMINGSI) ||
        (Get_Stater_Type() == YUNNEI) ||
        (Get_Stater_Type() == YUCHAI) ||
        (Get_Stater_Type() == SHANGCHAI))
    {
        if ((condition1 && condition5))
        {

            LED_STATE = 3u;
        }
        else
        {
            if (condition1 && condition4)
            {
                LED_STATE = 2u;
            }
            else
            {
                if ((condition1 && condition3))
                {
                    LED_STATE = 1u;
                }
                else
                {
                    LED_STATE = 0u;
                }
            }
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_High_Exhaust_Temperature_judge (void)                //排气温度高指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    uint8_t condition3 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_DPFC_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FD7C00_Sig_ExhaustedGasTemperatureHigh() == 1);
    condition3 = (Line_In_Get_Status(LINE_IN_High_ExhaustTemperature) == 1);
    if ((Get_Stater_Type() == KANGMINGSI) ||
        (Get_Stater_Type() == YUNNEI) ||
        (Get_Stater_Type() == YUCHAI) ||
        (Get_Stater_Type() == SHANGCHAI))
    {
        if ((condition1 && condition2) || (condition3))
        {
            LED_STATE = 1u;
        }
        else
        {
            LED_STATE = 0u;
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_Red_NCD_judge (void)                        //NCD红色指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    uint8_t condition3 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_Rx_OI_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FEFF00_Sig_DrivabilityLimitationSystem() == 3);
    condition3 = (Get_CAN_CH0_ID_18FEFF00_Sig_DrivabilityLimitationSystem() == 5);
    if ((Get_Stater_Type() == KANGMINGSI) ||
        (Get_Stater_Type() == WEICHAI) ||
        (Get_Stater_Type() == SHANGCHAI))
    {
        if (condition1 && condition3)
        {
            LED_STATE = 3u;
        }
        else
        {
            if (condition1 && condition2)
            {
                LED_STATE = 1u;
            }
            else
            {
                LED_STATE = 0u;
            }
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_Yellow_NCD_judge(void) // NCD黄色指示灯逻辑函数
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    uint8_t condition3 = 0u;
    uint8_t condition4 = 0u;
    uint8_t condition5 = 0u;
    condition4 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_OI_Msg_Count) == CAN_SIG_NORMAL);
    condition5 = (Get_CAN_CH0_ID_18FEFF00_Sig_DrivabilityLimitationSystem() == 3);
    condition1 = (Get_CAN_CH0_ID_18FEFF00_Sig_DrivabilityLimitationSystem() == 5);
    condition2 = (Get_CAN_CH0_ID_18FEFF00_Sig_DriverWarningSystem() == 1);
    condition3 = (Get_CAN_CH0_ID_18FEFF00_Sig_DriverWarningSystem() == 4);
    if ((Get_Stater_Type() == KANGMINGSI) ||
        (Get_Stater_Type() == WEICHAI)    ||
        (Get_Stater_Type() == SHANGCHAI))
    {
        if ((condition4 && condition5) || (condition4 && condition1))
        {
            LED_STATE = 0u;
        }
        else
        {
            if (condition4 && condition3)
            {
                LED_STATE = 2u;
            }
            else
            {
                if (condition4 && condition2)
                {
                    LED_STATE = 1u;
                }
                else
                {
                    LED_STATE = 0u;
                }
            }
        }
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;
}

static Tellib_uint16_t LED_Steering_Wheel_Lock_Condition_One_judge (void)         //方向盘锁状态1
{
    Tellib_uint16_t LED_STATE = 0u;
    static uint8_t condition1 = 0u;
    static uint8_t condition2 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FF4421_Sig_SteeringWheelLockStatus() == 1);
    if((condition1 && condition2 ))
   {
        LED_STATE = 1u;
   }
    else
   {
        LED_STATE = 0u;
   }
    return LED_STATE;  
}

static Tellib_uint16_t LED_Steering_Wheel_Lock_Condition_Two_judge (void)         //方向盘锁状态2
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    ;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FF44_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FF4421_Sig_SteeringWheelLockStatus() == 2);
    if (condition1 && condition2)
    {
        LED_STATE = 1u;
    }
    else
    {
        LED_STATE = 0u;
    }
    return LED_STATE;  
}

static Tellib_uint16_t LED_Driver_Warning_judge (void)                     //驾驶员警告
{
    Tellib_uint16_t LED_STATE = 0u;
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    uint8_t condition3 = 0u;
    uint8_t condition4 = 0u;
    uint8_t condition5 = 0u;
    uint8_t condition6 = 0u;
    uint8_t condition7 = 0u;
    condition1 = (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_DM1_ECU_Msg_Count) == CAN_SIG_NORMAL);
    condition2 = (Get_CAN_CH0_ID_18FECA00_Sig_FlashAmberWarningLamp() == 0);
    condition3 = (Get_CAN_CH0_ID_18FECA00_Sig_FlashAmberWarningLamp() == 1);
    condition5 = (Get_CAN_CH0_ID_18FECA00_Sig_FlashMalfuctionIndicatorLamp() == 0);
    condition6 = (Get_CAN_CH0_ID_18FECA00_Sig_FlashMalfuctionIndicatorLamp() == 1);
    condition7 = (Get_CAN_CH0_ID_18FECA00_Sig_AmberWarningLampStatus() == 1);
    condition4 = (Get_CAN_CH0_ID_18FECA00_Sig_MalfuctionIndicatorLampStatus() == 1);
    if ((Get_Stater_Type() == YUNNEI) ||
        (Get_Stater_Type() == YUCHAI))
    {
        if (condition1 && condition3)
        {
            LED_STATE = 3u;
        }
        else
        {
            if (condition1 && condition2)
            {
                LED_STATE = 2u;
            }
            else
            {
                if (condition1 && condition7)
                {
                    LED_STATE = 1u;
                }
                else
                {
                    LED_STATE = 0u;
                }
            }
        }
    }

    else if (Get_Stater_Type() == LUOTUO)
    {
        if (condition1 && condition6)
        {
            LED_STATE = 3u;
        }
        else
        {
            if (condition1 && condition5)
            {
                LED_STATE = 2u;
            }
             else
            {
                if (condition1 && condition4)
                {
                    LED_STATE = 1u;
                }
                else
                {
                    LED_STATE = 0u;
                }
            }
        }
    }
    else
    {
        LED_STATE = 0u;
    }


     return LED_STATE; 
}
static Tellib_uint16_t LED_Red_PCD_judge(void)   // PCD
{
    Tellib_uint16_t LED_STATE = 0u;
    return LED_STATE;
}
static Tellib_uint16_t LED_Yellow_PCD_judge (void)//PCD
{
    Tellib_uint16_t LED_STATE = 0u;
    return LED_STATE;
}
static Tellib_uint16_t LED_ResistanceHighDEF_Judge(void) //阻力高
{
    Tellib_uint16_t LED_STATE = 0u;
    return LED_STATE;
}

#define lamp_Elec 0

void SET_LED_ALL_Light_CLOSE(void)
{
}

void SET_LED_ALL_Light_OPEN(void)
{
}


void Audible_Alarm_Service(void)  // 声音服务函数
{
    static uint8_t Timer = 0u;  // 自检计时
    uint8_t condition1 = 0u;
    uint8_t condition2 = 0u;
    uint8_t condition3 = 0u;
    uint8_t condition4 = 0u;
    uint8_t condition5 = 0u;
    uint8_t condition6 = 0u;
    uint8_t condition7 = 0u;
    uint8_t condition8 = 0u;
    uint8_t condition9 = 0u;
    uint16_t Sound1 = 0;
    Sound1 = Get_Sound_Loudness();
    condition1 = (Get_TelltalesLedSts(m_LED_Engine_Stop) != 0); // 发动机停机   点亮或闪烁
    condition2 = (Get_TelltalesLedSts(m_LED_Coolant) == 1); //水温高   点亮
    condition3 = (Get_TelltalesLedSts(m_LED_Transmission_High) == 1); //变速箱油温高  点亮
    condition4 = ((Get_TelltalesLedSts(m_LED_Parking_Braking) == 1) && (Get_TelltalesLedSts(m_LED_GearDirection_Neutral) == 0)); //驻车制动  点亮； 空挡  熄灭
    condition5 = ((Get_EngineOilPressure_bright_status() == 1) && (Engine_Operation_Judge())); //机油压力报警  点亮; 发动机运行
    condition6 = (Get_Wet_Brake_Pressure_status_R() == 1); // 制动压力报警   点亮
    condition7 = (Get_TelltalesLedSts(m_LED_Air_Filter_Blocked) == 1); // 空滤器堵塞   点亮
    condition8 = (Get_TelltalesLedSts(m_LED_TransmissionOilFilterBlocked) == 1); // 变速箱油滤堵塞   点亮
    condition9 = (Get_TelltalesLedSts(m_LED_BatteryVoltage) == 1); // 电池电压报警   点亮
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if (Timer > 50)
        {
            if (g_RightKeyLONGPRESS == 0)
            {
                if (condition1 || condition2 || condition3 || condition4 || condition5 || condition6 || condition7 || condition8 || condition9) //
                {
                    PWM_Channel_Set_Duty(15, Sound1);
                }
                else
                {
                    PWM_Channel_Set_Duty(15, 0);
                }
            }
            else
            {
                PWM_Channel_Set_Duty(15, 0);
            }
        }
        else
        {
            Timer++;
            PWM_Channel_Set_Duty(15, 0);
        }
    }
    else
    {
        PWM_Channel_Set_Duty(15, 0);
        Timer = 0u;
        g_RightKeyLONGPRESS = 0;
    }
}

uint16_t Get_Sound_Loudness(void)
{
    uint16_t Sound = 0;
    switch (Get_Sound_Type())
    {
    case 1:
        Sound = 200;
        break;
    case 2:
        Sound = 400;
        break;
    case 3:
        Sound = 550;
        break;
    case 4:
        Sound = 700;
        break;
    case 5:
        Sound = 900;
        break;
    default:
        break;
    }
}


uint8_t Engine_Operation_Judge(void) // 发动机运行判断
{
    uint8_t Engine_Operation_Status = 0;  //1运行  0停止
    static uint8_t last_status = 0u;    // 0运行  1停止
    uint16_t PwrSts = 0;
    PwrSts = Get_CAN_CH0_ID_0CF00400_Sig_EngineSpeed();    //发动机转速
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if ((PwrSts > 0u) && (PwrSts <= 0xFAFF)) // 发动机转速有效
        {
            if (PwrSts >= 0x960) // 转速>=300  发动机运行
            {
                Engine_Operation_Status = 1;
                last_status = 0;
            }
            else if (PwrSts <= 0x190) // 转速<=50  发动机停止
            {
                Engine_Operation_Status = 0;
                last_status = 1;
            }
            else // 回滞
            {
                if (last_status == 0)
                {
                    Engine_Operation_Status = 1;
                }
                else if (last_status == 1)
                {
                    Engine_Operation_Status = 0;
                }
            }
        }
    }
    return Engine_Operation_Status;
}