#include "UDS_22Service_Main.h"
#include "RTE_GPIO.h"
#include "Analog_Signals.h"
#include "UDS_Common.h"
#include "dr7f701684.dvf.h"
#include "Services_Mileage_User.h"
#include <string.h>

//软硬件版本号修改地方
const uint8_t DID_F193 [8] = {'H', 'W', ':', '0', '.', '0', '.', '1'};
const uint8_t DID_F195 [8] = {'S', 'W', ':', '0', '.', '0', '.', '3'};
/**
 *22���������
 *@param A_TA_type �յ����ݵĵ�ַ
 *@param A_Length �յ����ݵĳ���
 *@param A_Data �յ����ݵ�����
 */
void UDS_Service_22_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data [])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if ( NRC == positiveResponse )
    {
        NRC = UDS_22Service_NRC11( ); /*22�����Ƿ�֧�ֹ���Ѱַ*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_22Service_NRC7F( ); /*22����Ự�Ƿ�֧����֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_22Service_NRC33( ); /*22��������ȼ���֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_22Service_NRC13_MinLengthCheck( ); /*22������С������֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_22Service_NRC31( ); /*22���񳬳�����Χ��֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_22Service_NRC13_TotalLengthCheck( ); /*22�����ܳ��ȳ�����֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_22Service_NRC22( ); /*22����������֤*/
    }
    if ( NRC == positiveResponse )
    {
        UDS_NRC78_Sand(0x22u);
        UDS_Delay(5000u);
        UDS_22Service_DID( ); /*22����DID�ж�*/
    }
    clearDiagMSG( ); /*��������Ϣ*/
}

/**
 *22�����ӹ���
 */
void UDS_22Service_DID(void)
{
    ( void )ReadDFlashData(WriteEOL0300DataAddr,   ( uint32_t * )&EOL0300ToDFlashInfo.Flag, sizeof(EOL0300ToDFlashInfo), EOL_0300_InitVal, 0xFD);
    ( void )ReadDFlashData(WriteEOL0301DataAddr,   ( uint32_t * )&EOL0301ToDFlashInfo.Flag, sizeof(EOL0301ToDFlashInfo), EOL_0301_InitVal, 0xFD);

    switch ( getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) ) /*22����DID�ж�*/
    {
        case 0x0300 :
            UDS_22Service_DID_0300();
        break;
        case 0x0301 :
            UDS_22Service_DID_0301();
        break;
        case 0xF193 :
            UDS_22Service_DID_F193();
        break;
        case 0xF195 :
            UDS_22Service_DID_F195();
        break;
        default:
        break;
    }
}

/**
 *22 DIDF0300
 *配置
 */
void UDS_22Service_DID_0300(void)
{
    ( void )memcpy(DiagMSG.msgData.DidDetail.Data, EOL0300ToDFlashInfo.DID_0300, sizeof(EOL0300ToDFlashInfo.DID_0300));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(EOL0300ToDFlashInfo.DID_0300), DiagMSG.msgData.Data);
}

/**
 *22 DID0301
 *配置
 */
void UDS_22Service_DID_0301(void)
{
    ( void )memcpy(DiagMSG.msgData.DidDetail.Data, EOL0301ToDFlashInfo.DID_0301, sizeof(EOL0301ToDFlashInfo.DID_0301));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(EOL0301ToDFlashInfo.DID_0301), DiagMSG.msgData.Data);
}

/**
 *22 DIDF193
 *硬件版本号
 */
void UDS_22Service_DID_F193(void)
{
    ( void )memcpy(DiagMSG.msgData.DidDetail.Data, DID_F193, sizeof(DID_F193));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(DID_F193), DiagMSG.msgData.Data);
}

/**
 *22 IDF195
 *软件版本号
 */
void UDS_22Service_DID_F195(void)
{
    ( void )memcpy(DiagMSG.msgData.DidDetail.Data, DID_F195, sizeof(DID_F195));
    UDS_Service_Response(0x22u, POSITIVE_RSP, DIAG_ID_Tx, 2u + sizeof(DID_F195), DiagMSG.msgData.Data);
}
