#include "UDS_23Service_Filter.h"

/**
  *23Ƿֹ֧Ѱַ
  *Ѱַθø
  *@return 
  */
uint8_t UDS_23Service_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    if ( DiagMSG.msgID == DIAG_ID_Rx_FUN )
    {
        NRC = serviceNotSupported;
    }
    return NRC;
}

/**
  *23ỰǷ֧֤
  *Ѱַθø
  *@return 
  */
uint8_t UDS_23Service_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    if ( getSessionType( ) == DefaultSession )
    {
        NRC = serviceNotSupportedInActiveSession;
        if ( DiagMSG.msgID == DIAG_ID_Rx_PHY )
        {
            UDS_Service_Response(0x23u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *23ȼ֤
  *@return 
  */
uint8_t UDS_23Service_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    if ( getSecurityLevel( ) == NormalKeyUnlock )
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = securityAccessDenied;
        UDS_Service_Response(0x23u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    return NRC;
}

/**
  *23С֤
  *@return 
  */
uint8_t UDS_23Service_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if ( DiagMSG.msgDLC < 7u )
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x23u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *23񳬳Χ֤
  *Ѱַθø
  *@return 
  */
uint8_t UDS_23Service_NRC31(void)
{
    uint8_t  NRC = positiveResponse;
    uint8_t  temp [ 2 ];
    uint32_t address = 0u;
    uint32_t length  = 0u;

    temp [ 0 ] = ( uint8_t )((( uint8_t )(DiagMSG.msgData.Data [ 0 ] >> 4u)) & 0x0Fu);
    temp [ 1 ] = ( uint8_t )(DiagMSG.msgData.Data [ 0 ] & 0x0Fu);
    if ( (temp [ 0 ] == 0x00u) || (temp [ 0 ] > 0x04u) )
    {
        NRC = requestOutOfRange;
        UDS_Service_Response(0x23u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else if ( (temp [ 1 ] == 0x00u) || (temp [ 1 ] > 0x02u) )
    {
        NRC = requestOutOfRange;
        UDS_Service_Response(0x23u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    if ( NRC == positiveResponse )
    {
        switch ( temp [ 0 ] )
        {
            case 1:
                address = toUint32_t(0u, 0u, 0u, DiagMSG.msgData.Data [ 1 ]);
                break;
            case 2:
                address = toUint32_t(0u, 0u, DiagMSG.msgData.Data [ 1 ], DiagMSG.msgData.Data [ 2 ]);
                break;
            case 3:
                address = toUint32_t(0u, DiagMSG.msgData.Data [ 1 ], DiagMSG.msgData.Data [ 2 ], DiagMSG.msgData.Data [ 3 ]);
                break;
            case 4:
                address = toUint32_t(DiagMSG.msgData.Data [ 1 ], DiagMSG.msgData.Data [ 2 ], DiagMSG.msgData.Data [ 3 ], DiagMSG.msgData.Data [ 4 ]);
                break;
            default:
                NRC = requestOutOfRange;
                UDS_Service_Response(0x23u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
                break;
        }
        if ( address > 0x00020000u )
        {
            NRC = requestOutOfRange;
            UDS_Service_Response(0x23u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
    }
    if ( NRC == positiveResponse )
    {
        switch ( temp [ 1 ] )
        {
            case 1:
                length = toUint32_t(0u, 0u, 0u, DiagMSG.msgData.Data [ 1u + temp [ 0 ] + 0u ]);
                break;
            case 2:
                length = toUint32_t(0u, 0u, DiagMSG.msgData.Data [ 1u + temp [ 0 ] + 0u ], DiagMSG.msgData.Data [ 1u + temp [ 0 ] + 1u ]);
                break;
            default:
                NRC = requestOutOfRange;
                UDS_Service_Response(0x23u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
                break;
        }
        if ( (length == 0x00u) || (length > (N_USDATA_RX_BUFFER_SIZE - 10u)) )
        {
            NRC = requestOutOfRange;
            UDS_Service_Response(0x23u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
    }

    return NRC;
}

/**
  *23ܳȳ֤
  *@return 
  */
uint8_t UDS_23Service_NRC13_TotalLengthCheck(void)
{
    uint8_t NRC  = positiveResponse;
    uint8_t temp = 0u;
    temp         = DiagMSG.msgData.Data [ 0 ];
    if ( DiagMSG.msgDLC != (( uint8_t )((( uint8_t )(temp & 0x0Fu)) + 1u + (( uint8_t )((( uint8_t )(temp >> 4u)) & 0xFFu)))) )
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x23u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *23֤
  *@return 
  */
uint8_t UDS_23Service_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}
