#include "UDS_27Service_Main.h"
#include "UDS_Common.h"
const uint8_t XorArray [ 4 ] = {0x74, 0xF7, 0x15, 0x17};
static void   Ser27_CalculateKeyLV1(uint8_t Seed [], uint8_t Key []);

void UDS_Service_27_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data [])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_NRC11( ); /*27�����Ƿ�֧�ֹ���Ѱַ*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_NRC7F( ); /*27����Ự�Ƿ�֧����֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_NRC33( ); /*27��������ȼ���֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_NRC13_MinLengthCheck( ); /*27������С������֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_NRC31( ); /*27���񳬳�����Χ��֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_NRC13_TotalLengthCheck( ); /*27�����ܳ��ȳ�����֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_NRC22( ); /*27����������֤*/
    }
    if ( NRC == positiveResponse )
    {
        UDS_27Service_Sub( ); /*27�����ӹ���*/
    }
    clearDiagMSG( ); /*��������Ϣ*/
}

/**
  *10�����ӹ���
  */
void UDS_27Service_Sub(void)
{
    uint8_t NRC = positiveResponse;
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_Sub_NRC13_MinLengthCheck( ); /*27�����ӹ�����С������֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_Sub_NRC12( ); /*27�����ӹ����Ƿ�֧����֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_Sub_NRC7E( ); /*27�����ӹ��ܻỰ�Ƿ�֧����֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_Sub_NRC31( ); /*27�����ӹ��ܳ�������Χ��֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_Sub_NRC13_TotalLengthCheck( ); /*27�����ӹ����ܳ��ȳ�����֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_Sub_NRC24( ); /*27�����ӹ�������˳����֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_Sub_NRC22( ); /*27�����ӹ���������֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_27Service_Sub_NRC37( ); /*27��ʱ��֤*/
    }

    if ( NRC == positiveResponse )
    {
        UDS_NRC78_Sand(0x27u);
        UDS_Delay(5000u);
        switch ( DiagMSG.msgData.SidDetail.SubID ) /*�ӷ����ж�*/
        {
            case requestSeed_LV1:
                UDS_27Service_Sub01( ); /*27����01�ӹ���*/
                break;
            case sendKey_LV1:
                UDS_27Service_Sub02( ); /*27����02�ӹ���*/
                break;
            case requestSeed_LV11:
                UDS_27Service_Sub11( ); /*27����11�ӹ���*/
                break;
            case sendKey_LV11:
                UDS_27Service_Sub12( ); /*27����12�ӹ���*/
                break;
            default:
                break;
        }
    }
}

/**
  *27����01�ӹ���
  */
void UDS_27Service_Sub01(void)
{
    uint8_t randomseed [ 4 ];
    if ( Ser27_FlowCtrl.LV1SafetyStatus != NormalKeyUnlock )
    {
        if ( Ser27_FlowCtrl.LV1Ctrl != SER27_REQ_SEEDED )
        {
            Ser27_CreateRandomSeed( );
            Ser27_FlowCtrl.LV1Seed [ 0 ] = (( uint8_t )(Ser27_SeedRandomNumber) ^ 0x31u) + 16u;
            Ser27_FlowCtrl.LV1Seed [ 1 ] = (( uint8_t )(Ser27_SeedRandomNumber >> 8) ^ 0x56u) + 9u;
            Ser27_FlowCtrl.LV1Seed [ 2 ] = (( uint8_t )(Ser27_SeedRandomNumber >> 16) ^ 0x87u) + 1u;
            Ser27_FlowCtrl.LV1Seed [ 3 ] = (( uint8_t )(Ser27_SeedRandomNumber >> 24) ^ 0x92u) + 21u;
        }
        else
        {
            Ser27_FlowCtrlCnt.LV1ReqSeedCnt += 1u;
        }
        /*
        ��FailCnt����D-Flash*/
        Ser27_WriteCtrlInfoToDFlash( );
        Ser27_FlowCtrl.LV1Ctrl = SER27_REQ_SEEDED;
        if ( Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
        {
            Ser27_EnDelayTimer( );
            Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;
        }
    }
    else
    {
        Ser27_FlowCtrl.LV1Seed [ 0 ] = 0u;
        Ser27_FlowCtrl.LV1Seed [ 1 ] = 0u;
        Ser27_FlowCtrl.LV1Seed [ 2 ] = 0u;
        Ser27_FlowCtrl.LV1Seed [ 3 ] = 0u;
    }
    DiagMSG.msgData.SidDetail.Data [ 0 ] = Ser27_FlowCtrl.LV1Seed [ 0 ];
    DiagMSG.msgData.SidDetail.Data [ 1 ] = Ser27_FlowCtrl.LV1Seed [ 1 ];
    DiagMSG.msgData.SidDetail.Data [ 2 ] = Ser27_FlowCtrl.LV1Seed [ 2 ];
    DiagMSG.msgData.SidDetail.Data [ 3 ] = Ser27_FlowCtrl.LV1Seed [ 3 ];
    randomseed [ 0 ]                     = Ser27_FlowCtrl.LV1Seed [ 0 ];
    randomseed [ 1 ]                     = Ser27_FlowCtrl.LV1Seed [ 1 ];
    randomseed [ 2 ]                     = Ser27_FlowCtrl.LV1Seed [ 2 ];
    randomseed [ 3 ]                     = Ser27_FlowCtrl.LV1Seed [ 3 ];

    if ( (randomseed [ 0 ] == 0x00u) && (randomseed [ 1 ] == 0x00u) && (randomseed [ 2 ] == 0x00u) && (randomseed [ 3 ] == 0x00u) )
    {
    }
    else
    {
        Ser27_CalculateKeyLV1(randomseed, Ser27_FlowCtrl.LV1Key);
    }
    if ( DiagMSG.msgData.SidDetail.PositiveSuppression == 0u )
    {
        UDS_Service_Response(0x27u, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
}

/**
  *27����02�ӹ���
  */
void UDS_27Service_Sub02(void)
{
    uint32_t KeyReceive;
    uint32_t KeyCalcValue;

    KeyReceive = ( uint32_t )DiagMSG.msgData.SidDetail.Data [ 0 ];
    KeyReceive = (KeyReceive << 8u) | (( uint32_t )DiagMSG.msgData.SidDetail.Data [ 1 ]);
    KeyReceive = (KeyReceive << 8u) | (( uint32_t )DiagMSG.msgData.SidDetail.Data [ 2 ]);
    KeyReceive = (KeyReceive << 8u) | (( uint32_t )DiagMSG.msgData.SidDetail.Data [ 3 ]);

    KeyCalcValue = ( uint32_t )Ser27_FlowCtrl.LV1Key [ 0 ];
    KeyCalcValue = (KeyCalcValue << 8u) | (( uint32_t )Ser27_FlowCtrl.LV1Key [ 1 ]);
    KeyCalcValue = (KeyCalcValue << 8u) | (( uint32_t )Ser27_FlowCtrl.LV1Key [ 2 ]);
    KeyCalcValue = (KeyCalcValue << 8u) | (( uint32_t )Ser27_FlowCtrl.LV1Key [ 3 ]);

    if ( KeyReceive == KeyCalcValue )
    {
        Ser27_FlowCtrl.LV1SafetyStatus    = NormalKeyUnlock;
        Ser27_FlowCtrl.LV11SafetyStatus   = NormalKeyLock;
        Ser27_FlowCtrl.LV1Ctrl            = SER27_CLEAR_REQ_SEEDED;
        Ser27_FlowCtrlCnt.LV1InvaidKyeCnt = 0u;
        Ser27_FlowCtrlCnt.LV1ReqSeedCnt   = 0u;
        DiagMSG.msgData.Data [ 0 ]        = sendKey_LV1;
        /*������flashд�纯��*/
        Ser27_WriteCtrlInfoToDFlash( );

        if ( DiagMSG.msgData.SidDetail.PositiveSuppression == 0u )
        {
            UDS_Service_Response(0x27u, POSITIVE_RSP, DIAG_ID_Tx, 1u, DiagMSG.msgData.Data);
        }
    }
    else
    {
        Ser27_FlowCtrlCnt.LV1ReqSeedCnt += 1u;
        /*������flashд�纯��*/
        Ser27_WriteCtrlInfoToDFlash( );
        if ( Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
        {
            Ser27_EnDelayTimer( );
            ( void )UDS_27Service_Sub_NRC36( );
        }
        else
        {
            ( void )UDS_27Service_Sub_NRC35( );
        }
        Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;
    }
}

/**
  *27����11�ӹ���
  */
void UDS_27Service_Sub11(void)
{
    uint8_t randomseed [ 4 ];
    if ( Ser27_FlowCtrl.LV11SafetyStatus != NormalKeyUnlock )
    {
        if ( Ser27_FlowCtrl.LV11Ctrl != SER27_REQ_SEEDED )
        {
            Ser27_CreateRandomSeed( );
            Ser27_FlowCtrl.LV11Seed [ 0 ] = (( uint8_t )(Ser27_SeedRandomNumber) ^ 0x31u) + 16u;
            Ser27_FlowCtrl.LV11Seed [ 1 ] = (( uint8_t )(Ser27_SeedRandomNumber >> 8) ^ 0x56u) + 9u;
            Ser27_FlowCtrl.LV11Seed [ 2 ] = (( uint8_t )(Ser27_SeedRandomNumber >> 16) ^ 0x87u) + 1u;
            Ser27_FlowCtrl.LV11Seed [ 3 ] = (( uint8_t )(Ser27_SeedRandomNumber >> 24) ^ 0x92u) + 21u;
        }
        else
        {
            Ser27_FlowCtrlCnt.LV11ReqSeedCnt += 1u;
        }
        /*
        ��FailCnt����D-Flash*/
        Ser27_WriteCtrlInfoToDFlash( );
        Ser27_FlowCtrl.LV11Ctrl = SER27_REQ_SEEDED;
        if ( Ser27_FlowCtrlCnt.LV11ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
        {
            Ser27_EnDelayTimer( );
            Ser27_FlowCtrl.LV11Ctrl = SER27_CLEAR_REQ_SEEDED;
        }
    }
    else
    {
        Ser27_FlowCtrl.LV11Seed [ 0 ] = 0u;
        Ser27_FlowCtrl.LV11Seed [ 1 ] = 0u;
        Ser27_FlowCtrl.LV11Seed [ 2 ] = 0u;
        Ser27_FlowCtrl.LV11Seed [ 3 ] = 0u;
    }
    DiagMSG.msgData.SidDetail.Data [ 0 ] = Ser27_FlowCtrl.LV11Seed [ 0 ];
    DiagMSG.msgData.SidDetail.Data [ 1 ] = Ser27_FlowCtrl.LV11Seed [ 1 ];
    DiagMSG.msgData.SidDetail.Data [ 2 ] = Ser27_FlowCtrl.LV11Seed [ 2 ];
    DiagMSG.msgData.SidDetail.Data [ 3 ] = Ser27_FlowCtrl.LV11Seed [ 3 ];
    randomseed [ 0 ]                     = Ser27_FlowCtrl.LV11Seed [ 0 ];
    randomseed [ 1 ]                     = Ser27_FlowCtrl.LV11Seed [ 1 ];
    randomseed [ 2 ]                     = Ser27_FlowCtrl.LV11Seed [ 2 ];
    randomseed [ 3 ]                     = Ser27_FlowCtrl.LV11Seed [ 3 ];

    if ( (randomseed [ 0 ] == 0x00u) && (randomseed [ 1 ] == 0x00u) && (randomseed [ 2 ] == 0x00u) && (randomseed [ 3 ] == 0x00u) )
    {
    }
    else
    {
        Ser27_CalculateKeyLV1(randomseed, Ser27_FlowCtrl.LV11Key);
    }
    if ( DiagMSG.msgData.SidDetail.PositiveSuppression == 0u )
    {
        UDS_Service_Response(0x27u, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
}

/**
  *27����12�ӹ���
  */
void UDS_27Service_Sub12(void)
{
    uint32_t KeyReceive;
    uint32_t KeyCalcValue;

    KeyReceive = ( uint32_t )DiagMSG.msgData.SidDetail.Data [ 0 ];
    KeyReceive = (KeyReceive << 8u) | (( uint32_t )DiagMSG.msgData.SidDetail.Data [ 1 ]);
    KeyReceive = (KeyReceive << 8u) | (( uint32_t )DiagMSG.msgData.SidDetail.Data [ 2 ]);
    KeyReceive = (KeyReceive << 8u) | (( uint32_t )DiagMSG.msgData.SidDetail.Data [ 3 ]);

    KeyCalcValue = ( uint32_t )Ser27_FlowCtrl.LV11Key [ 0 ];
    KeyCalcValue = (KeyCalcValue << 8u) | (( uint32_t )Ser27_FlowCtrl.LV11Key [ 1 ]);
    KeyCalcValue = (KeyCalcValue << 8u) | (( uint32_t )Ser27_FlowCtrl.LV11Key [ 2 ]);
    KeyCalcValue = (KeyCalcValue << 8u) | (( uint32_t )Ser27_FlowCtrl.LV11Key [ 3 ]);

    if ( KeyReceive == KeyCalcValue )
    {
        Ser27_FlowCtrl.LV1SafetyStatus     = NormalKeyLock;
        Ser27_FlowCtrl.LV11SafetyStatus    = NormalKeyUnlock;
        Ser27_FlowCtrl.LV11Ctrl            = SER27_CLEAR_REQ_SEEDED;
        Ser27_FlowCtrlCnt.LV11InvaidKyeCnt = 0u;
        Ser27_FlowCtrlCnt.LV11ReqSeedCnt   = 0u;
        DiagMSG.msgData.Data [ 0 ]         = sendKey_LV11;
        /*������flashд�纯��*/
        Ser27_WriteCtrlInfoToDFlash( );

        if ( DiagMSG.msgData.SidDetail.PositiveSuppression == 0u )
        {
            UDS_Service_Response(0x27u, POSITIVE_RSP, DIAG_ID_Tx, 1u, DiagMSG.msgData.Data);
        }
    }
    else
    {
        Ser27_FlowCtrlCnt.LV11ReqSeedCnt += 1u;
        /*������flashд�纯��*/
        Ser27_WriteCtrlInfoToDFlash( );
        if ( Ser27_FlowCtrlCnt.LV11ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
        {
            Ser27_EnDelayTimer( );
            ( void )UDS_27Service_Sub_NRC36( );
        }
        else
        {
            ( void )UDS_27Service_Sub_NRC35( );
        }
        Ser27_FlowCtrl.LV11Ctrl = SER27_CLEAR_REQ_SEEDED;
    }
}

static void Ser27_CalculateKeyLV1(uint8_t Seed [], uint8_t Key [])
{
    uint8_t  i, j;
    uint8_t  seed2 [ 4 ] = {0};
    uint8_t  key [ 4 ]   = {0};
    uint8_t  key1 [ 4 ]  = {0};
    uint8_t  key2 [ 4 ]  = {0};
    uint32_t keyL        = 0;
    uint32_t key1L       = 0;
    uint32_t key2L       = 0;
    uint8_t *p;

    for ( i = 0; i < 4; ++i )
    {
        for ( j = 0; j < 8; ++j )
        {
            if ( j < 4 )
            {
                seed2 [ 3 - i ] |= (Seed [ i ] & (0x01 << j)) << ( uint8_t )(2 * (3 - j) + 1);
            }
            else
            {
                seed2 [ 3 - i ] |= (Seed [ i ] & (0x01 << j)) >> ( uint8_t )(2 * (j - 4) + 1);
            }
        }
    }

    for ( i = 0; i < 4; ++i )
    {
        key1 [ i ] = Seed [ i ] ^ XorArray [ i ];
        key2 [ i ] = seed2 [ i ] ^ XorArray [ i ];
    }

    key1L = ( uint32_t )key1 [ 0 ] << 24 | ( uint32_t )key1 [ 1 ] << 16 | ( uint32_t )key1 [ 2 ] << 8 | ( uint32_t )key1 [ 3 ];
    key2L = ( uint32_t )key2 [ 0 ] << 24 | ( uint32_t )key2 [ 1 ] << 16 | ( uint32_t )key2 [ 2 ] << 8 | ( uint32_t )key2 [ 3 ];

    keyL = key1L + key2L;

    for ( i = 0; i < 4; ++i )
    {
        key [ i ] = ( uint8_t )(keyL >> ( uint8_t )((3 - i) * 8));
    }

    //SeedKeyΪ����õ�������Key
    Key [ 0 ] = key [ 0 ];
    Key [ 1 ] = key [ 1 ];
    Key [ 2 ] = key [ 2 ];
    Key [ 3 ] = key [ 3 ];
}
