#include "UDS_2FService_Filter.h"

const uint8_t  S2FDLC [] = {5u,       5u,       5u,       5u,      5u,       5u,      4u,      4u,     4u,     4u,     4u,     4u,     4u    };
const uint16_t S2FDID [] = {0xF001u,  0xF002u,  0xF003u,  0xF004u, 0xF005u,  0xF006u, 0xF007u, 0x6201, 0x6202, 0x6203, 0x6204, 0x6205, 0x6206};

/**
  *2F�����Ƿ�֧�ֹ���Ѱַ
  *����Ѱַ�����θø�����
  *@return ���������
  */
uint8_t UDS_2FService_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    if ( DiagMSG.msgID == DIAG_ID_Rx_FUN )
    {
        NRC = serviceNotSupported;
    }
    return NRC;
}

/**
  *2F����Ự�Ƿ�֧����֤
  *����Ѱַ�����θø�����
  *@return ���������
  */
uint8_t UDS_2FService_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    if ( getSessionType( ) == DefaultSession )
    {
        NRC = serviceNotSupportedInActiveSession;
        if ( DiagMSG.msgID == DIAG_ID_Rx_PHY )
        {
            UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2F��������ȼ���֤
  *@return ���������
  */
uint8_t UDS_2FService_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    if ( getSecurityLevel( ) == NormalKeyUnlock )
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = securityAccessDenied;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    return NRC;
}

/**
  *2F������С������֤
  *@return ���������
  */
uint8_t UDS_2FService_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if ( DiagMSG.msgDLC < 3u )
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2F���񳬳�����Χ��֤
  *����Ѱַ�����θø�����
  *@return ���������
  */
uint8_t UDS_2FService_NRC31(void)
{
    uint8_t NRC = requestOutOfRange;
    uint8_t i;
    for ( i = 0u; i < DIM(S2FDID); ++i )
    {
        if ( getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2FDID [ i ] )
        {
            if( ( DiagMSG.msgData.Data[2] == 0x00 ) || ( DiagMSG.msgData.Data[2] == 0x03 ) )
            {
                NRC = positiveResponse;
            }
            else
            {
                NRC = requestOutOfRange;
            }
        }
    }
    if ( (NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY) )
    {
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    return NRC;
}

/**
  *2F�����ܳ��ȳ�����֤
  *@return ���������
  */
uint8_t UDS_2FService_NRC13_TotalLengthCheck(void)
{
    uint8_t i;
    uint8_t NRC = positiveResponse;
    if ( DiagMSG.msgData.DidDetail.Data [ 0 ] == 0u )
    {
        if ( DiagMSG.msgDLC != 3u )
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
        }
    }
    else if ( DiagMSG.msgData.DidDetail.Data [ 0 ] == 3u )
    {
        for ( i = 0u; i < DIM(S2FDID); ++i )
        {
            if ( getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2FDID [ i ] )
            {
                if ( DiagMSG.msgDLC != S2FDLC [ i ] )
                {
                    NRC = incorrectMessageLength;
                    UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
                }
                else
                {
                    NRC = positiveResponse;
                }
                break;
            }
        }
    }
    return NRC;
}

/**
  *2F����������֤
  *@return ���������
  */
uint8_t UDS_2FService_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    if ( getSpeed( ) >= 3u )
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else if ( getESpeed( ) > 400u )
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}
uint8_t UDS_2FService_NRC12(void)
{
    uint8_t NRC = positiveResponse;
    if ( (DiagMSG.msgData.DidDetail.Data [ 0 ] != 0u) && (DiagMSG.msgData.DidDetail.Data [ 0 ] != 3u) )
    {
        NRC = subFunctionNotSupported;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&NRC);
    }
    return NRC;
}
