#include "UDS_2FService_Internal.h"
#include "Display.h"
#include "BackLight.h"

/**
  *Control All Input Switch Status
  *@param ControlParameter 00:ReturnControlToECU 03:ShortTermAdjustment
  *@param ControlOption 1:响，0:灭
  *@param ControlEnableMask 1：控制该声音，0：不控制声音
  */
void BuzzerTest(uint8_t ControlParameter,  ControlMotolControlMusic ControlOption, ControlMotolControlMusicMask ControlEnableMask)
{
    if ( ControlParameter == 0x00u )
    {
        /*控制权归还仪表*/
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.DoorOpenSoundST == 0x01u)
        {
            if(ControlOption.Bit.DoorOpenSound == 0x01u)
            {
                /*响门开*/
            }
            else
            {
                /*不响门开*/
            }
            
        }
        else
        {
            /*不控制声音*/
        }
    }
    /*if ( ControlStatus == 0x00u )
    {
        BuzzerForceCtrlRelease( );
    }
    if ( ControlStatus == 0x03u )
    {
        BuzzerForceCtrlRequest( );
        if ( BuzzerStatus == 0x00u )
        {
            BuzzerCtrlStopPlaying( );
        }
        if ( BuzzerStatus == 0xFFu )
        {
            BuzzerCtrlPlayBack( );
        }
    }*/
}

/**
 *指针测试
 *@param ControlStatus 控制状态：0关闭解除控制，3强制控制
 *@param GaugeType 控制的指针类型：1车速，2转速，3燃油，4水温
 *@param GaugeStatus 控制的指针类型：0零刻度，1半刻度，2满刻度
 */
void GaugeTest(uint8_t ControlStatus, uint8_t GaugeType, uint8_t GaugeStatus)
{
    if ( ControlStatus == 0x00u )
    {
        //       IC_Ctrl_Right(5,0);
    }
    if ( ControlStatus == 0x03u )
    {
        // IC_Ctrl_2F(GaugeType,GaugeStatus);
    }
}

/**
  *Control All Input Switch Status
  *@param ControlParameter 00:ReturnControlToECU 03:ShortTermAdjustment
  *@param ControlOption 1:指示灯点亮，0:熄灭
  *@param ControlEnableMask 1：控制该指示灯，0：不控制指示灯
  */
void Lamp1WarningTest(uint8_t ControlParameter,  LEDCtrl_1 ControlOption, LEDCtrl_1_Mask ControlEnableMask)
{

    uint32_t i = 0u;
    if ( ControlParameter == 0x00u )
    {
        /*控制权归还仪表*/
        /*左转，右转需要接口*/
        UDS_Set_Telltales_Left_Right(0,0);
        Telltales_DiagRelease(m_LED_Rear_Fog);
        Telltales_DiagRelease(m_LED_Position);
        Telltales_DiagRelease(m_LED_HI_Beam);
        Telltales_DiagRelease(m_LED_LOW_Beam);
        Telltales_DiagRelease(m_LED_MIL);
        Telltales_DiagRelease(m_LED_OilPressure_Low);
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_Turn_L== 0x01u)
        {
            if(ControlOption.Bit.LED_Turn_L == 0x01u)
            {
                if(ControlEnableMask.Bit.LED_Turn_R)
                {
                    if(ControlOption.Bit.LED_Turn_R == 1)
                    {
                        UDS_Set_Telltales_Left_Right(1,1);
                    }
                    else
                    {
                        UDS_Set_Telltales_Left_Right(1,2);
                    }
                }
                else
                {
                    UDS_Set_Telltales_Left_Right(1,0);
                }
            }
            else
            {
                if(ControlEnableMask.Bit.LED_Turn_R)
                {
                    if(ControlOption.Bit.LED_Turn_R == 1)
                    {
                        UDS_Set_Telltales_Left_Right(2,1);
                    }
                    else
                    {
                        UDS_Set_Telltales_Left_Right(2,2);
                    }
                }
                else
                {
                    UDS_Set_Telltales_Left_Right(2,0);
                }
            }
            
        }
        else
        {
            if(ControlEnableMask.Bit.LED_Turn_R)
            {
                if(ControlOption.Bit.LED_Turn_R == 1)
                {
                    UDS_Set_Telltales_Left_Right(0,1);
                }
                else
                {
                    UDS_Set_Telltales_Left_Right(0,2);
                }
            }
            else
            {
                UDS_Set_Telltales_Left_Right(0,0);
            }
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_Turn_R== 0x01u)
        {
            if(ControlOption.Bit.LED_Turn_R == 0x01u)
            {
                if(ControlEnableMask.Bit.LED_Turn_L)
                {
                    if(ControlOption.Bit.LED_Turn_L == 1)
                    {
                        UDS_Set_Telltales_Left_Right(1,1);
                    }
                    else
                    {
                        UDS_Set_Telltales_Left_Right(2,1);
                    }
                }
                else
                {
                    UDS_Set_Telltales_Left_Right(0,1);
                }
            }
            else
            {
                if(ControlEnableMask.Bit.LED_Turn_L)
                {
                    if(ControlOption.Bit.LED_Turn_L == 1)
                    {
                        UDS_Set_Telltales_Left_Right(1,2);
                    }
                    else
                    {
                        UDS_Set_Telltales_Left_Right(2,2);
                    }
                }
                else
                {
                    UDS_Set_Telltales_Left_Right(0,2);
                }
            }
            
        }
        else
        {
            if(ControlEnableMask.Bit.LED_Turn_L)
            {
                if(ControlOption.Bit.LED_Turn_L == 1)
                {
                    UDS_Set_Telltales_Left_Right(1,0);
                }
                else
                {
                    UDS_Set_Telltales_Left_Right(2,0);
                }
            }
            else
            {
                UDS_Set_Telltales_Left_Right(0,0);
            }
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_Rear_Fog== 0x01u)
        {
            if(ControlOption.Bit.LED_Rear_Fog == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_Rear_Fog,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_Rear_Fog,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_Rear_Fog);
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_Position== 0x01u)
        {
            if(ControlOption.Bit.LED_Position == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_Position,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_Position,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_Position);
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_HI_Beam== 0x01u)
        {
            if(ControlOption.Bit.LED_HI_Beam == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_HI_Beam,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_HI_Beam,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_HI_Beam);
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_LOW_Beam== 0x01u)
        {
            if(ControlOption.Bit.LED_LOW_Beam == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_LOW_Beam,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_LOW_Beam,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_LOW_Beam);
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_MIL== 0x01u)
        {
            if(ControlOption.Bit.LED_MIL == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_MIL,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_MIL,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_MIL);
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_OilPressure_Low== 0x01u)
        {
            if(ControlOption.Bit.LED_OilPressure_Low == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_OilPressure_Low,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_OilPressure_Low,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_OilPressure_Low);
        }
    }

}

/**
  *Control All Input Switch Status
  *@param ControlParameter 00:ReturnControlToECU 03:ShortTermAdjustment
  *@param ControlOption 1:指示灯点亮，0:熄灭
  *@param ControlEnableMask 1：控制该指示灯，0：不控制指示灯
  */
void Lamp2WarningTest(uint8_t ControlParameter,  LEDCtrl_2 ControlOption, LEDCtrl_2_Mask ControlEnableMask)
{

    uint32_t i = 0u;
    if ( ControlParameter == 0x00u )
    {
        Telltales_DiagRelease(m_LED_Battery);
        Telltales_DiagRelease(m_LED_Coolant);
        Telltales_DiagRelease(m_LED_Fuel);
        Telltales_DiagRelease(m_LED_Seatbelt);
        Telltales_DiagRelease(m_LED_GPF_State);
        Telltales_DiagRelease(m_LED_Air_Bag);
        Telltales_DiagRelease(m_LED_ABS);
        Telltales_DiagRelease(m_LED_BrakeLiquid_Low);
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_Battery== 0x01u)
        {
            if(ControlOption.Bit.LED_Battery == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_Battery,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_Battery,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_Battery);
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_Coolant== 0x01u)
        {
            if(ControlOption.Bit.LED_Coolant == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_Coolant,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_Coolant,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_Coolant);
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_Fuel== 0x01u)
        {
            if(ControlOption.Bit.LED_Fuel == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_Fuel,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_Fuel,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_Fuel);
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_Seatbelt== 0x01u)
        {
            if(ControlOption.Bit.LED_Seatbelt == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_Seatbelt,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_Seatbelt,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_Seatbelt);
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_GPF_State== 0x01u)
        {
            if(ControlOption.Bit.LED_GPF_State == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_GPF_State,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_GPF_State,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_GPF_State);
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_Air_Bag== 0x01u)
        {
            if(ControlOption.Bit.LED_Air_Bag == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_Air_Bag,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_Air_Bag,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_Air_Bag);
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_ABS== 0x01u)
        {
            if(ControlOption.Bit.LED_ABS == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_ABS,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_ABS,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_ABS);
        }
    }
    if( ControlParameter == 0x03u )
    {
        if(ControlEnableMask.Bit.LED_BrakeLiquid_Low== 0x01u)
        {
            if(ControlOption.Bit.LED_BrakeLiquid_Low == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_BrakeLiquid_Low,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_BrakeLiquid_Low,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_BrakeLiquid_Low);
        }
    }

}


/**
  *Control All Input Switch Status
  *@param ControlParameter 00:ReturnControlToECU 03:ShortTermAdjustment
  *@param ControlOption 1:指示灯点亮，0:熄灭
  *@param ControlEnableMask 1：控制该指示灯，0：不控制指示灯
  */
void Lamp3WarningTest(uint8_t ControlParameter,  LEDCtrl_3 ControlOption, LEDCtrl_3_Mask ControlEnableMask)
{
    uint32_t i = 0u;
    if ( ControlParameter == 0x00u )
    {
        Telltales_DiagRelease(m_LED_ESC);
        Telltales_DiagRelease(m_LED_ESC_OFF);
        Telltales_DiagRelease(m_LED_TPMS);
        Telltales_DiagRelease(m_LED_BrakeLiquid_Low);
        Telltales_DiagRelease(m_LED_P);
        Telltales_DiagRelease(m_LED_FailureLamp);
        Telltales_DiagRelease(m_LED_CI);
        Telltales_DiagRelease(m_LED_EPS);
    }
    if( ControlParameter == 0x03u )//1
    {
        if(ControlEnableMask.Bit.LED_ESC== 0x01u)
        {
            if(ControlOption.Bit.LED_ESC == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_ESC,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_ESC,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_ESC);
        }
    }
    if( ControlParameter == 0x03u )//2
    {
        if(ControlEnableMask.Bit.LED_ESC_OFF== 0x01u)
        {
            if(ControlOption.Bit.LED_ESC_OFF == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_ESC_OFF,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_ESC_OFF,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_ESC_OFF);
        }
    }
    if( ControlParameter == 0x03u )//4
    {
        if(ControlEnableMask.Bit.LED_TPMS== 0x01u)
        {
            if(ControlOption.Bit.LED_TPMS == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_TPMS,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_TPMS,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_TPMS);
        }
    }
    if( ControlParameter == 0x03u )//5
    {
        if(ControlEnableMask.Bit.LED_BrakeLiquid_Low== 0x01u)
        {
            if(ControlOption.Bit.LED_BrakeLiquid_Low == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_BrakeLiquid_Low,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_BrakeLiquid_Low,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_BrakeLiquid_Low);
        }
    }
    if( ControlParameter == 0x03u )//6
    {
        if(ControlEnableMask.Bit.LED_P== 0x01u)
        {
            if(ControlOption.Bit.LED_P == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_P,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_P,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_P);
        }
    }
    if( ControlParameter == 0x03u )//7
    {
        if(ControlEnableMask.Bit.LED_FailureLamp== 0x01u)
        {
            if(ControlOption.Bit.LED_FailureLamp == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_FailureLamp,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_FailureLamp,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_FailureLamp);
        }
    }
    if( ControlParameter == 0x03u )//8
    {
        if(ControlEnableMask.Bit.LED_CI== 0x01u)
        {
            if(ControlOption.Bit.LED_CI == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_CI,2);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_CI,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_CI);
        }
    }
    
    if( ControlParameter == 0x03u )//3
    {
        if(ControlEnableMask.Bit.LED_EPS== 0x01u)
        {
            if(ControlOption.Bit.LED_EPS == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_EPS,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_EPS,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_EPS);
        }
    }
}


/**
  *Control All Input Switch Status
  *@param ControlParameter 00:ReturnControlToECU 03:ShortTermAdjustment
  *@param ControlOption 1:指示灯点亮，0:熄灭
  *@param ControlEnableMask 1：控制该指示灯，0：不控制指示灯
  */
void Lamp4WarningTest(uint8_t ControlParameter,  LEDCtrl_4 ControlOption, LEDCtrl_4_Mask ControlEnableMask)
{
    uint32_t i = 0u;
    if ( ControlParameter == 0x00u )
    {
        Telltales_DiagRelease(m_LED_Start_UP_Stop);
        Telltales_DiagRelease(m_LED_TFS);
        Telltales_DiagRelease(m_LED_Master_Warning);
        Telltales_DiagRelease(m_LED_Autohold);
        Telltales_DiagRelease(m_LED_HDC_STATUS);
        Telltales_DiagRelease(m_LED_HostLaneStatus);
        Telltales_DiagRelease(m_LED_HostLaneStatus);
        Telltales_DiagRelease(m_LED_Anti_theft);
    }
    if( ControlParameter == 0x03u )//1
    {
        if(ControlEnableMask.Bit.LED_Start_UP_Stop== 0x01u)
        {
            if(ControlOption.Bit.LED_Start_UP_Stop == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_Start_UP_Stop,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_Start_UP_Stop,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_Start_UP_Stop);
        }
    }
    if( ControlParameter == 0x03u )//2
    {
        if(ControlEnableMask.Bit.LED_TFS== 0x01u)
        {
            if(ControlOption.Bit.LED_TFS == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_TFS,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_TFS,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_TFS);
        }
    }
    if( ControlParameter == 0x03u )//3
    {
        if(ControlEnableMask.Bit.LED_Master_Warning== 0x01u)
        {
            if(ControlOption.Bit.LED_Master_Warning == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_Master_Warning,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_Master_Warning,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_Master_Warning);
        }
    }
    if( ControlParameter == 0x03u )//4
    {
        if(ControlEnableMask.Bit.LED_Autohold== 0x01u)
        {
            if(ControlOption.Bit.LED_Autohold == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_Autohold,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_Autohold,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_Autohold);
        }
    }
    if( ControlParameter == 0x03u )//5
    {
        if(ControlEnableMask.Bit.LED_HDC_STATUS== 0x01u)
        {
            if(ControlOption.Bit.LED_HDC_STATUS == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_HDC_STATUS,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_HDC_STATUS,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_HDC_STATUS);
        }
    }
    if( ControlParameter == 0x03u )//6
    {
        if(ControlEnableMask.Bit.LED_HostLaneStatus_Y== 0x01u)
        {
            if(ControlOption.Bit.LED_HostLaneStatus_Y == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_HostLaneStatus,2);
            }
            else
            {
                if((ControlEnableMask.Bit.LED_HostLaneStatus_R != 1) || (ControlOption.Bit.LED_HostLaneStatus_R !=1))
                {
                    Telltales_DiagCtrl(m_LED_HostLaneStatus,0);
                }
            }
            
        }
        else
        {
            if((ControlEnableMask.Bit.LED_HostLaneStatus_R != 1) || (ControlOption.Bit.LED_HostLaneStatus_R !=1))
            {
                Telltales_DiagRelease(m_LED_HostLaneStatus);
            }
        }
    }
    if( ControlParameter == 0x03u )//7
    {
        if(ControlEnableMask.Bit.LED_HostLaneStatus_R== 0x01u)
        {
            if(ControlOption.Bit.LED_HostLaneStatus_R == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_HostLaneStatus,3);
            }
            else
            {
                if((ControlEnableMask.Bit.LED_HostLaneStatus_Y != 1) || (ControlOption.Bit.LED_HostLaneStatus_Y !=1))
                {
                    Telltales_DiagCtrl(m_LED_HostLaneStatus,0);
                }
            }
            
        }
        else
        {
            if((ControlEnableMask.Bit.LED_HostLaneStatus_Y != 1) || (ControlOption.Bit.LED_HostLaneStatus_Y !=1))
            {
                Telltales_DiagRelease(m_LED_HostLaneStatus);
            }
        }
    }
    if( ControlParameter == 0x03u )//8
    {
        if(ControlEnableMask.Bit.LED_Anti_theft== 0x01u)
        {
            if(ControlOption.Bit.LED_Anti_theft == 0x01u)
            {
                Telltales_DiagCtrl(m_LED_Anti_theft,1);
            }
            else
            {
                Telltales_DiagCtrl(m_LED_Anti_theft,0);
            }
            
        }
        else
        {
            Telltales_DiagRelease(m_LED_Anti_theft);
        }
    }
}

/**
 *display fuel meter
 *@param ControlStatus 控制状态：0关闭解除控制，3强制控制
 *@param SegmentLCDStatus 报警灯状态：0关闭所有段码，FF开启所有段码
 */
void FuelMeterControl(uint8_t ControlStatus, uint8_t Bar)
{
    if ( ControlStatus == 0x00u )
    {
        
        IC_Ctrl_Right(2,0);
    }
    if ( ControlStatus == 0x03u )
    {
        IC_Ctrl_2F(2,Bar);
    }
}

/**
 *display Temperature meter
 *@param ControlStatus 控制状态：0关闭解除控制，3强制控制
 *@param SegmentLCDStatus 报警灯状态：0关闭所有段码，FF开启所有段码
 */
void TemperatureMeterControl(uint8_t ControlStatus, uint8_t Bar)
{
    if ( ControlStatus == 0x00u )
    {
        IC_Ctrl_Right(1,0);
    }
    if ( ControlStatus == 0x03u )
    {
        IC_Ctrl_2F(1,Bar);
    }
}

/**
 *段码测试
 *@param ControlStatus 控制状态：0关闭解除控制，3强制控制
 *@param SegmentLCDStatus 报警灯状态：0关闭所有段码，FF开启所有段码
 */
void SegmentLCDTest_Factory(uint8_t ControlStatus, uint8_t SegmentLCDStatus)
{
    if ( ControlStatus == 0x00u )
    {
        Display_Factory_Release( );
    }
    if ( ControlStatus == 0x03u )
    {
        if ( SegmentLCDStatus == 0x00u )
        {
            Display_Factory_Release( );
        }
        if ( SegmentLCDStatus == 0x01u )
        {
            Display_Factory_Ctrl( );
        }
    }
}

/**
 *蜂鸣器测试
 *@param ControlStatus 控制状态：0关闭解除控制，3强制控制
 *@param BuzzerStatus 蜂鸣器状态：0关闭蜂鸣器，FF开启蜂鸣器
 */
void BuzzerTest_Factory(uint8_t ControlStatus, uint8_t BuzzerStatus)
{
    BuzzerFactoryCtrl_1(ControlStatus, BuzzerStatus);
}

/**
 *odo测试
 *@param ControlStatus 控制状态：0关闭解除控制，3强制控制
 *@param SegmentLCDStatus 报警灯状态：0关闭所有段码，FF开启所有段码
 */
void Factory_ODO_Test(uint8_t ControlStatus, uint8_t SegmentLCDStatus)
{
    Data_Mileage_Clear( );
}

/**
 *odo测试
 *@param ControlStatus 控制状态：0关闭解除控制，3强制控制
 *@param SegmentLCDStatus 报警灯状态：0关闭所有段码，FF开启所有段码
 */
void BackLight_Test(uint8_t ControlStatus, uint8_t SegmentLCDStatus)
{
    // BackLightTest(ControlStatus, SegmentLCDStatus);
}
