#include "UDS_DTC.h"
#include "CAN_CFG.h"
#include "Common_Interface.h"
#include "DoCAN_ISO15765.h"
#include "Key.h"
#include "System_Monitor.h"

uint8_t isNeedSaveDTC  = 0u;
uint8_t HVoltageStatus = 0u;
uint8_t LVoltageStatus = 0u;
uint8_t KEYStatus      = 0u;

/**
  *DTC列表
  */
uint32_t DTCList [ 22 ][ 2 ] = {
    { U110017, 1},
    { U110116, 1},
    { U001988, 1},
    { U114587, 1},
    { U116687, 1},
    { U116887, 1},
    { U116987, 0},//only for phev
    { U114787, 1},
    { U114887, 1},
    { U148087, 1},
    { U112587, 1},//only for fuel
    { U113087, 1},
    { U117687, 1},
    { U113387, 1},
    { U113587, 1},
    { U114187, 1},
    { B110111, 1},
    { B110115, 1},
    { B110341, 1},
    { B110515, 1},
    { B110400, 1},
    { U110216, 1},
};

/**
*DTC状态
  */
uint8_t DTCUpdataStatusList [ 22 ] = {0u};

/**
  *DTC发生时间
  */
uint32_t DTCTimerList [ 22 ] = {0u};

/**
  *msg列表
  */
uint16_t msgList [ 13 ][ 4 ] = {
    {0x366u, 8u, 100u,  0u,},/*1000ms*/
    {0x2D8u, 8u, 100u,  0u,},/*1000ms*/
    {0x501u, 8u, 1000u, 0u,},/*5000ms*/
    {0x362u, 8u, 100u,  0u,},/*1000ms*/
    {0x28Bu, 8u, 40u,   0u,},/*1000ms*/
    {0x347u, 8u, 500u,  0u,},/*1000ms*/
    {0x2E0u, 8u, 100u,  0u,},/*1000ms*/
    {0x196u, 8u, 50u,   0u,},/*1000ms*/
    {0x355u, 8u, 100u,  0u,},/*2500ms*/
    {0x338u, 8u, 100u,  0u,},/*1000ms*/
    {0x24Fu, 8u, 100u,  0u,},/*1000ms*/
    {0x187u, 8u, 100u,  0u,},/*1000ms*/
    {0x050u, 8u, 500u,  0u,},/*1000ms*/
};

/**
  *测试DTC
  *@param timer 计时器增加的时间，单位：ms
  */
void TestDTC(uint16_t timer)
{
    //TestDTC_B110762(timer); /*点火信号异常 C*/
    if ( getKL15Status( ) )
    {
        TestDTC_U110216(timer); /*KL 30电异常*/
        if ( ! getEngStatus( ) )
        {
            TestDTC_U110116(timer); /*电池电压小于阀值 C*/
            TestDTC_U110017(timer); /*电池电压超出阀值 C*/
            TestDTC_B110341(timer); /*EEPROM Checksum error EEPROM*/
            if ( ! getPowerStatus( ) )
            {
                TestDTC_U001988(     ); /* InfoCAN节点总线关闭 C*/
                TestDTC_B110515(timer); /*Steering swich open circuit*/
                TestDTC_B110400(timer); /*BSD LED failure盲区指示LED故障*/
                TestDTC_B110111(timer); /* Circuit short to ground 回路对地短路 */
                if(IGNON_4S())
                {
                    TestDTC_B110115(timer); /* Circuit short to battery or open 回路对电源短路或开路*/
                }
                if ( ! getBusoffStatus( ) )
                {
                    if ( (isDTCEnable( ) == 1u) )
                    {
                        TestDTC_U114587( ); /**/
                        TestDTC_U116687( ); /**/
                        TestDTC_U116887( ); /**/
                        TestDTC_U116987( ); /**/
                        TestDTC_U114787( ); /**/
                        TestDTC_U114887( ); /**/
                        TestDTC_U148087( ); /**/
                        TestDTC_U112587( ); /**/
                        TestDTC_U113087( ); /**/
                        TestDTC_U117687( ); /**/
                        TestDTC_U113387( ); /**/
                        TestDTC_U113587( ); /**/
                        TestDTC_U114187( ); /**/

                    }
                }
            }
            if ( (isNeedSaveDTC) && (TpCtrl.Process == TP_IDLE) )
            {
                SaveDTCData( );
                isNeedSaveDTC = 0u;
            }
        }
    }
}

/**
  *检测can总线关闭
  */
void TestDTC_U001988(void)
{
    // if ( DTCList [ cnU001988 ][ 1u ] )
    // {
    //     if ( GetBusOffState( ) )
    //     {
    //         if ( NM_GetCanBusoffOccurCnt( ) >= 5u )
    //         {
    //             ChangeDTCData(cnU001988, DTCError);
    //         }
    //     }
    //     else
    //     {
    //         ChangeDTCData(cnU001988, DTCNoError);
    //     }
    // }
}

/**
  *检测控制模块输入电压低
  *@param timer 计时器增加的时间，单位：ms
  */
void TestDTC_U110116(uint16_t timer)
{
    uint16_t KL30Voltage = 0u;
    if ( DTCList [ cnU110116 ][ 1u ] )
    {
        KL30Voltage = getKL30Voltage( );
        if ( KL30Voltage <= MinimumVoltage )
        {
            if ( DTCTimerList [ cnU110116 ] == LowVoltageTimer )
            {
                ChangeDTCData(cnU110116, DTCError);
            }
            else
            {
                DTCTimerList [ cnU110116 ] += timer;
            }
        }
        if ( KL30Voltage >= RestoreMinimumVoltage )
        {
            if ( DTCTimerList [ cnU110116 ] == 0u )
            {
                ChangeDTCData(cnU110116, DTCNoError);
            }
            else
            {
                if ( DTCTimerList [ cnU110116 ] > timer )
                {
                    DTCTimerList [ cnU110116 ] -= timer;
                }
                else
                {
                    DTCTimerList [ cnU110116 ] = 0u;
                }
            }
        }
    }
}

/**
  *检测控制模块输入电压高
  *@param timer 计时器增加的时间，单位：ms
  */
void TestDTC_U110017(uint16_t timer)
{
    uint16_t KL30Voltage = 0u;
    if ( DTCList [ cnU110017 ][ 1u ] )
    {
        KL30Voltage = getKL30Voltage( );
        if ( KL30Voltage >= MaximumVoltage )
        {
            if ( DTCTimerList [ cnU110017 ] == HightVoltageTimer )
            {
                ChangeDTCData(cnU110017, DTCError);
            }
            else
            {
                DTCTimerList [ cnU110017 ] += timer;
            }
        }
        if ( KL30Voltage <= RestoreMaximumVoltage )
        {
            if ( DTCTimerList [ cnU110017 ] == 0u )
            {
                ChangeDTCData(cnU110017, DTCNoError);
            }
            else
            {
                if ( DTCTimerList [ cnU110017 ] > timer )
                {
                    DTCTimerList [ cnU110017 ] -= timer;
                }
                else
                {
                    DTCTimerList [ cnU110017 ] = 0u;
                }
            }
        }
    }
}

/**
  *AC_366（ 报文） Message timeout
  */
void TestDTC_U114587(void)
{
    if ( DTCList [ cnU114587 ][ 1u ] )
    {
        if ( getMSGStatus(cnMSG366) )
        {
            ChangeDTCData(cnU114587, DTCError);
        }
        else
        {
            ChangeDTCData(cnU114587, DTCNoError);
        }
    }
}

/**
  *THU_HU_AVM_2D8（PHEV）/HU_AVM_2D8（燃油）（ 报文） Message timeout
  */
void TestDTC_U116687(void)
{
    if ( DTCList [ cnU116687 ][ 1u ] )
    {
        if ( getMSGStatus(cnMSG2D8) )
        {
            ChangeDTCData(cnU116687, DTCError);
        }
        else
        {
            ChangeDTCData(cnU116687, DTCNoError);
        }
    }
}

/**
  *HU_501（ 报文） Message timeout(是否有配置)
  */
void TestDTC_U116887(void)
{
    if ( DTCList [ cnU116887 ][ 1u ] )
    {
        //if(Val_EOL_F1FA_HU() == 1)
        {
            if ( getMSGStatus(cnMSG501) )
            {
                ChangeDTCData(cnU116887, DTCError);
            }
            else
            {
                ChangeDTCData(cnU116887, DTCNoError);
            }
        }
    }
}

/**
  *PCU_33B_2_362（PHEV）（ 报文） Message timeout
  */
void TestDTC_U116987(void)
{
    if ( DTCList [ cnU116987 ][ 1u ] )
    {
        if ( getMSGStatus(cnMSG362) )
        {
            ChangeDTCData(cnU116987, DTCError);
        }
        else
        {
            ChangeDTCData(cnU116987, DTCNoError);
        }
    }
}

/**
  *BDCF_BCM_28B（PHEV）/BCM_28B（燃油）（ 报文） Message timeout
  */
void TestDTC_U114787(void)
{
    if ( DTCList [ cnU114787 ][ 1u ] )
    {
        if ( getMSGStatus(cnMSG28B) )
        {
            ChangeDTCData(cnU114787, DTCError);
        }
        else
        {
            ChangeDTCData(cnU114787, DTCNoError);
        }
    }
}

/**
  *BCM_347（ 报文） Message timeout
  */
void TestDTC_U114887(void)
{
    if ( DTCList [ cnU114887 ][ 1u ] )
    {
        if ( getMSGStatus(cnMSG347) )
        {
            ChangeDTCData(cnU114887, DTCError);
        }
        else
        {
            ChangeDTCData(cnU114887, DTCNoError);
        }
    }
}

/**
  *RRS_2E0（ 报文） Message timeout(可能有配置)
  */
void TestDTC_U148087(void)
{
    if ( DTCList [ cnU148087 ][ 1u ] )
    {
        //if((Val_EOL_F1FA_RadarType( ) == RADAR_R4) || (Val_EOL_F1FA_RadarType( ) == RADAR_F2R4))
        {
            if ( getMSGStatus(cnMSG2E0) )
            {
                ChangeDTCData(cnU148087, DTCError);
            }
            else
            {
                ChangeDTCData(cnU148087, DTCNoError);
            }
        }
    }
}

/**
  *GW_EMS_196（ 报文） Message timeout
  */
void TestDTC_U112587(void)
{
    if ( DTCList [ cnU112587 ][ 1u ] )
    {
        if ( getMSGStatus(cnMSG196) )
        {
            ChangeDTCData(cnU112587, DTCError);
        }
        else
        {
            ChangeDTCData(cnU112587, DTCNoError);
        }
    }
}

/**
  *GW_EMS_355（ 报文） Message timeout
  */
void TestDTC_U113087(void)
{
    if ( DTCList [ cnU113087 ][ 1u ] )
    {
        if ( getMSGStatus(cnMSG355) )
        {
            ChangeDTCData(cnU113087, DTCError);
        }
        else
        {
            ChangeDTCData(cnU113087, DTCNoError);
        }
    }
}

/**
  *TCU_338（PHEV）/GW_TCU_338（燃油）（ 报文） Message timeout
  */
void TestDTC_U117687(void)
{
    if ( DTCList [ cnU117687 ][ 1u ] )
    {
        if ( getMSGStatus(cnMSG338) )
        {
            ChangeDTCData(cnU117687, DTCError);
        }
        else
        {
            ChangeDTCData(cnU117687, DTCNoError);
        }
    }
}

/**
  *EPS_24F（PHEV）/GW_EPS_24F（燃油）（ 报文） Message timeout
  */
void TestDTC_U113387(void)
{
    if ( DTCList [ cnU113387 ][ 1u ] )
    {
        if ( getMSGStatus(cnMSG24F) )
        {
            ChangeDTCData(cnU113387, DTCError);
        }
        else
        {
            ChangeDTCData(cnU113387, DTCNoError);
        }
    }
}

/**
  *IBCU_17A_0_187（PHEV）/GW_EPBI_187（燃油）（ 报文） Message timeout
  */
void TestDTC_U113587(void)
{
    if ( DTCList [ cnU113587 ][ 1u ] )
    {
        if ( getMSGStatus(cnMSG187) )
        {
            ChangeDTCData(cnU113587, DTCError);
        }
        else
        {
            ChangeDTCData(cnU113587, DTCNoError);
        }
    }
}

/**
  *SRS_50（PHEV）/GW_SRS_050（燃油）（ 报文） Message timeout
  */
void TestDTC_U114187(void)
{
    if ( DTCList [ cnU114187 ][ 1u ] )
    {
        if ( getMSGStatus(cnMSG050) )
        {
            ChangeDTCData(cnU114187, DTCError);
        }
        else
        {
            ChangeDTCData(cnU114187, DTCNoError);
        }
    }
}

/**
  * Fuel Sensor Fault 燃油传感器故障 Circuit short to ground 回路对地短路（需要接口）
  */
void TestDTC_B110111(uint16_t timer)
{
    // if ( DTCList [ cnB110111 ][ 1u ] )
    // {
    //     if ( (DATA_FUEL_SLIDE_RES <= 100) /*|| (Get_Fuel_Status() == 2)*/ )
    //     {
    //         if ( DTCTimerList [ cnB110111 ] == 20000u )
    //         {
    //             ChangeDTCData(cnB110111, DTCError);
    //         }
    //         else
    //         {
    //             DTCTimerList [ cnB110111 ] += timer;
    //         }
    //     }
    //     else
    //     {
    //         if ( DTCTimerList [ cnB110111 ] == 0u )
    //         {
    //             ChangeDTCData(cnB110111, DTCNoError);
    //         }
    //         else
    //         {
    //             if ( DTCTimerList [ cnB110111 ] > timer )
    //             {
    //                 DTCTimerList [ cnB110111 ] -= timer;
    //             }
    //             else
    //             {
    //                 DTCTimerList [ cnB110111 ] = 0u;
    //             }
    //         }
    //     }
    // }
}

/**
  * Fuel Sensor Fault 燃油传感器故障  Circuit short to battery or open 回路对电源短路或开路（需要接口）
  */
void TestDTC_B110115(uint16_t timer)
{
    // if ( DTCList [ cnB110115 ][ 1u ] )
    // {
    //     if ( (DATA_FUEL_SLIDE_RES >= 3100) /*|| (Get_Fuel_Status() == 1)*/ )
    //     {
    //         if ( DTCTimerList [ cnB110115 ] == 20000u )
    //         {
    //             ChangeDTCData(cnB110115, DTCError);
    //         }
    //         else
    //         {
    //             DTCTimerList [ cnB110115 ] += timer;
    //         }
    //     }
    //     else
    //     {
    //         if ( DTCTimerList [ cnB110115 ] == 0u )
    //         {
    //             ChangeDTCData(cnB110115, DTCNoError);
    //         }
    //         else
    //         {
    //             if ( DTCTimerList [ cnB110115 ] > timer )
    //             {
    //                 DTCTimerList [ cnB110115 ] -= timer;
    //             }
    //             else
    //             {
    //                 DTCTimerList [ cnB110115 ] = 0u;
    //             }
    //         }
    //     }
    // }
}

/**
  *  EEPROM Checksum error EEPROM 校验错误 （需要接口）
  */
void TestDTC_B110341(uint16_t timer)
{
    if ( DTCList [ cnB110341 ][ 1u ] )
    {
        if ( 0 ) 
        {
            
            ChangeDTCData(cnB110341, DTCError);
        }
        else
        {
            ChangeDTCData(cnB110341, DTCNoError);
        }
            
    }
}

/**
  *  Steering swich open circuit
     键开关开路(需要接口)
  */
void TestDTC_B110515(uint16_t timer)
{
    if ( DTCList [ cnB110515 ][ 1u ] )
    {
        if ( (Get_UDS_Key_Res() == 1) || (Get_UDS_Key_30S() == 1) ) 
        {
            //if(DTCTimerList[cnB110515] <= 1000)
            //{
            //    DTCTimerList[cnB110515] += timer;
            //}
            //else
            //{
              ChangeDTCData(cnB110515, DTCError);
            //}
        }
        else
        {
            //if(DTCTimerList[cnB110515] >= timer)
            //{
            //    DTCTimerList[cnB110515] -= timer;
            //}
            //else
            //{
            //  DTCTimerList[cnB110515] = 0;
              ChangeDTCData(cnB110515, DTCNoError);
            //}
        }   
    }
}

/**
  *  BSD LED failure盲区指示LED故障 (需要接口) 刘野说没有
  */
void TestDTC_B110400(uint16_t timer)
{
    if ( DTCList [ cnB110400 ][ 1u ] )
    {
        if ( 0 ) 
        {
            if(DTCTimerList[cnB110400] <= 1000)
            {
                DTCTimerList[cnB110400] += timer;
            }
            else
            {
                DTCTimerList[cnB110400] = 1000;
                ChangeDTCData(cnB110400, DTCError);
            }
        }
        else
        {
            if(DTCTimerList[cnB110400] >= timer)
            {
                DTCTimerList[cnB110400] -= timer;
            }
            else
            {
                DTCTimerList[cnB110400] = 0;
                ChangeDTCData(cnB110400, DTCNoError);
            }
        }   
    }
}


/**
  *  30电断路，或电压低（欠压）,15电正常工作 (需要接口)
  */
void TestDTC_U110216(uint16_t timer)
{
    if ( DTCList [ cnU110216 ][ 1u ] )
    {
        if ( Get_UDS_KL30_Abnormal_Status() ) 
        {
            if(DTCTimerList[cnU110216] <= 2000)
            {
                DTCTimerList[cnU110216] += timer;
            }
            else
            {
                DTCTimerList[cnU110216] = 2000;
                ChangeDTCData(cnU110216, DTCError);
            }
        }
        else
        {
            if(DTCTimerList[cnU110216] >= timer)
            {
                DTCTimerList[cnU110216] -= timer;
            }
            else
            {
                DTCTimerList[cnU110216] = 0;
                ChangeDTCData(cnU110216, DTCNoError);
            }
        }   
    }
}





/**
  *获取30电电压状态
  *@return 30电电压状态 0为电压正常,1为低压,2为高压
  */
uint8_t getPowerStatus(void)
{
    uint8_t  enResult    = NormalVottage;
    uint16_t KL30Voltage = getKL30Voltage( );

    if ( (KL30Voltage >= 8500u) && (KL30Voltage <= 16500u) )
    //if ( (KL30Voltage >= 6500u) && (KL30Voltage <= 18000u) )
    {
        if ( LVoltageStatus == 1u )
        {
            if ( KL30Voltage < 9000u )
            //if ( KL30Voltage < 7500u )
            {
                enResult = LowVottage;
                setDTCEnableTimer(H_LVoltageDTCEnableTimer);
            }
            else
            {
                LVoltageStatus = 0u;
                enResult       = NormalVottage;
            }
        }
        else if ( HVoltageStatus == 1u )
        {
            if ( KL30Voltage > 16000u )
            //if ( KL30Voltage > 17000u )
            {
                enResult = HightVottage;
                setDTCEnableTimer(H_LVoltageDTCEnableTimer);
            }
            else
            {
                HVoltageStatus = 0u;
                enResult       = NormalVottage;
            }
        }
        else
        {
            enResult = NormalVottage;
        }
    }
    else if ( KL30Voltage > 16500u )
    //else if ( KL30Voltage > 18000u )
    {
        HVoltageStatus = 1u;
        enResult       = HightVottage;
        setDTCEnableTimer(H_LVoltageDTCEnableTimer);
    }
    else
    {
        LVoltageStatus = 1u;
        enResult       = LowVottage;
        setDTCEnableTimer(H_LVoltageDTCEnableTimer);
    }
    return enResult;
}

/**
  *获取busoff状态
  *@return busoff状态 0为正常,1为异常
  */
uint8_t getBusoffStatus(void)
{
    if ( GetBusOffState( ) )
    {
        setDTCEnableTimer(BusOffDTCEnableTimer);
    }
    return GetBusOffState( );
}

/**
  *获取发动机启动状态
  *@return EngStatus 0为未启动,1为启动
  */
uint8_t getEngStatus(void)
{
    uint8_t status = 0u;
    status         = 0;//Get_CAN_CH0_ID_1A6_Sig_EMS_EngineStatus( );
    if ( status == 1u )
    {
        status = 1u;
    }
    return status;
}

/**
  *设置按键状态
  *@param Statues 最高位 1为卡滞 0为松开, 后7为位按键类型
  */
void set_DTC_Key_Statues(uint8_t Statues)
{
    if ( (Statues & 0x80u) == 0x80u )
    {
        KEYStatus = KEYStatus | (Statues & 0x7Fu);
    }
    else
    {
        KEYStatus = KEYStatus & (~Statues);
    }
}
/*
*获取显示屏状态
*/
uint8_t Get_LED_Status(void)
{
    uint8_t res;
    res = 0;
    return res;
}
/**
  *获取报文状态
  *@param cnMsgID 报文数组下标
  *@return 报文状态 0为在线,1为掉线
  */
uint8_t getMSGStatus(uint8_t cnMsgID)
{
    uint8_t enResult;
    if ( msgList [ cnMsgID ][ 2 ] < 200u )
    {
        if ( msgList [ cnMsgID ][ 3 ] < 200u * OfflineLoopMultiple )
        {
            enResult = 0u;
        }
        else
        {
            enResult = 1u;
        }
    }
    else
    {
        if ( msgList [ cnMsgID ][ 3 ] < msgList [ cnMsgID ][ 2 ] * OfflineLoopMultiple )
        {
            enResult = 0u;
        }
        else
        {
            enResult = 1u;
        }
    }
    return enResult;
}

/**
  *更改DTC状态
  *@param DTCNum DTC编号
  *@param DTCStatus DTC状态
  */
void ChangeDTCData(uint8_t DTCNum, uint8_t DTCStatus)
{
    if ( DTCTestIsOpen( ) )
    {
        if ( ( uint8_t )(DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus & DTCNoTestLastClear) == DTCNoTestLastClear )
        {
            DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus = ( uint8_t )(DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus & (~DTCNoTestLastClear));
        }
        if ( ( uint8_t )(DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus & DTCNoTestThisCycle) == DTCNoTestThisCycle )
        {
            DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus = ( uint8_t )(DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus & (~DTCNoTestThisCycle));
        }
        if ( DTCStatus == DTCError )
        {
            if ( ( uint8_t )(DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus & DTCError) != DTCError )
            {
                DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus |= DTCError;
                if ( ( uint8_t )(DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus & DTCErrorThisCycle) != DTCErrorThisCycle )
                {
                    DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus |= DTCErrorThisCycle;
                    DTCToDFlashInfo.DTC [ DTCNum ].DTCAgeing = 0u;
                    DTCToDFlashInfo.DTC [ DTCNum ].DTCPendingCount++;
                    if ( DTCToDFlashInfo.DTC [ DTCNum ].DTCPendingCount >= MaxDTCPendingCount )
                    {
                        if ( ( uint8_t )(DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus & DTCConfirmed) != DTCConfirmed )
                        {
                            DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus |= DTCConfirmed;
                        }
                    }
                }
                if ( ( uint8_t )(DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus & DTCPending) != DTCPending )
                {
                    DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus |= DTCPending;
                }
                if ( ( uint8_t )(DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus & DTCErrorLastClear) != DTCErrorLastClear )
                {
                    DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus |= DTCErrorLastClear;
                }
                //DTCToDFlashInfo.DTC [ DTCNum ].Snapshot.OdometerValue       = Data_ODO_Read( ) / 10u;
                //DTCToDFlashInfo.DTC [ DTCNum ].Snapshot.SystemSupplyVoltage = ( uint8_t )(getKL30Voltage( ) / 100u);
                //DTCToDFlashInfo.DTC [ DTCNum ].Snapshot.VehicleSpeed        = getSpeed( );
                //DTCToDFlashInfo.DTC[DTCNum].Snapshot.DTCLocalTime = (year<<26)|(month<<22)|(hour<<17)|(hour<<12)|(minute<<6)|second;
                //DTCToDFlashInfo.DTC [ DTCNum ].Snapshot.DTCLocalTime_second = Get_CAN_CH0_ID_501_Sig_HU_LocalTimeSecond( );
                //DTCToDFlashInfo.DTC [ DTCNum ].Snapshot.DTCLocalTime_minute = Get_CAN_CH0_ID_501_Sig_HU_LocalTimeMinute( );
                //DTCToDFlashInfo.DTC [ DTCNum ].Snapshot.DTCLocalTime_hour   = Get_CAN_CH0_ID_501_Sig_HU_LocalTimeHour( );
                //DTCToDFlashInfo.DTC [ DTCNum ].Snapshot.DTCLocalTime_day    = Get_CAN_CH0_ID_501_Sig_HU_LocalTimeDate( );
                //DTCToDFlashInfo.DTC [ DTCNum ].Snapshot.DTCLocalTime_month  = Get_CAN_CH0_ID_501_Sig_HU_LocalTimeMonth( );
                //DTCToDFlashInfo.DTC [ DTCNum ].Snapshot.DTCLocalTime_year   = Get_CAN_CH0_ID_501_Sig_HU_LocalTimeYear( );
                //DTCUpdataStatusList [ DTCNum ]                              = 1u;
                isNeedSaveDTC                                               = 1u;
                DTCUpdataStatusList [ DTCNum ]                              = 1u;
            }
        }
        else
        {
            if ( ( uint8_t )(DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus & DTCError) == DTCError )
            {
                DTCToDFlashInfo.DTC [ DTCNum ].DTCStatus &= DTCNoError;
                DTCUpdataStatusList [ DTCNum ] = 1u;
                isNeedSaveDTC                  = 1u;
            }
        }
    }
}

/**
  *保存DTC状态
  */
void SaveDTCData(void)
{
    //( void )WriteDFlashData(WriteDTCAddr, ( uint32_t * )&DTCToDFlashInfo.Flag, sizeof(DTCToDFlashInfo), NoNeedWait, 0xEE);
}
