
#include "CAN_CFG.h"
#include "TYW_stdint.h"
#include "RSCAN.h"
#include "RTE_GPIO.h"
#include "RTE_CAN.h"
// #include "NM_Config.h"
#include "UDS_DTC.h"
// uint8_t NMWakeupFalg = 0u;
uint8_t CAN_APP_STATUS;
uint8_t CAN_NM_STATUS;
uint8_t CAN_NM__REC_STATUS;

uint8_t GetBusOffState(void)
{
    uint8_t rscan_st;
    rscan_st = RSCAN0_CH4_Get_Busoff_Status( );
    return rscan_st;
}

void AbortAllCanTx(void)
{
    // RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_0);
    // RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_1);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_2);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_3);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_4);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_5);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_6);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_7);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_8);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_9);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_10);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_11);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_12);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_13);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_14);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_15);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_16);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_17);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_18);
    RSCAN0_CH4_Abort(RSCAN_CHANNEL_BUF_19);
}

void CanBusoffRecover(void)
{
    AbortAllCanTx( );
    RSCAN0_CH4_Busoff_Recover( );
}

void CanInit(void)
{
    CAN_APP_STATUS     = 0u;
    CAN_NM_STATUS      = 0u;
    CAN_NM__REC_STATUS = 0U;
    Can_Init( );
    // NMWakeupFalg = 0u;
    //Can2_Init( );
}

void CanRequestSleep(void)
{
   //RSCAN0_Sleep_Init( );
//    NMWakeupFalg = 1u;
}

void SetCanSTBLevel(uint8_t n)
{
    B_CAN_STB = n;
}

void CAN_SET_APP_SEND(uint8_t status)
{
    CAN_APP_STATUS = status;
}
void CAN_SET_NM_SEND(uint8_t status)
{
    CAN_NM_STATUS = status;
}
void CAN_SET_NM_REC(uint8_t status)
{
    CAN_NM__REC_STATUS = status;
}

uint8_t CAN_GET_NM_REC(void)
{
    return CAN_NM__REC_STATUS;
}
uint8_t CAN_GET_APP_SEND(void)
{
    return CAN_APP_STATUS;
}
uint8_t CAN_GET_NM_SEND(void)
{
    return CAN_NM_STATUS;
}
void CanTxMsg(uint8_t SendCh, uint8_t *data, uint8_t len, uint32_t id)
{
    uint32_t       i;
    static uint8_t       i_dtc = 0;
    uint8_t      count     = 0U;
    uint8_t        DTCStatus = 0U;
    uint32_t       DTC       = 0U;
    CAN_Frame_st_t m_msg;
    // ( void )NmSetLastId(id);
    switch ( id )
    {
        case 0x401U:
            m_msg.u32CANID      = 0X401U;
            m_msg.u8CANLEN      = len;
            m_msg.u8CANFrameIDE = 0;
            for ( i = 0; i < m_msg.u8CANLEN; i++ )
            {
                m_msg.unCANData.u8CANData [ i ] = data [ i ];
            }
            // m_msg.unCANData.u8CANData[4]=5;
            // m_msg.unCANData.u8CANData[7]=3;
            //Can_Set_Buff_401(m_msg.unCANData.u8CANData);
            if ( CAN_NM_STATUS == 0u )
            {
                RSCAN0_CH4_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_2, &m_msg);
            }
            break;
        default:
            break;
    }
}

void Can2TxMsg(uint8_t *data, uint8_t len, uint16_t id)
{
    uint32_t       i;
    CAN_Frame_st_t m_msg;

    m_msg.u32CANID      = id;
    m_msg.u8CANLEN      = len;
    m_msg.u8CANFrameIDE = 0u;
    for ( i = 0; i < m_msg.u8CANLEN; i++ )
    {
        m_msg.unCANData.u8CANData [ i ] = data [ i ];
    }
    RSCAN0_CH2_Set_TXBUF_Data(RSCAN_CHANNEL_BUF_1, &m_msg);
}
