#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Data_Time.h"
#include "Common_Interface.h"
#include "Telltales_user.h"
#include "RTE_LED.h"
#include "BackLight.h"
#include "EOL_Para.h"
#include "DisplaySch.h"
#include "LED_Map.h"
#include "eepromManage.h"
#include "Services_Mileage_User.h"
#include "Services_Mileage.h"

static uint8_t s_uPreTimeMode;
static uint8_t s_Hour;
static uint8_t s_Minute;
DataDriverInfoStruct      DataAfterIgnOn;
static uint16_t DataAfterIgnOnMin;
static uint8_t  DataAfterIgnOnClearFlag = 0u;
static uint8_t Minute_Conversion = 0u;
void Time_Service(void);
void Data_Time_KL30_Init(void)
{
    uint8_t TempBuf[8] = {0};
    s_uPreTimeMode = 0;
    s_Hour         = 24;
    s_Minute       = 60;
    DataAfterIgnOnClearFlag = 0;
    DataAfterIgnOnMin = 0;
    DataAfterIgnOn.TimeHour_H = 0;
    DataAfterIgnOn.TimeHour_L = 0;
    DataAfterIgnOn.TimeMin = 0;
    DataAfterIgnOn.Status = 0x20;
    ( void )Data_User_EEPROM_Read((uint16_t)EM_Eng_Time_BLOCK, TempBuf, 1);
    if(TempBuf[0] == 0xFFFFFFFF)
    {
        DataAfterIgnOn.TimeHour_H = 0;
        DataAfterIgnOn.TimeHour_L = 0;
        DataAfterIgnOn.TimeMin = 0;
    }
    else 
    {
        if(DataAfterIgnOn.Status == TempBuf[3])
        {
            DataAfterIgnOn.TimeHour_H = TempBuf[0];
            DataAfterIgnOn.TimeHour_L = TempBuf[1];
            DataAfterIgnOn.TimeMin = TempBuf[2];
        }
        else 
        {
            DataAfterIgnOn.TimeHour_H = 0;
            DataAfterIgnOn.TimeHour_L = 0;
            DataAfterIgnOn.TimeMin = 0;
        }
    }
}

// void TimeDispService(uint8_t Msg [])
// {
//     uint8_t uCurTimeMode;
//     uint8_t uHour, uMinute;
//     if ( Val_EOL_F1F8_TimeDisplay( ) == 1 )
//     {
//         if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
//         {
//             if ( Get_CANFD_CH2_ID_516_Sig_HU_LocalTimeValid( ) == 0 )
//             {
//                 if ( Get_CANFD_CH2_ID_516_Sig_HU_LocalTimeSystem( ) == 0 )    // 24
//                 {
//                     uCurTimeMode = 0;
//                 }
//                 else if ( Get_CANFD_CH2_ID_516_Sig_HU_LocalTimeSystem( ) == 1 )    // 12
//                 {
//                     uCurTimeMode = 1;
//                 }
//                 else
//                 {
//                     uCurTimeMode = s_uPreTimeMode;
//                 }
//                 s_uPreTimeMode = uCurTimeMode;

//                 uHour   = Get_CANFD_CH2_ID_516_Sig_HU_LocalTimeHour( );
//                 uMinute = Get_CANFD_CH2_ID_516_Sig_HU_LocalTimeMinute( );

//                 if ( (uHour < 24) && (uMinute < 60) )
//                 {
//                     if ( uCurTimeMode == 1 )    // 12
//                     {
//                         if ( uHour > 12 )
//                         {
//                             uHour -= 12;
//                         }
//                     }
//                 }
//                 else
//                 {
//                 }
//             }
//             else
//             {
//                 uHour   = 24;
//                 uMinute = 60;
//             }
//         }
//         else
//         {
//             uHour   = 25;
//             uMinute = 61;
//         }
//     }
//     else
//     {
//         uHour   = 25;
//         uMinute = 61;
//     }
//     s_Hour   = uHour;
//     s_Minute = uMinute;
// }

// void Set_Time_Close(uint8_t Msg [])
// {
//     s_Hour   = 24;
//     s_Minute = 60;
// }

// uint8_t Get_Hour_Display(void)
// {
//     return s_Hour;
// }

// uint8_t Get_Minite_Display(void)
// {
//     return s_Minute;
// }
void Data_Driver_Timer_Service(void)
{
    uint16_t PwrSts = 0u;
    uint8_t EngineConfiguration = 0u;
    uint32_t PwrCanTimeHour = 0u;
    static uint16_t PwrCanTimeMin = 0u;    //CAN时间判断   1min
    static uint16_t PwrCanTimeMinThree = 0u;  //CAN时间判断   3min
    static uint8_t last_status = 0u;    // 0运行  1停止
    EngineConfiguration = Val_EOL_0300_Engine_Running_Time_Counting_Method_Configuration();  //配置
    PwrSts = Get_CAN_CH0_ID_0CF00400_Sig_EngineSpeed();    //发动机转速
    PwrCanTimeHour = Get_CAN_CH0_ID_18FEE500_Sig_EngineTotalHoursofOperation();  //CAN信号时间
    if(EngineConfiguration == 0)  //点火打开
    {
        if(Common_Get_IG_Sts() == COMMON_POWER_ON)
        {
            Time_Service();
        }
    }
    else if(EngineConfiguration == 1) //发动机运行
    {
        if(Common_Get_IG_Sts() == COMMON_POWER_ON)
        {
            if((PwrSts > 0u) && (PwrSts <= 0xFAFF))  //发动机转速有效
            {
                if(PwrSts >= 0x960)  // 转速>=300  发动机运行
                {
                    last_status = 0;
                    Time_Service();
                }
                else if(PwrSts <= 0x190) // 转速<=50  发动机停止
                {
                    last_status = 1;
                }
                else   //回滞
                {
                    if(last_status == 0)
                    {
                        Time_Service();
                    }
                    else if(last_status == 1)
                    {

                    }
                }
            }
        }
    }
    else if(EngineConfiguration == 2) //CAN信号
    {
        if((Common_Get_IG_Sts() == COMMON_POWER_ON))
        {
            if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_RX_HOURS_Msg_Count) == CAN_SIG_NORMAL)
            {
                if(PwrCanTimeHour <= 0xFAFFFFFF)
                {
                    PwrCanTimeMin++;
                    if (PwrCanTimeMin >= 600)
                    {
                        PwrCanTimeMin = 0;
                        DataAfterIgnOn.TimeMin = ((PwrCanTimeHour * 3) % 60);
                        if((PwrCanTimeHour * 3) < (99999 * 60))   //<99999h
                        {
                            PwrCanTimeHour /= 20;    //转成小时
                            DataAfterIgnOn.TimeHour_L = (PwrCanTimeHour & 0xFF);
                            DataAfterIgnOn.TimeHour_H = ((PwrCanTimeHour >> 8) & 0xFF);
                        }
                        else
                        {
                            if((PwrCanTimeHour * 3) >= 5999994) // >=99999.9*60min  判断总时间是否大于99999.9h
                            {
                                DataAfterIgnOn.TimeMin = 59;
                            }
                            PwrCanTimeHour = 99999;
                            DataAfterIgnOn.TimeHour_L = (PwrCanTimeHour & 0xFF);
                            DataAfterIgnOn.TimeHour_H = ((PwrCanTimeHour >> 8) & 0xFF);
                        }
                        PwrCanTimeMinThree++;
                    }
                    if(PwrCanTimeMinThree >= 3)  //3min
                    {
                        PwrCanTimeMinThree = 0;
                        DataAfterIgnOn.Status = 0x20;
                        Set_Driver_Timer_EEL(&DataAfterIgnOn);
                    }
                }
                else
                {
                        //显示-----.- h
                }
            }
            else
            {
                    //显示-----.- h
            }
        }
    }
}

void Time_Service(void)
{
    uint16_t TimeHour = 0u;
    DataAfterIgnOnMin++;
    if(DataAfterIgnOnMin >= 600)
    {
        DataAfterIgnOnMin = 0u;
        DataAfterIgnOn.TimeMin++;
        TimeHour = ((DataAfterIgnOn.TimeHour_H << 8) + DataAfterIgnOn.TimeHour_L);
        if(TimeHour < 99999)
        {
            if(DataAfterIgnOn.TimeMin > 59)
            {
                DataAfterIgnOn.TimeMin = 0;
                if(DataAfterIgnOn.TimeHour_L >= 0xFF)
                {
                    DataAfterIgnOn.TimeHour_H ++;
                    DataAfterIgnOn.TimeHour_L = 0u;
                }
                else 
                {
                    DataAfterIgnOn.TimeHour_L++;
                }
            }
        }
        else
        {
            TimeHour = 99999;
            if(DataAfterIgnOn.TimeMin > 59)
            {
                DataAfterIgnOn.TimeMin = 59;
            }
        }
        
    }
    if(DataAfterIgnOn.TimeMin % 3 == 0)
    {
        DataAfterIgnOn.Status = 0x20;
        Set_Driver_Timer_EEL(&DataAfterIgnOn);
    }
}

uint8_t Get_TimeMin_Conversion(void)      //分钟转换小时
{
    uint8_t EngineConfiguration = 0u;
    EngineConfiguration = Val_EOL_0300_Engine_Running_Time_Counting_Method_Configuration();  //配置
    if(EngineConfiguration == 2)  //CAN
    {
        if(CAN_MSG_Status(&CAN_CH0_CanMsgOp,CAN_CH0_ID_RX_HOURS_Msg_Count) == CAN_SIG_NORMAL)
        {
            if(Get_CAN_CH0_ID_18FEE500_Sig_EngineTotalHoursofOperation() > 0xFAFFFFFF)
            {
                Minute_Conversion = 0xFF;
            }
            else
            {
                Minute_Conversion = Get_AfterIgnOn_TimeMin();
                Minute_Conversion /= 6;
            }
        }
        else
        {
            Minute_Conversion = 0xFF;
        }
    }
    else                       //点火打开、发动机运行
    {
        Minute_Conversion = Get_AfterIgnOn_TimeMin();
        Minute_Conversion /= 6;
    }

    return Minute_Conversion;
}

uint16_t Get_AfterIgnOn_TimeHour(void)   //获取小时
{
    uint16_t TimeHour;
    uint8_t EngineConfiguration = 0u;
    EngineConfiguration = Val_EOL_0300_Engine_Running_Time_Counting_Method_Configuration();  //配置
    if(EngineConfiguration == 2)     // CAN
    {
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_RX_HOURS_Msg_Count) == CAN_SIG_NORMAL)
        {
            if (Get_CAN_CH0_ID_18FEE500_Sig_EngineTotalHoursofOperation() > 0xFAFFFFFF)
            {
                TimeHour = 0xFFFF;
            }
            else
            {
                TimeHour = DataAfterIgnOn.TimeHour_H;
                TimeHour <<= 8;
                TimeHour |= DataAfterIgnOn.TimeHour_L;
            }
        }
        else
        {
            TimeHour = 0xFFFF;
        }
    }
    else                         //点火打开、发动机运行
    {
        TimeHour = DataAfterIgnOn.TimeHour_H;
        TimeHour <<= 8;
        TimeHour |= DataAfterIgnOn.TimeHour_L;
    }
    return TimeHour;
}

uint8_t Get_AfterIgnOn_TimeMin(void)
{
    return DataAfterIgnOn.TimeMin;
}


void Set_Driver_Timer_EEL(DataDriverInfoStruct *DataAfterIgnOn)
{
    eeprom_WriteRecord(EEPROM_BLOCK_05, ( uint8_t * )DataAfterIgnOn, 64);
}