#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Services_Mileage_User.h"
#include "Analog_Signals.h"
#include "DisplaySch.h"
#include "EOL_Para.h"
#include "RTE_ADC.h"
#include "UDS_DTC.h"
#include "Key.h"
#include "RTE_GPIO.h"
#include "Menu.h"

uint16_t UDS_Key = 0;
uint8_t g_RightKeyLONGPRESS = 0u;  //右键长按 蜂鸣器屏蔽标志
/*-------------------------------------------------------*/
uint16_t Get_Key_Lin_Resistance(void)
{
    uint16_t u16Key_Res_buffer      = 0U;
    uint8_t  u8Key_Res_Valid_buffer = 0U;
    //u8Key_Res_Valid_buffer          = ADC_Read_Signal_Valid(ADC_CH_KEY);
    //if ( u8Key_Res_Valid_buffer == 0U )
    // {
    //     u16Key_Res_buffer = ADC_Read_Signal(ADC_CH_KEY);
    // }

    return u16Key_Res_buffer;
}

uint16_t Get_Key_Lin_Right_voltage(void)
{
    uint16_t u16Key_Right_voltage      = 0U;
    u16Key_Right_voltage          = Right_Key;
    if ( u16Key_Right_voltage == 0U )
    {
        u16Key_Right_voltage = 1;
    }
    else
    {
        u16Key_Right_voltage = 0;
    }

    return u16Key_Right_voltage;
}
uint16_t Get_Key_Lin_Left_voltage(void)
{
    uint16_t u16Key_Left_voltage      = 0U;
    u16Key_Left_voltage          = Left_Key;
    if ( u16Key_Left_voltage == 0U )
    {
        u16Key_Left_voltage = 1;
    }
    else
    {
        u16Key_Left_voltage = 0;
    }

    return u16Key_Left_voltage;
}
/*----------�������幦��ִ�еĻص�����-----------------------*/

void Key_Operation_Enter(Key_Event_en_t enKeyEvent)
{

    HMI_Set_KEY_Trip(enKeyEvent);
    Data_ODO_Key_Set(enKeyEvent);
    Set_UDS_KEY_EVENT_LONG(enKeyEvent);
}

void Key_Operation_Right(Key_Event_en_t enKeyEvent)
{
    uint8_t Menu = 0;
    Menu = Get_Home_Page();
    if (enKeyEvent == KEY_EVENT_SHORT_PRESS)
    {   
        Menu_Service(MENU_KEY_DOWN_SHORT);
    }
    else if (enKeyEvent == KEY_EVENT_LONG_PRESS)
    {

        //如果在主页，长按右键屏蔽蜂鸣器
        if (Menu != 0)
        {
            if (g_RightKeyLONGPRESS == 0u)
            {
                g_RightKeyLONGPRESS = 1u;
            }
            else
            {
                g_RightKeyLONGPRESS = 0u;
            }
        }

        //如果不在主页，长按右键确定
        else
        {
            Menu_Service(MENU_KEY_CONFIRM_SHORT);
        }
    }
    else
    {
    }
    Set_UDS_KEY_EVENT_LONG(enKeyEvent);
}

void Key_Operation_Left(Key_Event_en_t enKeyEvent)
{
    uint8_t Menu = 0;
    uint8_t Menu1 = 0;
    uint8_t language = 0;
    language = Val_EOL_0300_IC_Language_Configuration();
    Menu1 = Menu_Get_Current_Cursor_Information();
    Menu = Get_Home_Page();

    if (enKeyEvent == KEY_EVENT_SHORT_PRESS)
    {
        //如果在主页，短按左键进入主菜单
        if(Menu != 0)
        {
            Menu_Service(MENU_KEY_CONFIRM_SHORT);
        }
        //如果不在主页，短按左键向上翻页
        else
        {
            Menu_Service(MENU_KEY_UP_SHORT);
        }   
    }
    else if (enKeyEvent == KEY_EVENT_LONG_PRESS)
    {
        Menu_Item_Select_Set(MENU_ITEM_Home_Page, 1);
    }
    else
    {
    }
    Set_UDS_KEY_EVENT_LONG(enKeyEvent);
}

void UDS_Key_Res_buffer(void)
{
    if(Get_HMI_SelfCheck_Timer() > 3000)
    {
        if(Get_Key_Lin_Resistance() < 10u)
        {
            UDS_Key = 1;
        }
        else 
        {
            UDS_Key = 0;
        }
    }
    else 
    {
        UDS_Key = 0;  
    }
}

uint16_t Get_UDS_Key_Res(void)
{
    return UDS_Key;
}

/*-------------------------------------------------*/

Key_Real_Status_en_t Key_Real_Status_Read_Enter_Line(void)
{
    uint16_t             u16Key_Lin_Resistance = 0U;
    Key_Real_Status_en_t enKeyRealStatus       = KEY_CAN_NONE;
    u16Key_Lin_Resistance                      = Get_Key_Lin_Resistance( );

    if ( (u16Key_Lin_Resistance <= 150U) && (u16Key_Lin_Resistance >= 50U) )
    {
        enKeyRealStatus = KEY_LINE_PRESS;
    }
    else
    {
        enKeyRealStatus = KEY_LINE_LOOSEN;
        set_DTC_Key_Statues(0x01u);
    }
    return enKeyRealStatus;
}

Key_Real_Status_en_t Key_Real_Status_Read_Enter(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_CAN_NONE;

    enKeyRealStatus = Key_Real_Status_Read_Enter_Line( );

    return enKeyRealStatus;
}
Key_Real_Status_en_t Key_Real_Status_Right_Read_Enter_Line(void)
{
    uint16_t             u16Key_Lin_Right_voltage = 0U;
    Key_Real_Status_en_t enKeyRealStatus       = KEY_CAN_NONE;
    u16Key_Lin_Right_voltage                      = Get_Key_Lin_Right_voltage( );

    if (u16Key_Lin_Right_voltage == 1)
    {
        enKeyRealStatus = KEY_LINE_PRESS;
    }
    else
    {
        enKeyRealStatus = KEY_LINE_LOOSEN;
        set_DTC_Key_Statues(0x01u);
    }
    return enKeyRealStatus;
}

Key_Real_Status_en_t Key_Real_Status_Right_Read_Enter(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_CAN_NONE;

    enKeyRealStatus = Key_Real_Status_Right_Read_Enter_Line( );

    return enKeyRealStatus;
}
Key_Real_Status_en_t Key_Real_Status_Left_Read_Enter_Line(void)
{
    uint16_t             u16Key_Lin_Left_voltage = 0U;
    Key_Real_Status_en_t enKeyRealStatus       = KEY_CAN_NONE;
    u16Key_Lin_Left_voltage                      = Get_Key_Lin_Left_voltage( );

    if (u16Key_Lin_Left_voltage == 1)
    {
        enKeyRealStatus = KEY_LINE_PRESS;
    }
    else
    {
        enKeyRealStatus = KEY_LINE_LOOSEN;
        set_DTC_Key_Statues(0x01u);
    }
    return enKeyRealStatus;
}

Key_Real_Status_en_t Key_Real_Status_Left_Read_Enter(void)
{
    Key_Real_Status_en_t enKeyRealStatus = KEY_CAN_NONE;

    enKeyRealStatus = Key_Real_Status_Left_Read_Enter_Line( );

    return enKeyRealStatus;
}
/*---------------------------------------------------------------------------------------*/
const Key_Attribute_st_t stKeyAttribute [ KEY_NUM_MAX ] = {
    {KEY_TYPE_LINE, Key_Real_Status_Read_Enter, Key_Operation_Enter},
    {KEY_TYPE_LINE, Key_Real_Status_Right_Read_Enter, Key_Operation_Right},
    {KEY_TYPE_LINE, Key_Real_Status_Left_Read_Enter, Key_Operation_Left},

};
