
//#include "I2S_MAX98357.h"
#include "EOL_Para.h"
#include "Sound_Player.h"
#include "Sound_Scheduler.h"
#include "Sound_List.h"
#include "GenDelay.h"
/************************************************************************/
#define SND_PREPARE_CNT 4U
#pragma ghs section bss = ".myNonInitArea"
uint8_t             SoundPlayCtrl_SoundType;
#pragma ghs section bss = default
SoundPlayCtrlStruct SoundPlayCtrl;
volatile uint8_t    SoundPlaySeatbeltSync;
uint32_t            Factory_Ctrl_Type;
uint32_t            Factory_Ctrl_Val;
static void         Set_Sys_Volume(void);

void SoundType30Init(void)
{
    if ( (SoundPlayCtrl_SoundType >= 1) && (SoundPlayCtrl_SoundType <= 5) )
    {
    }
    else
    {
        SoundPlayCtrl_SoundType = 1u;
    }
}

void Sound_Player_Init(void)
{
    SoundPlayCtrl.Playing      = SND_TOTAL_NUM;
    SoundPlayCtrl.Timer        = 0U;
    SoundPlayCtrl.Cycle        = 0U;
    SoundPlayCtrl.PrepareTimer = SND_PREPARE_CNT;
    SoundPlayCtrl.Status       = SND_PLAYER_IDLE;
    if ( (SoundPlayCtrl.VolInit >= 1U) && (SoundPlayCtrl.VolInit <= 3U) )
    {
        SoundPlayCtrl.VolInit = SoundPlayCtrl.VolInit;
    }
    else
    {
        SoundPlayCtrl.VolInit = 1U;
    }
    BuzzerForceCtrlRelease( );
    BuzzerFactoryInit( );
}

uint8_t Sound_Play(uint32_t SoundID)
{
    uint32_t loc_ret = 0U;

    if ( SoundID < SND_TOTAL_NUM )
    {
        if ( SoundPlayCtrl.Status != SND_PLAYER_IDLE )
        {
            loc_ret = 1u;
        }
        else
        {
            SoundPlayCtrl.Playing      = SoundList [ SoundID ].Src;
            SoundPlayCtrl.Timer        = 0U;
            SoundPlayCtrl.Cycle        = SoundList [ SoundID ].Cycle;
            SoundPlayCtrl.Status       = SND_PLAYER_PEEPARE;
            SoundPlayCtrl.PrepareTimer = SND_PREPARE_CNT;
            loc_ret                    = 0U;
        }
    }
    else
    {
        loc_ret = 2u;
    }
    return loc_ret;
}

uint8_t Sound_Stop(uint32_t SoundID)
{
    uint32_t loc_ret = 0U;

    if ( SoundID < SND_SRC_TOTAL_NUM )
    {
        if ( (SoundPlayCtrl.Status == SND_PLAYER_IDLE) || (SoundPlayCtrl.Playing != SoundID) )
        {
            loc_ret = 0U;
        }
        else if ( SoundPlayCtrl.Status == SND_PLAYER_PLAY_REQ )
        {
            SoundPlayCtrl.Playing      = SND_SRC_NONE;
            SoundPlayCtrl.Timer        = 0U;
            SoundPlayCtrl.Cycle        = 0U;
            SoundPlayCtrl.PrepareTimer = SND_PREPARE_CNT;
            SoundPlayCtrl.Status       = SND_PLAYER_IDLE;
            loc_ret                    = 0U;
        }
        else
        {
            SoundPlayCtrl.Status = SND_PLAYER_STOP_REQ;
            loc_ret              = 1u;
        }
    }
    else
    {
        loc_ret = 2u;
    }

    return loc_ret;
}

void Sound_Clear(void)
{
    if ( SoundPlayCtrl.Status == SND_PLAYER_PLAY_REQ )
    {

        SoundPlayCtrl.Playing      = SND_SRC_NONE;
        SoundPlayCtrl.Timer        = 0U;
        SoundPlayCtrl.PrepareTimer = SND_PREPARE_CNT;
        SoundPlayCtrl.Cycle        = 0U;
        SoundPlayCtrl.Status       = SND_PLAYER_IDLE;
    }
    else
    {
        if ( SoundPlayCtrl.Playing < SND_SRC_TOTAL_NUM )
        {
            Gen_TimeDelay(1000UL, 50UL);
        }

        SoundPlayCtrl.Playing      = SND_SRC_NONE;
        SoundPlayCtrl.Timer        = 0U;
        SoundPlayCtrl.PrepareTimer = SND_PREPARE_CNT;
        SoundPlayCtrl.Cycle        = 0U;
        SoundPlayCtrl.Status       = SND_PLAYER_IDLE;
    }
}

uint32_t Sound_Priority_Query(uint32_t SoundID)
{
    uint32_t loc_ret         = 0U;
    uint32_t loc_snd_current = Get_SoundScheduling_Current( );
    if ( SoundID == SND_SRC_CURRENT )
    {
        if ( (loc_snd_current < SND_TOTAL_NUM) && (SoundPlayCtrl.Playing < SND_SRC_TOTAL_NUM) )
        {
            loc_ret = SoundList [ loc_snd_current ].Priority;
        }
        else
        {
            loc_ret = SND_SRC_NONE;
        }
    }
    else
    {
        if ( SoundID < SND_TOTAL_NUM )
        {
            loc_ret = SoundList [ SoundID ].Priority;
        }
        else
        {
            loc_ret = SND_SRC_NONE;
        }
    }
    return loc_ret;
}

/*10ms*/
void Sound_Play_Service(void)
{
    uint32_t SoundName    = 0U;
    uint32_t loc_idx      = 0u;
    uint32_t Snd_Interval = 0UL;
    uint32_t Snd_Period   = 0UL;
    SoundName             = Get_SoundScheduling_Current( );

    if ( Factory_Ctrl_Type == 0 )
    {
        if ( GetBuzzerForceCtrlSta( ) == 0u )
        {
            switch ( SoundPlayCtrl.Status )
            {
                case SND_PLAYER_PEEPARE:
                    if ( (SoundPlayCtrl.Cycle != 0u) && (SoundPlayCtrl.Playing < SND_SRC_TOTAL_NUM) )
                    {
                        if (1)//( Val_EOL_F1F8_SoundPlaybackMode( ) == 0 )
                        {
                        }
                        if ( SoundPlayCtrl.PrepareTimer )
                        {
                            SoundPlayCtrl.PrepareTimer--;
                        }
                        else
                        {
                            SoundPlayCtrl.Status = SND_PLAYER_PLAY_REQ;
                        }
                    }
                    break;
                case SND_PLAYER_PLAY_REQ:
                    if ( (SoundPlayCtrl.Cycle != 0u) && (SoundPlayCtrl.Playing < SND_SRC_TOTAL_NUM) )
                    {
                        Set_Sys_Volume( );
                        loc_idx = SndAttributeTable [ SoundPlayCtrl.Playing ].Index [ Get_Sound_Type( ) - 1u ];
                        if ( SoundList [ SoundName ].Mode == SND_MODE_SINGLE )
                        {
                            if ( (SoundName == SND_RADAR_R_3) || (SoundName == SND_RADAR_F_3) )
                            {
                                if (1)//( Val_EOL_F1F8_SoundPlaybackMode( ) == 0 )
                                {
                                }
                            }
                            else
                            {
                                if (1)//( Val_EOL_F1F8_SoundPlaybackMode( ) == 0 )
                                {
                                }
                            }
                        }
                        else
                        {
                            if (1)//( Val_EOL_F1F8_SoundPlaybackMode( ) == 0 )
                            {
                            }
                        }
                        Snd_Interval        = SoundList [ SoundName ].Interval [ Get_Sound_Type( ) - 1u ];
                        Snd_Period          = SndAttributeTable [ SoundPlayCtrl.Playing ].Period [ Get_Sound_Type( ) - 1u ];
                        SoundPlayCtrl.Timer = (Snd_Interval + Snd_Period + 9u) / 10U;
                        if ( SoundPlayCtrl.Cycle != SND_CYCLE_NONSTOP )
                        {
                            SoundPlayCtrl.Cycle--;
                        }
                        SoundPlayCtrl.Status = SND_PLAYER_PLAYING;
                    }
                    else
                    {
                        SoundPlayCtrl.Playing = SND_SRC_NONE;
                        SoundPlayCtrl.Cycle   = 0U;
                        SoundPlayCtrl.Status  = SND_PLAYER_IDLE;
                    }
                    break;

                case SND_PLAYER_PLAYING:
                    if ( SoundPlayCtrl.Timer )
                    {
                        SoundPlayCtrl.Timer--;
                    }
                    if ( SoundPlayCtrl.Timer == 0u )
                    {
                        loc_idx = SndAttributeTable [ SoundPlayCtrl.Playing ].Index [ Get_Sound_Type( ) - 1u ];
                        if ( SoundPlayCtrl.Cycle == 0u )
                        {
                            if ( SoundList [ SoundName ].Mode != SND_MODE_SINGLE )
                            {
                                if (1)//( Val_EOL_F1F8_SoundPlaybackMode( ) == 0 )
                                {
                                }
                            }
                            else
                            {
                                if (1)//( Val_EOL_F1F8_SoundPlaybackMode( ) == 0 )
                                {
                                }
                            }
                            Set_Sys_Volume( );
                            SoundPlayCtrl.Playing = SND_SRC_NONE;
                            SoundPlayCtrl.Status  = SND_PLAYER_PLAY_END;
                        }
                        else
                        {
                            if ( SoundList [ SoundName ].Mode == SND_MODE_SINGLE )
                            {
                                Set_Sys_Volume( );
                                if ( (SoundName == SND_RADAR_R_3) || (SoundName == SND_RADAR_F_3) )
                                {
                                    if (1)//( Val_EOL_F1F8_SoundPlaybackMode( ) == 0 )
                                    {
                                    }
                                }
                                else
                                {
                                    if (1)//( Val_EOL_F1F8_SoundPlaybackMode( ) == 0 )
                                    {
                                    }
                                }
                            }
                            Snd_Interval        = SoundList [ SoundName ].Interval [ Get_Sound_Type( ) - 1u ];
                            Snd_Period          = SndAttributeTable [ SoundPlayCtrl.Playing ].Period [ Get_Sound_Type( ) - 1u ];
                            SoundPlayCtrl.Timer = (Snd_Interval + Snd_Period + 9u) / 10U;
                            if ( SoundPlayCtrl.Cycle != SND_CYCLE_NONSTOP )
                            {
                                SoundPlayCtrl.Cycle--;
                            }
                        }
                    }
                    break;
                case SND_PLAYER_PLAY_END:
                    if (1)//( Val_EOL_F1F8_SoundPlaybackMode( ) == 0 )
                    {
                    }
                    SoundPlayCtrl.Status = SND_PLAYER_IDLE;
                    break;
                case SND_PLAYER_STOP_REQ:
                    if ( SoundPlayCtrl.Playing < SND_SRC_TOTAL_NUM )
                    {
                        if ( SoundList [ SoundName ].Mode != SND_MODE_SINGLE )
                        {
                            if (1)//( Val_EOL_F1F8_SoundPlaybackMode( ) == 0 )
                            {
                            }
                            SoundPlayCtrl.Playing = SND_SRC_NONE;
                            SoundPlayCtrl.Cycle   = 0U;
                            SoundPlayCtrl.Status  = SND_PLAYER_PLAY_END;
                        }
                        else
                        {
                            if ( SoundPlayCtrl.Timer )
                            {
                                SoundPlayCtrl.Timer--;
                            }

                            if ( SoundPlayCtrl.Timer == 0u )
                            {
                                if (1)//( Val_EOL_F1F8_SoundPlaybackMode( ) == 0 )
                                {
                                }
                                SoundPlayCtrl.Playing = SND_SRC_NONE;
                                SoundPlayCtrl.Cycle   = 0U;
                                SoundPlayCtrl.Status  = SND_PLAYER_PLAY_END;
                            }
                        }
                    }
                    break;

                default:
                    break; /* case SND_PLAYER_IDLE      : break;*/
            }
        }
    }
}

void DIAG_SoundPlay(void)
{
}

void DIAG_SoundStop(void)
{
}

uint8_t Get_SND_SEATBELT_SYNC(void)
{
    return SND_SEATBELT_SYNC;
}

void ReSet_SND_SEATBELT_SYNC(void)
{
    SND_SEATBELT_SYNC = 0U;
}

static uint8_t DiagCtrlSta = 0U;

void BuzzerForceCtrlRequest(void)
{
    DiagCtrlSta = 1u;
}

void BuzzerForceCtrlRelease(void)
{
    if ( DiagCtrlSta == 1u )
    {
        DiagCtrlSta = 0U;
        DIAG_SoundStop( );
    }
}

uint8_t GetBuzzerForceCtrlSta(void)
{
    return DiagCtrlSta;
}

void BuzzerCtrlPlayBack(void)
{
    DIAG_SoundPlay( );
}

void BuzzerCtrlStopPlaying(void)
{
    DIAG_SoundStop( );
}

uint32_t GetCurSndSrcIndx(void)
{
    uint32_t loc_idx;
    loc_idx = SoundPlayCtrl.Playing;    // SoundList [ SoundPlayCtrl.Playing ].Src;
    return ( uint32_t )SndAttributeTable [ loc_idx ].Index [ Get_Sound_Type( ) - 1u ];
}

static void Set_Sys_Volume(void)
{
    uint32_t loc_idx;
    uint8_t  Tagte_volume = 0U;
    loc_idx               = SoundPlayCtrl.Playing;    // SoundList [ SoundPlayCtrl.Playing ].Src;

    switch ( SoundPlayCtrl.VolInit )
    {
        case NVM_ALARM_VOLUME_LO:
            Tagte_volume = SndAttributeTable [ loc_idx ].Volume [ 0 ];
            break;
        case NVM_ALARM_VOLUME_HI:
            Tagte_volume = SndAttributeTable [ loc_idx ].Volume [ 2 ];
            break;
        case NVM_ALARM_VOLUME_MID:
        default:
            Tagte_volume = SndAttributeTable [ loc_idx ].Volume [ 1 ];
            break;
    }
    if ( Tagte_volume >= 100U )
    {
        Tagte_volume = 100U;
    }
}

void Set_Sound_Volume(uint8_t Volume)
{
    SoundPlayCtrl.VolInit = Volume;
}

uint8_t Get_Sound_Volume(void)
{
    return SoundPlayCtrl.VolInit;
}

void Set_Sound_Type(uint8_t SoundType)
{
    SoundPlayCtrl_SoundType = SoundType;
}
uint8_t Get_Sound_Type(void)
{
    return SoundPlayCtrl_SoundType;
}

uint8_t Get_SoundPlayCtrlPlaying(void)
{
    return SoundPlayCtrl.Playing;
}

void BuzzerFactoryCtrl_1(uint32_t cmd, uint32_t val)
{
    Factory_Ctrl_Type = cmd;
    if ( Factory_Ctrl_Type != 0 )
    {
        Gen_TimeDelay(1000U, 50U);
        Gen_TimeDelay(1000U, 50U);
    }
    else
    {
    }
}

void BuzzerFactoryRelease(void)
{
    Factory_Ctrl_Type = 0u;
}
void BuzzerFactoryInit(void)
{
    Factory_Ctrl_Type = 0u;
}
