
#ifndef _SOUND_SCHEDULER_H_
#define _SOUND_SCHEDULER_H_

#include "TYW_stdint.h"
#include "Sound_List.h"
typedef struct
{
    uint32_t Current;
    uint32_t Next;
    uint8_t  ReqCode;
    uint8_t  StopReq;
} SoundSchedulingStruct;
#define W0  0xC0
#define W1  0xD0
#define W2  0xD1
#define OP1 0xD2
#define D1  0XD3
#define D2  0XD4
#define OP2 0xD5
#define OP3 0xD6
#define OP4 0xD7
#define OP5 0xD8

enum SND_THEME
{
    SND_THEME_0,
    SND_THEME_1,
    SND_THEME_2,
    SND_THEME_MAX,
};

enum SND_Volume
{
    SND_Volume_L,
    SND_Volume_M,
    SND_Volume_H,
    SND_Volume_MAX,
};
enum SND_Power
{
    POWER_OFF,
    POWER_ON,
    POWER_ALL,
};

/******************************************************************************
声音属性结构
******************************************************************************/
typedef struct
{
    uint32_t Src;  /*音源*/
    uint32_t Type; /*类型*/
    uint32_t Priority;
    uint32_t Cycle;
    uint16_t Mode;
    uint16_t PowerMode;
    uint32_t Interval [ SND_THEME_MAX ];
    uint8_t  IP_VoiceReq;
    uint8_t  IP_TurnWarningReq;
    uint8_t  IP_SeatBeltWarningReq;
    uint8_t  IP_MsgWarningReq;
    uint8_t  IP_VoicePlayTimesReq;
    uint8_t  IP_VoicePlayIntervalReq;
    uint8_t  IP_VoicePlay_CycleReq;
    uint8_t  IP_LFReq;
    uint8_t  IP_RFReq;
    uint8_t  IP_LRReq;
    uint8_t  IP_RRReq;
    uint8_t  IP_RadarWarningReq;
} SoundAttributeStruct;
/******************************************************************************
声音属性结构
******************************************************************************/
typedef struct
{
    uint32_t Index [ SND_THEME_MAX ];
    uint32_t Period [ SND_THEME_MAX ];
    uint32_t Volume [ SND_Volume_MAX ];
} SndAttributeStruct;
/*声音列表*/
#pragma alignvar(8)
extern const SoundAttributeStruct SoundList [ SND_TOTAL_NUM ];
#pragma alignvar(8)
extern const SndAttributeStruct SndAttributeTable [ SND_SRC_TOTAL_NUM ];


extern uint8_t               SoundEnableCode [ SND_TOTAL_NUM ];

#define SND_SEATBELT_DISABLE    0x00u
#define SND_SEATBELT_TIMING     0x01u
#define SND_SEATBELT_TIME_UP    0x02u
#define SND_SEATBELT_CONTINUOUS 0x03u

void     Sound_Scheduler_Init(void);
void     Sound_Request(uint32_t Sound, uint8_t ReqCode);
void     Sound_Delete(uint32_t Sound);
void     Sound_Scheduling_Service(void);
uint32_t Get_SoundScheduling_Current(void);
uint32_t Get_SoundScheduling_Next(void);

#endif
