#ifndef TELLTALES_USER_H
#define TELLTALES_USER_H
#include "TYW_stdint.h"
#include "Telltales_Lib.h"

#define t50ms_in_1s 20

#define LED_LAMP_OPEN  255
#define LED_LAMP_CLOSE 0
extern uint8_t g_RightKeyLONGPRESS;
typedef enum
{
	/*液晶屏报警图标列表*/
	m_LED_Reversal_Cooling_fan,				//冷却风扇反转报警灯
	m_LED_Emergency_Steering,	    		//应急转向
    m_LED_Power_cut_off,					//动力切断
	m_LED_Stabilization_Module,				//稳定模块指示灯
	m_LED_GearDirection_Neutral,			//空挡指示灯
	m_LED_HI_Beam,							//远光灯
	m_LED_Bridgefilterblocked,				//桥滤清器堵塞报警灯
	m_LED_Wheeldifferentiallock,    		//轮间差速锁止信号灯
	m_LED_Hydraulicoilfilterblockagesignal, //液压油滤堵塞信号灯
	m_LED_Bridge_Oil_Temperature_Is_High,	//桥油温高
	m_LED_Water_In_The_Oil,                 //油中有水
	m_LED_RadiatingOilFilterBlocked,		//散热油滤堵塞指示灯
	m_LED_FNR,                      		//FNR指示灯
	m_LED_LCD_Transmission_failure, 		//变速箱故障指示灯液晶屏
	m_LED_AutoShiftGear,            		//自动换挡
	m_LED_Low_Cooling_Level,			    //冷却液位低
	m_LED_Oil_Water_Separation,			    //油水分离预热
	m_LED_Safety_Belt,					    //安全带
	m_LED_Fuel_Filter_Plugging,             //燃油滤堵塞
	m_LED_Engine_Stop, 	  		    		//发动机停机
	m_LED_High_Exhaust_Temperature, 	  	//排气温度高
	m_LED_Air_Filter_Blocked, 	  		    //空滤器堵塞指示
	m_LED_TransmissionOilFilterBlocked, 	//变速箱油滤堵塞
	m_LED_Red_NCD,                          //NCD红色
    m_LED_Yellow_NCD,                       //NCD黄色
	m_LED_Red_PCD,                          //PCD红色
    m_LED_Yellow_PCD,                       //PCD黄色
	m_LED_DPFLampCommand_R,         		//再生指示灯 红
	m_LED_DPFLampCommand_Y,		 			//再生指示灯 黄
	m_LED_DPFLampCommand_G,		   			//再生指示灯 绿
	m_LED_ForbidDPFLampCommand_R,   		//禁止再生指示灯 红
	m_LED_ForbidDPFLampCommand_Y,   		//禁止再生指示灯 黄
	m_LED_ResistanceHighDEF,   				//阻力高 黄
	m_LED_EngineWaittoStartLamp,        	//发动机预热
	m_LED_MovableArmAuto,           		//动臂定位指示灯
	m_LED_BucketAuto, 						//铲斗定位指示灯
	m_LED_TheTranslationalLift,     		//平动举升指示灯
	m_LED_MovableArmInch,           		//动臂微动指示灯
	m_LED_MachineQuickChange,       		//机具快换未锁指示灯
	m_LED_MachineQuickChangeFinish, 		//机具快换锁止指示灯
	m_LED_CAN,								//CAN报警
	m_LED_Transmission_High,				//变速箱油温高,液晶屏报警图标
	m_LED_Coolant,							//水温高
	m_LED_FuelEconomy,              		//燃油经济性指示灯
	m_LED_Engine_Maintenance,				//发动机维修指示灯
	m_LED_RedWarningLampStatus,         	//故障报警灯 红
	m_LED_YellowWarningLampStatus,      	//故障报警灯 黄
	m_LED_Buzzer_Shielding,					//蜂鸣器屏蔽
	m_LED_MIL_Y,                    		//MIL排放灯
	m_LED_Remote_Lock,						//远程锁车
	m_LED_Steering_Wheel_Lock_Condition_One,//方向盘锁状态1
	m_LED_Steering_Wheel_Lock_Condition_Two,//方向盘锁状态2
	m_LED_One_Click_Shake_Material, 	    //一键抖料
	m_LED_HydraulicLockStatus_One,  		//液压锁状态 图标1
	m_LED_HydraulicLockStatus_Two,  		//液压锁状态 图标2
	m_LED_Rearview_Mirror_Heating_Up, 	    //后视镜加热
	m_LED_Presence_Status_Indication, 	    //在位状态指示	
	m_LED_Driver_Warning,				    //驾驶员警告

	// m_LED_Turn_L,
	// m_LED_Turn_R,
	m_LED_Rear_Fog,
	m_LED_Position,
	m_LED_LOW_Beam,
	m_LED_OilPressure_Low,	 // 在线配置
	m_LED_P,	 // 在线配置
	m_LED_FailureLamp,	 // 在线配置
	m_LED_Seatbelt,	 // 副驾安全带未系报警，符号共用
	m_LED_Battery,
	m_LED_ESC,	 // 需在线配置
	m_LED_ESC_OFF,	 // 需在线配置
	m_LED_MIL,
	m_LED_Fuel,
	m_LED_TPMS,	 // 在线配置
	m_LED_HDC_STATUS,
	m_LED_Autohold,
	m_LED_TFS,	 // 在线配置
	m_LED_RTTW,	 // 在线配置
	m_LED_CI,	 // 在线配置
	m_LED_BrakeLiquid_Low,	 // 与制动液位低共用
	m_LED_Air_Bag,
	m_LED_ABS,
	m_LED_EPS,
	m_LED_HostLaneStatus,	 // 在线配置
	m_LED_LCDA_SystemStatus,	 // 预留，在线配置
	m_LED_GPF_State,
	m_LED_Key_Y,
	m_LED_Key_G,
	m_LED_Anti_theft,
	m_LED_Master_Warning,
	m_LED_DrvMode,
	m_LED_Start_UP_Stop,
	/*液晶屏表头报警图标*/
	m_LED_EngineOilPressure,				//机油压力报警，液晶屏表头图标
	// m_LED_DEFHigh_R,						//尿素液位低,红灯
	m_LED_DEFHigh_Y,						//尿素液位低,黄灯
	m_LED_BatteryVoltage,					//电池电压报警
	m_LED_EldingLevelPercent,				//燃油液位低报警灯 
	m_LED_BrakePressure,				    //制动压力报警
	m_LED_TransmissionTop_High,				//变速箱油温高,液晶屏表头报警图标
	m_LED_TransmissionOilPressure,			//变速箱油压
	m_LED_HydraulicOilTemperature,			//液压油温
	// m_LED_Turn_L,						//左转向
	// m_LED_Turn_R,						//右转向
	m_LED_Lamplet,							//小灯
	m_LED_Parking_Braking,					//驻车制动报警灯
	m_LED_Charge,							//充电指示灯
	m_LED_GEARBOX_BREAKDOWN,				//变速箱故障
	m_LED_ENGINE_DIAGNOSTIC,				//发动机诊断
	m_LED_Water_Tem,						//水温表LED图标
	m_LED_Oil_Tem,							//变速箱油温LED图标
	

    LED_Max,
} LED_Idx_t;

#define LED_TEL_OFF  (Tellib_uint16_t)(0x00u)
#define LED_TEL1_ON  (Tellib_uint16_t)(0x01u)
#define LED_TEL2_ON  (Tellib_uint16_t)(0x02u)
#define LED_TEL3_ON  (Tellib_uint16_t)(0x03u)
#define LED_TEL4_ON  (Tellib_uint16_t)(0x04u)
#define LED_TEL5_ON  (Tellib_uint16_t)(0x05u)
#define LED_TEL6_ON  (Tellib_uint16_t)(0x06u)
#define LED_TEL7_ON  (Tellib_uint16_t)(0x07u)
#define LED_TEL8_ON  (Tellib_uint16_t)(0x08u)
#define LED_TEL9_ON  (Tellib_uint16_t)(0x09u)
#define LED_TEL10_ON (Tellib_uint16_t)(0x0Au)
#define LED_TEL11_ON (Tellib_uint16_t)(0x0Bu)
#define LED_TEL12_ON (Tellib_uint16_t)(0x0Cu)
#define LED_TEL13_ON (Tellib_uint16_t)(0x0Du)
#define LED_TEL14_ON (Tellib_uint16_t)(0x0Eu)
#define LED_TEL15_ON (Tellib_uint16_t)(0x0Fu)

void    Telltales_Init(void);
void BREAKFLUID_3S_Init(void);

void Telltales_Left_Right_Management_Service(void);
void SET_LED_ALL_Light_CLOSE(void);
void SET_LED_ALL_Light_OPEN(void);
uint16_t Get_CC_Vspeed_Display(void);
void UDS_Set_Telltales_Left_Right(uint8_t m_Left, uint8_t m_Right); //诊断控制转向灯，0不控制1亮2灭

uint16_t Get_EngineOilPressure_Flash_status(void);
uint16_t Get_DEFHigh_Flash_status(void);
uint16_t Get_EldingLevelPercent_Flash_status(void);
uint16_t Get_Brake_Pressure_Flash_status(void);
Tellib_uint16_t Get_Transmission_Oil_Temperature_Flash_status(void);
uint16_t LED_Lamplet_Judge(void);
Tellib_uint16_t Get_TransmissionOilPressure_Status(void); //变速箱油压灯的状态
void Audible_Alarm_Service(void);  // 声音服务函数
Tellib_uint16_t Get_EldingLevelPercent_bright_status(void);
Tellib_uint16_t Get_HydraulicOilTemperatureHigh_bright_Status(void);
Tellib_uint16_t Get_TransmissionOilPressure_bright_Status(void);  //变速箱油压灯的状态  点亮
Tellib_uint16_t Get_Transmission_Oil_Temperature_bright_status(void);
Tellib_uint16_t Get_EngineOilPressure_bright_status(void);
extern uint16_t Get_Wet_Brake_Pressure_status_R(void);
#endif
