#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "Common_Interface.h"
#include "Transmission_oil_Tem_Table.h"
#include "LED_Map.h"
#include "RTE_LED.h"
#include "DisplaySch.h"
#include "Analog_Signals.h"
#include "Configuration.h"

static uint8_t                g_OilTemSegNum_Disp;
static uint8_t                g_OilTemValid;          // -0 无效 -1 有效
static DataOilTemCalcStruct g_DataOilTemTempCalc;
uint8_t led_state_old       = 0u;                     //0:有效，1错误

/*** 变速箱油温上升表格 ***/
static const uint16_t DataOilTemTable_Up [ DATA_OilTem_TEMP_TOTAL_SEG ] =
    /*显示段：|    0     |    1     |    2     |    3     |    4     |    5     |    6    |     7    |*/
    {61, 71, 81, 91, 101, 111, 121, 131};    // 上升时小于等于表值则熄灭相应段

/*** 变速箱油温下降表格 ***/
static const uint16_t DataOilTemTable_Dn [ DATA_OilTem_TEMP_TOTAL_SEG ] =
    /*显示段：|    0     |    1     |    2     |    3     |    4     |    5     |    6    |     7    |*/
    {58, 68, 78, 88, 98, 108, 118, 128};    // 下降时小于等于表值则熄灭相应段

void Data_OilTem_TempPara_KL30_Init(void)
{
    g_DataOilTemTempCalc.FastMode         = 0u;
    g_OilTemSegNum_Disp                   = 0u;
    g_OilTemValid                         = 1u;
    g_DataOilTemTempCalc.Last             = 0u;
    g_DataOilTemTempCalc.InvalidCnt       = 0u;
    g_DataOilTemTempCalc.DstSeg           = 0u;
    g_DataOilTemTempCalc.State            = DATA_OilTem_TEMP_STATE_DELAY;
    g_DataOilTemTempCalc.Wait             = DATA_OilTem_TEMP_WAIT_SEC * 10;
    g_DataOilTemTempCalc.Prescaler        = 0u;
    g_DataOilTemTempCalc.OutputEnable     = 0u;
    g_DataOilTemTempCalc.DispTimer        = 0u;
    g_DataOilTemTempCalc.EngineStartTimer = 0u;
    g_DataOilTemTempCalc.Backup           = 0u;
}

void Data_OilTem_TempPara_Wakeup_Init(void)
{
    g_OilTemSegNum_Disp                   = 0u;
    g_OilTemValid                         = 1u;
    g_DataOilTemTempCalc.Last             = 0u;
    g_DataOilTemTempCalc.InvalidCnt       = 0u;
    g_DataOilTemTempCalc.DstSeg           = 0u;
    g_DataOilTemTempCalc.State            = DATA_OilTem_TEMP_STATE_DELAY;
    g_DataOilTemTempCalc.Wait             = DATA_OilTem_TEMP_WAIT_SEC * 10;
    g_DataOilTemTempCalc.Prescaler        = 0u;
    g_DataOilTemTempCalc.OutputEnable     = 0u;
    g_DataOilTemTempCalc.DispTimer        = 0u;
    g_DataOilTemTempCalc.EngineStartTimer = 0u;
}

/******************************************************************************
函数名：Data_OilTem_Temp_Processing_Service
功  能：SOC数据处理函数
参  数：无
返回值：无
*******************************************************************************
注  意：该函数必须每20ms被调用一次
******************************************************************************/
void Data_OilTem_Temp_Processing_Service(void)
{
    uint32_t  Data_Oil_Tem      = 0u;
    uint8_t  Delta              = 0u;
    uint32_t DataOilTem_Temp    = 0u;
    uint16_t TransmissionHigh_resistance = 0u;                 //硬线采集获取阻值
    TransmissionHigh_resistance = ADC_Read_Signal(ADC_CH_TRANSMISSION_OIL_TEMPERATURE);

    if ( Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TOT_Msg_Count) == CAN_SIG_LOST) &&
            (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_DANA_Msg_Count) == CAN_SIG_LOST) &&
            (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FD95_Msg_Count) == CAN_SIG_LOST))
        {
            g_OilTemValid   = 0u; //0无效，1有效
            DataOilTem_Temp = 0u;
            if(TransmissionHigh_resistance <=30)
            {
                g_OilTemValid   = 0u; //0无效，1有效
                DataOilTem_Temp = 0u;
                led_state_old   = 1u;
            }
            else if(TransmissionHigh_resistance <100)
            {
                if(led_state_old   == 1u)
                {
                    g_OilTemValid   = 0u; //0无效，1有效
                    DataOilTem_Temp = 0u;
                    led_state_old   = 1u;
                }
                else
                {
                    Data_Oil_Tem = Transmission_Oil_Temperature_Resistance(TransmissionHigh_resistance);
                    led_state_old   = 0u;
                    DataOilTem_Temp = Data_Oil_Tem;
                    g_OilTemValid = 1u;
                }
            }
        else
        {
            Data_Oil_Tem = Transmission_Oil_Temperature_Resistance(TransmissionHigh_resistance);
            led_state_old   = 0u;
            DataOilTem_Temp = Data_Oil_Tem;
            g_OilTemValid = 1u;
        }
        }
        else
        {
            if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_FD95_Msg_Count) == CAN_SIG_NORMAL)
            {

                Data_Oil_Tem = Get_CAN_CH0_ID_18FD9503_Sig_TransmissionOilTemperature();
                Data_Oil_Tem *= 100;
                Data_Oil_Tem /= 4;
                Data_Oil_Tem *= 1000;
                Data_Oil_Tem /= 8;
                Data_Oil_Tem /= 100000;
                if(Data_Oil_Tem < 273)
                {
                    Data_Oil_Tem = 0;
                }
                else
                {
                    Data_Oil_Tem -= 273;
                }

            }
            if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_DANA_Msg_Count) == CAN_SIG_NORMAL)
            {
                
                Data_Oil_Tem = Get_CAN_CH0_ID_0CFF3003_Sig_TransmissionOilTemperature();
                if(Data_Oil_Tem < 50)
                {
                    Data_Oil_Tem = 0;
                }
                else
                {
                    Data_Oil_Tem -= 50;
                }

            }
            if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_Rx_TOT_Msg_Count) == CAN_SIG_NORMAL)
            {

                Data_Oil_Tem = Get_CAN_CH0_ID_18FF1F03_Sig_TransmissionOilTemperatureofZF();
                if(Data_Oil_Tem < 50)
                {
                    Data_Oil_Tem = 0;
                }
                else
                {
                    Data_Oil_Tem -= 50;
                }

            }

            DataOilTem_Temp = Data_Oil_Tem;
            g_OilTemValid = 1u;
            
        }
        // if ( DataOilTemFristPower == 2u )
        // {
        //     DataOilTemFristPower = 1u;
        // }

        // 第2步：获取变速箱油温格数
        if ( g_OilTemValid )
        {
            if ( DataOilTem_Temp > g_DataOilTemTempCalc.Last )    // 新变速箱油温高于前次变速箱油温,查上升表
            {
                while ( g_DataOilTemTempCalc.DstSeg < DATA_OilTem_TEMP_TOTAL_SEG )
                {
                    if ( DataOilTem_Temp < DataOilTemTable_Up [ g_DataOilTemTempCalc.DstSeg ] )
                        break;
                    g_DataOilTemTempCalc.DstSeg++;
                }
            }
            else if ( DataOilTem_Temp < g_DataOilTemTempCalc.Last )    // 新变速箱油温低于前次变速箱油温,查下降表
            {
                while ( g_DataOilTemTempCalc.DstSeg )
                {
                    if ( DataOilTem_Temp > DataOilTemTable_Dn [ g_DataOilTemTempCalc.DstSeg - 1 ] )
                        break;
                    g_DataOilTemTempCalc.DstSeg--;
                }
            }

            g_DataOilTemTempCalc.Last = DataOilTem_Temp;
        }

        // 第3步：状态转换,每100ms执行一次
        g_DataOilTemTempCalc.Prescaler++;
        if ( g_DataOilTemTempCalc.Prescaler >= 5 )
        {
            g_DataOilTemTempCalc.Prescaler = 0;

            switch ( g_DataOilTemTempCalc.State )
            {
                case DATA_OilTem_TEMP_STATE_DELAY:
                    if ( g_DataOilTemTempCalc.Wait )
                        g_DataOilTemTempCalc.Wait--;
                    else
                        g_DataOilTemTempCalc.State = DATA_OilTem_TEMP_STATE_INIT;

                    break;

                case DATA_OilTem_TEMP_STATE_INIT:
                    if ( g_OilTemValid )
                    {
                        if ( g_DataOilTemTempCalc.DstSeg )
                        {
                            g_DataOilTemTempCalc.OutputEnable = 1;
                            g_DataOilTemTempCalc.FastMode     = 1;
                            g_DataOilTemTempCalc.State        = DATA_OilTem_TEMP_STATE_FAST;
                        }
                    }
                    else
                    {
                        g_DataOilTemTempCalc.OutputEnable = 1;
                        g_DataOilTemTempCalc.FastMode     = 1;
                        g_DataOilTemTempCalc.Last         = 0;
                        g_DataOilTemTempCalc.DstSeg       = 0;

                        g_DataOilTemTempCalc.State = DATA_OilTem_TEMP_STATE_FAULT;
                    }

                    break;

                case DATA_OilTem_TEMP_STATE_FAST:
                    if ( g_OilTemValid )
                    {
                        if ( g_DataOilTemTempCalc.FastMode == 0 )
                            g_DataOilTemTempCalc.State = DATA_OilTem_TEMP_STATE_NORMAL;
                    }
                    else
                    {
                        g_DataOilTemTempCalc.OutputEnable = 1;
                        g_DataOilTemTempCalc.FastMode     = 1;
                        g_DataOilTemTempCalc.Last         = 0;
                        g_DataOilTemTempCalc.DstSeg       = 0;

                        g_DataOilTemTempCalc.State = DATA_OilTem_TEMP_STATE_FAULT;
                    }

                    break;

                case DATA_OilTem_TEMP_STATE_NORMAL:
                    if ( g_OilTemValid == 0 )
                    {
                        g_DataOilTemTempCalc.OutputEnable = 1;
                        g_DataOilTemTempCalc.FastMode     = 1;
                        g_DataOilTemTempCalc.Last         = 0;
                        g_DataOilTemTempCalc.DstSeg       = 0;

                        g_DataOilTemTempCalc.State = DATA_OilTem_TEMP_STATE_FAULT;
                    }

                    break;

                case DATA_OilTem_TEMP_STATE_FAULT:
                    if ( g_OilTemValid )
                        g_DataOilTemTempCalc.State = DATA_OilTem_TEMP_STATE_INIT;

                    break;

                default:
                    g_OilTemSegNum_Disp               = 0;
                    DataOilTem_Temp                   = 0;
                    g_OilTemValid                     = 0;
                    g_DataOilTemTempCalc.OutputEnable = 1;
                    g_DataOilTemTempCalc.FastMode     = 1;
                    g_DataOilTemTempCalc.Last         = 0;
                    g_DataOilTemTempCalc.DstSeg       = 0;

                    g_DataOilTemTempCalc.State = DATA_OilTem_TEMP_STATE_FAULT;

                    break;
            }
        }

        // 第4步：显示输出格数
        if ( g_DataOilTemTempCalc.OutputEnable )
        {
            if ( g_OilTemSegNum_Disp < g_DataOilTemTempCalc.DstSeg )    // 需要增加段数时
            {
                if ( g_DataOilTemTempCalc.FastMode )
                    Delta = ( uint8_t )(DATA_OilTem_TEMP_SEG_STEP_FAST / 20);
                else
                    Delta = ( uint8_t )(DATA_OilTem_TEMP_SEG_STEP_SLOW / 20);

                g_DataOilTemTempCalc.DispTimer++;
                if ( g_DataOilTemTempCalc.DispTimer >= Delta )
                {
                    g_DataOilTemTempCalc.DispTimer = 0;
                    g_OilTemSegNum_Disp++;
                }
            }
            else if ( g_OilTemSegNum_Disp > g_DataOilTemTempCalc.DstSeg )    // 需要减少段数时
            {
                if ( g_DataOilTemTempCalc.FastMode )
                    Delta = ( uint8_t )(DATA_OilTem_TEMP_SEG_STEP_FAST / 20);
                else
                    Delta = ( uint8_t )(DATA_OilTem_TEMP_SEG_STEP_SLOW / 20);

                g_DataOilTemTempCalc.DispTimer++;
                if ( g_DataOilTemTempCalc.DispTimer >= Delta )
                {
                    g_DataOilTemTempCalc.DispTimer = 0;
                    g_OilTemSegNum_Disp--;
                }
            }
            else
            {
                g_DataOilTemTempCalc.DispTimer = 0;
                g_DataOilTemTempCalc.FastMode  = 0;
            }
        }
    }
    else
    {
        g_DataOilTemTempCalc.EngineStartTimer = 0;
        g_DataOilTemTempCalc.Backup           = DataOilTem_Temp;
        // if ( DataOilTemFristPower == 1 )
        // {
        //     DataOilTemFristPower = 0;
        // }
    }
}

uint8_t Get_Oil_Tem_Valid(void)
{
    return g_OilTemValid;
}
uint8_t Get_Oil_Tem_Display(void)
{
    return g_OilTemSegNum_Disp;
}
//变速箱油温闪烁标志返回
uint16_t Get_OilTem_Flash_status(void)
{
    return led_state_old;
}


void Oil_Tem_Table_Processing(uint8_t table)
{
    switch (table)
    {
    case 1:
        GPIO_SET_LED_TRANSMISSION_OIL_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM3_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM4_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM5_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM6_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM7_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

        case 2:
        GPIO_SET_LED_TRANSMISSION_OIL_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM3_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM4_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM5_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM6_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;
        
        case 3:
        GPIO_SET_LED_TRANSMISSION_OIL_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM3_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM4_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM5_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM6_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

        case 4:
        GPIO_SET_LED_TRANSMISSION_OIL_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM3_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM4_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM5_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM6_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

        case 5:
        GPIO_SET_LED_TRANSMISSION_OIL_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM3_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM4_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM5_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM6_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

        case 6:
        GPIO_SET_LED_TRANSMISSION_OIL_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM3_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM4_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM5_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM6_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

        case 7:
        GPIO_SET_LED_TRANSMISSION_OIL_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM2_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM3_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM4_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM5_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM6_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

        case 8:
        GPIO_SET_LED_TRANSMISSION_OIL_TEM1_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM2_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM3_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM4_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM5_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM6_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM7_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM8_LAMP(LAMP_LIGHT_POSITIVE(1, LED_Turn_L));
        break;

    default:
        GPIO_SET_LED_TRANSMISSION_OIL_TEM1_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM2_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM3_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM4_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM5_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM6_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM7_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        GPIO_SET_LED_TRANSMISSION_OIL_TEM8_LAMP(LAMP_LIGHT_POSITIVE(0, LED_Turn_L));
        break;
    }
}

void Display_Oil_Tem_Table(void)
{
    uint8_t table = Get_Oil_Tem_Display();

    if(Get_HMI_Sys_Type() >= Disp_SelfCheck)
    {
        Oil_Tem_Table_Processing(table);
    }
    else
    {
        Oil_Tem_Table_Processing(0);
    }
    
}