#include "UDS_10Service_Main.h"

/**
  *10服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_10_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data [])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_NRC11( ); /*10服务是否支持功能寻址*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_NRC7F( ); /*10服务会话是否支持验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_NRC33( ); /*10服务解锁等级验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_NRC13_MinLengthCheck( ); /*10服务最小长度验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_NRC31( ); /*10服务超出请求范围验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_NRC13_TotalLengthCheck( ); /*10服务总长度长度验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_NRC22( ); /*10服务条件验证*/
    }
    if ( NRC == positiveResponse )
    {
        UDS_10Service_Sub( ); /*10服务子功能*/
    }
    clearDiagMSG( ); /*清除诊断信息*/
}

/**
  *10服务子功能
  */
void UDS_10Service_Sub(void)
{
    uint8_t NRC = positiveResponse;
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_Sub_NRC13_MinLengthCheck( ); /*10服务子功能最小长度验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_Sub_NRC12( ); /*10服务子功能是否支持验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_Sub_NRC7E( ); /*10服务子功能会话是否支持验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_Sub_NRC31( ); /*10服务子功能超出请求范围验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_Sub_NRC13_TotalLengthCheck( ); /*10服务子功能总长度长度验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_Sub_NRC24( ); /*10服务子功能请求顺序验证*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_10Service_Sub_NRC22( ); /*10服务子功能条件验证*/
    }
    if ( NRC == positiveResponse )
    {
        switch ( DiagMSG.msgData.SidDetail.SubID ) /*子服务判断*/
        {
            case DefaultSession:
                UDS_10Service_Sub01( ); /*10服务01子功能*/
                break;
            case ProgrammingSession:
                UDS_10Service_Sub02( ); /*10服务02子功能*/
                break;
            case ExtendedDiagnosticSession:
                UDS_10Service_Sub03( ); /*10服务03子功能*/
                break;
            default:
                break;
        }
    }
}

/**
  *10服务01子功能
  */
void UDS_10Service_Sub01(void)
{
    UDS_10Service_S27Init( );
    UDS_10Service_S28Init( );
    UDS_10Service_S2FInit( );
    UDS_10Service_S85Init( );
    setSessionType(DefaultSession);

    if ( DiagMSG.msgData.SidDetail.PositiveSuppression == 0u )
    {
        DiagMSG.msgData.SidDetail.Data [ 0 ] = ( uint8_t )((P2_SERVER & ( uint16_t )0xFF00) >> 8);
        DiagMSG.msgData.SidDetail.Data [ 1 ] = ( uint8_t )(P2_SERVER & ( uint16_t )0x00FF);
        DiagMSG.msgData.SidDetail.Data [ 2 ] = ( uint8_t )((P2_AST_SERVER & ( uint16_t )0xFF00) >> 8);
        DiagMSG.msgData.SidDetail.Data [ 3 ] = ( uint8_t )(P2_AST_SERVER & ( uint16_t )0x00FF);
        UDS_Service_Response(0x10u, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
}

/**
  *10服务02子功能
  */
void UDS_10Service_Sub02(void)
{
    setSessionType(ProgrammingSession);
    //if ( DiagMSG.msgData.SidDetail.PositiveSuppression == 0u )
    {
        UDS_NRC78_Sand(0x10u);
        WriteJumpBootStatusToDFlash(JumpToBoot02);
        UDS_RESET( );
    }
    //else
    //{
    //    WriteJumpBootStatusToDFlash(JumpToBoot02);
    //    UDS_RESET( );
    //}
}

/**
  *10服务03子功能
  */
void UDS_10Service_Sub03(void)
{
    UDS_10Service_S27Init( );
    if ( getSessionType( ) == DefaultSession )
    {
        UDS_10Service_S28Init( );
        UDS_10Service_S2FInit( );
        UDS_10Service_S85Init( );
        setSessionType(ExtendedDiagnosticSession);
    }

    if ( DiagMSG.msgData.SidDetail.PositiveSuppression == 0u )
    {
        DiagMSG.msgData.SidDetail.Data [ 0 ] = ( uint8_t )((P2_SERVER & ( uint16_t )0xFF00) >> 8);
        DiagMSG.msgData.SidDetail.Data [ 1 ] = ( uint8_t )(P2_SERVER & ( uint16_t )0x00FF);
        DiagMSG.msgData.SidDetail.Data [ 2 ] = ( uint8_t )((P2_AST_SERVER & ( uint16_t )0xFF00) >> 8);
        DiagMSG.msgData.SidDetail.Data [ 3 ] = ( uint8_t )(P2_AST_SERVER & ( uint16_t )0x00FF);
        UDS_Service_Response(0x10u, POSITIVE_RSP, DIAG_ID_Tx, 5u, DiagMSG.msgData.Data);
    }
}