#include "UDS_2EService_Main.h"
#include "NVM.h"

/**
 *2E���������
 *@param A_TA_type �յ����ݵĵ�ַ
 *@param A_Length �յ����ݵĳ���
 *@param A_Data �յ����ݵ�����
 */
void UDS_Service_2E_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data [])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC11( ); /*2E�����Ƿ�֧�ֹ���Ѱַ*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC7F( ); /*2E����Ự�Ƿ�֧����֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC33( ); /*2E��������ȼ���֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC13_MinLengthCheck( ); /*2E������С������֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC31( ); /*2E���񳬳�����Χ��֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC13_TotalLengthCheck( ); /*2E�����ܳ��ȳ�����֤*/
    }
    if ( NRC == positiveResponse )
    {
        NRC = UDS_2EService_NRC22( ); /*2E����������֤*/
    }
    if ( NRC == positiveResponse )
    {
        UDS_NRC78_Sand(0x2Eu);
        UDS_Delay(5000u);
        UDS_2EService_DID( ); /*2E����DID�ж�*/
    }
    clearDiagMSG( ); /*��������Ϣ*/
}

/**
 *2E�����ӹ���
 */
void UDS_2EService_DID(void)
{
    switch ( getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) ) /*2E����DID�ж�*/
    {
        case 0x0300 :
            UDS_2EService_DID_0300();
        break;
        case 0x0301 :
            UDS_2EService_DID_0301();
        break;
        default:
        break;
    }
}


/**
 *2E DID0300
 *System Function Configuration
 */
void UDS_2EService_DID_0300(void)
{
    uint8_t enResult = 0u;    // WFLASH_RW_PASS;
    ( void )memcpy(EOL0300ToDFlashInfo.DID_0300, DiagMSG.msgData.DidDetail.Data, sizeof(EOL0300ToDFlashInfo.DID_0300));
    enResult = write2EData(WriteEOL0300Data);
    if ( enResult == 0u )    // WFLASH_RW_PASS)
    {
        EOL_Set0300(EOL0300ToDFlashInfo.DID_0300, 90u);
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}

/**
 *2E DID0301
 *System Function Configuration
 */
void UDS_2EService_DID_0301(void)
{
    uint8_t enResult = 0u;    // WFLASH_RW_PASS;
    ( void )memcpy(EOL0301ToDFlashInfo.DID_0301, DiagMSG.msgData.DidDetail.Data, sizeof(EOL0301ToDFlashInfo.DID_0301));
    enResult = write2EData(WriteEOL0301Data);
    if ( enResult == 0u )    // WFLASH_RW_PASS)
    {
        UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
    }
}


/**
 *2E����DIDF1F0
 *�ܼ����
 */
void UDS_2EService_DID_F1F0(void)
{
    #if 0
    uint8_t  enResult = 0u;
    uint32_t mileage  = 0u;
    uint32_t ODO      = 0u;
    mileage           = toUint32_t(0x00u, DiagMSG.msgData.DidDetail.Data [ 0 ], DiagMSG.msgData.DidDetail.Data [ 1 ], DiagMSG.msgData.DidDetail.Data [ 2 ]);
    ODO               = Data_ODO_Read( ) / 10u;
    if ( getSecurityLevel( ) == NormalKeyUnlock )
    {
        if ( (mileage < 256) && (ODO < 256) && (Ser2EToDFlashInfo.DID_F1F0 [ 0 ] == 0u) )
        {
            Ser2EToDFlashInfo.DID_F1F0 [ 0 ] = 1u;
            enResult                         = write2EData(Write2EData);
            if ( enResult == 0u )
            {
                Data_Mileage_Clear( );
                enResult = Data_Mileage_Write(mileage * 10u);
            }
            if ( enResult == 1u )
            {
                UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
            }
            else
            {
                enResult = generalProgrammingFailure;
                UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
            }
        }
        else
        {
            enResult = requestOutOfRange;
            UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
        }
    }
    if ( getSecurityLevel( ) == BootKeyUnlock )
    {
        Data_Mileage_Clear( );
        enResult = Data_Mileage_Write(mileage * 10u);
        if ( enResult == 1u )
        {
            UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
        }
        else
        {
            enResult = generalProgrammingFailure;
            UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, ( uint8_t * )&enResult);
        }
    }
    #endif
}

void UDS_2E_CLEAR_0300(void)
{
    EOL_0300_InitVal( );
    ( void )write2EData(WriteEOL0300DataAddr);
}

void UDS_2E_CLEAR_0301(void)
{
    EOL_0301_InitVal( );
    ( void )write2EData(WriteEOL0301DataAddr);
}

