#ifndef __UDS_2FSERVICE_INTERNA_H
#define __UDS_2FSERVICE_INTERNA_H

#include "TYW_stdint.h"
#include "UDS_Common.h"


typedef union 
{
    uint8_t Byte[1];/* data */
    struct 
    {
        uint8_t LED_Turn_L :1;
        uint8_t LED_Turn_R :1;
        uint8_t LED_Rear_Fog : 1;
        uint8_t LED_Position :1;
        uint8_t LED_HI_Beam :1;
        uint8_t LED_LOW_Beam :1;
        uint8_t LED_MIL :1;
        uint8_t LED_OilPressure_Low :1;
    }Bit;
}LEDCtrl_1;

typedef union 
{
    uint8_t Byte[1];/* data */
    struct 
    {
        uint8_t LED_Battery :1;
        uint8_t LED_Coolant :1;
        uint8_t LED_Fuel :1;
        uint8_t LED_Seatbelt : 1;
        uint8_t LED_GPF_State :1;
        uint8_t LED_Air_Bag :1;
        uint8_t LED_ABS :1;
        uint8_t LED_BrakeLiquid_Low  :1;//
    }Bit;
}LEDCtrl_2;

typedef union 
{
    uint8_t Byte[1];/* data */
    struct 
    {
        uint8_t LED_ESC :1;
        uint8_t LED_ESC_OFF :1;
        uint8_t LED_TPMS :1;
        uint8_t LED_BrakeLiquid_Low : 1;
        uint8_t LED_P :1;
        uint8_t LED_FailureLamp :1;
        uint8_t LED_CI :1;//2
        uint8_t LED_EPS :1;
    }Bit;
}LEDCtrl_3;

typedef union 
{
    uint8_t Byte[1];/* data */
    struct 
    {
        uint8_t LED_Start_UP_Stop :1;
        uint8_t LED_TFS :1;
        uint8_t LED_Master_Warning :1;
        uint8_t LED_Autohold : 1;
        uint8_t LED_HDC_STATUS :1;
        uint8_t LED_HostLaneStatus_Y :1;//2
        uint8_t LED_HostLaneStatus_R :1;//1
        uint8_t LED_Anti_theft :1;
    }Bit;
}LEDCtrl_4;

typedef union 
{
    uint8_t Byte[1];/* data */
    struct 
    {
        uint8_t LED_Turn_L :1;
        uint8_t LED_Turn_R :1;
        uint8_t LED_Rear_Fog : 1;
        uint8_t LED_Position :1;
        uint8_t LED_HI_Beam :1;
        uint8_t LED_LOW_Beam :1;
        uint8_t LED_MIL :1;
        uint8_t LED_OilPressure_Low :1;
    }Bit;
}LEDCtrl_1_Mask;

typedef union 
{
    uint8_t Byte[1];/* data */
    struct 
    {
        uint8_t LED_Battery :1;
        uint8_t LED_Coolant :1;
        uint8_t LED_Fuel :1;
        uint8_t LED_Seatbelt : 1;
        uint8_t LED_GPF_State :1;
        uint8_t LED_Air_Bag :1;
        uint8_t LED_ABS :1;
        uint8_t LED_BrakeLiquid_Low  :1;//
    }Bit;
}LEDCtrl_2_Mask;

typedef union 
{
    uint8_t Byte[1];/* data */
    struct 
    {
        uint8_t LED_ESC :1;
        uint8_t LED_ESC_OFF :1;
        uint8_t LED_TPMS :1;
        uint8_t LED_BrakeLiquid_Low : 1;
        uint8_t LED_P :1;
        uint8_t LED_FailureLamp :1;
        uint8_t LED_CI :1;//2
        uint8_t LED_EPS :1;
    }Bit;
}LEDCtrl_3_Mask;

typedef union 
{
    uint8_t Byte[1];/* data */
    struct 
    {
        uint8_t LED_Start_UP_Stop :1;
        uint8_t LED_TFS :1;
        uint8_t LED_Master_Warning :1;
        uint8_t LED_Autohold : 1;
        uint8_t LED_HDC_STATUS :1;
        uint8_t LED_HostLaneStatus_Y :1;//2
        uint8_t LED_HostLaneStatus_R :1;//1
        uint8_t LED_Anti_theft :1;
    }Bit;
}LEDCtrl_4_Mask;
typedef union 
{
    uint8_t Byte[6];/* data */
    struct 
    {
        uint8_t POPUP_ID_Radar :1;
        uint8_t POPUP_ID_NO_KEY_FOUND :1;
        uint8_t POPUP_ID_Steering_NotRelieved :1;
        uint8_t POPUP_ID_SHIFT_TO_N :1;
        uint8_t Res1 :1;
        uint8_t POPUP_ID_TheftPrevention_Auth_Fault :1;
        uint8_t POPUP_ID_Cruise_ungratified :1;
        uint8_t POPUP_ID_Oil_Pressure :1;

        uint8_t POPUP_ID_TempHigh :1;
        uint8_t POPUP_ID_Tire_Pressure_Low_Temp :1;
        uint8_t Res2 :1;
        uint8_t POPUP_ID_Take_Over_TPMS :1;
        uint8_t POPUP_ID_KEY_LOW_BATT :1;
        uint8_t Res3 :1;
        uint8_t POPUP_ID_Brake_To_Start :1;
        uint8_t POPUP_ID_SHIFT_TO_P :1;

        uint8_t POPUP_ID_CheckReturnLockSys :1;
        uint8_t POPUP_ID_LEFT_IN_CAR_Lock :1;
        uint8_t POPUP_ID_PowerAllot_Fault :1;
        uint8_t POPUP_ID_StartupSystem_Failure :1;
        uint8_t POPUP_ID_Radar_Fault :1;
        uint8_t POPUP_ID_CloseDoor_To_Lock :1;
        uint8_t POPUP_ID_Not_Disconnect_The_Power :1;
        uint8_t POPUP_ID_Maintenance_Tips :1;
        uint8_t POPUP_ID_Primary_limits_the_remaining_time :1;
        uint8_t POPUP_ID_Follow_GoHome :1;
        uint8_t Res4 :1;

        uint8_t POPUP_ID_HoodtOpen :1;
        uint8_t POPUP_ID_TrunkOpen :1;
        uint8_t POPUP_ID_DoorOpen :1;
        uint8_t POPUP_ID_SkyLightOpen :1;
        uint8_t Res5 :1;
        uint8_t POPUP_ID_EPB_Clamp_Force_Low :1;
        uint8_t POPUP_ID_ParkSlope_TooLarge :1;
        uint8_t Res6 :1;

        uint8_t POPUP_ID_Cruising_Target_Speed :1;
        uint8_t Res7 :5;
        uint8_t POPUP_ID_Power_Management_Tips :1;
        uint8_t Res8 :1;

        uint8_t Res9 :1;
        uint8_t POPUP_ID_Lane_Assist_System_Failure :1;
        uint8_t Res10 :6;
    }Bit;
}AlarmPopupsControl;

typedef union 
{
    uint8_t Byte[3];/* data */
    struct 
    {
        uint8_t Res1 :8;
        uint8_t Res2 :8;

        uint8_t TurnSignalSound :1;
        uint8_t SeatBeltNotFastenedSound :1;
        uint8_t DoorOpenSound :1;
        uint8_t RemoteControlBatteryPowerLowSound :1;
        uint8_t NoKeyDetectedSound :1;
        uint8_t Res3 :3;
    }Bit;
}ControlMotolControlMusic;


typedef union 
{
    uint8_t Byte[6];/* data */
    struct 
    {
        uint8_t POPUP_ID_ST_Radar :1;
        uint8_t POPUP_ID_ST_NO_KEY_FOUND :1;
        uint8_t POPUP_ID_ST_Steering_NotRelieved :1;
        uint8_t POPUP_ID_ST_SHIFT_TO_N :1;
        uint8_t Res1 :1;
        uint8_t POPUP_ID_ST_TheftPrevention_Auth_Fault :1;
        uint8_t POPUP_ID_ST_Cruise_ungratified :1;
        uint8_t POPUP_ID_ST_Oil_Pressure :1;

        uint8_t POPUP_ID_ST_TempHigh :1;
        uint8_t POPUP_ID_ST_Tire_Pressure_Low_Temp :1;
        uint8_t Res2 :1;
        uint8_t POPUP_ID_ST_Take_Over_TPMS :1;
        uint8_t POPUP_ID_ST_KEY_LOW_BATT :1;
        uint8_t Res3 :1;
        uint8_t POPUP_ID_ST_Brake_To_Start :1;
        uint8_t POPUP_ID_ST_SHIFT_TO_P :1;

        uint8_t POPUP_ID_ST_CheckReturnLockSys :1;
        uint8_t POPUP_ID_ST_LEFT_IN_CAR_Lock :1;
        uint8_t POPUP_ID_ST_PowerAllot_Fault :1;
        uint8_t POPUP_ID_ST_StartupSystem_Failure :1;
        uint8_t POPUP_ID_ST_Radar_Fault :1;
        uint8_t POPUP_ID_ST_CloseDoor_To_Lock :1;
        uint8_t POPUP_ID_ST_Follow_GoHome :1;
        uint8_t Res4 :1;

        uint8_t POPUP_ID_ST_HoodtOpen :1;
        uint8_t POPUP_ID_ST_TrunkOpen :1;
        uint8_t POPUP_ID_ST_DoorOpen :1;
        uint8_t POPUP_ID_ST_SkyLightOpen :1;
        uint8_t Res5 :1;
        uint8_t POPUP_ID_ST_EPB_Clamp_Force_Low :1;
        uint8_t POPUP_ID_ST_ParkSlope_TooLarge :1;
        uint8_t Res6 :1;

        uint8_t POPUP_ID_ST_Cruising_Target_Speed :1;
        uint8_t Res7 :5;
        uint8_t POPUP_ID_ST_Power_Management_Tips :1;
        uint8_t Res8 :1;

        uint8_t Res9 :1;
        uint8_t POPUP_ID_ST_Lane_Assist_System_Failure :1;
        uint8_t Res10 :6;
    }Bit;
}AlarmPopupsControlMask;

typedef union 
{
    uint8_t Byte[3];/* data */
    struct 
    {
        uint8_t Res1 :8;
        uint8_t Res2 :8;

        uint8_t TurnSignalSoundST :1;
        uint8_t SeatBeltNotFastenedSoundST :1;
        uint8_t DoorOpenSoundST :1;
        uint8_t RemoteControlBatteryPowerLowSoundST :1;
        uint8_t NoKeyDetectedSoundST :1;
        uint8_t Res3 :3;
    }Bit;
}ControlMotolControlMusicMask;

void BuzzerTest(uint8_t ControlParameter,  ControlMotolControlMusic ControlOption, ControlMotolControlMusicMask ControlEnableMask);
void BuzzerTest_Factory(uint8_t ControlStatus, uint8_t BuzzerStatus);
void GaugeTest(uint8_t ControlStatus, uint8_t GaugeType, uint8_t GaugeStatus);
void Lamp1WarningTest(uint8_t ControlParameter,  LEDCtrl_1 ControlOption, LEDCtrl_1_Mask ControlEnableMask);
void Lamp2WarningTest(uint8_t ControlParameter,  LEDCtrl_2 ControlOption, LEDCtrl_2_Mask ControlEnableMask);
void Lamp3WarningTest(uint8_t ControlParameter,  LEDCtrl_3 ControlOption, LEDCtrl_3_Mask ControlEnableMask);
void Lamp4WarningTest(uint8_t ControlParameter,  LEDCtrl_4 ControlOption, LEDCtrl_4_Mask ControlEnableMask);
void FuelMeterControl(uint8_t ControlStatus, uint8_t Bar);
void TemperatureMeterControl(uint8_t ControlStatus, uint8_t Bar);

void PopupsControlTest(uint8_t ControlParameter,  AlarmPopupsControl ControlOption, AlarmPopupsControlMask ControlEnableMask);
void SegmentLCDTest_Factory(uint8_t ControlStatus, uint8_t SegmentLCDStatus);
void Factory_ODO_Test(uint8_t ControlStatus, uint8_t SegmentLCDStatus);
void BackLight_Test(uint8_t ControlStatus, uint8_t SegmentLCDStatus);

#endif
