#ifndef __UDS_DTC_H
#define __UDS_DTC_H

#include "TYW_stdint.h"
#include "UDS_Common.h"

#define  U110017  0xD10017
#define  U110116  0xD10116
#define  U001988  0xC01988
#define  U114587  0xD14587
#define  U116687  0xD16687
#define  U116887  0xD16887
#define  U116987  0xD16987
#define  U114787  0xD14787
#define  U114887  0xD14887
#define  U148087  0xD48087
#define  U112587  0xD12587
#define  U113087  0xD13087
#define  U117687  0xD17687
#define  U113387  0xD13387
#define  U113587  0xD13587
#define  U114187  0xD14187
#define  B110111  0x910111
#define  B110115  0x910115
#define  B110341  0x910341
#define  B110515  0x910515
#define  B110400  0x910400
#define  U110216  0xD10216

#define  cnU110017    0
#define  cnU110116    1
#define  cnU001988    2
#define  cnU114587    3
#define  cnU116687    4
#define  cnU116887    5
#define  cnU116987    6
#define  cnU114787    7
#define  cnU114887    8
#define  cnU148087    9
#define  cnU112587    10
#define  cnU113087    11
#define  cnU117687    12
#define  cnU113387    13
#define  cnU113587    14
#define  cnU114187    15
#define  cnB110111    16
#define  cnB110115    17
#define  cnB110341    18
#define  cnB110515    19
#define  cnB110400    20
#define  cnU110216    21


#define  cnMSG366      0
#define  cnMSG2D8      1
#define  cnMSG501      2
#define  cnMSG362      3
#define  cnMSG28B      4 
#define  cnMSG347      5 
#define  cnMSG2E0      6 
#define  cnMSG196      7
#define  cnMSG355      8
#define  cnMSG338      9 
#define  cnMSG24F      10 
#define  cnMSG187      11 
#define  cnMSG050      12

extern uint8_t        HVoltageStatus;
extern uint8_t        LVoltageStatus;
extern uint16_t       msgList [ 13u ][ 4u ];
extern uint32_t       DTCTimerList [ 22u ];
extern uint32_t       DTCList [ 22 ][ 2 ];
extern uint8_t        DTCUpdataStatusList [ 22u ];

void    TestDTC(uint16_t timer);
void TestDTC_U001988(void);
void TestDTC_U110116(uint16_t timer);
void TestDTC_U110017(uint16_t timer);
void TestDTC_U114587(void);
void TestDTC_U116687(void);
void TestDTC_U116887(void);
void TestDTC_U116987(void);
void TestDTC_U114787(void);
void TestDTC_U114887(void);
void TestDTC_U148087(void);
void TestDTC_U112587(void);
void TestDTC_U113087(void);
void TestDTC_U117687(void);
void TestDTC_U113387(void);
void TestDTC_U113587(void);
void TestDTC_U114187(void);
void TestDTC_B110111(uint16_t timer);
void TestDTC_B110115(uint16_t timer);
void TestDTC_B110341(uint16_t timer);
void TestDTC_B110515(uint16_t timer);
void TestDTC_B110400(uint16_t timer);
void TestDTC_U110216(uint16_t timer);
uint8_t getPowerStatus(void);
uint8_t getBusoffStatus(void);
uint8_t getEngStatus(void);
void    set_DTC_Key_Statues(uint8_t Statues);
uint8_t getMSGStatus(uint8_t cnMsgID);
void    ChangeDTCData(uint8_t DTCNum, uint8_t DTCStatus);
void    SaveDTCData(void);
uint8_t Get_LED_Status(void);

#endif