#ifndef _BACKLIGHT_H_
#define _BACKLIGHT_H_

#include "TYW_stdint.h"

typedef struct
{

    uint16_t BackGoal;
    uint16_t BackCurrent;

    uint16_t BackBrightness;

    uint16_t LostTimer;

    uint16_t BackGoalBackUp;
    uint16_t BackLightValid;

    uint8_t FactorLevelBack;

    uint16_t BackDampingTimer;

    uint16_t Ntc_Timer;
    uint8_t  Ntc_Factor;
    uint8_t  Off_Delay_Timer;
    uint16_t Bl_delay;
    uint16_t Delay_Tag;

    uint8_t BackLightSYNC;
    uint8_t led_Delay_Timer;
    uint8_t led_status;
    uint8_t SleepStatus;
} BackLightCtrlStruct;

#define BL_PWM_DUTY_CYCLE_APPR_FACTOR 16
#define BL_PWM_DUTY_CYCLE_APPR_SPEED  5

#define BACKLIGHT_LCMLEVEL 21
#define BACKLIGHT_HULEVEL  11

static const uint16_t BackLightNightHighLevel [ BACKLIGHT_LCMLEVEL ][ BACKLIGHT_HULEVEL ] = {
    ///*HU???0*/*HU???1*/*HU???2*/*HU???3*/*HU???4*/*HU???5*/*HU???6*/*HU???7*/*HU???8*/**HU???9**/*HU???10*
    //BCM???1
    {10U, 14U, 18U, 23U, 28U, 33U, 45U, 55U, 100U, 86U, 105U},
    //BCM???2
    {12U, 16U, 20U, 25U, 30U, 37U, 50U, 60U, 100U, 93U, 120},
    //BCM???3
    {14U, 18U, 23U, 28U, 33U, 45U, 55U, 70U, 100U, 105U, 130},
    //BCM???4
    {16U, 20U, 25U, 30U, 37U, 50U, 60U, 80U, 100U, 120U, 150},
    //BCM???5
    {18U, 23U, 28U, 33U, 45U, 55U, 70U, 86U, 100U, 130U, 160},
    //BCM???636
    {20U, 25U, 30U, 40U, 50U, 60U, 80U, 93U, 100U, 151U, 195},
    //BCM???7
    {23U, 28U, 33U, 45U, 55U, 70U, 86U, 105U, 100U, 160U, 210},
    //BCM???8
    {25, 30, 37, 50, 60, 80, 93, 120, 100, 190, 240},
    //BCM???9
    {28, 33, 45, 55, 70, 86, 105, 130, 100, 210, 256},
    //BCM???10
    {30, 40, 50, 60, 80, 93, 120, 150, 100, 240, 295},
    //BCM???11
    {33, 45, 55, 70, 86, 105, 130, 160, 100, 256, 330},
    //BCM???12
    {37, 50, 60, 80, 93, 120, 150, 190, 100, 295, 370},
    //BCM???13
    {45, 55, 70, 86, 105, 130, 160, 210, 100, 330, 416},
    //BCM???14
    {50, 60, 80, 93, 120, 150, 190, 240, 100, 370, 470},
    //BCM???15
    {55, 70, 86, 105, 130, 160, 210, 256, 100, 416, 530},
    //BCM???16
    {60, 80, 93, 120, 150, 190, 240, 295, 100, 470, 590},
    //BCM???17
    {70, 86, 105, 130, 160, 210, 256, 330, 100, 530, 670},
    //BCM???18
    {80, 93, 120, 150, 190, 240, 295, 370, 100, 590, 750},
    //BCM???19
    {86, 105, 130, 160, 210, 256, 330, 416, 100, 670, 850},
    //BCM???20
    {93, 120, 150, 190, 240, 295, 370, 470, 100, 750, 950},
    //BCM???21
    {105, 130, 160, 210, 256, 330, 416, 530, 100, 850, 1000},

};

//?????????(????)
static const uint16_t BackLightNightLowLevel [ BACKLIGHT_LCMLEVEL ][ BACKLIGHT_HULEVEL ] = {
    ///*HU???0*/*HU???1*/*HU???2*/*HU???3*/*HU???4*/*HU???5*/*HU???6*/*HU???7*/*HU???8*/**HU???9**/*HU???10*
    //BCM???1
    {10, 13, 16, 60, 25, 32, 40, 50, 63, 79, 100},
    //BCM???2
    {11, 14, 18, 70, 28, 35, 45, 56, 71, 89, 112},
    //BCM???3
    {13, 16, 20, 80, 32, 40, 50, 63, 79, 100, 126},
    //BCM???4
    {14, 18, 22, 90, 35, 45, 56, 71, 89, 112, 141},
    //BCM???5
    {16, 20, 25, 100, 40, 50, 63, 79, 100, 126, 158},
    //BCM???6
    {18, 22, 28, 110, 45, 56, 71, 89, 112, 141, 178},
    //BCM???7
    {20, 25, 32, 120, 50, 63, 79, 100, 126, 158, 200},
    //BCM???8
    {22, 28, 35, 140, 56, 71, 89, 112, 141, 178, 224},
    //BCM???9
    {25, 32, 40, 150, 63, 79, 100, 126, 159, 199, 251},
    //BCM???10
    {28, 36, 45, 170, 71, 89, 112, 141, 178, 224, 282},
    //BCM???11
    {32, 40, 50, 190, 79, 100, 126, 158, 200, 251, 316},
    //BCM???12
    {35, 45, 56, 220, 89, 112, 141, 178, 224, 282, 355},
    //BCM???13
    {40, 50, 63, 240, 100, 126, 158, 199, 251, 316, 398},
    //BCM???14
    {45, 56, 71, 270, 112, 141, 178, 224, 282, 355, 447},
    //BCM???15
    {50, 63, 79, 300, 126, 158, 199, 251, 316, 398, 501},
    //BCM???16
    {56, 71, 89, 340, 141, 178, 224, 282, 355, 446, 562},
    //BCM???17
    {63, 80, 100, 380, 158, 199, 251, 316, 398, 501, 631},
    //BCM???18
    {71, 89, 112, 430, 178, 224, 282, 355, 447, 562, 708},
    //BCM???19
    {79, 100, 126, 480, 199, 251, 316, 398, 501, 631, 794},
    //BCM???20
    {89, 112, 141, 540, 224, 282, 355, 447, 562, 708, 891},
    //BCM???21
    {100, 126, 158, 610, 251, 316, 398, 501, 631, 794, 1000},
};

//?????????(????)
static const uint16_t BackLightDayHighLevel [ BACKLIGHT_HULEVEL ] = {
    650, 650, 650, 650, 650, 650, 650, 650, 650, 650, 650};

//?????????(????)
static const uint16_t BackLightDayLowLevel [ BACKLIGHT_HULEVEL ] = {
    100, 126, 158, 200, 251, 95, 398, 501, 631, 794, 990};

static const uint16_t BackLightNightLevel [] = {
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
};

static const uint16_t BackLightDayLevel [ BACKLIGHT_HULEVEL ] = {
    100, 126, 158, 200, 251, 316, 398, 501, 631, 794, 1000};

enum
{
    HU_Level_0 = 0,
    HU_Level_1,
    HU_Level_2,
    HU_Level_3,
    HU_Level_4,
    HU_Level_5,
    HU_Level_6,
    HU_Level_7,
    HU_Level_8,
    HU_Level_9,
    HU_Level_10,
    HU_Level_MAX,
};

enum
{
    LCM_Level_0 = 0,
    LCM_Level_1,
    LCM_Level_2,
    LCM_Level_3,
    LCM_Level_4,
    LCM_Level_5,
    LCM_Level_6,
    LCM_Level_7,
    LCM_Level_8,
    LCM_Level_9,
    LCM_Level_10,
    LCM_Level_11,
    LCM_Level_12,
    LCM_Level_13,
    LCM_Level_14,
    LCM_Level_15,
    LCM_Level_16,
    LCM_Level_17,
    LCM_Level_18,
    LCM_Level_19,
    LCM_Level_20,
    LCM_Level_21,

    LCM_Level_MAX,
};

static const uint16_t BackLightLevel_Tbl [ 10u ][ 2u ] = {
    {300U, 10U},
    {360U, 20U},
    {430U, 30U},
    {500U, 40U},
    {570U, 50U},
    {630U, 70U},
    {700U, 90U},
    {780U, 150U},
    {860U, 220U},
    {950U, 300U},
};

#define BACK_LIGHT_LOST_TIME 400

void BackLight_30_Init(void);
void BackLight_LV_30_Init(void);
void BackLight_15_Init(void);
void BackLight_WakeUp_Init(void);
void BackLight_Sleep_Init(void);
void BackLight_Ctrl_Service(void);
void BackLight_Back_PWM_Init(void); /*PWM Channel Enable*/

void ADProcess_NTC_Temp_Service(void);
void BackLightTest(uint32_t cmd,uint32_t val);


uint8_t BackLight_Get_Level(void);
void    BackLight_Get_Level_To_Factor(void);
uint8_t Remote_Start_Signal(void);

void    Remote_Start_Signal_Monitor(void);
void    BackLight_Back_Set_Brightness(uint16_t Br);
void    Remote_STOP_Display(void);
void    Remote_Status_Sync(void);
uint8_t GET_BackLight_APP_TX(void);

uint8_t Get_BackDay_LV_App(void);
uint8_t Get_BackNight_LV_App(void);
uint8_t Get_BackSend_Temp(void);

void Set_Theme_Color(void);
uint8_t Get_Theme_App(void);
void BackLight_PWM_Duty_Cycle_Delta(uint16_t Goal, uint16_t *Current, uint16_t *DampingTimer);
#endif
